/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class EyeblossomBlock
extends FlowerBlock {
    public static final MapCodec<EyeblossomBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("open").forGetter(eyeblossomblock -> eyeblossomblock.type.open), EyeblossomBlock.propertiesCodec()).apply((Applicative)instance, EyeblossomBlock::new));
    private static final int EYEBLOSSOM_XZ_RANGE = 3;
    private static final int EYEBLOSSOM_Y_RANGE = 2;
    private final Type type;

    public MapCodec<? extends EyeblossomBlock> codec() {
        return CODEC;
    }

    public EyeblossomBlock(Type eyeblossomblock_a, BlockBehaviour.Properties blockbase_info) {
        super(eyeblossomblock_a.effect, eyeblossomblock_a.effectDuration, blockbase_info);
        this.type = eyeblossomblock_a;
    }

    public EyeblossomBlock(boolean flag, BlockBehaviour.Properties blockbase_info) {
        super(Type.fromBoolean((boolean)flag).effect, Type.fromBoolean((boolean)flag).effectDuration, blockbase_info);
        this.type = Type.fromBoolean(flag);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        BlockState iblockdata1;
        if (this.type.emitSounds() && randomsource.nextInt(700) == 0 && (iblockdata1 = world.getBlockState(blockposition.below())).is(Blocks.PALE_MOSS_BLOCK)) {
            world.playLocalSound(blockposition.getX(), blockposition.getY(), blockposition.getZ(), SoundEvents.EYEBLOSSOM_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (this.tryChangingState(iblockdata, worldserver, blockposition, randomsource)) {
            worldserver.playSound((Entity)null, blockposition, this.type.transform().longSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(iblockdata, worldserver, blockposition, randomsource);
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (this.tryChangingState(iblockdata, worldserver, blockposition, randomsource)) {
            worldserver.playSound((Entity)null, blockposition, this.type.transform().shortSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.tick(iblockdata, worldserver, blockposition, randomsource);
    }

    private boolean tryChangingState(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!worldserver.dimensionType().natural()) {
            return false;
        }
        if (CreakingHeartBlock.isNaturalNight(worldserver) == this.type.open) {
            return false;
        }
        Type eyeblossomblock_a = this.type.transform();
        if (!CraftEventFactory.handleBlockFormEvent((Level)worldserver, blockposition, eyeblossomblock_a.state(), 3)) {
            return false;
        }
        worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(iblockdata));
        eyeblossomblock_a.spawnTransformParticle(worldserver, blockposition, randomsource);
        BlockPos.betweenClosed(blockposition.offset(-3, -2, -3), blockposition.offset(3, 2, 3)).forEach(blockposition1 -> {
            BlockState iblockdata1 = worldserver.getBlockState((BlockPos)blockposition1);
            if (iblockdata1 == iblockdata) {
                double d0 = Math.sqrt(blockposition.distSqr((Vec3i)blockposition1));
                int i = randomsource.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                worldserver.scheduleTick((BlockPos)blockposition1, iblockdata.getBlock(), i);
            }
        });
        return true;
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier) {
        if (!world.isClientSide() && world.getDifficulty() != Difficulty.PEACEFUL && entity instanceof Bee) {
            Bee entitybee = (Bee)entity;
            if (Bee.attractsBees(iblockdata) && !entitybee.hasEffect(MobEffects.POISON)) {
                entitybee.addEffect(this.getBeeInteractionEffect());
            }
        }
    }

    @Override
    public MobEffectInstance getBeeInteractionEffect() {
        return new MobEffectInstance(MobEffects.POISON, 25);
    }

    public static enum Type {
        OPEN(true, MobEffects.BLINDNESS, 11.0f, SoundEvents.EYEBLOSSOM_OPEN_LONG, SoundEvents.EYEBLOSSOM_OPEN, 16545810),
        CLOSED(false, MobEffects.NAUSEA, 7.0f, SoundEvents.EYEBLOSSOM_CLOSE_LONG, SoundEvents.EYEBLOSSOM_CLOSE, 0x5F5F5F);

        final boolean open;
        final Holder<MobEffect> effect;
        final float effectDuration;
        final SoundEvent longSwitchSound;
        final SoundEvent shortSwitchSound;
        private final int particleColor;

        private Type(boolean flag, Holder holder, float f, SoundEvent soundeffect, SoundEvent soundeffect1, int i) {
            this.open = flag;
            this.effect = holder;
            this.effectDuration = f;
            this.longSwitchSound = soundeffect;
            this.shortSwitchSound = soundeffect1;
            this.particleColor = i;
        }

        public Block block() {
            return this.open ? Blocks.OPEN_EYEBLOSSOM : Blocks.CLOSED_EYEBLOSSOM;
        }

        public BlockState state() {
            return this.block().defaultBlockState();
        }

        public Type transform() {
            return Type.fromBoolean(!this.open);
        }

        public boolean emitSounds() {
            return this.open;
        }

        public static Type fromBoolean(boolean flag) {
            return flag ? OPEN : CLOSED;
        }

        public void spawnTransformParticle(ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
            Vec3 vec3d = blockposition.getCenter();
            double d0 = 0.5 + randomsource.nextDouble();
            Vec3 vec3d1 = new Vec3(randomsource.nextDouble() - 0.5, randomsource.nextDouble() + 1.0, randomsource.nextDouble() - 0.5);
            Vec3 vec3d2 = vec3d.add(vec3d1.scale(d0));
            TrailParticleOption trailparticleoption = new TrailParticleOption(vec3d2, this.particleColor, (int)(20.0 * d0));
            worldserver.sendParticles(trailparticleoption, vec3d.x, vec3d.y, vec3d.z, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public SoundEvent longSwitchSound() {
            return this.longSwitchSound;
        }
    }
}

