/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeafLitterBlock
extends VegetationBlock
implements SegmentableBlock {
    public static final MapCodec<LeafLitterBlock> CODEC = LeafLitterBlock.simpleCodec(LeafLitterBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final Function<BlockState, VoxelShape> shapes;

    public LeafLitterBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(this.getSegmentAmountProperty(), 1));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, this.getSegmentAmountProperty()));
    }

    protected MapCodec<LeafLitterBlock> codec() {
        return CODEC;
    }

    @Override
    public BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        if (this.canBeReplaced(var0, var1, this.getSegmentAmountProperty())) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockPos var3 = var2.below();
        return var1.getBlockState(var3).isFaceSturdy(var1, var3, Direction.UP);
    }

    @Override
    public VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return this.getStateForPlacement(var0, this, this.getSegmentAmountProperty(), FACING);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, this.getSegmentAmountProperty());
    }
}

