/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class MultifaceSpreader {
    public static final SpreadType[] DEFAULT_SPREAD_ORDER = new SpreadType[]{SpreadType.SAME_POSITION, SpreadType.SAME_PLANE, SpreadType.WRAP_AROUND};
    private final SpreadConfig config;

    public MultifaceSpreader(MultifaceBlock multifaceblock) {
        this(new DefaultSpreaderConfig(multifaceblock));
    }

    public MultifaceSpreader(SpreadConfig multifacespreader_b) {
        this.config = multifacespreader_b;
    }

    public boolean canSpreadInAnyDirection(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return Direction.stream().anyMatch(enumdirection1 -> {
            SpreadConfig multifacespreader_b = this.config;
            Objects.requireNonNull(this.config);
            return this.getSpreadFromFaceTowardDirection(iblockdata, iblockaccess, blockposition, enumdirection, (Direction)enumdirection1, multifacespreader_b::canSpreadInto).isPresent();
        });
    }

    public Optional<SpreadPos> spreadFromRandomFaceTowardRandomDirection(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource) {
        return Direction.allShuffled(randomsource).stream().filter(enumdirection -> this.config.canSpreadFrom(iblockdata, (Direction)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardRandomDirection(iblockdata, generatoraccess, blockposition, (Direction)enumdirection, randomsource, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, boolean flag) {
        return Direction.stream().filter(enumdirection -> this.config.canSpreadFrom(iblockdata, (Direction)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardAllDirections(iblockdata, generatoraccess, blockposition, (Direction)enumdirection, flag)).reduce(0L, Long::sum);
    }

    public Optional<SpreadPos> spreadFromFaceTowardRandomDirection(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection, RandomSource randomsource, boolean flag) {
        return Direction.allShuffled(randomsource).stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, (Direction)enumdirection1, flag)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection, boolean flag) {
        return Direction.stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, (Direction)enumdirection1, flag)).filter(Optional::isPresent).count();
    }

    @VisibleForTesting
    public Optional<SpreadPos> spreadFromFaceTowardDirection(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection, Direction enumdirection1, boolean flag) {
        SpreadConfig multifacespreader_b = this.config;
        Objects.requireNonNull(this.config);
        return this.getSpreadFromFaceTowardDirection(iblockdata, generatoraccess, blockposition, enumdirection, enumdirection1, multifacespreader_b::canSpreadInto).flatMap(multifacespreader_c -> this.spreadToFace(generatoraccess, (SpreadPos)multifacespreader_c, flag));
    }

    public Optional<SpreadPos> getSpreadFromFaceTowardDirection(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, Direction enumdirection1, SpreadPredicate multifacespreader_d) {
        if (enumdirection1.getAxis() == enumdirection.getAxis()) {
            return Optional.empty();
        }
        if (this.config.isOtherBlockValidAsSource(iblockdata) || this.config.hasFace(iblockdata, enumdirection) && !this.config.hasFace(iblockdata, enumdirection1)) {
            for (SpreadType multifacespreader_e : this.config.getSpreadTypes()) {
                SpreadPos multifacespreader_c = multifacespreader_e.getSpreadPos(blockposition, enumdirection1, enumdirection);
                if (!multifacespreader_d.test(iblockaccess, blockposition, multifacespreader_c)) continue;
                return Optional.of(multifacespreader_c);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<SpreadPos> spreadToFace(LevelAccessor generatoraccess, SpreadPos multifacespreader_c, boolean flag) {
        BlockState iblockdata = generatoraccess.getBlockState(multifacespreader_c.pos());
        return this.config.placeBlock(generatoraccess, multifacespreader_c, iblockdata, flag) ? Optional.of(multifacespreader_c) : Optional.empty();
    }

    public static class DefaultSpreaderConfig
    implements SpreadConfig {
        protected MultifaceBlock block;

        public DefaultSpreaderConfig(MultifaceBlock multifaceblock) {
            this.block = multifaceblock;
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
            return this.block.getStateForPlacement(iblockdata, iblockaccess, blockposition, enumdirection);
        }

        protected boolean stateCanBeReplaced(BlockGetter iblockaccess, BlockPos blockposition, BlockPos blockposition1, Direction enumdirection, BlockState iblockdata) {
            return iblockdata.isAir() || iblockdata.is(this.block) || iblockdata.is(Blocks.WATER) && iblockdata.getFluidState().isSource();
        }

        @Override
        public boolean canSpreadInto(BlockGetter iblockaccess, BlockPos blockposition, SpreadPos multifacespreader_c) {
            BlockState iblockdata = iblockaccess.getBlockState(multifacespreader_c.pos());
            return this.stateCanBeReplaced(iblockaccess, blockposition, multifacespreader_c.pos(), multifacespreader_c.face(), iblockdata) && this.block.isValidStateForPlacement(iblockaccess, iblockdata, multifacespreader_c.pos(), multifacespreader_c.face());
        }
    }

    public static interface SpreadConfig {
        @Nullable
        public BlockState getStateForPlacement(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4);

        public boolean canSpreadInto(BlockGetter var1, BlockPos var2, SpreadPos var3);

        default public SpreadType[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(BlockState iblockdata, Direction enumdirection) {
            return MultifaceBlock.hasFace(iblockdata, enumdirection);
        }

        default public boolean isOtherBlockValidAsSource(BlockState iblockdata) {
            return false;
        }

        default public boolean canSpreadFrom(BlockState iblockdata, Direction enumdirection) {
            return this.isOtherBlockValidAsSource(iblockdata) || this.hasFace(iblockdata, enumdirection);
        }

        default public boolean placeBlock(LevelAccessor generatoraccess, SpreadPos multifacespreader_c, BlockState iblockdata, boolean flag) {
            BlockState iblockdata1 = this.getStateForPlacement(iblockdata, generatoraccess, multifacespreader_c.pos(), multifacespreader_c.face());
            if (iblockdata1 != null) {
                if (flag) {
                    generatoraccess.getChunk(multifacespreader_c.pos()).markPosForPostprocessing(multifacespreader_c.pos());
                }
                return CraftEventFactory.handleBlockSpreadEvent(generatoraccess, multifacespreader_c.source(), multifacespreader_c.pos(), iblockdata1, 2);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface SpreadPredicate {
        public boolean test(BlockGetter var1, BlockPos var2, SpreadPos var3);
    }

    public static enum SpreadType {
        SAME_POSITION{

            @Override
            public SpreadPos getSpreadPos(BlockPos blockposition, Direction enumdirection, Direction enumdirection1) {
                return new SpreadPos(blockposition, enumdirection, blockposition);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public SpreadPos getSpreadPos(BlockPos blockposition, Direction enumdirection, Direction enumdirection1) {
                return new SpreadPos(blockposition.relative(enumdirection), enumdirection1, blockposition);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public SpreadPos getSpreadPos(BlockPos blockposition, Direction enumdirection, Direction enumdirection1) {
                return new SpreadPos(blockposition.relative(enumdirection).relative(enumdirection1), enumdirection.getOpposite(), blockposition);
            }
        };


        public abstract SpreadPos getSpreadPos(BlockPos var1, Direction var2, Direction var3);
    }

    public record SpreadPos(BlockPos pos, Direction face, BlockPos source) {
    }
}

