/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SideChainPart;

public interface SideChainPartBlock {
    public SideChainPart getSideChainPart(BlockState var1);

    public BlockState setSideChainPart(BlockState var1, SideChainPart var2);

    public Direction getFacing(BlockState var1);

    public boolean isConnectable(BlockState var1);

    public int getMaxChainLength();

    default public List<BlockPos> getAllBlocksConnectedTo(LevelAccessor var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        if (!this.isConnectable(var2)) {
            return List.of();
        }
        Neighbors var3 = this.getNeighbors(var0, var1, this.getFacing(var2));
        LinkedList<BlockPos> var4 = new LinkedList<BlockPos>();
        var4.add(var1);
        this.addBlocksConnectingTowards(var3::left, SideChainPart.LEFT, var4::addFirst);
        this.addBlocksConnectingTowards(var3::right, SideChainPart.RIGHT, var4::addLast);
        return var4;
    }

    private void addBlocksConnectingTowards(IntFunction<Neighbor> var0, SideChainPart var1, Consumer<BlockPos> var2) {
        for (int var3 = 1; var3 < this.getMaxChainLength(); ++var3) {
            Neighbor var4 = var0.apply(var3);
            if (var4.connectsTowards(var1)) {
                var2.accept(var4.pos());
            }
            if (var4.isUnconnectableOrChainEnd()) break;
        }
    }

    default public void updateNeighborsAfterPoweringDown(LevelAccessor var0, BlockPos var1, BlockState var2) {
        Neighbors var3 = this.getNeighbors(var0, var1, this.getFacing(var2));
        var3.left().disconnectFromRight();
        var3.right().disconnectFromLeft();
    }

    default public void updateSelfAndNeighborsOnPoweringUp(LevelAccessor var0, BlockPos var1, BlockState var2, BlockState var3) {
        if (!this.isConnectable(var2)) {
            return;
        }
        if (this.isBeingUpdatedByNeighbor(var2, var3)) {
            return;
        }
        Neighbors var4 = this.getNeighbors(var0, var1, this.getFacing(var2));
        SideChainPart var5 = SideChainPart.UNCONNECTED;
        int var6 = var4.left().isConnectable() ? this.getAllBlocksConnectedTo(var0, var4.left().pos()).size() : 0;
        int var7 = var4.right().isConnectable() ? this.getAllBlocksConnectedTo(var0, var4.right().pos()).size() : 0;
        int var8 = 1;
        if (this.canConnect(var6, var8)) {
            var5 = var5.whenConnectedToTheLeft();
            var4.left().connectToTheRight();
            var8 += var6;
        }
        if (this.canConnect(var7, var8)) {
            var5 = var5.whenConnectedToTheRight();
            var4.right().connectToTheLeft();
        }
        this.setPart(var0, var1, var5);
    }

    private boolean canConnect(int var0, int var1) {
        return var0 > 0 && var1 + var0 <= this.getMaxChainLength();
    }

    private boolean isBeingUpdatedByNeighbor(BlockState var0, BlockState var1) {
        boolean var2 = this.getSideChainPart(var0).isConnected();
        boolean var3 = this.isConnectable(var1) && this.getSideChainPart(var1).isConnected();
        return var2 || var3;
    }

    private Neighbors getNeighbors(LevelAccessor var0, BlockPos var1, Direction var2) {
        return new Neighbors(this, var0, var2, var1, new HashMap<BlockPos, Neighbor>());
    }

    default public void setPart(LevelAccessor var0, BlockPos var1, SideChainPart var2) {
        BlockState var3 = var0.getBlockState(var1);
        if (this.getSideChainPart(var3) != var2) {
            var0.setBlock(var1, this.setSideChainPart(var3, var2), 3);
        }
    }

    public record Neighbors(SideChainPartBlock block, LevelAccessor level, Direction facing, BlockPos center, Map<BlockPos, Neighbor> cache) {
        private boolean isConnectableToThisBlock(BlockState var0) {
            return this.block.isConnectable(var0) && this.block.getFacing(var0) == this.facing;
        }

        private Neighbor createNewNeighbor(BlockPos var0) {
            BlockState var1 = this.level.getBlockState(var0);
            SideChainPart var2 = this.isConnectableToThisBlock(var1) ? this.block.getSideChainPart(var1) : null;
            return var2 == null ? new EmptyNeighbor(var0) : new SideChainNeighbor(this.level, this.block, var0, var2);
        }

        private Neighbor getOrCreateNeighbor(Direction var0, Integer var1) {
            return this.cache.computeIfAbsent(this.center.relative(var0, (int)var1), this::createNewNeighbor);
        }

        public Neighbor left(int var0) {
            return this.getOrCreateNeighbor(this.facing.getClockWise(), var0);
        }

        public Neighbor right(int var0) {
            return this.getOrCreateNeighbor(this.facing.getCounterClockWise(), var0);
        }

        public Neighbor left() {
            return this.left(1);
        }

        public Neighbor right() {
            return this.right(1);
        }
    }

    public static sealed interface Neighbor
    permits EmptyNeighbor, SideChainNeighbor {
        public BlockPos pos();

        public boolean isConnectable();

        public boolean isUnconnectableOrChainEnd();

        public boolean connectsTowards(SideChainPart var1);

        default public void connectToTheRight() {
        }

        default public void connectToTheLeft() {
        }

        default public void disconnectFromRight() {
        }

        default public void disconnectFromLeft() {
        }
    }

    public record SideChainNeighbor(LevelAccessor level, SideChainPartBlock block, BlockPos pos, SideChainPart part) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return this.part.isChainEnd();
        }

        @Override
        public boolean connectsTowards(SideChainPart var0) {
            return this.part.isConnectionTowards(var0);
        }

        @Override
        public void connectToTheRight() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheRight());
        }

        @Override
        public void connectToTheLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheLeft());
        }

        @Override
        public void disconnectFromRight() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheRight());
        }

        @Override
        public void disconnectFromLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheLeft());
        }
    }

    public record EmptyNeighbor(BlockPos pos) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return false;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return true;
        }

        @Override
        public boolean connectsTowards(SideChainPart var0) {
            return false;
        }
    }
}

