/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class SugarCaneBlock
extends Block {
    public static final MapCodec<SugarCaneBlock> CODEC = SugarCaneBlock.simpleCodec(SugarCaneBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 16.0);

    public MapCodec<SugarCaneBlock> codec() {
        return CODEC;
    }

    protected SugarCaneBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!iblockdata.canSurvive(worldserver, blockposition)) {
            worldserver.destroyBlock(blockposition, true);
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.isEmptyBlock(blockposition.above())) {
            int i = 1;
            while (worldserver.getBlockState(blockposition.below(i)).is(this)) {
                ++i;
            }
            if (i < 3) {
                int j = iblockdata.getValue(AGE);
                if (j == 15) {
                    CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition.above(), this.defaultBlockState());
                    worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(AGE, 0), 260);
                } else {
                    worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(AGE, j + 1), 260);
                }
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (!iblockdata.canSurvive(iworldreader, blockposition)) {
            scheduledtickaccess.scheduleTick(blockposition, this, 1);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.below());
        if (iblockdata1.is(this)) {
            return true;
        }
        if (iblockdata1.is(BlockTags.DIRT) || iblockdata1.is(BlockTags.SAND)) {
            BlockPos blockposition1 = blockposition.below();
            for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                BlockState iblockdata2 = iworldreader.getBlockState(blockposition1.relative(enumdirection));
                FluidState fluid = iworldreader.getFluidState(blockposition1.relative(enumdirection));
                if (!fluid.is(FluidTags.WATER) && !iblockdata2.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }
}

