/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class BarrelBlockEntity
extends RandomizableContainerBlockEntity {
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    private static final Component DEFAULT_NAME = Component.translatable("container.barrel");
    private NonNullList<ItemStack> items = NonNullList.withSize(27, ItemStack.EMPTY);
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(Level world, BlockPos blockposition1, BlockState iblockdata1) {
            BarrelBlockEntity.this.playSound(iblockdata1, SoundEvents.BARREL_OPEN);
            BarrelBlockEntity.this.updateBlockState(iblockdata1, true);
        }

        @Override
        protected void onClose(Level world, BlockPos blockposition1, BlockState iblockdata1) {
            BarrelBlockEntity.this.playSound(iblockdata1, SoundEvents.BARREL_CLOSE);
            BarrelBlockEntity.this.updateBlockState(iblockdata1, false);
        }

        @Override
        protected void openerCountChanged(Level world, BlockPos blockposition1, BlockState iblockdata1, int i, int j) {
        }

        @Override
        public boolean isOwnContainer(Player entityhuman) {
            if (entityhuman.containerMenu instanceof ChestMenu) {
                Container iinventory = ((ChestMenu)entityhuman.containerMenu).getContainer();
                return iinventory == BarrelBlockEntity.this;
            }
            return false;
        }
    };

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i) {
        this.maxStack = i;
    }

    public BarrelBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BARREL, blockposition, iblockdata);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        if (!this.trySaveLootTable(valueoutput)) {
            ContainerHelper.saveAllItems(valueoutput, this.items);
        }
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueinput)) {
            ContainerHelper.loadAllItems(valueinput, this.items);
        }
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, Inventory playerinventory) {
        return ChestMenu.threeRows(i, playerinventory, this);
    }

    @Override
    public void startOpen(ContainerUser containeruser) {
        if (!this.remove && !containeruser.getLivingEntity().isSpectator()) {
            this.openersCounter.incrementOpeners(containeruser.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), containeruser.getContainerInteractionRange());
        }
    }

    @Override
    public void stopOpen(ContainerUser containeruser) {
        if (!this.remove && !containeruser.getLivingEntity().isSpectator()) {
            this.openersCounter.decrementOpeners(containeruser.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public List<ContainerUser> getEntitiesWithContainerOpen() {
        return this.openersCounter.getEntitiesWithContainerOpen(this.getLevel(), this.getBlockPos());
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void updateBlockState(BlockState iblockdata, boolean flag) {
        this.level.setBlock(this.getBlockPos(), (BlockState)iblockdata.setValue(BarrelBlock.OPEN, flag), 3);
    }

    public void playSound(BlockState iblockdata, SoundEvent soundeffect) {
        Vec3i baseblockposition = iblockdata.getValue(BarrelBlock.FACING).getUnitVec3i();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)baseblockposition.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)baseblockposition.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)baseblockposition.getZ() / 2.0;
        this.level.playSound((Entity)null, d0, d1, d2, soundeffect, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

