/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;

public class BellBlockEntity
extends BlockEntity {
    private static final int DURATION = 50;
    private static final int GLOW_DURATION = 60;
    private static final int MIN_TICKS_BETWEEN_SEARCHES = 60;
    private static final int MAX_RESONATION_TICKS = 40;
    private static final int TICKS_BEFORE_RESONATION = 5;
    private static final int SEARCH_RADIUS = 48;
    private static final int HEAR_BELL_RADIUS = 32;
    private static final int HIGHLIGHT_RAIDERS_RADIUS = 48;
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<net.minecraft.world.entity.LivingEntity> nearbyEntities;
    public boolean resonating;
    public int resonationTicks;

    public BellBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BELL, blockposition, iblockdata);
    }

    @Override
    public boolean triggerEvent(int i, int j) {
        if (i == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.from3DDataValue(j);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.triggerEvent(i, j);
    }

    private static void tick(Level world, BlockPos blockposition, BlockState iblockdata, BellBlockEntity tileentitybell, ResonationEndAction tileentitybell_a) {
        if (tileentitybell.shaking) {
            ++tileentitybell.ticks;
        }
        if (tileentitybell.ticks >= 50) {
            tileentitybell.shaking = false;
            tileentitybell.ticks = 0;
        }
        if (tileentitybell.ticks >= 5 && tileentitybell.resonationTicks == 0 && BellBlockEntity.areRaidersNearby(blockposition, tileentitybell.nearbyEntities)) {
            tileentitybell.resonating = true;
            world.playSound((Entity)null, blockposition, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (tileentitybell.resonating) {
            if (tileentitybell.resonationTicks < 40) {
                ++tileentitybell.resonationTicks;
            } else {
                tileentitybell_a.run(world, blockposition, tileentitybell.nearbyEntities);
                tileentitybell.resonating = false;
            }
        }
    }

    public static void clientTick(Level world, BlockPos blockposition, BlockState iblockdata, BellBlockEntity tileentitybell) {
        BellBlockEntity.tick(world, blockposition, iblockdata, tileentitybell, BellBlockEntity::showBellParticles);
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, BellBlockEntity tileentitybell) {
        BellBlockEntity.tick(world, blockposition, iblockdata, tileentitybell, BellBlockEntity::makeRaidersGlow);
    }

    public void onHit(Direction enumdirection) {
        BlockPos blockposition = this.getBlockPos();
        this.clickDirection = enumdirection;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        this.level.blockEvent(blockposition, this.getBlockState().getBlock(), 1, enumdirection.get3DDataValue());
    }

    private void updateEntities() {
        BlockPos blockposition = this.getBlockPos();
        if (this.level.getGameTime() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
            this.lastRingTimestamp = this.level.getGameTime();
            AABB axisalignedbb = new AABB(blockposition).inflate(48.0);
            this.nearbyEntities = this.level.getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, axisalignedbb);
        }
        if (!this.level.isClientSide()) {
            for (net.minecraft.world.entity.LivingEntity entityliving : this.nearbyEntities) {
                if (!entityliving.isAlive() || entityliving.isRemoved() || !blockposition.closerToCenterThan(entityliving.position(), 32.0)) continue;
                entityliving.getBrain().setMemory(MemoryModuleType.HEARD_BELL_TIME, this.level.getGameTime());
            }
        }
    }

    private static boolean areRaidersNearby(BlockPos blockposition, List<net.minecraft.world.entity.LivingEntity> list) {
        for (net.minecraft.world.entity.LivingEntity entityliving : list) {
            if (!entityliving.isAlive() || entityliving.isRemoved() || !blockposition.closerToCenterThan(entityliving.position(), 32.0) || !entityliving.getType().is(EntityTypeTags.RAIDERS)) continue;
            return true;
        }
        return false;
    }

    private static void makeRaidersGlow(Level world, BlockPos blockposition, List<net.minecraft.world.entity.LivingEntity> list) {
        List entities = list.stream().filter(entityliving -> BellBlockEntity.isRaiderWithinRange(blockposition, entityliving)).map(entity -> (LivingEntity)entity.getBukkitEntity()).collect(Collectors.toCollection(ArrayList::new));
        CraftEventFactory.handleBellResonateEvent(world, blockposition, entities).forEach(BellBlockEntity::glow);
    }

    private static void showBellParticles(Level world, BlockPos blockposition, List<net.minecraft.world.entity.LivingEntity> list) {
        MutableInt mutableint = new MutableInt(16700985);
        int i = (int)list.stream().filter(entityliving -> blockposition.closerToCenterThan(entityliving.position(), 48.0)).count();
        list.stream().filter(entityliving -> BellBlockEntity.isRaiderWithinRange(blockposition, entityliving)).forEach(entityliving -> {
            float f = 1.0f;
            double d0 = Math.sqrt((entityliving.getX() - (double)blockposition.getX()) * (entityliving.getX() - (double)blockposition.getX()) + (entityliving.getZ() - (double)blockposition.getZ()) * (entityliving.getZ() - (double)blockposition.getZ()));
            double d1 = (double)((float)blockposition.getX() + 0.5f) + 1.0 / d0 * (entityliving.getX() - (double)blockposition.getX());
            double d2 = (double)((float)blockposition.getZ() + 0.5f) + 1.0 / d0 * (entityliving.getZ() - (double)blockposition.getZ());
            int j = Mth.clamp((i - 21) / -2, 3, 15);
            for (int k = 0; k < j; ++k) {
                int l = mutableint.addAndGet(5);
                world.addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, l), d1, (float)blockposition.getY() + 0.5f, d2, 0.0, 0.0, 0.0);
            }
        });
    }

    private static boolean isRaiderWithinRange(BlockPos blockposition, net.minecraft.world.entity.LivingEntity entityliving) {
        return entityliving.isAlive() && !entityliving.isRemoved() && blockposition.closerToCenterThan(entityliving.position(), 48.0) && entityliving.getType().is(EntityTypeTags.RAIDERS);
    }

    private static void glow(net.minecraft.world.entity.LivingEntity entityliving) {
        entityliving.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60));
    }

    @FunctionalInterface
    private static interface ResonationEndAction {
        public void run(Level var1, BlockPos var2, List<net.minecraft.world.entity.LivingEntity> var3);
    }
}

