/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private static final int NO_COOLDOWN_TIME = -1;
    private static final Component DEFAULT_NAME = Component.translatable("container.hopper");
    private NonNullList<net.minecraft.world.item.ItemStack> items;
    private int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public HopperBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.HOPPER, blockposition, iblockdata);
        this.items = NonNullList.withSize(5, net.minecraft.world.item.ItemStack.EMPTY);
        this.facing = iblockdata.getValue(HopperBlock.FACING);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        if (!this.tryLoadLootTable(valueinput)) {
            ContainerHelper.loadAllItems(valueinput, this.items);
        }
        this.cooldownTime = valueinput.getIntOr("TransferCooldown", -1);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        if (!this.trySaveLootTable(valueoutput)) {
            ContainerHelper.saveAllItems(valueoutput, this.items);
        }
        valueoutput.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack removeItem(int i, int j) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), i, j);
    }

    @Override
    public void setItem(int i, net.minecraft.world.item.ItemStack itemstack) {
        this.unpackLootTable(null);
        this.getItems().set(i, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
    }

    @Override
    public void setBlockState(BlockState iblockdata) {
        super.setBlockState(iblockdata);
        this.facing = iblockdata.getValue(HopperBlock.FACING);
    }

    @Override
    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    public static void pushItemsTick(Level world, BlockPos blockposition, BlockState iblockdata, HopperBlockEntity tileentityhopper) {
        --tileentityhopper.cooldownTime;
        tileentityhopper.tickedGameTime = world.getGameTime();
        if (!tileentityhopper.isOnCooldown()) {
            tileentityhopper.setCooldown(0);
            HopperBlockEntity.tryMoveItems(world, blockposition, iblockdata, tileentityhopper, () -> HopperBlockEntity.suckInItems(world, tileentityhopper));
        }
    }

    private static boolean tryMoveItems(Level world, BlockPos blockposition, BlockState iblockdata, HopperBlockEntity tileentityhopper, BooleanSupplier booleansupplier) {
        if (world.isClientSide()) {
            return false;
        }
        if (!tileentityhopper.isOnCooldown() && iblockdata.getValue(HopperBlock.ENABLED).booleanValue()) {
            boolean flag = false;
            if (!tileentityhopper.isEmpty()) {
                flag = HopperBlockEntity.ejectItems(world, blockposition, tileentityhopper);
            }
            if (!tileentityhopper.inventoryFull()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                tileentityhopper.setCooldown(8);
                HopperBlockEntity.setChanged(world, blockposition, iblockdata);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (net.minecraft.world.item.ItemStack itemstack : this.items) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level world, BlockPos blockposition, HopperBlockEntity tileentityhopper) {
        Container iinventory = HopperBlockEntity.getAttachedContainer(world, blockposition, tileentityhopper);
        if (iinventory == null) {
            return false;
        }
        Direction enumdirection = tileentityhopper.facing.getOpposite();
        if (HopperBlockEntity.isFullContainer(iinventory, enumdirection)) {
            return false;
        }
        for (int i = 0; i < tileentityhopper.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = tileentityhopper.getItem(i);
            if (itemstack.isEmpty()) continue;
            int j = itemstack.getCount();
            net.minecraft.world.item.ItemStack original = itemstack.copy();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(tileentityhopper.removeItem(i, 1));
            Object destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentityhopper.getOwner().getInventory(), (ItemStack)oitemstack, (Inventory)destinationInventory, true);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                tileentityhopper.setItem(i, original);
                tileentityhopper.setCooldown(8);
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = HopperBlockEntity.addItem(tileentityhopper, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection);
            if (itemstack1.isEmpty()) {
                iinventory.setChanged();
                return true;
            }
            itemstack.setCount(j);
            if (j != 1) continue;
            tileentityhopper.setItem(i, itemstack);
        }
        return false;
    }

    private static int[] getSlots(Container iinventory, Direction enumdirection) {
        if (iinventory instanceof WorldlyContainer) {
            WorldlyContainer iworldinventory = (WorldlyContainer)iinventory;
            return iworldinventory.getSlotsForFace(enumdirection);
        }
        int i = iinventory.getContainerSize();
        if (i < CACHED_SLOTS.length) {
            int[] aint = CACHED_SLOTS[i];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = HopperBlockEntity.createFlatSlots(i);
            HopperBlockEntity.CACHED_SLOTS[i] = aint1;
            return aint1;
        }
        return HopperBlockEntity.createFlatSlots(i);
    }

    private static int[] createFlatSlots(int i) {
        int[] aint = new int[i];
        int j = 0;
        while (j < aint.length) {
            aint[j] = j++;
        }
        return aint;
    }

    private static boolean isFullContainer(Container iinventory, Direction enumdirection) {
        int[] aint;
        for (int i : aint = HopperBlockEntity.getSlots(iinventory, enumdirection)) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(i);
            if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(Level world, Hopper ihopper) {
        boolean flag;
        BlockState iblockdata;
        BlockPos blockposition = BlockPos.containing(ihopper.getLevelX(), ihopper.getLevelY() + 1.0, ihopper.getLevelZ());
        Container iinventory = HopperBlockEntity.getSourceContainer(world, ihopper, blockposition, iblockdata = world.getBlockState(blockposition));
        if (iinventory != null) {
            Direction enumdirection = Direction.DOWN;
            for (int i : HopperBlockEntity.getSlots(iinventory, enumdirection)) {
                if (!HopperBlockEntity.tryTakeInItemFromSlot(ihopper, iinventory, i, enumdirection)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = ihopper.isGridAligned() && iblockdata.isCollisionShapeFullBlock(world, blockposition) && !iblockdata.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (!flag) {
            for (ItemEntity entityitem : HopperBlockEntity.getItemsAtAndAbove(world, ihopper)) {
                if (!HopperBlockEntity.addItem(ihopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper ihopper, Container iinventory, int i, Direction enumdirection) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(i);
        if (!itemstack.isEmpty() && HopperBlockEntity.canTakeItemFromContainer(ihopper, iinventory, itemstack, i, enumdirection)) {
            int j = itemstack.getCount();
            net.minecraft.world.item.ItemStack original = itemstack.copy();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(iinventory.removeItem(i, 1));
            Object sourceInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent((Inventory)sourceInventory, (ItemStack)oitemstack, ihopper.getOwner().getInventory(), false);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                iinventory.setItem(i, original);
                if (ihopper instanceof HopperBlockEntity) {
                    ((HopperBlockEntity)ihopper).setCooldown(8);
                }
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = HopperBlockEntity.addItem(iinventory, ihopper, CraftItemStack.asNMSCopy(event.getItem()), null);
            if (itemstack1.isEmpty()) {
                iinventory.setChanged();
                return true;
            }
            itemstack.setCount(j);
            if (j == 1) {
                iinventory.setItem(i, itemstack);
            }
        }
        return false;
    }

    public static boolean addItem(Container iinventory, ItemEntity entityitem) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(iinventory.getOwner().getInventory(), (Item)entityitem.getBukkitEntity());
        entityitem.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = entityitem.getItem().copy();
        net.minecraft.world.item.ItemStack itemstack1 = HopperBlockEntity.addItem(null, iinventory, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            entityitem.setItem(net.minecraft.world.item.ItemStack.EMPTY);
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            entityitem.setItem(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack addItem(@Nullable Container iinventory, Container iinventory1, net.minecraft.world.item.ItemStack itemstack, @Nullable Direction enumdirection) {
        if (iinventory1 instanceof WorldlyContainer) {
            WorldlyContainer iworldinventory = (WorldlyContainer)iinventory1;
            if (enumdirection != null) {
                int[] aint = iworldinventory.getSlotsForFace(enumdirection);
                for (int i = 0; i < aint.length && !itemstack.isEmpty(); ++i) {
                    itemstack = HopperBlockEntity.tryMoveInItem(iinventory, iinventory1, itemstack, aint[i], enumdirection);
                }
                return itemstack;
            }
        }
        int j = iinventory1.getContainerSize();
        for (int k = 0; k < j && !itemstack.isEmpty(); ++k) {
            itemstack = HopperBlockEntity.tryMoveInItem(iinventory, iinventory1, itemstack, k, enumdirection);
        }
        return itemstack;
    }

    private static boolean canPlaceItemInContainer(Container iinventory, net.minecraft.world.item.ItemStack itemstack, int i, @Nullable Direction enumdirection) {
        WorldlyContainer iworldinventory;
        if (!iinventory.canPlaceItem(i, itemstack)) {
            return false;
        }
        if (iinventory instanceof WorldlyContainer && !(iworldinventory = (WorldlyContainer)iinventory).canPlaceItemThroughFace(i, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean canTakeItemFromContainer(Container iinventory, Container iinventory1, net.minecraft.world.item.ItemStack itemstack, int i, Direction enumdirection) {
        WorldlyContainer iworldinventory;
        if (!iinventory1.canTakeItem(iinventory, i, itemstack)) {
            return false;
        }
        if (iinventory1 instanceof WorldlyContainer && !(iworldinventory = (WorldlyContainer)iinventory1).canTakeItemThroughFace(i, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static net.minecraft.world.item.ItemStack tryMoveInItem(@Nullable Container iinventory, Container iinventory1, net.minecraft.world.item.ItemStack itemstack, int i, @Nullable Direction enumdirection) {
        net.minecraft.world.item.ItemStack itemstack1 = iinventory1.getItem(i);
        if (HopperBlockEntity.canPlaceItemInContainer(iinventory1, itemstack, i, enumdirection)) {
            boolean flag = false;
            boolean flag1 = iinventory1.isEmpty();
            if (itemstack1.isEmpty()) {
                iinventory1.setItem(i, itemstack);
                itemstack = net.minecraft.world.item.ItemStack.EMPTY;
                flag = true;
            } else if (HopperBlockEntity.canMergeItems(itemstack1, itemstack)) {
                int j = itemstack.getMaxStackSize() - itemstack1.getCount();
                int k = Math.min(itemstack.getCount(), j);
                itemstack.shrink(k);
                itemstack1.grow(k);
                boolean bl = flag = k > 0;
            }
            if (flag) {
                HopperBlockEntity tileentityhopper;
                if (flag1 && iinventory1 instanceof HopperBlockEntity && !(tileentityhopper = (HopperBlockEntity)iinventory1).isOnCustomCooldown()) {
                    int l = 0;
                    if (iinventory instanceof HopperBlockEntity) {
                        HopperBlockEntity tileentityhopper1 = (HopperBlockEntity)iinventory;
                        if (tileentityhopper.tickedGameTime >= tileentityhopper1.tickedGameTime) {
                            l = 1;
                        }
                    }
                    tileentityhopper.setCooldown(8 - l);
                }
                iinventory1.setChanged();
            }
        }
        return itemstack;
    }

    @Nullable
    private static Container runHopperInventorySearchEvent(Container inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static Container getAttachedContainer(Level world, BlockPos blockposition, HopperBlockEntity tileentityhopper) {
        BlockPos searchPosition = blockposition.relative(tileentityhopper.facing);
        Container inventory = HopperBlockEntity.getContainerAt(world, searchPosition);
        CraftBlock hopper = CraftBlock.at(world, blockposition);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static Container getSourceContainer(Level world, Hopper ihopper, BlockPos blockposition, BlockState iblockdata) {
        Container inventory = HopperBlockEntity.getContainerAt(world, blockposition, iblockdata, ihopper.getLevelX(), ihopper.getLevelY() + 1.0, ihopper.getLevelZ());
        BlockPos blockPosition = BlockPos.containing(ihopper.getLevelX(), ihopper.getLevelY(), ihopper.getLevelZ());
        CraftBlock hopper = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.above());
        return HopperBlockEntity.runHopperInventorySearchEvent(inventory, hopper, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level world, Hopper ihopper) {
        AABB axisalignedbb = ihopper.getSuckAabb().move(ihopper.getLevelX() - 0.5, ihopper.getLevelY() - 0.5, ihopper.getLevelZ() - 0.5);
        return world.getEntitiesOfClass(ItemEntity.class, axisalignedbb, EntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static Container getContainerAt(Level world, BlockPos blockposition) {
        return HopperBlockEntity.getContainerAt(world, blockposition, world.getBlockState(blockposition), (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level world, BlockPos blockposition, BlockState iblockdata, double d0, double d1, double d2) {
        Container iinventory = HopperBlockEntity.getBlockContainer(world, blockposition, iblockdata);
        if (iinventory == null) {
            iinventory = HopperBlockEntity.getEntityContainer(world, d0, d1, d2);
        }
        return iinventory;
    }

    @Nullable
    private static Container getBlockContainer(Level world, BlockPos blockposition, BlockState iblockdata) {
        BlockEntity tileentity;
        Block block = iblockdata.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)((Object)block)).getContainer(iblockdata, world, blockposition);
        }
        if (iblockdata.hasBlockEntity() && (tileentity = world.getBlockEntity(blockposition)) instanceof Container) {
            Container iinventory = (Container)((Object)tileentity);
            if (iinventory instanceof ChestBlockEntity && block instanceof ChestBlock) {
                iinventory = ChestBlock.getContainer((ChestBlock)block, iblockdata, world, blockposition, true);
            }
            return iinventory;
        }
        return null;
    }

    @Nullable
    private static Container getEntityContainer(Level world, double d0, double d1, double d2) {
        List<Entity> list = world.getEntities((Entity)null, new AABB(d0 - 0.5, d1 - 0.5, d2 - 0.5, d0 + 0.5, d1 + 0.5, d2 + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR);
        return !list.isEmpty() ? (Container)((Object)list.get(world.random.nextInt(list.size()))) : null;
    }

    private static boolean canMergeItems(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        return itemstack.getCount() <= itemstack.getMaxStackSize() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, itemstack1);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    private void setCooldown(int i) {
        this.cooldownTime = i;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    public static void entityInside(Level world, BlockPos blockposition, BlockState iblockdata, Entity entity, HopperBlockEntity tileentityhopper) {
        ItemEntity entityitem;
        if (entity instanceof ItemEntity && !(entityitem = (ItemEntity)entity).getItem().isEmpty() && entity.getBoundingBox().move(-blockposition.getX(), -blockposition.getY(), -blockposition.getZ()).intersects(tileentityhopper.getSuckAabb())) {
            HopperBlockEntity.tryMoveItems(world, blockposition, iblockdata, tileentityhopper, () -> HopperBlockEntity.addItem(tileentityhopper, entityitem));
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int i, net.minecraft.world.entity.player.Inventory playerinventory) {
        return new HopperMenu(i, playerinventory, this);
    }
}

