/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerStateData {
    private static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    private static final int DELAY_BETWEEN_PLAYER_SCANS = 20;
    private static final int TRIAL_OMEN_PER_BAD_OMEN_LEVEL = 18000;
    public final Set<UUID> detectedPlayers = new HashSet<UUID>();
    public final Set<UUID> currentMobs = new HashSet<UUID>();
    long cooldownEndsAt;
    long nextMobSpawnsAt;
    int totalMobsSpawned;
    public Optional<SpawnData> nextSpawnData = Optional.empty();
    Optional<ResourceKey<LootTable>> ejectingLootTable = Optional.empty();
    @Nullable
    private Entity displayEntity;
    @Nullable
    private WeightedList<ItemStack> dispensing;
    double spin;
    double oSpin;

    public Packed pack() {
        return new Packed(Set.copyOf(this.detectedPlayers), Set.copyOf(this.currentMobs), this.cooldownEndsAt, this.nextMobSpawnsAt, this.totalMobsSpawned, this.nextSpawnData, this.ejectingLootTable);
    }

    public void apply(Packed trialspawnerdata_a) {
        this.detectedPlayers.clear();
        this.detectedPlayers.addAll(trialspawnerdata_a.detectedPlayers);
        this.currentMobs.clear();
        this.currentMobs.addAll(trialspawnerdata_a.currentMobs);
        this.cooldownEndsAt = trialspawnerdata_a.cooldownEndsAt;
        this.nextMobSpawnsAt = trialspawnerdata_a.nextMobSpawnsAt;
        this.totalMobsSpawned = trialspawnerdata_a.totalMobsSpawned;
        this.nextSpawnData = trialspawnerdata_a.nextSpawnData;
        this.ejectingLootTable = trialspawnerdata_a.ejectingLootTable;
    }

    public void reset() {
        this.currentMobs.clear();
        this.nextSpawnData = Optional.empty();
        this.resetStatistics();
    }

    public void resetStatistics() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
    }

    public boolean hasMobToSpawn(TrialSpawner trialspawner, RandomSource randomsource) {
        boolean flag = this.getOrCreateNextSpawnData(trialspawner, randomsource).getEntityToSpawn().getString("id").isPresent();
        return flag || !trialspawner.activeConfig().spawnPotentialsDefinition().isEmpty();
    }

    public boolean hasFinishedSpawningAllMobs(TrialSpawnerConfig trialspawnerconfig, int i) {
        return this.totalMobsSpawned >= trialspawnerconfig.calculateTargetTotalMobs(i);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(ServerLevel worldserver, TrialSpawnerConfig trialspawnerconfig, int i) {
        return worldserver.getGameTime() >= this.nextMobSpawnsAt && this.currentMobs.size() < trialspawnerconfig.calculateTargetSimultaneousMobs(i);
    }

    public int countAdditionalPlayers(BlockPos blockposition) {
        if (this.detectedPlayers.isEmpty()) {
            Util.logAndPauseIfInIde("Trial Spawner at " + String.valueOf(blockposition) + " has no detected players");
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(ServerLevel worldserver, BlockPos blockposition, TrialSpawner trialspawner) {
        boolean flag;
        boolean bl = flag = (blockposition.asLong() + worldserver.getGameTime()) % 20L != 0L;
        if (!(flag || trialspawner.getState().equals(TrialSpawnerState.COOLDOWN) && trialspawner.isOminous())) {
            boolean flag1;
            List<UUID> list = trialspawner.getPlayerDetector().detect(worldserver, trialspawner.getEntitySelector(), blockposition, trialspawner.getRequiredPlayerRange(), true);
            if (!trialspawner.isOminous() && !list.isEmpty()) {
                Optional<Pair<Player, Holder<MobEffect>>> optional = TrialSpawnerStateData.findPlayerWithOminousEffect(worldserver, list);
                optional.ifPresent(pair -> {
                    Player entityhuman = (Player)pair.getFirst();
                    if (pair.getSecond() == MobEffects.BAD_OMEN) {
                        TrialSpawnerStateData.transformBadOmenIntoTrialOmen(entityhuman);
                    }
                    worldserver.levelEvent(3020, BlockPos.containing(entityhuman.getEyePosition()), 0);
                    trialspawner.applyOminous(worldserver, blockposition);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!trialspawner.getState().equals(TrialSpawnerState.COOLDOWN) || flag1) {
                List<UUID> list1;
                boolean flag2 = trialspawner.getStateData().detectedPlayers.isEmpty();
                List<UUID> list2 = list1 = flag2 ? list : trialspawner.getPlayerDetector().detect(worldserver, trialspawner.getEntitySelector(), blockposition, trialspawner.getRequiredPlayerRange(), false);
                if (this.detectedPlayers.addAll(list1)) {
                    this.nextMobSpawnsAt = Math.max(worldserver.getGameTime() + 40L, this.nextMobSpawnsAt);
                    if (!flag1) {
                        int i = trialspawner.isOminous() ? 3019 : 3013;
                        worldserver.levelEvent(i, blockposition, this.detectedPlayers.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<Player, Holder<MobEffect>>> findPlayerWithOminousEffect(ServerLevel worldserver, List<UUID> list) {
        Player entityhuman = null;
        for (UUID uuid : list) {
            Player entityhuman1 = worldserver.getPlayerByUUID(uuid);
            if (entityhuman1 == null) continue;
            Holder<MobEffect> holder = MobEffects.TRIAL_OMEN;
            if (entityhuman1.hasEffect(holder)) {
                return Optional.of(Pair.of((Object)entityhuman1, holder));
            }
            if (!entityhuman1.hasEffect(MobEffects.BAD_OMEN)) continue;
            entityhuman = entityhuman1;
        }
        return Optional.ofNullable(entityhuman).map(entityhuman2 -> Pair.of((Object)entityhuman2, MobEffects.BAD_OMEN));
    }

    public void resetAfterBecomingOminous(TrialSpawner trialspawner, ServerLevel worldserver) {
        Stream stream = this.currentMobs.stream();
        Objects.requireNonNull(worldserver);
        stream.map(worldserver::getEntity).forEach(entity -> {
            if (entity != null) {
                worldserver.levelEvent(3012, entity.blockPosition(), TrialSpawner.FlameParticle.NORMAL.encode());
                if (entity instanceof Mob) {
                    Mob entityinsentient = (Mob)entity;
                    entityinsentient.dropPreservedEquipment(worldserver);
                }
                entity.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!trialspawner.ominousConfig().spawnPotentialsDefinition().isEmpty()) {
            this.nextSpawnData = Optional.empty();
        }
        this.totalMobsSpawned = 0;
        this.currentMobs.clear();
        this.nextMobSpawnsAt = worldserver.getGameTime() + (long)trialspawner.ominousConfig().ticksBetweenSpawn();
        trialspawner.markUpdated();
        this.cooldownEndsAt = worldserver.getGameTime() + trialspawner.ominousConfig().ticksBetweenItemSpawners();
    }

    private static void transformBadOmenIntoTrialOmen(Player entityhuman) {
        MobEffectInstance mobeffect = entityhuman.getEffect(MobEffects.BAD_OMEN);
        if (mobeffect != null) {
            int i = mobeffect.getAmplifier() + 1;
            int j = 18000 * i;
            entityhuman.removeEffect(MobEffects.BAD_OMEN);
            entityhuman.addEffect(new MobEffectInstance(MobEffects.TRIAL_OMEN, j, 0));
        }
    }

    public boolean isReadyToOpenShutter(ServerLevel worldserver, float f, int i) {
        long j = this.cooldownEndsAt - (long)i;
        return (float)worldserver.getGameTime() >= (float)j + f;
    }

    public boolean isReadyToEjectItems(ServerLevel worldserver, float f, int i) {
        long j = this.cooldownEndsAt - (long)i;
        return (float)(worldserver.getGameTime() - j) % f == 0.0f;
    }

    public boolean isCooldownFinished(ServerLevel worldserver) {
        return worldserver.getGameTime() >= this.cooldownEndsAt;
    }

    protected SpawnData getOrCreateNextSpawnData(TrialSpawner trialspawner, RandomSource randomsource) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        WeightedList<SpawnData> weightedlist = trialspawner.activeConfig().spawnPotentialsDefinition();
        Optional<SpawnData> optional = weightedlist.isEmpty() ? this.nextSpawnData : weightedlist.getRandom(randomsource);
        this.nextSpawnData = Optional.of(optional.orElseGet(SpawnData::new));
        trialspawner.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(TrialSpawner trialspawner, Level world, TrialSpawnerState trialspawnerstate) {
        CompoundTag nbttagcompound;
        if (!trialspawnerstate.hasSpinningMob()) {
            return null;
        }
        if (this.displayEntity == null && (nbttagcompound = this.getOrCreateNextSpawnData(trialspawner, world.getRandom()).getEntityToSpawn()).getString("id").isPresent()) {
            this.displayEntity = EntityType.loadEntityRecursive(nbttagcompound, world, EntitySpawnReason.TRIAL_SPAWNER, Function.identity());
        }
        return this.displayEntity;
    }

    public CompoundTag getUpdateTag(TrialSpawnerState trialspawnerstate) {
        CompoundTag nbttagcompound = new CompoundTag();
        if (trialspawnerstate == TrialSpawnerState.ACTIVE) {
            nbttagcompound.putLong(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(mobspawnerdata -> nbttagcompound.store(TAG_SPAWN_DATA, SpawnData.CODEC, mobspawnerdata));
        return nbttagcompound;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    WeightedList<ItemStack> getDispensingItems(ServerLevel worldserver, TrialSpawnerConfig trialspawnerconfig, BlockPos blockposition) {
        long i;
        LootParams lootparams;
        if (this.dispensing != null) {
            return this.dispensing;
        }
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(trialspawnerconfig.itemsToDropWhenOminous());
        ObjectArrayList<ItemStack> objectarraylist = loottable.getRandomItems(lootparams = new LootParams.Builder(worldserver).create(LootContextParamSets.EMPTY), i = TrialSpawnerStateData.lowResolutionPosition(worldserver, blockposition));
        if (objectarraylist.isEmpty()) {
            return WeightedList.of();
        }
        WeightedList.Builder<ItemStack> weightedlist_a = WeightedList.builder();
        for (ItemStack itemstack : objectarraylist) {
            weightedlist_a.add(itemstack.copyWithCount(1), itemstack.getCount());
        }
        this.dispensing = weightedlist_a.build();
        return this.dispensing;
    }

    private static long lowResolutionPosition(ServerLevel worldserver, BlockPos blockposition) {
        BlockPos blockposition1 = new BlockPos(Mth.floor((float)blockposition.getX() / 30.0f), Mth.floor((float)blockposition.getY() / 20.0f), Mth.floor((float)blockposition.getZ() / 30.0f));
        return worldserver.getSeed() + blockposition1.asLong();
    }

    public record Packed(Set<UUID> detectedPlayers, Set<UUID> currentMobs, long cooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, Optional<SpawnData> nextSpawnData, Optional<ResourceKey<LootTable>> ejectingLootTable) {
        public static final MapCodec<Packed> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("registered_players", Set.of()).forGetter(Packed::detectedPlayers), (App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("current_mobs", Set.of()).forGetter(Packed::currentMobs), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(Packed::cooldownEndsAt), (App)Codec.LONG.lenientOptionalFieldOf(TrialSpawnerStateData.TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(Packed::nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(Packed::totalMobsSpawned), (App)SpawnData.CODEC.lenientOptionalFieldOf(TrialSpawnerStateData.TAG_SPAWN_DATA).forGetter(Packed::nextSpawnData), (App)LootTable.KEY_CODEC.lenientOptionalFieldOf("ejecting_loot_table").forGetter(Packed::ejectingLootTable)).apply((Applicative)instance, Packed::new));
    }
}

