/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BlockPatternBuilder {
    private static final Joiner COMMA_JOINED = Joiner.on((String)",");
    private final List<String[]> pattern = Lists.newArrayList();
    private final Map<Character, Predicate<BlockInWorld>> lookup = Maps.newHashMap();
    private int height;
    private int width;

    private BlockPatternBuilder() {
        this.lookup.put(Character.valueOf(' '), var0 -> true);
    }

    public BlockPatternBuilder aisle(String ... var0) {
        if (ArrayUtils.isEmpty((Object[])var0) || StringUtils.isEmpty((CharSequence)var0[0])) {
            throw new IllegalArgumentException("Empty pattern for aisle");
        }
        if (this.pattern.isEmpty()) {
            this.height = var0.length;
            this.width = var0[0].length();
        }
        if (var0.length != this.height) {
            throw new IllegalArgumentException("Expected aisle with height of " + this.height + ", but was given one with a height of " + var0.length + ")");
        }
        for (String var4 : var0) {
            if (var4.length() != this.width) {
                throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.width + ", found one with " + var4.length() + ")");
            }
            for (char var8 : var4.toCharArray()) {
                if (this.lookup.containsKey(Character.valueOf(var8))) continue;
                this.lookup.put(Character.valueOf(var8), null);
            }
        }
        this.pattern.add(var0);
        return this;
    }

    public static BlockPatternBuilder start() {
        return new BlockPatternBuilder();
    }

    public BlockPatternBuilder where(char var0, Predicate<BlockInWorld> var1) {
        this.lookup.put(Character.valueOf(var0), var1);
        return this;
    }

    public BlockPattern build() {
        return new BlockPattern(this.createPattern());
    }

    private Predicate<BlockInWorld>[][][] createPattern() {
        this.ensureAllCharactersMatched();
        Predicate[][][] var0 = (Predicate[][][])Array.newInstance(Predicate.class, this.pattern.size(), this.height, this.width);
        for (int var1 = 0; var1 < this.pattern.size(); ++var1) {
            for (int var2 = 0; var2 < this.height; ++var2) {
                for (int var3 = 0; var3 < this.width; ++var3) {
                    var0[var1][var2][var3] = this.lookup.get(Character.valueOf(this.pattern.get(var1)[var2].charAt(var3)));
                }
            }
        }
        return var0;
    }

    private void ensureAllCharactersMatched() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<Character, Predicate<BlockInWorld>> var2 : this.lookup.entrySet()) {
            if (var2.getValue() != null) continue;
            var0.add(var2.getKey());
        }
        if (!var0.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + COMMA_JOINED.join((Iterable)var0) + " are missing");
        }
    }
}

