/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class EndDragonFight {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_DRAGON_RESPAWN = 1200;
    private static final int TIME_BETWEEN_CRYSTAL_SCANS = 100;
    public static final int TIME_BETWEEN_PLAYER_SCANS = 20;
    private static final int ARENA_SIZE_CHUNKS = 8;
    public static final int ARENA_TICKET_LEVEL = 9;
    private static final int GATEWAY_COUNT = 20;
    private static final int GATEWAY_DISTANCE = 96;
    public static final int DRAGON_SPAWN_Y = 128;
    private final Predicate<Entity> validPlayer;
    public final ServerBossEvent dragonEvent = (ServerBossEvent)new ServerBossEvent(Component.translatable("entity.minecraft.ender_dragon"), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).setPlayBossMusic(true).setCreateWorldFog(true);
    public final ServerLevel level;
    private final BlockPos origin;
    private final ObjectArrayList<Integer> gateways = new ObjectArrayList();
    private final BlockPattern exitPortalPattern;
    private int ticksSinceDragonSeen;
    private int crystalsAlive;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan = 21;
    private boolean dragonKilled;
    public boolean previouslyKilled;
    private boolean skipArenaLoadedCheck = false;
    @Nullable
    public UUID dragonUUID;
    private boolean needsStateScanning = true;
    @Nullable
    public BlockPos portalLocation;
    @Nullable
    public DragonRespawnAnimation respawnStage;
    private int respawnTime;
    @Nullable
    private List<EndCrystal> respawnCrystals;

    public EndDragonFight(ServerLevel worldserver, long i, Data enderdragonbattle_a) {
        this(worldserver, i, enderdragonbattle_a, BlockPos.ZERO);
    }

    public EndDragonFight(ServerLevel worldserver, long i, Data enderdragonbattle_a, BlockPos blockposition) {
        this.level = worldserver;
        this.origin = blockposition;
        this.validPlayer = EntitySelector.ENTITY_STILL_ALIVE.and(EntitySelector.withinDistance(blockposition.getX(), 128 + blockposition.getY(), blockposition.getZ(), 192.0));
        this.needsStateScanning = enderdragonbattle_a.needsStateScanning;
        this.dragonUUID = enderdragonbattle_a.dragonUUID.orElse(null);
        this.dragonKilled = enderdragonbattle_a.dragonKilled;
        this.previouslyKilled = enderdragonbattle_a.previouslyKilled;
        if (enderdragonbattle_a.isRespawning) {
            this.respawnStage = DragonRespawnAnimation.START;
        }
        this.portalLocation = enderdragonbattle_a.exitPortalLocation.orElse(null);
        this.gateways.addAll((Collection)enderdragonbattle_a.gateways.orElseGet(() -> {
            ObjectArrayList objectarraylist = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Util.shuffle(objectarraylist, RandomSource.create(i));
            return objectarraylist;
        }));
        this.exitPortalPattern = BlockPatternBuilder.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', BlockInWorld.hasState(BlockPredicate.forBlock(Blocks.BEDROCK))).build();
    }

    @Deprecated
    @VisibleForTesting
    public void skipArenaLoadedCheck() {
        this.skipArenaLoadedCheck = true;
    }

    public Data saveData() {
        return new Data(this.needsStateScanning, this.dragonKilled, this.previouslyKilled, false, Optional.ofNullable(this.dragonUUID), Optional.ofNullable(this.portalLocation), Optional.of(this.gateways));
    }

    public void tick() {
        this.dragonEvent.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addTicketWithRadius(TicketType.DRAGON, new ChunkPos(0, 0), 9);
            boolean flag = this.isArenaLoaded();
            if (this.needsStateScanning && flag) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (this.respawnStage != null) {
                if (this.respawnCrystals == null && flag) {
                    this.respawnStage = null;
                    this.tryRespawn();
                }
                this.respawnStage.tick(this.level, this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && flag) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && flag) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeTicketWithRadius(TicketType.DRAGON, new ChunkPos(0, 0), 9);
        }
    }

    private void scanState() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean flag = this.hasActiveExitPortal();
        if (flag) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.spawnExitPortal(false);
            }
        }
        List<? extends EnderDragon> list = this.level.getDragons();
        if (list.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EnderDragon entityenderdragon = list.get(0);
            this.dragonUUID = entityenderdragon.getUUID();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)entityenderdragon);
            this.dragonKilled = false;
            if (!flag) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                entityenderdragon.discard(null);
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List<? extends EnderDragon> list = this.level.getDragons();
        if (list.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUUID = list.get(0).getUUID();
        }
    }

    public void setRespawnStage(DragonRespawnAnimation enumdragonrespawn) {
        if (this.respawnStage == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (enumdragonrespawn == DragonRespawnAnimation.END) {
            this.respawnStage = null;
            this.dragonKilled = false;
            EnderDragon entityenderdragon = this.createNewDragon();
            if (entityenderdragon != null) {
                for (ServerPlayer entityplayer : this.dragonEvent.getPlayers()) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(entityplayer, entityenderdragon);
                }
            }
        } else {
            this.respawnStage = enumdragonrespawn;
        }
    }

    private boolean hasActiveExitPortal() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                LevelChunk chunk = this.level.getChunk(i, j);
                for (BlockEntity tileentity : chunk.getBlockEntities().values()) {
                    if (!(tileentity instanceof TheEndPortalBlockEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public BlockPattern.BlockPatternMatch findExitPortal() {
        int k;
        ChunkPos chunkcoordintpair = new ChunkPos(this.origin);
        for (int i = -8 + chunkcoordintpair.x; i <= 8 + chunkcoordintpair.x; ++i) {
            for (int j = -8 + chunkcoordintpair.z; j <= 8 + chunkcoordintpair.z; ++j) {
                LevelChunk chunk = this.level.getChunk(i, j);
                for (BlockEntity tileentity : chunk.getBlockEntities().values()) {
                    BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection;
                    if (!(tileentity instanceof TheEndPortalBlockEntity) || (shapedetector_shapedetectorcollection = this.exitPortalPattern.find(this.level, tileentity.getBlockPos())) == null) continue;
                    BlockPos blockposition = shapedetector_shapedetectorcollection.getBlock(3, 3, 3).getPos();
                    if (this.portalLocation == null) {
                        this.portalLocation = blockposition;
                    }
                    return shapedetector_shapedetectorcollection;
                }
            }
        }
        BlockPos blockposition1 = EndPodiumFeature.getLocation(this.origin);
        for (int l = k = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockposition1).getY(); l >= this.level.getMinY(); --l) {
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection1 = this.exitPortalPattern.find(this.level, new BlockPos(blockposition1.getX(), l, blockposition1.getZ()));
            if (shapedetector_shapedetectorcollection1 == null) continue;
            if (this.portalLocation == null) {
                this.portalLocation = shapedetector_shapedetectorcollection1.getBlock(3, 3, 3).getPos();
            }
            return shapedetector_shapedetectorcollection1;
        }
        return null;
    }

    private boolean isArenaLoaded() {
        if (this.skipArenaLoadedCheck) {
            return true;
        }
        ChunkPos chunkcoordintpair = new ChunkPos(this.origin);
        for (int i = -8 + chunkcoordintpair.x; i <= 8 + chunkcoordintpair.x; ++i) {
            for (int j = 8 + chunkcoordintpair.z; j <= 8 + chunkcoordintpair.z; ++j) {
                ChunkAccess ichunkaccess = this.level.getChunk(i, j, ChunkStatus.FULL, false);
                if (!(ichunkaccess instanceof LevelChunk)) {
                    return false;
                }
                FullChunkStatus fullchunkstatus = ((LevelChunk)ichunkaccess).getFullStatus();
                if (fullchunkstatus.isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayer entityplayer : this.level.getPlayers(this.validPlayer)) {
            this.dragonEvent.addPlayer(entityplayer);
            set.add(entityplayer);
        }
        HashSet set1 = Sets.newHashSet(this.dragonEvent.getPlayers());
        set1.removeAll(set);
        for (ServerPlayer entityplayer1 : set1) {
            this.dragonEvent.removePlayer(entityplayer1);
        }
    }

    private void updateCrystalCount() {
        this.ticksSinceCrystalsScanned = 0;
        this.crystalsAlive = 0;
        for (SpikeFeature.EndSpike worldgenender_spike : SpikeFeature.getSpikesForLevel(this.level)) {
            this.crystalsAlive += this.level.getEntitiesOfClass(EndCrystal.class, worldgenender_spike.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.crystalsAlive);
    }

    public void setDragonKilled(EnderDragon entityenderdragon) {
        if (entityenderdragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.level.setBlockAndUpdate(this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.getLocation(this.origin)), Blocks.DRAGON_EGG.defaultBlockState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void removeAllGateways() {
        this.gateways.clear();
    }

    private void spawnNewGateway() {
        if (!this.gateways.isEmpty()) {
            int i = (Integer)this.gateways.remove(this.gateways.size() - 1);
            int j = Mth.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            int k = Mth.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i)));
            this.spawnNewGateway(new BlockPos(j, 75, k));
        }
    }

    private void spawnNewGateway(BlockPos blockposition) {
        this.level.levelEvent(3000, blockposition, 0);
        this.level.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.get(EndFeatures.END_GATEWAY_DELAYED)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), blockposition));
    }

    public void spawnExitPortal(boolean flag) {
        EndPodiumFeature worldgenendtrophy = new EndPodiumFeature(flag);
        if (this.portalLocation == null) {
            this.portalLocation = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(this.origin)).below();
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > 63) {
                this.portalLocation = this.portalLocation.below();
            }
            this.portalLocation = this.portalLocation.atY(Math.max(this.level.getMinY() + 1, this.portalLocation.getY()));
        }
        if (worldgenendtrophy.place(FeatureConfiguration.NONE, this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), this.portalLocation)) {
            int i = Mth.positiveCeilDiv(4, 16);
            this.level.getChunkSource().chunkMap.waitForLightBeforeSending(new ChunkPos(this.portalLocation), i);
        }
    }

    @Nullable
    private EnderDragon createNewDragon() {
        this.level.getChunkAt(new BlockPos(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ()));
        EnderDragon entityenderdragon = EntityType.ENDER_DRAGON.create(this.level, EntitySpawnReason.EVENT);
        if (entityenderdragon != null) {
            entityenderdragon.setDragonFight(this);
            entityenderdragon.setFightOrigin(this.origin);
            entityenderdragon.getPhaseManager().setPhase(EnderDragonPhase.HOLDING_PATTERN);
            entityenderdragon.snapTo(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            this.level.addFreshEntity(entityenderdragon);
            this.dragonUUID = entityenderdragon.getUUID();
        }
        return entityenderdragon;
    }

    public void updateDragon(EnderDragon entityenderdragon) {
        if (entityenderdragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(entityenderdragon.getHealth() / entityenderdragon.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (entityenderdragon.hasCustomName()) {
                this.dragonEvent.setName(entityenderdragon.getDisplayName());
            }
        }
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }

    public void onCrystalDestroyed(EndCrystal entityendercrystal, DamageSource damagesource) {
        if (this.respawnStage != null && this.respawnCrystals.contains(entityendercrystal)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
            this.spawnExitPortal(true);
        } else {
            this.updateCrystalCount();
            Entity entity = this.level.getEntity(this.dragonUUID);
            if (entity instanceof EnderDragon) {
                EnderDragon entityenderdragon = (EnderDragon)entity;
                entityenderdragon.onCrystalDestroyed(this.level, entityendercrystal, entityendercrystal.blockPosition(), damagesource);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public boolean tryRespawn() {
        if (this.dragonKilled && this.respawnStage == null) {
            BlockPos blockposition = this.portalLocation;
            if (blockposition == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection = this.findExitPortal();
                if (shapedetector_shapedetectorcollection == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.spawnExitPortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & saved its location for next time.");
                }
                blockposition = this.portalLocation;
            }
            ArrayList list = Lists.newArrayList();
            BlockPos blockposition1 = blockposition.above(1);
            for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                List<EndCrystal> list1 = this.level.getEntitiesOfClass(EndCrystal.class, new AABB(blockposition1.relative(enumdirection, 2)));
                if (list1.isEmpty()) {
                    return false;
                }
                list.addAll(list1);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            return this.respawnDragon(list);
        }
        return false;
    }

    public boolean respawnDragon(List<EndCrystal> list) {
        if (this.dragonKilled && this.respawnStage == null) {
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection = this.findExitPortal();
            while (shapedetector_shapedetectorcollection != null) {
                for (int i = 0; i < this.exitPortalPattern.getWidth(); ++i) {
                    for (int j = 0; j < this.exitPortalPattern.getHeight(); ++j) {
                        for (int k = 0; k < this.exitPortalPattern.getDepth(); ++k) {
                            BlockInWorld shapedetectorblock = shapedetector_shapedetectorcollection.getBlock(i, j, k);
                            if (!shapedetectorblock.getState().is(Blocks.BEDROCK) && !shapedetectorblock.getState().is(Blocks.END_PORTAL)) continue;
                            this.level.setBlockAndUpdate(shapedetectorblock.getPos(), Blocks.END_STONE.defaultBlockState());
                        }
                    }
                }
                shapedetector_shapedetectorcollection = this.findExitPortal();
            }
            this.respawnStage = DragonRespawnAnimation.START;
            this.respawnTime = 0;
            this.spawnExitPortal(false);
            this.respawnCrystals = list;
            return true;
        }
        return false;
    }

    public void resetSpikeCrystals() {
        for (SpikeFeature.EndSpike worldgenender_spike : SpikeFeature.getSpikesForLevel(this.level)) {
            for (EndCrystal entityendercrystal : this.level.getEntitiesOfClass(EndCrystal.class, worldgenender_spike.getTopBoundingBox())) {
                entityendercrystal.setInvulnerable(false);
                entityendercrystal.setBeamTarget(null);
            }
        }
    }

    @Nullable
    public UUID getDragonUUID() {
        return this.dragonUUID;
    }

    public record Data(boolean needsStateScanning, boolean dragonKilled, boolean previouslyKilled, boolean isRespawning, Optional<UUID> dragonUUID, Optional<BlockPos> exitPortalLocation, Optional<List<Integer>> gateways) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(Data::needsStateScanning), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(Data::dragonKilled), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(Data::previouslyKilled), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(Data::isRespawning), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("Dragon").forGetter(Data::dragonUUID), (App)BlockPos.CODEC.lenientOptionalFieldOf("ExitPortalLocation").forGetter(Data::exitPortalLocation), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(Data::gateways)).apply((Applicative)instance, Data::new));
        public static final Data DEFAULT = new Data(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

