/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(palemossdecorator -> Float.valueOf(palemossdecorator.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(palemossdecorator -> Float.valueOf(palemossdecorator.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(palemossdecorator -> Float.valueOf(palemossdecorator.groundProbability))).apply((Applicative)instance, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float f, float f1, float f2) {
        this.leavesProbability = f;
        this.trunkProbability = f1;
        this.groundProbability = f2;
    }

    @Override
    public void place(TreeDecorator.Context worldgenfeaturetree_a) {
        RandomSource randomsource = worldgenfeaturetree_a.random();
        WorldGenLevel generatoraccessseed = (WorldGenLevel)worldgenfeaturetree_a.level();
        List<BlockPos> list = Util.shuffledCopy(worldgenfeaturetree_a.logs(), randomsource);
        if (!list.isEmpty()) {
            MutableObject mutable = new MutableObject((Object)list.getFirst());
            list.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)mutable, arg_0));
            BlockPos blockposition = (BlockPos)mutable.getValue();
            if (randomsource.nextFloat() < this.groundProbability) {
                generatoraccessseed.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.get(VegetationFeatures.PALE_MOSS_PATCH)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(generatoraccessseed, ((ServerChunkCache)generatoraccessseed.getChunkSource()).getGenerator(), randomsource, blockposition.above()));
            }
            worldgenfeaturetree_a.logs().forEach(blockposition1 -> {
                BlockPos blockposition2;
                if (randomsource.nextFloat() < this.trunkProbability && worldgenfeaturetree_a.isAir(blockposition2 = blockposition1.below())) {
                    PaleMossDecorator.addMossHanger(blockposition2, worldgenfeaturetree_a);
                }
            });
            worldgenfeaturetree_a.leaves().forEach(blockposition1 -> {
                BlockPos blockposition2;
                if (randomsource.nextFloat() < this.leavesProbability && worldgenfeaturetree_a.isAir(blockposition2 = blockposition1.below())) {
                    PaleMossDecorator.addMossHanger(blockposition2, worldgenfeaturetree_a);
                }
            });
        }
    }

    private static void addMossHanger(BlockPos blockposition, TreeDecorator.Context worldgenfeaturetree_a) {
        while (worldgenfeaturetree_a.isAir(blockposition.below()) && (double)worldgenfeaturetree_a.random().nextFloat() >= 0.5) {
            worldgenfeaturetree_a.setBlock(blockposition, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            blockposition = blockposition.below();
        }
        worldgenfeaturetree_a.setBlock(blockposition, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void lambda$place$4(Mutable mutable, BlockPos blockposition) {
        if (blockposition.getY() < ((BlockPos)mutable.getValue()).getY()) {
            mutable.setValue((Object)blockposition);
        }
    }
}

