/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FancyTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<FancyTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var0 -> FancyTrunkPlacer.trunkPlacerParts(var0).apply((Applicative)var0, FancyTrunkPlacer::new));
    private static final double TRUNK_HEIGHT_SCALE = 0.618;
    private static final double CLUSTER_DENSITY_MAGIC = 1.382;
    private static final double BRANCH_SLOPE = 0.381;
    private static final double BRANCH_LENGTH_MAGIC = 0.328;

    public FancyTrunkPlacer(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.FANCY_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        int var13;
        int var6 = 5;
        int var7 = var3 + 2;
        int var8 = Mth.floor((double)var7 * 0.618);
        FancyTrunkPlacer.setDirtAt(var0, var1, var2, var4.below(), var5);
        double var9 = 1.0;
        int var11 = Math.min(1, Mth.floor(1.382 + Math.pow(1.0 * (double)var7 / 13.0, 2.0)));
        int var12 = var4.getY() + var8;
        ArrayList var14 = Lists.newArrayList();
        var14.add(new FoliageCoords(var4.above(var13), var12));
        for (var13 = var7 - 5; var13 >= 0; --var13) {
            float var15 = FancyTrunkPlacer.treeShape(var7, var13);
            if (var15 < 0.0f) continue;
            for (int var16 = 0; var16 < var11; ++var16) {
                BlockPos var28;
                double var17 = 1.0;
                double var19 = 1.0 * (double)var15 * ((double)var2.nextFloat() + 0.328);
                double var21 = (double)(var2.nextFloat() * 2.0f) * Math.PI;
                double var23 = var19 * Math.sin(var21) + 0.5;
                double var25 = var19 * Math.cos(var21) + 0.5;
                BlockPos var27 = var4.offset(Mth.floor(var23), var13 - 1, Mth.floor(var25));
                if (!this.makeLimb(var0, var1, var2, var27, var28 = var27.above(5), false, var5)) continue;
                int var29 = var4.getX() - var27.getX();
                int var30 = var4.getZ() - var27.getZ();
                double var31 = (double)var27.getY() - Math.sqrt(var29 * var29 + var30 * var30) * 0.381;
                int var33 = var31 > (double)var12 ? var12 : (int)var31;
                BlockPos var34 = new BlockPos(var4.getX(), var33, var4.getZ());
                if (!this.makeLimb(var0, var1, var2, var34, var27, false, var5)) continue;
                var14.add(new FoliageCoords(var27, var34.getY()));
            }
        }
        this.makeLimb(var0, var1, var2, var4, var4.above(var8), true, var5);
        this.makeBranches(var0, var1, var2, var7, var4, var14, var5);
        ArrayList var15 = Lists.newArrayList();
        for (FoliageCoords var17 : var14) {
            if (!this.trimBranches(var7, var17.getBranchBase() - var4.getY())) continue;
            var15.add(var17.attachment);
        }
        return var15;
    }

    private boolean makeLimb(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var22, BlockPos var3, BlockPos var4, boolean var5, TreeConfiguration var6) {
        if (!var5 && Objects.equals(var3, var4)) {
            return true;
        }
        BlockPos var7 = var4.offset(-var3.getX(), -var3.getY(), -var3.getZ());
        int var8 = this.getSteps(var7);
        float var9 = (float)var7.getX() / (float)var8;
        float var10 = (float)var7.getY() / (float)var8;
        float var11 = (float)var7.getZ() / (float)var8;
        for (int var12 = 0; var12 <= var8; ++var12) {
            BlockPos var13 = var3.offset(Mth.floor(0.5f + (float)var12 * var9), Mth.floor(0.5f + (float)var12 * var10), Mth.floor(0.5f + (float)var12 * var11));
            if (var5) {
                this.placeLog(var0, var1, var22, var13, var6, var2 -> (BlockState)var2.trySetValue(RotatedPillarBlock.AXIS, this.getLogAxis(var3, var13)));
                continue;
            }
            if (this.isFree(var0, var13)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos var0) {
        int var1 = Mth.abs(var0.getX());
        int var2 = Mth.abs(var0.getY());
        int var3 = Mth.abs(var0.getZ());
        return Math.max(var1, Math.max(var2, var3));
    }

    private Direction.Axis getLogAxis(BlockPos var0, BlockPos var1) {
        int var4;
        Direction.Axis var2 = Direction.Axis.Y;
        int var3 = Math.abs(var1.getX() - var0.getX());
        int var5 = Math.max(var3, var4 = Math.abs(var1.getZ() - var0.getZ()));
        if (var5 > 0) {
            var2 = var3 == var5 ? Direction.Axis.X : Direction.Axis.Z;
        }
        return var2;
    }

    private boolean trimBranches(int var0, int var1) {
        return (double)var1 >= (double)var0 * 0.2;
    }

    private void makeBranches(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, List<FoliageCoords> var5, TreeConfiguration var6) {
        for (FoliageCoords var8 : var5) {
            int var9 = var8.getBranchBase();
            BlockPos var10 = new BlockPos(var4.getX(), var9, var4.getZ());
            if (var10.equals(var8.attachment.pos()) || !this.trimBranches(var3, var9 - var4.getY())) continue;
            this.makeLimb(var0, var1, var2, var10, var8.attachment.pos(), true, var6);
        }
    }

    private static float treeShape(int var0, int var1) {
        if ((float)var1 < (float)var0 * 0.3f) {
            return -1.0f;
        }
        float var2 = (float)var0 / 2.0f;
        float var3 = var2 - (float)var1;
        float var4 = Mth.sqrt(var2 * var2 - var3 * var3);
        if (var3 == 0.0f) {
            var4 = var2;
        } else if (Math.abs(var3) >= var2) {
            return 0.0f;
        }
        return var4 * 0.5f;
    }

    static class FoliageCoords {
        final FoliagePlacer.FoliageAttachment attachment;
        private final int branchBase;

        public FoliageCoords(BlockPos var0, int var1) {
            this.attachment = new FoliagePlacer.FoliageAttachment(var0, 0, false);
            this.branchBase = var1;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

