/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SinglePoolElement
extends StructurePoolElement {
    private static final Comparator<StructureTemplate.JigsawBlockInfo> HIGHEST_SELECTION_PRIORITY_FIRST = Comparator.comparingInt(StructureTemplate.JigsawBlockInfo::selectionPriority).reversed();
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(SinglePoolElement::encodeTemplate, (Decoder)ResourceLocation.CODEC.map(Either::left));
    public static final MapCodec<SinglePoolElement> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group(SinglePoolElement.templateCodec(), SinglePoolElement.processorsCodec(), SinglePoolElement.projectionCodec(), SinglePoolElement.overrideLiquidSettingsCodec()).apply((Applicative)var0, SinglePoolElement::new));
    protected final Either<ResourceLocation, StructureTemplate> template;
    protected final Holder<StructureProcessorList> processors;
    protected final Optional<LiquidSettings> overrideLiquidSettings;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> var0, DynamicOps<T> var1, T var2) {
        Optional var3 = var0.left();
        if (var3.isEmpty()) {
            return DataResult.error(() -> "Can not serialize a runtime pool element");
        }
        return ResourceLocation.CODEC.encode((Object)((ResourceLocation)var3.get()), var1, var2);
    }

    protected static <E extends SinglePoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> processorsCodec() {
        return StructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(var0 -> var0.processors);
    }

    protected static <E extends SinglePoolElement> RecordCodecBuilder<E, Optional<LiquidSettings>> overrideLiquidSettingsCodec() {
        return LiquidSettings.CODEC.optionalFieldOf("override_liquid_settings").forGetter(var0 -> var0.overrideLiquidSettings);
    }

    protected static <E extends SinglePoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(var0 -> var0.template);
    }

    protected SinglePoolElement(Either<ResourceLocation, StructureTemplate> var0, Holder<StructureProcessorList> var1, StructureTemplatePool.Projection var2, Optional<LiquidSettings> var3) {
        super(var2);
        this.template = var0;
        this.processors = var1;
        this.overrideLiquidSettings = var3;
    }

    @Override
    public Vec3i getSize(StructureTemplateManager var0, Rotation var1) {
        StructureTemplate var2 = this.getTemplate(var0);
        return var2.getSize(var1);
    }

    private StructureTemplate getTemplate(StructureTemplateManager var0) {
        return (StructureTemplate)this.template.map(var0::getOrCreate, Function.identity());
    }

    public List<StructureTemplate.StructureBlockInfo> getDataMarkers(StructureTemplateManager var0, BlockPos var1, Rotation var2, boolean var3) {
        StructureTemplate var4 = this.getTemplate(var0);
        ObjectArrayList<StructureTemplate.StructureBlockInfo> var5 = var4.filterBlocks(var1, new StructurePlaceSettings().setRotation(var2), Blocks.STRUCTURE_BLOCK, var3);
        ArrayList var6 = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo var8 : var5) {
            StructureMode var10;
            CompoundTag var9 = var8.nbt();
            if (var9 == null || (var10 = var9.read("mode", StructureMode.LEGACY_CODEC).orElseThrow()) != StructureMode.DATA) continue;
            var6.add(var8);
        }
        return var6;
    }

    @Override
    public List<StructureTemplate.JigsawBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPos var1, Rotation var2, RandomSource var3) {
        List<StructureTemplate.JigsawBlockInfo> var4 = this.getTemplate(var0).getJigsaws(var1, var2);
        Util.shuffle(var4, var3);
        SinglePoolElement.sortBySelectionPriority(var4);
        return var4;
    }

    @VisibleForTesting
    static void sortBySelectionPriority(List<StructureTemplate.JigsawBlockInfo> var0) {
        var0.sort(HIGHEST_SELECTION_PRIORITY_FIRST);
    }

    @Override
    public BoundingBox getBoundingBox(StructureTemplateManager var0, BlockPos var1, Rotation var2) {
        StructureTemplate var3 = this.getTemplate(var0);
        return var3.getBoundingBox(new StructurePlaceSettings().setRotation(var2), var1);
    }

    @Override
    public boolean place(StructureTemplateManager var0, WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, BlockPos var4, BlockPos var5, Rotation var6, BoundingBox var7, RandomSource var8, LiquidSettings var9, boolean var10) {
        StructurePlaceSettings var12;
        StructureTemplate var11 = this.getTemplate(var0);
        if (var11.placeInWorld(var1, var4, var5, var12 = this.getSettings(var6, var7, var9, var10), var8, 18)) {
            List<StructureTemplate.StructureBlockInfo> var13 = StructureTemplate.processBlockInfos(var1, var4, var5, var12, this.getDataMarkers(var0, var4, var6, false));
            for (StructureTemplate.StructureBlockInfo var15 : var13) {
                this.handleDataMarker(var1, var15, var4, var6, var8, var7);
            }
            return true;
        }
        return false;
    }

    protected StructurePlaceSettings getSettings(Rotation var0, BoundingBox var1, LiquidSettings var2, boolean var3) {
        StructurePlaceSettings var4 = new StructurePlaceSettings();
        var4.setBoundingBox(var1);
        var4.setRotation(var0);
        var4.setKnownShape(true);
        var4.setIgnoreEntities(false);
        var4.addProcessor(BlockIgnoreProcessor.STRUCTURE_BLOCK);
        var4.setFinalizeEntities(true);
        var4.setLiquidSettings(this.overrideLiquidSettings.orElse(var2));
        if (!var3) {
            var4.addProcessor(JigsawReplacementProcessor.INSTANCE);
        }
        this.processors.value().list().forEach(var4::addProcessor);
        this.getProjection().getProcessors().forEach(var4::addProcessor);
        return var4;
    }

    @Override
    public StructurePoolElementType<?> getType() {
        return StructurePoolElementType.SINGLE;
    }

    public String toString() {
        return "Single[" + String.valueOf(this.template) + "]";
    }

    @VisibleForTesting
    public ResourceLocation getTemplateLocation() {
        return (ResourceLocation)this.template.orThrow();
    }
}

