/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.entity.EntityType;

public class NetherFortressPieces {
    private static final int MAX_DEPTH = 30;
    private static final int LOWEST_Y_POSITION = 10;
    public static final int MAGIC_START_Y = 64;
    static final PieceWeight[] BRIDGE_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(BridgeStraight.class, 30, 0, true), new PieceWeight(BridgeCrossing.class, 10, 4), new PieceWeight(RoomCrossing.class, 10, 4), new PieceWeight(StairsRoom.class, 10, 3), new PieceWeight(MonsterThrone.class, 5, 2), new PieceWeight(CastleEntrance.class, 5, 1)};
    static final PieceWeight[] CASTLE_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(CastleSmallCorridorPiece.class, 25, 0, true), new PieceWeight(CastleSmallCorridorCrossingPiece.class, 15, 5), new PieceWeight(CastleSmallCorridorRightTurnPiece.class, 5, 10), new PieceWeight(CastleSmallCorridorLeftTurnPiece.class, 5, 10), new PieceWeight(CastleCorridorStairsPiece.class, 10, 3, true), new PieceWeight(CastleCorridorTBalconyPiece.class, 7, 2), new PieceWeight(CastleStalkRoom.class, 5, 2)};

    static NetherBridgePiece findAndCreateBridgePieceFactory(PieceWeight netherfortresspieces_n, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
        Class<? extends NetherBridgePiece> oclass = netherfortresspieces_n.pieceClass;
        NetherBridgePiece netherfortresspieces_m = null;
        if (oclass == BridgeStraight.class) {
            netherfortresspieces_m = BridgeStraight.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == BridgeCrossing.class) {
            netherfortresspieces_m = BridgeCrossing.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == RoomCrossing.class) {
            netherfortresspieces_m = RoomCrossing.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == StairsRoom.class) {
            netherfortresspieces_m = StairsRoom.createPiece(structurepieceaccessor, i, j, k, l, enumdirection);
        } else if (oclass == MonsterThrone.class) {
            netherfortresspieces_m = MonsterThrone.createPiece(structurepieceaccessor, i, j, k, l, enumdirection);
        } else if (oclass == CastleEntrance.class) {
            netherfortresspieces_m = CastleEntrance.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == CastleSmallCorridorPiece.class) {
            netherfortresspieces_m = CastleSmallCorridorPiece.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == CastleSmallCorridorRightTurnPiece.class) {
            netherfortresspieces_m = CastleSmallCorridorRightTurnPiece.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == CastleSmallCorridorLeftTurnPiece.class) {
            netherfortresspieces_m = CastleSmallCorridorLeftTurnPiece.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        } else if (oclass == CastleCorridorStairsPiece.class) {
            netherfortresspieces_m = CastleCorridorStairsPiece.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == CastleCorridorTBalconyPiece.class) {
            netherfortresspieces_m = CastleCorridorTBalconyPiece.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == CastleSmallCorridorCrossingPiece.class) {
            netherfortresspieces_m = CastleSmallCorridorCrossingPiece.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        } else if (oclass == CastleStalkRoom.class) {
            netherfortresspieces_m = CastleStalkRoom.createPiece(structurepieceaccessor, i, j, k, enumdirection, l);
        }
        return netherfortresspieces_m;
    }

    private static class PieceWeight {
        public final Class<? extends NetherBridgePiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;
        public final boolean allowInRow;

        public PieceWeight(Class<? extends NetherBridgePiece> oclass, int i, int j, boolean flag) {
            this.pieceClass = oclass;
            this.weight = i;
            this.maxPlaceCount = j;
            this.allowInRow = flag;
        }

        public PieceWeight(Class<? extends NetherBridgePiece> oclass, int i, int j) {
            this(oclass, i, j, false);
        }

        public boolean doPlace(int i) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class BridgeStraight
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public BridgeStraight(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public BridgeStraight(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 3, false);
        }

        public static BridgeStraight createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -3, 0, 5, 10, 19, enumdirection);
            return BridgeStraight.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new BridgeStraight(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 4, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 0, 3, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 0, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 0, 4, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 13, 4, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 15, 4, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, 18 - j, structureboundingbox);
                }
            }
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(FenceBlock.EAST, true);
            BlockState iblockdata2 = (BlockState)iblockdata.setValue(FenceBlock.WEST, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 4, 0, 4, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 14, 0, 4, 14, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 17, 0, 4, 17, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 4, 1, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 4, 4, 4, 4, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 14, 4, 4, 14, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 17, 4, 4, 17, iblockdata2, iblockdata2, false);
        }
    }

    public static class BridgeCrossing
    extends NetherBridgePiece {
        private static final int WIDTH = 19;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public BridgeCrossing(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        protected BridgeCrossing(int i, int j, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, 0, StructurePiece.makeBoundingBox(i, 64, j, enumdirection, 19, 10, 19));
            this.setOrientation(enumdirection);
        }

        protected BridgeCrossing(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }

        public BridgeCrossing(CompoundTag nbttagcompound) {
            this(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 8, 3, false);
            this.generateChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 3, 8, false);
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 3, 8, false);
        }

        public static BridgeCrossing createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -8, -3, 0, 19, 10, 19, enumdirection);
            return BridgeCrossing.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new BridgeCrossing(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 3, 0, 11, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 7, 18, 4, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 8, 18, 7, 10, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 5, 0, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 5, 11, 7, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 11, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 11, 11, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 7, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 7, 18, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 11, 7, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 11, 18, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 2, 0, 11, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 2, 13, 11, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 0, 0, 11, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 0, 15, 11, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 7; i <= 11; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, 18 - j, structureboundingbox);
                }
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 7, 5, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 13, 2, 7, 18, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 7, 3, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 15, 0, 7, 18, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int k = 0; k <= 2; ++k) {
                for (int l = 7; l <= 11; ++l) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k, -1, l, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 18 - k, -1, l, structureboundingbox);
                }
            }
        }
    }

    public static class RoomCrossing
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 9;
        private static final int DEPTH = 7;

        public RoomCrossing(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public RoomCrossing(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 2, 0, false);
            this.generateChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 2, false);
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 2, false);
        }

        public static RoomCrossing createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -2, 0, 0, 7, 9, 7, enumdirection);
            return RoomCrossing.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new RoomCrossing(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 7, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 1, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 6, 1, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 6, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 6, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 5, 0, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 0, 6, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 5, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 0, 4, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 5, 0, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 6, 4, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 6, 4, 5, 6, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 2, 0, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 2, 0, 5, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 6, 2, 6, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 5, 2, 6, 5, 4, iblockdata1, iblockdata1, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class StairsRoom
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 7;

        public StairsRoom(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public StairsRoom(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 6, 2, false);
        }

        public static StairsRoom createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, int l, Direction enumdirection) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -2, 0, 0, 7, 11, 7, enumdirection);
            return StairsRoom.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new StairsRoom(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 10, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 1, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 6, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 1, 0, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 1, 6, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 6, 5, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 2, 0, 5, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 2, 6, 5, 2, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 4, 6, 5, 4, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 5, 4, 3, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 2, 5, 3, 4, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 2, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 5, 1, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, 1, 5, 7, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 8, 2, 6, 8, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 0, 4, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 5, 0, iblockdata, iblockdata, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class MonsterThrone
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 8;
        private static final int DEPTH = 9;
        private boolean hasPlacedSpawner;

        public MonsterThrone(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public MonsterThrone(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, nbttagcompound);
            this.hasPlacedSpawner = nbttagcompound.getBooleanOr("Mob", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Mob", this.hasPlacedSpawner);
        }

        public static MonsterThrone createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, int l, Direction enumdirection) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -2, 0, 0, 7, 8, 9, enumdirection);
            return MonsterThrone.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new MonsterThrone(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            BlockPos.MutableBlockPos blockposition1;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 7, 7, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 0, 0, 5, 1, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 1, 5, 2, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 2, 5, 3, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 3, 5, 4, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 0, 1, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 5, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 2, 1, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 2, 5, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 3, 0, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 5, 3, 6, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 8, 5, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 1, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 5, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.NORTH, true), 0, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.NORTH, true), 6, 6, 3, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 4, 0, 6, 7, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 6, 4, 6, 6, 7, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.SOUTH, true), 0, 6, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.SOUTH, true), 6, 6, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, 8, 5, 6, 8, iblockdata, iblockdata, false);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 1, 7, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 7, 8, 4, 7, 8, iblockdata, iblockdata, false);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 5, 7, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 2, 8, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata, 3, 8, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 4, 8, 8, structureboundingbox);
            if (!this.hasPlacedSpawner && structureboundingbox.isInside(blockposition1 = this.getWorldPos(3, 5, 5))) {
                this.hasPlacedSpawner = true;
                this.placeCraftSpawner(generatoraccessseed, blockposition1, EntityType.BLAZE, 2);
            }
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class CastleEntrance
    extends NetherBridgePiece {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public CastleEntrance(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleEntrance(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 5, 3, true);
        }

        public static CastleEntrance createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -5, -3, 0, 13, 14, 13, enumdirection);
            return CastleEntrance.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleEntrance(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 8, 0, 7, 8, 0, Blocks.NETHER_BRICK_FENCE.defaultBlockState(), Blocks.NETHER_BRICK_FENCE.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            for (int i = 1; i <= 11; i += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, i, 10, 0, i, 11, 0, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i, 10, 12, i, 11, 12, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 10, i, 0, 11, i, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 10, i, 12, 11, i, iblockdata1, iblockdata1, false);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, i, structureboundingbox);
                if (i == 11) continue;
                this.placeBlock(generatoraccessseed, iblockdata, i + 1, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, i + 1, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 0, 13, i + 1, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 12, 13, i + 1, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 0, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 0, structureboundingbox);
            for (int j = 3; j <= 9; j += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, j, 1, 8, j, (BlockState)iblockdata1.setValue(FenceBlock.WEST, true), (BlockState)iblockdata1.setValue(FenceBlock.WEST, true), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 11, 7, j, 11, 8, j, (BlockState)iblockdata1.setValue(FenceBlock.EAST, true), (BlockState)iblockdata1.setValue(FenceBlock.EAST, true), false);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int k = 4; k <= 8; ++k) {
                for (int l = 0; l <= 2; ++l) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k, -1, l, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k, -1, 12 - l, structureboundingbox);
                }
            }
            for (int i1 = 0; i1 <= 2; ++i1) {
                for (int j1 = 4; j1 <= 8; ++j1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i1, -1, j1, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - i1, -1, j1, structureboundingbox);
                }
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 5, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, 6, 6, 4, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 6, 0, 6, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.LAVA.defaultBlockState(), 6, 5, 6, structureboundingbox);
            BlockPos.MutableBlockPos blockposition1 = this.getWorldPos(6, 5, 6);
            if (structureboundingbox.isInside(blockposition1)) {
                generatoraccessseed.scheduleTick((BlockPos)blockposition1, Fluids.LAVA, 0);
            }
        }
    }

    public static class CastleSmallCorridorPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public CastleSmallCorridorPiece(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleSmallCorridorPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
        }

        public static CastleSmallCorridorPiece createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, 0, 0, 5, 7, 5, enumdirection);
            return CastleSmallCorridorPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleSmallCorridorPiece(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 4, 1, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 3, 0, 4, 3, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 1, 4, 4, 1, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 3, 4, 4, 3, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class CastleSmallCorridorRightTurnPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public CastleSmallCorridorRightTurnPiece(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.isNeedingChest = randomsource.nextInt(3) == 0;
        }

        public CastleSmallCorridorRightTurnPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, nbttagcompound);
            this.isNeedingChest = nbttagcompound.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static CastleSmallCorridorRightTurnPiece createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, 0, 0, 5, 7, 5, enumdirection);
            return CastleSmallCorridorRightTurnPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleSmallCorridorRightTurnPiece(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 3, 0, 4, 3, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 1, 4, 4, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 3, 4, 3, 4, 4, iblockdata, iblockdata, false);
            if (this.isNeedingChest && structureboundingbox.isInside(this.getWorldPos(1, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 1, 2, 3, BuiltInLootTables.NETHER_BRIDGE);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class CastleSmallCorridorLeftTurnPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public CastleSmallCorridorLeftTurnPiece(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.isNeedingChest = randomsource.nextInt(3) == 0;
        }

        public CastleSmallCorridorLeftTurnPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, nbttagcompound);
            this.isNeedingChest = nbttagcompound.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static CastleSmallCorridorLeftTurnPiece createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, 0, 0, 5, 7, 5, enumdirection);
            return CastleSmallCorridorLeftTurnPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleSmallCorridorLeftTurnPiece(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 1, 4, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 3, 4, 4, 3, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 3, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 1, 4, 4, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 3, 4, 3, 4, 4, iblockdata, iblockdata, false);
            if (this.isNeedingChest && structureboundingbox.isInside(this.getWorldPos(3, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 2, 3, BuiltInLootTables.NETHER_BRIDGE);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class CastleCorridorStairsPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 10;

        public CastleCorridorStairsPiece(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleCorridorStairsPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
        }

        public static CastleCorridorStairsPiece createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -7, 0, 5, 14, 10, enumdirection);
            return CastleCorridorStairsPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleCorridorStairsPiece(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            BlockState iblockdata = (BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            for (int i = 0; i <= 9; ++i) {
                int j = Math.max(1, 7 - i);
                int k = Math.min(Math.max(j + 5, 14 - i), 13);
                int l = i;
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, i, 4, j, i, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 1, j + 1, i, 3, k - 1, i, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
                if (i <= 6) {
                    this.placeBlock(generatoraccessseed, iblockdata, 1, j + 1, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 2, j + 1, i, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 3, j + 1, i, structureboundingbox);
                }
                this.generateBox(generatoraccessseed, structureboundingbox, 0, k, i, 4, k, i, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, j + 1, i, 0, k - 1, i, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, j + 1, i, 4, k - 1, i, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                if ((i & 1) == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 0, j + 2, i, 0, j + 3, i, iblockdata1, iblockdata1, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 4, j + 2, i, 4, j + 3, i, iblockdata1, iblockdata1, false);
                }
                for (int i1 = 0; i1 <= 4; ++i1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i1, -1, l, structureboundingbox);
                }
            }
        }
    }

    public static class CastleCorridorTBalconyPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 9;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 9;

        public CastleCorridorTBalconyPiece(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleCorridorTBalconyPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i = 1;
            Direction enumdirection = this.getOrientation();
            if (enumdirection == Direction.WEST || enumdirection == Direction.NORTH) {
                i = 5;
            }
            this.generateChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, i, randomsource.nextInt(8) > 0);
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, i, randomsource.nextInt(8) > 0);
        }

        public static CastleCorridorTBalconyPiece createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -3, 0, 0, 9, 7, 9, enumdirection);
            return CastleCorridorTBalconyPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleCorridorTBalconyPiece(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 8, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 8, 5, 8, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 8, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 2, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 0, 8, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 0, 1, 4, 0, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 3, 0, 7, 4, 0, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 8, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 4, 2, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, 4, 7, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 8, 7, 3, 8, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.SOUTH, true), 0, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.SOUTH, true), 8, 3, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 6, 0, 3, 7, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 3, 6, 8, 3, 7, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 4, 0, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 3, 4, 8, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 5, 7, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 5, 1, 5, 5, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 4, 5, 7, 5, 5, iblockdata1, iblockdata1, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), j, -1, i, structureboundingbox);
                }
            }
        }
    }

    public static class CastleSmallCorridorCrossingPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public CastleSmallCorridorCrossingPiece(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleSmallCorridorCrossingPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
            this.generateChildLeft((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
            this.generateChildRight((StartPiece)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static CastleSmallCorridorCrossingPiece createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, 0, 0, 5, 7, 5, enumdirection);
            return CastleSmallCorridorCrossingPiece.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleSmallCorridorCrossingPiece(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, -1, j, structureboundingbox);
                }
            }
        }
    }

    public static class CastleStalkRoom
    extends NetherBridgePiece {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public CastleStalkRoom(int i, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, i, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public CastleStalkRoom(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 5, 3, true);
            this.generateChildForward((StartPiece)structurepiece, structurepieceaccessor, randomsource, 5, 11, true);
        }

        public static CastleStalkRoom createPiece(StructurePieceAccessor structurepieceaccessor, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -5, -3, 0, 13, 14, 13, enumdirection);
            return CastleStalkRoom.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new CastleStalkRoom(l, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState iblockdata = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState iblockdata1 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState iblockdata2 = (BlockState)iblockdata1.setValue(FenceBlock.WEST, true);
            BlockState iblockdata3 = (BlockState)iblockdata1.setValue(FenceBlock.EAST, true);
            for (int i = 1; i <= 11; i += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, i, 10, 0, i, 11, 0, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i, 10, 12, i, 11, 12, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 10, i, 0, 11, i, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 10, i, 12, 11, i, iblockdata1, iblockdata1, false);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, i, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, i, structureboundingbox);
                if (i == 11) continue;
                this.placeBlock(generatoraccessseed, iblockdata, i + 1, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, i + 1, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 0, 13, i + 1, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 12, 13, i + 1, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 0, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 0, structureboundingbox);
            for (int j = 3; j <= 9; j += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, j, 1, 8, j, iblockdata2, iblockdata2, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 11, 7, j, 11, 8, j, iblockdata3, iblockdata3, false);
            }
            BlockState iblockdata4 = (BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            for (int k = 0; k <= 6; ++k) {
                int l = k + 4;
                for (int i1 = 5; i1 <= 7; ++i1) {
                    this.placeBlock(generatoraccessseed, iblockdata4, i1, 5 + k, l, structureboundingbox);
                }
                if (l >= 5 && l <= 8) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, l, 7, k + 4, l, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                } else if (l >= 9 && l <= 10) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 5, 8, l, 7, k + 4, l, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
                if (k < 1) continue;
                this.generateBox(generatoraccessseed, structureboundingbox, 5, 6 + k, l, 7, 9 + k, l, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            }
            for (int j1 = 5; j1 <= 7; ++j1) {
                this.placeBlock(generatoraccessseed, iblockdata4, j1, 12, 11, structureboundingbox);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 6, 7, 5, 7, 7, iblockdata3, iblockdata3, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 6, 7, 7, 7, 7, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 13, 12, 7, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 2, 3, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 9, 3, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 4, 2, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 2, 10, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 9, 10, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 10, 5, 4, 10, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState iblockdata5 = (BlockState)iblockdata4.setValue(StairBlock.FACING, Direction.EAST);
            BlockState iblockdata6 = (BlockState)iblockdata4.setValue(StairBlock.FACING, Direction.WEST);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 10, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 4, 4, 4, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 4, 4, 9, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 5, 4, 4, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 4, 9, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int k1 = 4; k1 <= 8; ++k1) {
                for (int l1 = 0; l1 <= 2; ++l1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k1, -1, l1, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k1, -1, 12 - l1, structureboundingbox);
                }
            }
            for (int i2 = 0; i2 <= 2; ++i2) {
                for (int j2 = 4; j2 <= 8; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class BridgeEndFiller
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 8;
        private final int selfSeed;

        public BridgeEndFiller(int i, RandomSource randomsource, BoundingBox structureboundingbox, Direction enumdirection) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, i, structureboundingbox);
            this.setOrientation(enumdirection);
            this.selfSeed = randomsource.nextInt();
        }

        public BridgeEndFiller(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, nbttagcompound);
            this.selfSeed = nbttagcompound.getIntOr("Seed", 0);
        }

        public static BridgeEndFiller createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            BoundingBox structureboundingbox = BoundingBox.orientBox(i, j, k, -1, -3, 0, 5, 10, 8, enumdirection);
            return BridgeEndFiller.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new BridgeEndFiller(l, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Seed", this.selfSeed);
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            RandomSource randomsource1 = RandomSource.create(this.selfSeed);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 3; j <= 4; ++j) {
                    int k = randomsource1.nextInt(8);
                    this.generateBox(generatoraccessseed, structureboundingbox, i, j, 0, i, j, k, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
            int l = randomsource1.nextInt(8);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 0, 5, l, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            l = randomsource1.nextInt(8);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 0, 4, 5, l, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i1 = 0; i1 <= 4; ++i1) {
                int j1 = randomsource1.nextInt(5);
                this.generateBox(generatoraccessseed, structureboundingbox, i1, 2, 0, i1, 2, j1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            }
            for (int k1 = 0; k1 <= 4; ++k1) {
                for (int l1 = 0; l1 <= 1; ++l1) {
                    int i2 = randomsource1.nextInt(3);
                    this.generateBox(generatoraccessseed, structureboundingbox, k1, l1, 0, k1, l1, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
        }
    }

    public static class StartPiece
    extends BridgeCrossing {
        public PieceWeight previousPiece;
        public List<PieceWeight> availableBridgePieces;
        public List<PieceWeight> availableCastlePieces;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public StartPiece(RandomSource randomsource, int i, int j) {
            super(i, j, StartPiece.getRandomHorizontalDirection(randomsource));
            this.availableBridgePieces = Lists.newArrayList();
            for (PieceWeight netherfortresspieces_n : BRIDGE_PIECE_WEIGHTS) {
                netherfortresspieces_n.placeCount = 0;
                this.availableBridgePieces.add(netherfortresspieces_n);
            }
            this.availableCastlePieces = Lists.newArrayList();
            for (PieceWeight netherfortresspieces_n1 : CASTLE_PIECE_WEIGHTS) {
                netherfortresspieces_n1.placeCount = 0;
                this.availableCastlePieces.add(netherfortresspieces_n1);
            }
        }

        public StartPiece(CompoundTag nbttagcompound) {
            super(StructurePieceType.NETHER_FORTRESS_START, nbttagcompound);
        }
    }

    private static abstract class NetherBridgePiece
    extends StructurePiece {
        protected NetherBridgePiece(StructurePieceType worldgenfeaturestructurepiecetype, int i, BoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i, structureboundingbox);
        }

        public NetherBridgePiece(StructurePieceType worldgenfeaturestructurepiecetype, CompoundTag nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
        }

        private int updatePieceWeight(List<PieceWeight> list) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight netherfortresspieces_n : list) {
                if (netherfortresspieces_n.maxPlaceCount > 0 && netherfortresspieces_n.placeCount < netherfortresspieces_n.maxPlaceCount) {
                    flag = true;
                }
                i += netherfortresspieces_n.weight;
            }
            return flag ? i : -1;
        }

        private NetherBridgePiece generatePiece(StartPiece netherfortresspieces_q, List<PieceWeight> list, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, Direction enumdirection, int l) {
            int i1 = this.updatePieceWeight(list);
            boolean flag = i1 > 0 && l <= 30;
            int j1 = 0;
            block0: while (j1 < 5 && flag) {
                ++j1;
                int k1 = randomsource.nextInt(i1);
                for (PieceWeight netherfortresspieces_n : list) {
                    if ((k1 -= netherfortresspieces_n.weight) >= 0) continue;
                    if (!netherfortresspieces_n.doPlace(l) || netherfortresspieces_n == netherfortresspieces_q.previousPiece && !netherfortresspieces_n.allowInRow) continue block0;
                    NetherBridgePiece netherfortresspieces_m = NetherFortressPieces.findAndCreateBridgePieceFactory(netherfortresspieces_n, structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
                    if (netherfortresspieces_m == null) continue;
                    ++netherfortresspieces_n.placeCount;
                    netherfortresspieces_q.previousPiece = netherfortresspieces_n;
                    if (!netherfortresspieces_n.isValid()) {
                        list.remove(netherfortresspieces_n);
                    }
                    return netherfortresspieces_m;
                }
            }
            return BridgeEndFiller.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        }

        private StructurePiece generateAndAddPiece(StartPiece netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, int k, @Nullable Direction enumdirection, int l, boolean flag) {
            if (Math.abs(i - netherfortresspieces_q.getBoundingBox().minX()) <= 112 && Math.abs(k - netherfortresspieces_q.getBoundingBox().minZ()) <= 112) {
                NetherBridgePiece structurepiece;
                List<PieceWeight> list = netherfortresspieces_q.availableBridgePieces;
                if (flag) {
                    list = netherfortresspieces_q.availableCastlePieces;
                }
                if ((structurepiece = this.generatePiece(netherfortresspieces_q, list, structurepieceaccessor, randomsource, i, j, k, enumdirection, l + 1)) != null) {
                    structurepieceaccessor.addPiece(structurepiece);
                    netherfortresspieces_q.pendingChildren.add(structurepiece);
                }
                return structurepiece;
            }
            return BridgeEndFiller.createPiece(structurepieceaccessor, randomsource, i, j, k, enumdirection, l);
        }

        @Nullable
        protected StructurePiece generateChildForward(StartPiece netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, boolean flag) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + i, this.boundingBox.minY() + j, this.boundingBox.minZ() - 1, enumdirection, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + i, this.boundingBox.minY() + j, this.boundingBox.maxZ() + 1, enumdirection, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + j, this.boundingBox.minZ() + i, enumdirection, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + j, this.boundingBox.minZ() + i, enumdirection, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildLeft(StartPiece netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, boolean flag) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.WEST, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.WEST, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildRight(StartPiece netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i, int j, boolean flag) {
            Direction enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.EAST, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i, this.boundingBox.minZ() + j, Direction.EAST, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j, this.boundingBox.minY() + i, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(BoundingBox structureboundingbox) {
            return structureboundingbox != null && structureboundingbox.minY() > 10;
        }
    }
}

