/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;

public abstract class NodeEvaluator {
    protected PathfindingContext currentContext;
    protected Mob mob;
    protected final Int2ObjectMap<Node> nodes = new Int2ObjectOpenHashMap();
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors = true;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    protected boolean canWalkOverFences;

    public void prepare(PathNavigationRegion var0, Mob var1) {
        this.currentContext = new PathfindingContext(var0, var1);
        this.mob = var1;
        this.nodes.clear();
        this.entityWidth = Mth.floor(var1.getBbWidth() + 1.0f);
        this.entityHeight = Mth.floor(var1.getBbHeight() + 1.0f);
        this.entityDepth = Mth.floor(var1.getBbWidth() + 1.0f);
    }

    public void done() {
        this.currentContext = null;
        this.mob = null;
    }

    protected Node getNode(BlockPos var0) {
        return this.getNode(var0.getX(), var0.getY(), var0.getZ());
    }

    protected Node getNode(int var0, int var1, int var2) {
        return (Node)this.nodes.computeIfAbsent(Node.createHash(var0, var1, var2), var3 -> new Node(var0, var1, var2));
    }

    public abstract Node getStart();

    public abstract Target getTarget(double var1, double var3, double var5);

    protected Target getTargetNodeAt(double var0, double var2, double var4) {
        return new Target(this.getNode(Mth.floor(var0), Mth.floor(var2), Mth.floor(var4)));
    }

    public abstract int getNeighbors(Node[] var1, Node var2);

    public abstract PathType getPathTypeOfMob(PathfindingContext var1, int var2, int var3, int var4, Mob var5);

    public abstract PathType getPathType(PathfindingContext var1, int var2, int var3, int var4);

    public PathType getPathType(Mob var0, BlockPos var1) {
        return this.getPathType(new PathfindingContext(var0.level(), var0), var1.getX(), var1.getY(), var1.getZ());
    }

    public void setCanPassDoors(boolean var0) {
        this.canPassDoors = var0;
    }

    public void setCanOpenDoors(boolean var0) {
        this.canOpenDoors = var0;
    }

    public void setCanFloat(boolean var0) {
        this.canFloat = var0;
    }

    public void setCanWalkOverFences(boolean var0) {
        this.canWalkOverFences = var0;
    }

    public boolean canPassDoors() {
        return this.canPassDoors;
    }

    public boolean canOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean canFloat() {
        return this.canFloat;
    }

    public boolean canWalkOverFences() {
        return this.canWalkOverFences;
    }

    public static boolean isBurningBlock(BlockState var0) {
        return var0.is(BlockTags.FIRE) || var0.is(Blocks.LAVA) || var0.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire(var0) || var0.is(Blocks.LAVA_CAULDRON);
    }
}

