/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapFrame;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class MapItemSavedData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAP_SIZE = 128;
    private static final int HALF_MAP_SIZE = 64;
    public static final int MAX_SCALE = 4;
    public static final int TRACKED_DECORATION_LIMIT = 256;
    private static final String FRAME_PREFIX = "frame-";
    public static final Codec<MapItemSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(worldmap -> worldmap.dimension), (App)Codec.INT.fieldOf("xCenter").forGetter(worldmap -> worldmap.centerX), (App)Codec.INT.fieldOf("zCenter").forGetter(worldmap -> worldmap.centerZ), (App)Codec.BYTE.optionalFieldOf("scale", (Object)0).forGetter(worldmap -> worldmap.scale), (App)Codec.BYTE_BUFFER.fieldOf("colors").forGetter(worldmap -> ByteBuffer.wrap(worldmap.colors)), (App)Codec.BOOL.optionalFieldOf("trackingPosition", (Object)true).forGetter(worldmap -> worldmap.trackingPosition), (App)Codec.BOOL.optionalFieldOf("unlimitedTracking", (Object)false).forGetter(worldmap -> worldmap.unlimitedTracking), (App)Codec.BOOL.optionalFieldOf("locked", (Object)false).forGetter(worldmap -> worldmap.locked), (App)MapBanner.CODEC.listOf().optionalFieldOf("banners", List.of()).forGetter(worldmap -> List.copyOf(worldmap.bannerMarkers.values())), (App)MapFrame.CODEC.listOf().optionalFieldOf("frames", List.of()).forGetter(worldmap -> List.copyOf(worldmap.frameMarkers.values())), (App)Codec.LONG.optionalFieldOf("UUIDLeast", (Object)0L).forGetter(worldmap -> {
        UUID uuid = worldmap.updateUUID();
        return uuid != null ? uuid.getLeastSignificantBits() : 0L;
    }), (App)Codec.LONG.optionalFieldOf("UUIDMost", (Object)0L).forGetter(worldmap -> {
        UUID uuid = worldmap.updateUUID();
        return uuid != null ? uuid.getMostSignificantBits() : 0L;
    })).apply((Applicative)instance, MapItemSavedData::new));
    public int centerX;
    public int centerZ;
    public ResourceKey<Level> dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public boolean locked;
    public final List<HoldingPlayer> carriedBy = Lists.newArrayList();
    public final Map<Player, HoldingPlayer> carriedByPlayers = Maps.newHashMap();
    private final Map<String, MapBanner> bannerMarkers = Maps.newHashMap();
    public final Map<String, MapDecoration> decorations = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> frameMarkers = Maps.newHashMap();
    private int trackedDecorationCount;
    public final CraftMapView mapView;
    public UUID uniqueId = null;
    public MapId id;

    private static ResourceKey<Level> getWorldKey(ResourceKey<Level> resourcekey, long uuidLeast, long uuidMost) {
        UUID uniqueId;
        CraftWorld world;
        ServerLevel lookup = MinecraftServer.getServer().getLevel(resourcekey);
        if (lookup != null) {
            return resourcekey;
        }
        if (uuidLeast != 0L && uuidMost != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(uuidMost, uuidLeast)))) != null) {
            return world.getHandle().dimension();
        }
        throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(resourcekey));
    }

    @Nullable
    private UUID updateUUID() {
        ServerLevel world;
        if (this.uniqueId == null && (world = MinecraftServer.getServer().getLevel(this.dimension)) != null) {
            this.uniqueId = world.getWorld().getUID();
        }
        return this.uniqueId;
    }

    public static SavedDataType<MapItemSavedData> type(MapId mapid) {
        return new SavedDataType<MapItemSavedData>(mapid.key(), () -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, CODEC, DataFixTypes.SAVED_DATA_MAP_DATA);
    }

    private MapItemSavedData(int i, int j, byte b0, boolean flag, boolean flag1, boolean flag2, ResourceKey<Level> resourcekey) {
        this.scale = b0;
        this.centerX = i;
        this.centerZ = j;
        this.dimension = resourcekey;
        this.trackingPosition = flag;
        this.unlimitedTracking = flag1;
        this.locked = flag2;
        this.updateUUID();
        this.mapView = new CraftMapView(this);
    }

    private MapItemSavedData(ResourceKey<Level> resourcekey, int i, int j, byte b0, ByteBuffer bytebuffer, boolean flag, boolean flag1, boolean flag2, List<MapBanner> list, List<MapFrame> list1, long uuidLeast, long uuidMost) {
        this(i, j, (byte)Mth.clamp(b0, 0, 4), flag, flag1, flag2, MapItemSavedData.getWorldKey(resourcekey, uuidLeast, uuidMost));
        if (bytebuffer.array().length == 16384) {
            this.colors = bytebuffer.array();
        }
        for (MapBanner mapiconbanner : list) {
            this.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
            this.addDecoration(mapiconbanner.getDecoration(), null, mapiconbanner.getId(), mapiconbanner.pos().getX(), mapiconbanner.pos().getZ(), 180.0, mapiconbanner.name().orElse(null));
        }
        for (MapFrame worldmapframe : list1) {
            this.frameMarkers.put(worldmapframe.getId(), worldmapframe);
            this.addDecoration(MapDecorationTypes.FRAME, null, MapItemSavedData.getFrameKey(worldmapframe.entityId()), worldmapframe.pos().getX(), worldmapframe.pos().getZ(), worldmapframe.rotation(), null);
        }
    }

    public static MapItemSavedData createFresh(double d0, double d1, byte b0, boolean flag, boolean flag1, ResourceKey<Level> resourcekey) {
        int i = 128 * (1 << b0);
        int j = Mth.floor((d0 + 64.0) / (double)i);
        int k = Mth.floor((d1 + 64.0) / (double)i);
        int l = j * i + i / 2 - 64;
        int i1 = k * i + i / 2 - 64;
        return new MapItemSavedData(l, i1, b0, flag, flag1, false, resourcekey);
    }

    public static MapItemSavedData createForClient(byte b0, boolean flag, ResourceKey<Level> resourcekey) {
        return new MapItemSavedData(0, 0, b0, false, false, flag, resourcekey);
    }

    public MapItemSavedData locked() {
        MapItemSavedData worldmap = new MapItemSavedData(this.centerX, this.centerZ, this.scale, this.trackingPosition, this.unlimitedTracking, true, this.dimension);
        worldmap.bannerMarkers.putAll(this.bannerMarkers);
        worldmap.decorations.putAll(this.decorations);
        worldmap.trackedDecorationCount = this.trackedDecorationCount;
        System.arraycopy(this.colors, 0, worldmap.colors, 0, this.colors.length);
        return worldmap;
    }

    public MapItemSavedData scaled() {
        return MapItemSavedData.createFresh(this.centerX, this.centerZ, (byte)Mth.clamp(this.scale + 1, 0, 4), this.trackingPosition, this.unlimitedTracking, this.dimension);
    }

    private static Predicate<ItemStack> mapMatcher(ItemStack itemstack) {
        MapId mapid = itemstack.get(DataComponents.MAP_ID);
        return itemstack1 -> itemstack1 == itemstack ? true : itemstack1.is(itemstack.getItem()) && Objects.equals(mapid, itemstack1.get(DataComponents.MAP_ID));
    }

    public void tickCarriedBy(Player entityhuman, ItemStack itemstack) {
        if (!this.carriedByPlayers.containsKey(entityhuman)) {
            HoldingPlayer worldmap_worldmaphumantracker = new HoldingPlayer(entityhuman);
            this.carriedByPlayers.put(entityhuman, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = MapItemSavedData.mapMatcher(itemstack);
        if (!entityhuman.getInventory().contains(predicate)) {
            this.removeDecoration(entityhuman.getPlainTextName());
        }
        for (int i = 0; i < this.carriedBy.size(); ++i) {
            HoldingPlayer worldmap_worldmaphumantracker1 = this.carriedBy.get(i);
            Player entityhuman1 = worldmap_worldmaphumantracker1.player;
            String s = entityhuman1.getPlainTextName();
            if (!entityhuman1.isRemoved() && (entityhuman1.getInventory().contains(predicate) || itemstack.isFramed())) {
                if (!itemstack.isFramed() && entityhuman1.level().dimension() == this.dimension && this.trackingPosition) {
                    this.addDecoration(MapDecorationTypes.PLAYER, entityhuman1.level(), s, entityhuman1.getX(), entityhuman1.getZ(), entityhuman1.getYRot(), null);
                }
            } else {
                this.carriedByPlayers.remove(entityhuman1);
                this.carriedBy.remove(worldmap_worldmaphumantracker1);
                this.removeDecoration(s);
            }
            if (entityhuman1.equals(entityhuman) || !MapItemSavedData.hasMapInvisibilityItemEquipped(entityhuman1)) continue;
            this.removeDecoration(s);
        }
        if (itemstack.isFramed() && this.trackingPosition) {
            ItemFrame entityitemframe = itemstack.getFrame();
            BlockPos blockposition = entityitemframe.getPos();
            MapFrame worldmapframe = this.frameMarkers.get(MapFrame.frameId(blockposition));
            if (worldmapframe != null && entityitemframe.getId() != worldmapframe.entityId() && this.frameMarkers.containsKey(worldmapframe.getId())) {
                this.removeDecoration(MapItemSavedData.getFrameKey(worldmapframe.entityId()));
            }
            MapFrame worldmapframe1 = new MapFrame(blockposition, entityitemframe.getDirection().get2DDataValue() * 90, entityitemframe.getId());
            this.addDecoration(MapDecorationTypes.FRAME, entityhuman.level(), MapItemSavedData.getFrameKey(entityitemframe.getId()), blockposition.getX(), blockposition.getZ(), entityitemframe.getDirection().get2DDataValue() * 90, null);
            MapFrame worldmapframe2 = this.frameMarkers.put(worldmapframe1.getId(), worldmapframe1);
            if (!worldmapframe1.equals(worldmapframe2)) {
                this.setDirty();
            }
        }
        MapDecorations mapdecorations = itemstack.getOrDefault(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY);
        if (!this.decorations.keySet().containsAll(mapdecorations.decorations().keySet())) {
            mapdecorations.decorations().forEach((s1, mapdecorations_a) -> {
                if (!this.decorations.containsKey(s1)) {
                    this.addDecoration(mapdecorations_a.type(), entityhuman.level(), (String)s1, mapdecorations_a.x(), mapdecorations_a.z(), mapdecorations_a.rotation(), null);
                }
            });
        }
    }

    private static boolean hasMapInvisibilityItemEquipped(Player entityhuman) {
        for (EquipmentSlot enumitemslot : EquipmentSlot.values()) {
            if (enumitemslot == EquipmentSlot.MAINHAND || enumitemslot == EquipmentSlot.OFFHAND || !entityhuman.getItemBySlot(enumitemslot).is(ItemTags.MAP_INVISIBILITY_EQUIPMENT)) continue;
            return true;
        }
        return false;
    }

    private void removeDecoration(String s) {
        MapDecoration mapicon = this.decorations.remove(s);
        if (mapicon != null && mapicon.type().value().trackCount()) {
            --this.trackedDecorationCount;
        }
        this.setDecorationsDirty();
    }

    public static void addTargetDecoration(ItemStack itemstack, BlockPos blockposition, String s, Holder<MapDecorationType> holder) {
        MapDecorations.Entry mapdecorations_a = new MapDecorations.Entry(holder, blockposition.getX(), blockposition.getZ(), 180.0f);
        itemstack.update(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY, mapdecorations -> mapdecorations.withDecoration(s, mapdecorations_a));
        if (holder.value().hasMapColor()) {
            itemstack.set(DataComponents.MAP_COLOR, new MapItemColor(holder.value().mapColor()));
        }
    }

    private void addDecoration(Holder<MapDecorationType> holder, @Nullable LevelAccessor generatoraccess, String s, double d0, double d1, double d2, @Nullable Component ichatbasecomponent) {
        int i = 1 << this.scale;
        float f = (float)(d0 - (double)this.centerX) / (float)i;
        float f1 = (float)(d1 - (double)this.centerZ) / (float)i;
        MapDecorationLocation worldmap_b = this.calculateDecorationLocationAndType(holder, generatoraccess, d2, f, f1);
        if (worldmap_b == null) {
            this.removeDecoration(s);
        } else {
            MapDecoration mapicon1;
            MapDecoration mapicon = new MapDecoration(worldmap_b.type(), worldmap_b.x(), worldmap_b.y(), worldmap_b.rot(), Optional.ofNullable(ichatbasecomponent));
            if (!mapicon.equals(mapicon1 = this.decorations.put(s, mapicon))) {
                if (mapicon1 != null && mapicon1.type().value().trackCount()) {
                    --this.trackedDecorationCount;
                }
                if (worldmap_b.type().value().trackCount()) {
                    ++this.trackedDecorationCount;
                }
                this.setDecorationsDirty();
            }
        }
    }

    @Nullable
    private MapDecorationLocation calculateDecorationLocationAndType(Holder<MapDecorationType> holder, @Nullable LevelAccessor generatoraccess, double d0, float f, float f1) {
        byte b0 = MapItemSavedData.clampMapCoordinate(f);
        byte b1 = MapItemSavedData.clampMapCoordinate(f1);
        if (holder.is(MapDecorationTypes.PLAYER)) {
            Pair<Holder<MapDecorationType>, Byte> pair = this.playerDecorationTypeAndRotation(holder, generatoraccess, d0, f, f1);
            return pair == null ? null : new MapDecorationLocation((Holder)pair.getFirst(), b0, b1, (Byte)pair.getSecond());
        }
        return !MapItemSavedData.isInsideMap(f, f1) && !this.unlimitedTracking ? null : new MapDecorationLocation(holder, b0, b1, this.calculateRotation(generatoraccess, d0));
    }

    @Nullable
    private Pair<Holder<MapDecorationType>, Byte> playerDecorationTypeAndRotation(Holder<MapDecorationType> holder, @Nullable LevelAccessor generatoraccess, double d0, float f, float f1) {
        if (MapItemSavedData.isInsideMap(f, f1)) {
            return Pair.of(holder, (Object)this.calculateRotation(generatoraccess, d0));
        }
        Holder<MapDecorationType> holder1 = this.decorationTypeForPlayerOutsideMap(f, f1);
        return holder1 == null ? null : Pair.of(holder1, (Object)0);
    }

    private byte calculateRotation(@Nullable LevelAccessor generatoraccess, double d0) {
        if (this.dimension == Level.NETHER && generatoraccess != null) {
            int i = (int)(generatoraccess.getLevelData().getDayTime() / 10L);
            return (byte)(i * i * 34187121 + i * 121 >> 15 & 0xF);
        }
        double d1 = d0 < 0.0 ? d0 - 8.0 : d0 + 8.0;
        return (byte)(d1 * 16.0 / 360.0);
    }

    private static boolean isInsideMap(float f, float f1) {
        int i = 63;
        return f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f;
    }

    @Nullable
    private Holder<MapDecorationType> decorationTypeForPlayerOutsideMap(float f, float f1) {
        boolean flag;
        int i = 320;
        boolean bl = flag = Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f;
        return flag ? MapDecorationTypes.PLAYER_OFF_MAP : (this.unlimitedTracking ? MapDecorationTypes.PLAYER_OFF_LIMITS : null);
    }

    private static byte clampMapCoordinate(float f) {
        int i = 63;
        return (byte)(f <= -63.0f ? -128 : (byte)(f >= 63.0f ? 127 : (byte)((double)(f * 2.0f) + 0.5)));
    }

    @Nullable
    public Packet<?> getUpdatePacket(MapId mapid, Player entityhuman) {
        HoldingPlayer worldmap_worldmaphumantracker = this.carriedByPlayers.get(entityhuman);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.nextUpdatePacket(mapid);
    }

    public void setColorsDirty(int i, int j) {
        this.setDirty();
        for (HoldingPlayer worldmap_worldmaphumantracker : this.carriedBy) {
            worldmap_worldmaphumantracker.markColorsDirty(i, j);
        }
    }

    public void setDecorationsDirty() {
        this.carriedBy.forEach(HoldingPlayer::markDecorationsDirty);
    }

    public HoldingPlayer getHoldingPlayer(Player entityhuman) {
        HoldingPlayer worldmap_worldmaphumantracker = this.carriedByPlayers.get(entityhuman);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new HoldingPlayer(entityhuman);
            this.carriedByPlayers.put(entityhuman, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean toggleBanner(LevelAccessor generatoraccess, BlockPos blockposition) {
        double d0 = (double)blockposition.getX() + 0.5;
        double d1 = (double)blockposition.getZ() + 0.5;
        int i = 1 << this.scale;
        double d2 = (d0 - (double)this.centerX) / (double)i;
        double d3 = (d1 - (double)this.centerZ) / (double)i;
        int j = 63;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapBanner mapiconbanner = MapBanner.fromWorld(generatoraccess, blockposition);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.bannerMarkers.remove(mapiconbanner.getId(), mapiconbanner)) {
                this.removeDecoration(mapiconbanner.getId());
                this.setDirty();
                return true;
            }
            if (!this.isTrackedCountOverLimit(256)) {
                this.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
                this.addDecoration(mapiconbanner.getDecoration(), generatoraccess, mapiconbanner.getId(), d0, d1, 180.0, mapiconbanner.name().orElse(null));
                this.setDirty();
                return true;
            }
        }
        return false;
    }

    public void checkBanners(BlockGetter iblockaccess, int i, int j) {
        Iterator<MapBanner> iterator = this.bannerMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapiconbanner1;
            MapBanner mapiconbanner = iterator.next();
            if (mapiconbanner.pos().getX() != i || mapiconbanner.pos().getZ() != j || mapiconbanner.equals(mapiconbanner1 = MapBanner.fromWorld(iblockaccess, mapiconbanner.pos()))) continue;
            iterator.remove();
            this.removeDecoration(mapiconbanner.getId());
            this.setDirty();
        }
    }

    public Collection<MapBanner> getBanners() {
        return this.bannerMarkers.values();
    }

    public void removedFromFrame(BlockPos blockposition, int i) {
        this.removeDecoration(MapItemSavedData.getFrameKey(i));
        this.frameMarkers.remove(MapFrame.frameId(blockposition));
        this.setDirty();
    }

    public boolean updateColor(int i, int j, byte b0) {
        byte b1 = this.colors[i + j * 128];
        if (b1 != b0) {
            this.setColor(i, j, b0);
            return true;
        }
        return false;
    }

    public void setColor(int i, int j, byte b0) {
        this.colors[i + j * 128] = b0;
        this.setColorsDirty(i, j);
    }

    public boolean isExplorationMap() {
        for (MapDecoration mapicon : this.decorations.values()) {
            if (!mapicon.type().value().explorationMapElement()) continue;
            return true;
        }
        return false;
    }

    public void addClientSideDecorations(List<MapDecoration> list) {
        this.decorations.clear();
        this.trackedDecorationCount = 0;
        for (int i = 0; i < list.size(); ++i) {
            MapDecoration mapicon = list.get(i);
            this.decorations.put("icon-" + i, mapicon);
            if (!mapicon.type().value().trackCount()) continue;
            ++this.trackedDecorationCount;
        }
    }

    public Iterable<MapDecoration> getDecorations() {
        return this.decorations.values();
    }

    public boolean isTrackedCountOverLimit(int i) {
        return this.trackedDecorationCount >= i;
    }

    private static String getFrameKey(int i) {
        return FRAME_PREFIX + i;
    }

    public class HoldingPlayer {
        public final Player player;
        private boolean dirtyData = true;
        private int minDirtyX;
        private int minDirtyY;
        private int maxDirtyX = 127;
        private int maxDirtyY = 127;
        private boolean dirtyDecorations = true;
        private int tick;
        public int step;

        HoldingPlayer(Player entityhuman) {
            this.player = entityhuman;
        }

        private MapPatch createPatch(byte[] buffer) {
            int i = this.minDirtyX;
            int j = this.minDirtyY;
            int k = this.maxDirtyX + 1 - this.minDirtyX;
            int l = this.maxDirtyY + 1 - this.minDirtyY;
            byte[] abyte = new byte[k * l];
            for (int i1 = 0; i1 < k; ++i1) {
                for (int j1 = 0; j1 < l; ++j1) {
                    abyte[i1 + j1 * k] = buffer[i + i1 + (j + j1) * 128];
                }
            }
            return new MapPatch(i, j, k, l, abyte);
        }

        @Nullable
        Packet<?> nextUpdatePacket(MapId mapid) {
            ArrayList<MapDecoration> collection;
            MapPatch worldmap_c;
            RenderData render = MapItemSavedData.this.mapView.render((CraftPlayer)this.player.getBukkitEntity());
            if (this.dirtyData) {
                this.dirtyData = false;
                worldmap_c = this.createPatch(render.buffer);
            } else {
                worldmap_c = null;
            }
            if (this.tick++ % 5 == 0) {
                this.dirtyDecorations = false;
                ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapDecoration(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_c == null ? null : new ClientboundMapItemDataPacket(mapid, MapItemSavedData.this.scale, MapItemSavedData.this.locked, collection, worldmap_c);
        }

        void markColorsDirty(int i, int j) {
            if (this.dirtyData) {
                this.minDirtyX = Math.min(this.minDirtyX, i);
                this.minDirtyY = Math.min(this.minDirtyY, j);
                this.maxDirtyX = Math.max(this.maxDirtyX, i);
                this.maxDirtyY = Math.max(this.maxDirtyY, j);
            } else {
                this.dirtyData = true;
                this.minDirtyX = i;
                this.minDirtyY = j;
                this.maxDirtyX = i;
                this.maxDirtyY = j;
            }
        }

        private void markDecorationsDirty() {
            this.dirtyDecorations = true;
        }
    }

    private record MapDecorationLocation(Holder<MapDecorationType> type, byte x, byte y, byte rot) {
    }

    public record MapPatch(int startX, int startY, int width, int height, byte[] mapColors) {
        public static final StreamCodec<ByteBuf, Optional<MapPatch>> STREAM_CODEC = StreamCodec.of(MapPatch::write, MapPatch::read);

        private static void write(ByteBuf bytebuf, Optional<MapPatch> optional) {
            if (optional.isPresent()) {
                MapPatch worldmap_c = optional.get();
                bytebuf.writeByte(worldmap_c.width);
                bytebuf.writeByte(worldmap_c.height);
                bytebuf.writeByte(worldmap_c.startX);
                bytebuf.writeByte(worldmap_c.startY);
                FriendlyByteBuf.writeByteArray(bytebuf, worldmap_c.mapColors);
            } else {
                bytebuf.writeByte(0);
            }
        }

        private static Optional<MapPatch> read(ByteBuf bytebuf) {
            short i = bytebuf.readUnsignedByte();
            if (i > 0) {
                short j = bytebuf.readUnsignedByte();
                short k = bytebuf.readUnsignedByte();
                short l = bytebuf.readUnsignedByte();
                byte[] abyte = FriendlyByteBuf.readByteArray(bytebuf);
                return Optional.of(new MapPatch(k, l, i, j, abyte));
            }
            return Optional.empty();
        }

        public void applyToMap(MapItemSavedData worldmap) {
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    worldmap.setColor(this.startX + i, this.startY + j, this.mapColors[i + j * this.width]);
                }
            }
        }
    }
}

