/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> UNLIMITED_CODEC = ListOperation.codec(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> codec(int var02) {
        return Type.CODEC.dispatchMap("mode", ListOperation::mode, var0 -> var0.mapCodec).validate(var1 -> {
            int var3;
            ReplaceSection var2;
            if (var1 instanceof ReplaceSection && (var2 = (ReplaceSection)var1).size().isPresent() && (var3 = var2.size().get().intValue()) > var02) {
                return DataResult.error(() -> "Size value too large: " + var3 + ", max size is " + var02);
            }
            return DataResult.success((Object)var1);
        });
    }

    public Type mode();

    default public <T> List<T> apply(List<T> var0, List<T> var1) {
        return this.apply(var0, var1, Integer.MAX_VALUE);
    }

    public <T> List<T> apply(List<T> var1, List<T> var2, int var3);

    public static enum Type implements StringRepresentable
    {
        REPLACE_ALL("replace_all", ReplaceAll.MAP_CODEC),
        REPLACE_SECTION("replace_section", ReplaceSection.MAP_CODEC),
        INSERT("insert", Insert.MAP_CODEC),
        APPEND("append", Append.MAP_CODEC);

        public static final Codec<Type> CODEC;
        private final String id;
        final MapCodec<? extends ListOperation> mapCodec;

        private Type(String var2, MapCodec var3) {
            this.id = var2;
            this.mapCodec = var3;
        }

        public MapCodec<? extends ListOperation> mapCodec() {
            return this.mapCodec;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record ReplaceSection(int offset, Optional<Integer> size) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<ReplaceSection> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(ReplaceSection::offset), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("size").forGetter(ReplaceSection::size)).apply((Applicative)var0, ReplaceSection::new));

        public ReplaceSection(int var0) {
            this(var0, Optional.empty());
        }

        @Override
        public Type mode() {
            return Type.REPLACE_SECTION;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            ImmutableList var6;
            int var3 = var0.size();
            if (this.offset > var3) {
                LOGGER.error("Cannot replace when offset is out of bounds");
                return var0;
            }
            ImmutableList.Builder var4 = ImmutableList.builder();
            var4.addAll(var0.subList(0, this.offset));
            var4.addAll(var1);
            int var5 = this.offset + this.size.orElse(var1.size());
            if (var5 < var3) {
                var4.addAll(var0.subList(var5, var3));
            }
            if ((var6 = var4.build()).size() > var2) {
                LOGGER.error("Contents overflow in section replacement");
                return var0;
            }
            return var6;
        }
    }

    public record StandAlone<T>(List<T> value, ListOperation operation) {
        public static <T> Codec<StandAlone<T>> codec(Codec<T> var0, int var1) {
            return RecordCodecBuilder.create(var2 -> var2.group((App)var0.sizeLimitedListOf(var1).fieldOf("values").forGetter(var0 -> var0.value), (App)ListOperation.codec(var1).forGetter(var0 -> var0.operation)).apply((Applicative)var2, StandAlone::new));
        }

        public List<T> apply(List<T> var0) {
            return this.operation.apply(var0, this.value);
        }
    }

    public static class Append
    implements ListOperation {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final Append INSTANCE = new Append();
        public static final MapCodec<Append> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private Append() {
        }

        @Override
        public Type mode() {
            return Type.APPEND;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            if (var0.size() + var1.size() > var2) {
                LOGGER.error("Contents overflow in section append");
                return var0;
            }
            return Stream.concat(var0.stream(), var1.stream()).toList();
        }
    }

    public record Insert(int offset) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Insert> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(Insert::offset)).apply((Applicative)var0, Insert::new));

        @Override
        public Type mode() {
            return Type.INSERT;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            int var3 = var0.size();
            if (this.offset > var3) {
                LOGGER.error("Cannot insert when offset is out of bounds");
                return var0;
            }
            if (var3 + var1.size() > var2) {
                LOGGER.error("Contents overflow in section insertion");
                return var0;
            }
            ImmutableList.Builder var4 = ImmutableList.builder();
            var4.addAll(var0.subList(0, this.offset));
            var4.addAll(var1);
            var4.addAll(var0.subList(this.offset, var3));
            return var4.build();
        }
    }

    public static class ReplaceAll
    implements ListOperation {
        public static final ReplaceAll INSTANCE = new ReplaceAll();
        public static final MapCodec<ReplaceAll> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private ReplaceAll() {
        }

        @Override
        public Type mode() {
            return Type.REPLACE_ALL;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            return var1;
        }
    }
}

