/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickAccess;

public class LevelTicks<T>
implements LevelTickAccess<T> {
    private static final Comparator<LevelChunkTicks<?>> CONTAINER_DRAIN_ORDER = (var0, var1) -> ScheduledTick.INTRA_TICK_DRAIN_ORDER.compare(var0.peek(), var1.peek());
    private final LongPredicate tickCheck;
    private final Long2ObjectMap<LevelChunkTicks<T>> allContainers = new Long2ObjectOpenHashMap();
    private final Long2LongMap nextTickForContainer = (Long2LongMap)Util.make(new Long2LongOpenHashMap(), var0 -> var0.defaultReturnValue(Long.MAX_VALUE));
    private final Queue<LevelChunkTicks<T>> containersToTick = new PriorityQueue(CONTAINER_DRAIN_ORDER);
    private final Queue<ScheduledTick<T>> toRunThisTick = new ArrayDeque<ScheduledTick<T>>();
    private final List<ScheduledTick<T>> alreadyRunThisTick = new ArrayList<ScheduledTick<T>>();
    private final Set<ScheduledTick<?>> toRunThisTickSet = new ObjectOpenCustomHashSet(ScheduledTick.UNIQUE_TICK_HASH);
    private final BiConsumer<LevelChunkTicks<T>, ScheduledTick<T>> chunkScheduleUpdater = (var0, var1) -> {
        if (var1.equals(var0.peek())) {
            this.updateContainerScheduling((ScheduledTick<T>)var1);
        }
    };

    public LevelTicks(LongPredicate var02) {
        this.tickCheck = var02;
    }

    public void addContainer(ChunkPos var0, LevelChunkTicks<T> var1) {
        long var2 = var0.toLong();
        this.allContainers.put(var2, var1);
        ScheduledTick<T> var4 = var1.peek();
        if (var4 != null) {
            this.nextTickForContainer.put(var2, var4.triggerTick());
        }
        var1.setOnTickAdded(this.chunkScheduleUpdater);
    }

    public void removeContainer(ChunkPos var0) {
        long var1 = var0.toLong();
        LevelChunkTicks var3 = (LevelChunkTicks)this.allContainers.remove(var1);
        this.nextTickForContainer.remove(var1);
        if (var3 != null) {
            var3.setOnTickAdded(null);
        }
    }

    @Override
    public void schedule(ScheduledTick<T> var0) {
        long var1 = ChunkPos.asLong(var0.pos());
        LevelChunkTicks var3 = (LevelChunkTicks)this.allContainers.get(var1);
        if (var3 == null) {
            Util.logAndPauseIfInIde("Trying to schedule tick in not loaded position " + String.valueOf(var0.pos()));
            return;
        }
        var3.schedule(var0);
    }

    public void tick(long var0, int var2, BiConsumer<BlockPos, T> var3) {
        ProfilerFiller var4 = Profiler.get();
        var4.push("collect");
        this.collectTicks(var0, var2, var4);
        var4.popPush("run");
        var4.incrementCounter("ticksToRun", this.toRunThisTick.size());
        this.runCollectedTicks(var3);
        var4.popPush("cleanup");
        this.cleanupAfterTick();
        var4.pop();
    }

    private void collectTicks(long var0, int var2, ProfilerFiller var3) {
        this.sortContainersToTick(var0);
        var3.incrementCounter("containersToTick", this.containersToTick.size());
        this.drainContainers(var0, var2);
        this.rescheduleLeftoverContainers();
    }

    private void sortContainersToTick(long var0) {
        ObjectIterator var2 = Long2LongMaps.fastIterator((Long2LongMap)this.nextTickForContainer);
        while (var2.hasNext()) {
            Long2LongMap.Entry var3 = (Long2LongMap.Entry)var2.next();
            long var4 = var3.getLongKey();
            long var6 = var3.getLongValue();
            if (var6 > var0) continue;
            LevelChunkTicks var8 = (LevelChunkTicks)this.allContainers.get(var4);
            if (var8 == null) {
                var2.remove();
                continue;
            }
            ScheduledTick var9 = var8.peek();
            if (var9 == null) {
                var2.remove();
                continue;
            }
            if (var9.triggerTick() > var0) {
                var3.setValue(var9.triggerTick());
                continue;
            }
            if (!this.tickCheck.test(var4)) continue;
            var2.remove();
            this.containersToTick.add(var8);
        }
    }

    private void drainContainers(long var0, int var2) {
        LevelChunkTicks<T> var3;
        while (this.canScheduleMoreTicks(var2) && (var3 = this.containersToTick.poll()) != null) {
            ScheduledTick<T> var4 = var3.poll();
            this.scheduleForThisTick(var4);
            this.drainFromCurrentContainer(this.containersToTick, var3, var0, var2);
            ScheduledTick<T> var5 = var3.peek();
            if (var5 == null) continue;
            if (var5.triggerTick() <= var0 && this.canScheduleMoreTicks(var2)) {
                this.containersToTick.add(var3);
                continue;
            }
            this.updateContainerScheduling(var5);
        }
    }

    private void rescheduleLeftoverContainers() {
        for (LevelChunkTicks levelChunkTicks : this.containersToTick) {
            this.updateContainerScheduling(levelChunkTicks.peek());
        }
    }

    private void updateContainerScheduling(ScheduledTick<T> var0) {
        this.nextTickForContainer.put(ChunkPos.asLong(var0.pos()), var0.triggerTick());
    }

    private void drainFromCurrentContainer(Queue<LevelChunkTicks<T>> var0, LevelChunkTicks<T> var1, long var2, int var4) {
        ScheduledTick<T> var7;
        ScheduledTick<T> var6;
        if (!this.canScheduleMoreTicks(var4)) {
            return;
        }
        LevelChunkTicks<T> var5 = var0.peek();
        ScheduledTick<T> scheduledTick = var6 = var5 != null ? var5.peek() : null;
        while (this.canScheduleMoreTicks(var4) && (var7 = var1.peek()) != null && var7.triggerTick() <= var2 && (var6 == null || ScheduledTick.INTRA_TICK_DRAIN_ORDER.compare(var7, var6) <= 0)) {
            var1.poll();
            this.scheduleForThisTick(var7);
        }
    }

    private void scheduleForThisTick(ScheduledTick<T> var0) {
        this.toRunThisTick.add(var0);
    }

    private boolean canScheduleMoreTicks(int var0) {
        return this.toRunThisTick.size() < var0;
    }

    private void runCollectedTicks(BiConsumer<BlockPos, T> var0) {
        while (!this.toRunThisTick.isEmpty()) {
            ScheduledTick<T> var1 = this.toRunThisTick.poll();
            if (!this.toRunThisTickSet.isEmpty()) {
                this.toRunThisTickSet.remove(var1);
            }
            this.alreadyRunThisTick.add(var1);
            var0.accept(var1.pos(), (BlockPos)var1.type());
        }
    }

    private void cleanupAfterTick() {
        this.toRunThisTick.clear();
        this.containersToTick.clear();
        this.alreadyRunThisTick.clear();
        this.toRunThisTickSet.clear();
    }

    @Override
    public boolean hasScheduledTick(BlockPos var0, T var1) {
        LevelChunkTicks var2 = (LevelChunkTicks)this.allContainers.get(ChunkPos.asLong(var0));
        return var2 != null && var2.hasScheduledTick(var0, var1);
    }

    @Override
    public boolean willTickThisTick(BlockPos var0, T var1) {
        this.calculateTickSetIfNeeded();
        return this.toRunThisTickSet.contains(ScheduledTick.probe(var1, var0));
    }

    private void calculateTickSetIfNeeded() {
        if (this.toRunThisTickSet.isEmpty() && !this.toRunThisTick.isEmpty()) {
            this.toRunThisTickSet.addAll(this.toRunThisTick);
        }
    }

    private void forContainersInArea(BoundingBox var0, PosAndContainerConsumer<T> var1) {
        int var2 = SectionPos.posToSectionCoord(var0.minX());
        int var3 = SectionPos.posToSectionCoord(var0.minZ());
        int var4 = SectionPos.posToSectionCoord(var0.maxX());
        int var5 = SectionPos.posToSectionCoord(var0.maxZ());
        for (int var6 = var2; var6 <= var4; ++var6) {
            for (int var7 = var3; var7 <= var5; ++var7) {
                long var8 = ChunkPos.asLong(var6, var7);
                LevelChunkTicks var10 = (LevelChunkTicks)this.allContainers.get(var8);
                if (var10 == null) continue;
                var1.accept(var8, var10);
            }
        }
    }

    public void clearArea(BoundingBox var0) {
        Predicate<ScheduledTick> var12 = var1 -> var0.isInside(var1.pos());
        this.forContainersInArea(var0, (var1, var3) -> {
            ScheduledTick var4 = var3.peek();
            var3.removeIf(var12);
            ScheduledTick var5 = var3.peek();
            if (var5 != var4) {
                if (var5 != null) {
                    this.updateContainerScheduling(var5);
                } else {
                    this.nextTickForContainer.remove(var1);
                }
            }
        });
        this.alreadyRunThisTick.removeIf(var12);
        this.toRunThisTick.removeIf(var12);
    }

    public void copyArea(BoundingBox var0, Vec3i var1) {
        this.copyAreaFrom(this, var0, var1);
    }

    public void copyAreaFrom(LevelTicks<T> var0, BoundingBox var12, Vec3i var22) {
        ArrayList var3 = new ArrayList();
        Predicate<ScheduledTick> var42 = var1 -> var12.isInside(var1.pos());
        var0.alreadyRunThisTick.stream().filter(var42).forEach(var3::add);
        var0.toRunThisTick.stream().filter(var42).forEach(var3::add);
        var0.forContainersInArea(var12, (var2, var4) -> var4.getAll().filter(var42).forEach(var3::add));
        LongSummaryStatistics var52 = var3.stream().mapToLong(ScheduledTick::subTickOrder).summaryStatistics();
        long var6 = var52.getMin();
        long var8 = var52.getMax();
        var3.forEach(var5 -> this.schedule(new ScheduledTick(var5.type(), var5.pos().offset(var22), var5.triggerTick(), var5.priority(), var5.subTickOrder() - var6 + var8 + 1L)));
    }

    @Override
    public int count() {
        return this.allContainers.values().stream().mapToInt(TickAccess::count).sum();
    }

    @FunctionalInterface
    static interface PosAndContainerConsumer<T> {
        public void accept(long var1, LevelChunkTicks<T> var3);
    }
}

