/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_21_R6.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements org.bukkit.entity.AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, AreaEffectCloud entity) {
        super(server, entity);
    }

    @Override
    public AreaEffectCloud getHandle() {
        return (AreaEffectCloud)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    public int getDuration() {
        return this.getHandle().getDuration();
    }

    public void setDuration(int duration) {
        this.getHandle().setDuration(duration);
    }

    public int getWaitTime() {
        return this.getHandle().waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.getHandle().setWaitTime(waitTime);
    }

    public int getReapplicationDelay() {
        return this.getHandle().reapplicationDelay;
    }

    public void setReapplicationDelay(int delay) {
        this.getHandle().reapplicationDelay = delay;
    }

    public int getDurationOnUse() {
        return this.getHandle().durationOnUse;
    }

    public void setDurationOnUse(int duration) {
        this.getHandle().durationOnUse = duration;
    }

    public float getRadius() {
        return this.getHandle().getRadius();
    }

    public void setRadius(float radius) {
        this.getHandle().setRadius(radius);
    }

    public float getRadiusOnUse() {
        return this.getHandle().radiusOnUse;
    }

    public void setRadiusOnUse(float radius) {
        this.getHandle().setRadiusOnUse(radius);
    }

    public float getRadiusPerTick() {
        return this.getHandle().radiusPerTick;
    }

    public void setRadiusPerTick(float radius) {
        this.getHandle().setRadiusPerTick(radius);
    }

    public Particle getParticle() {
        return CraftParticle.minecraftToBukkit(this.getHandle().getParticle().getType());
    }

    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().setCustomParticle(CraftParticle.createParticleParam(particle, data));
    }

    public Color getColor() {
        return Color.fromRGB((int)this.getHandle().potionContents.getColor());
    }

    public void setColor(Color color) {
        PotionContents old = this.getHandle().potionContents;
        this.getHandle().setPotionContents(new PotionContents(old.potion(), Optional.of(color.asRGB()), old.customEffects(), old.customName()));
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().addEffect(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().updateParticle();
        return true;
    }

    public void clearCustomEffects() {
        PotionContents old = this.getHandle().potionContents;
        this.getHandle().setPotionContents(new PotionContents(old.potion(), old.customColor(), List.of(), old.customName()));
        this.getHandle().updateParticle();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffectInstance effect : this.getHandle().potionContents.customEffects()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffectInstance effect : this.getHandle().potionContents.customEffects()) {
            if (!CraftPotionUtil.equals(effect.getEffect(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().potionContents.customEffects().isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        Holder<MobEffect> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        PotionContents old = this.getHandle().potionContents;
        this.getHandle().setPotionContents(new PotionContents(old.potion(), old.customColor(), old.customEffects().stream().filter(mobEffect -> !mobEffect.getEffect().equals(minecraft)).toList(), old.customName()));
        return true;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().setPotionContents(this.getHandle().potionContents.withPotion(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            PotionContents old = this.getHandle().potionContents;
            this.getHandle().setPotionContents(new PotionContents(Optional.empty(), old.customColor(), old.customEffects(), old.customName()));
        }
    }

    public PotionType getBasePotionType() {
        return this.getHandle().potionContents.potion().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public ProjectileSource getSource() {
        net.minecraft.world.entity.LivingEntity source = this.getHandle().getOwner();
        return source == null ? null : (LivingEntity)source.getBukkitEntity();
    }

    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            CraftLivingEntity craftLivingEntity = (CraftLivingEntity)shooter;
            this.getHandle().setOwner(craftLivingEntity.getHandle());
        } else {
            this.getHandle().setOwner(null);
        }
    }
}

