/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.item.FallingBlockEntity;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.FallingBlock;

public class CraftFallingBlock
extends CraftEntity
implements FallingBlock {
    public CraftFallingBlock(CraftServer server, FallingBlockEntity entity) {
        super(server, entity);
    }

    @Override
    public FallingBlockEntity getHandle() {
        return (FallingBlockEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFallingBlock";
    }

    public Material getMaterial() {
        return this.getBlockData().getMaterial();
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().getBlockState());
    }

    public boolean getDropItem() {
        return this.getHandle().dropItem;
    }

    public void setDropItem(boolean drop) {
        this.getHandle().dropItem = drop;
    }

    public boolean getCancelDrop() {
        return this.getHandle().cancelDrop;
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.getHandle().cancelDrop = cancelDrop;
    }

    public boolean canHurtEntities() {
        return this.getHandle().hurtEntities;
    }

    public void setHurtEntities(boolean hurtEntities) {
        this.getHandle().hurtEntities = hurtEntities;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().time = value;
    }

    public float getDamagePerBlock() {
        return this.getHandle().fallDamagePerDistance;
    }

    public void setDamagePerBlock(float damage) {
        Preconditions.checkArgument(((double)damage >= 0.0 ? 1 : 0) != 0, (String)"damage must be >= 0.0, given %s", (Object)Float.valueOf(damage));
        this.getHandle().fallDamagePerDistance = damage;
        if ((double)damage > 0.0) {
            this.setHurtEntities(true);
        }
    }

    public int getMaxDamage() {
        return this.getHandle().fallDamageMax;
    }

    public void setMaxDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, given %s", (int)damage);
        this.getHandle().fallDamageMax = damage;
        if (damage > 0) {
            this.setHurtEntities(true);
        }
    }
}

