/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundClearDialogPacket;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Input;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.ban.IpBanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_21_R6.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftInput;
import org.bukkit.craftbukkit.v1_21_R6.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_21_R6.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private String lastKnownName;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private BorderChangeListener clientWorldBorderListener = this.createWorldBorderListener();
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private Component playerListHeader;
    private Component playerListFooter;

    public CraftPlayer(CraftServer server, ServerPlayer entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().getGameProfile();
    }

    private NameAndId nameAndId() {
        return this.getHandle().nameAndId();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(String.format("Cannot remove player %s, use Player#kickPlayer(String) instead.", this.getName()));
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().isOp(this.nameAndId());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().op(this.nameAndId());
        } else {
            this.server.getHandle().deop(this.nameAndId());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this.nameAndId());
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().connection.protocol() == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().connection.getRemoteAddress();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public boolean handleCookieResponse(ServerboundCookieResponsePacket response) {
        CookieFuture future = this.requestedCookies.peek();
        if (future != null && future.key.equals(response.key())) {
            Preconditions.checkState((future == this.requestedCookies.poll() ? 1 : 0) != 0, (Object)"requestedCookies queue mismatch");
            future.future().complete(response.payload());
            return true;
        }
        return false;
    }

    public boolean isTransferred() {
        return this.getHandle().transferCookieConnection.isTransferred();
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        ResourceLocation nms = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.add(new CookieFuture(nms, future));
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundCookieRequestPacket(nms));
        return future;
    }

    public void storeCookie(NamespacedKey key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Cookie value cannot be null");
        Preconditions.checkArgument((value.length <= 5120 ? 1 : 0) != 0, (Object)"Cookie value too large, must be smaller than 5120 bytes");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.CONFIGURATION || this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.PLAY ? 1 : 0) != 0, (Object)"Can only store cookie in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundStoreCookiePacket(CraftNamespacedKey.toMinecraft(key), value));
    }

    public void transfer(String host, int port) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"Host cannot be null");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.CONFIGURATION || this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.PLAY ? 1 : 0) != 0, (Object)"Can only transfer in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundTransferPacket(host, port));
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        this.sendRawMessage(null, message);
    }

    public void sendRawMessage(UUID sender, String message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        for (Component component : CraftChatMessage.fromString(message)) {
            this.getHandle().sendSystemMessage(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    public void setDisplayName(String name) {
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (ServerPlayer player : this.server.getHandle().players) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.connection.send(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.getHandle()));
        }
    }

    public int getPlayerListOrder() {
        return this.getHandle().listOrder;
    }

    public void setPlayerListOrder(int order) {
        Preconditions.checkArgument((order >= 0 ? 1 : 0) != 0, (Object)"order cannot be negative");
        this.getHandle().listOrder = order;
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : CraftChatMessage.fromComponent(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : CraftChatMessage.fromComponent(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = CraftChatMessage.fromStringOrNull(header, true);
        this.playerListFooter = CraftChatMessage.fromStringOrNull(footer, true);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundTabListPacket packet = new ClientboundTabListPacket(this.playerListHeader == null ? Component.empty() : this.playerListHeader, this.playerListFooter == null ? Component.empty() : this.playerListFooter);
        this.getHandle().connection.send(packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public void kickPlayer(String message) {
        this.getHandle().transferCookieConnection.kickPlayer(CraftChatMessage.fromStringOrEmpty(message, true));
    }

    public void setCompassTarget(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundSetDefaultSpawnPositionPacket(LevelData.RespawnData.of(((CraftWorld)loc.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(loc), loc.getYaw(), loc.getPitch())));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"msg cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.chat(msg, PlayerChatMessage.system(msg), false);
    }

    public boolean performCommand(String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command cannot be null");
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType((byte)instrument), new Note((int)note));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"Instrument cannot be null");
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"Note cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        Sound instrumentSound = instrument.getSound();
        if (instrumentSound == null) {
            return;
        }
        float pitch = note.getPitch();
        this.getHandle().connection.send(new ClientboundSoundPacket(CraftSound.bukkitToMinecraftHolder(instrumentSound), SoundSource.RECORDS, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, pitch, this.getHandle().getRandom().nextLong()));
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().connection == null) {
            return;
        }
        this.playSound0(loc, CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().connection == null) {
            return;
        }
        this.playSound0(loc, Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Location loc, Holder<SoundEvent> soundEffectHolder, SoundSource categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundSoundPacket packet = new ClientboundSoundPacket(soundEffectHolder, categoryNMS, loc.getX(), loc.getY(), loc.getZ(), volume, pitch, seed);
        this.getHandle().connection.send(packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().connection != null) break block3;
            }
            return;
        }
        this.playSound0(entity, CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().connection != null) break block3;
            }
            return;
        }
        this.playSound0(entity, Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Entity entity, Holder<SoundEvent> soundEffectHolder, SoundSource categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((soundEffectHolder != null ? 1 : 0) != 0, (Object)"Holder of SoundEffect cannot be null");
        Preconditions.checkArgument((categoryNMS != null ? 1 : 0) != 0, (Object)"SoundCategory cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(soundEffectHolder, categoryNMS, craftEntity.getHandle(), volume, pitch, seed);
        this.getHandle().connection.send(packet);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(ResourceLocation.parse(sound), category == null ? SoundSource.MASTER : SoundSource.valueOf(category.name())));
    }

    public void stopSound(SoundCategory category) {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(null, SoundSource.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        int packetData = effect.getId();
        ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().connection.send(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.getData().isAssignableFrom(data.getClass()), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals((Object)this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().gameMode.destroyBlock(new BlockPos(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().connection.send(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().connection.send(packet);
    }

    public void sendBlockChanges(Collection<org.bukkit.block.BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().connection == null || blocks.isEmpty()) {
            return;
        }
        HashMap<SectionPos, ChunkSectionChanges> changes = new HashMap<SectionPos, ChunkSectionChanges>();
        for (org.bukkit.block.BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            BlockPos blockPosition = cstate.getPosition();
            SectionPos sectionPosition = SectionPos.of(blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(SectionPos.sectionRelativePos(blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            ClientboundSectionBlocksUpdatePacket packet = new ClientboundSectionBlocksUpdatePacket((SectionPos)entry.getKey(), chunkChanges.positions(), (BlockState[])chunkChanges.blockData().toArray(BlockState[]::new));
            this.getHandle().connection.send(packet);
        }
    }

    public void sendBlockChanges(Collection<org.bukkit.block.BlockState> blocks, boolean suppressLightUpdates) {
        this.sendBlockChanges(blocks);
    }

    public void sendBlockDamage(Location loc, float progress) {
        this.sendBlockDamage(loc, progress, this.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().connection == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().connection.send(packet);
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        Preconditions.checkArgument((lines.length >= 4 ? 1 : 0) != 0, (String)"Must have at least 4 lines (%s)", (int)lines.length);
        if (this.getHandle().connection == null) {
            return;
        }
        Component[] components = CraftSign.sanitizeLines(lines);
        SignBlockEntity sign = new SignBlockEntity(CraftLocation.toBlockPosition(loc), Blocks.OAK_SIGN.defaultBlockState());
        SignText text = sign.getFrontText();
        text = text.setColor(net.minecraft.world.item.DyeColor.byId(dyeColor.getWoolData()));
        text = text.setHasGlowingText(hasGlowingText);
        for (int i = 0; i < components.length; ++i) {
            text = text.setMessage(i, components[i]);
        }
        sign.setText(text, true);
        this.getHandle().connection.send(new ClientboundBlockEntityDataPacket(sign.getBlockPos(), sign.getType(), sign.getUpdateTag(this.getHandle().registryAccess())));
    }

    public void sendBlockUpdate(@NotNull Location location, @NotNull TileState tileState) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Preconditions.checkArgument((tileState != null ? 1 : 0) != 0, (Object)"TileState can not be null");
        if (this.getHandle().connection == null) {
            return;
        }
        CraftBlockEntityState craftState = (CraftBlockEntityState)tileState;
        this.getHandle().connection.send(craftState.getUpdatePacket(location));
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, org.bukkit.inventory.ItemStack item) {
        this.sendEquipmentChange(entity, Map.of(slot, item));
    }

    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, org.bukkit.inventory.ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        ArrayList<Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>> equipment = new ArrayList<Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>>(items.size());
        for (Map.Entry<EquipmentSlot, org.bukkit.inventory.ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add((Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>)new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().connection.send(new ClientboundSetEquipmentPacket(entity.getEntityId(), equipment));
    }

    public void sendPotionEffectChange(LivingEntity entity, PotionEffect effect) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundUpdateMobEffectPacket(entity.getEntityId(), CraftPotionUtil.fromBukkit(effect), true));
    }

    public void sendPotionEffectChangeRemove(LivingEntity entity, PotionEffectType type) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundRemoveMobEffectPacket(entity.getEntityId(), CraftPotionEffectType.bukkitToMinecraftHolder(type)));
    }

    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    public void setWorldBorder(WorldBorder border) {
        net.minecraft.world.level.border.WorldBorder newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals((Object)this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().removeListener(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().addListener(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        ServerGamePacketListenerImpl connection = this.getHandle().connection;
        connection.send(new ClientboundSetBorderSizePacket(newWorldBorder));
        connection.send(new ClientboundSetBorderLerpSizePacket(newWorldBorder));
        connection.send(new ClientboundSetBorderCenterPacket(newWorldBorder));
        connection.send(new ClientboundSetBorderWarningDelayPacket(newWorldBorder));
        connection.send(new ClientboundSetBorderWarningDistancePacket(newWorldBorder));
    }

    private BorderChangeListener createWorldBorderListener() {
        return new BorderChangeListener(){

            @Override
            public void onSetSize(net.minecraft.world.level.border.WorldBorder border, double size) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderSizePacket(border));
            }

            @Override
            public void onLerpSize(net.minecraft.world.level.border.WorldBorder border, double size, double newSize, long time) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderLerpSizePacket(border));
            }

            @Override
            public void onSetCenter(net.minecraft.world.level.border.WorldBorder border, double x, double z) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderCenterPacket(border));
            }

            @Override
            public void onSetWarningTime(net.minecraft.world.level.border.WorldBorder border, int warningTime) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderWarningDelayPacket(border));
            }

            @Override
            public void onSetWarningBlocks(net.minecraft.world.level.border.WorldBorder border, int warningBlocks) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderWarningDistancePacket(border));
            }

            @Override
            public void onSetDamagePerBlock(net.minecraft.world.level.border.WorldBorder border, double damage) {
            }

            @Override
            public void onSetSafeZone(net.minecraft.world.level.border.WorldBorder border, double blocks) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    public void sendMap(MapView map) {
        if (this.getHandle().connection == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapDecoration(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
        }
        ClientboundMapItemDataPacket packet = new ClientboundMapItemDataPacket(new MapId(map.getId()), map.getScale().getValue(), map.isLocked(), icons, new MapItemSavedData.MapPatch(0, 0, 128, 128, data.buffer));
        this.getHandle().connection.send(packet);
    }

    public void sendHurtAnimation(float yaw) {
        if (this.getHandle().connection == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().connection.send(new ClientboundHurtAnimationPacket(this.getEntityId(), actualYaw));
    }

    public void sendLinks(ServerLinks links) {
        if (this.getHandle().connection == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        net.minecraft.server.ServerLinks nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().connection.send(new ClientboundServerLinksPacket(nms.untrust()));
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.ADD);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.REMOVE);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.SET);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, ClientboundCustomChatCompletionsPacket.Action action) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundCustomChatCompletionsPacket packet = new ClientboundCustomChatCompletionsPacket(action, new ArrayList<String>(completions));
        this.getHandle().connection.send(packet);
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnsupportedOperationException("Cannot set rotation of players. Consider teleporting instead.");
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        location.checkFinite();
        ServerPlayer entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.isRemoved()) {
            return false;
        }
        if (entity.connection == null) {
            return false;
        }
        if (entity.isVehicle()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to, cause);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        entity.stopRiding();
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        ServerLevel fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        ServerLevel toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().containerMenu != this.getHandle().inventoryMenu) {
            this.getHandle().closeContainer();
        }
        if (fromWorld == toWorld) {
            entity.connection.teleport(to);
        } else {
            entity.portalProcess = null;
            this.server.getHandle().respawn(entity, true, Entity.RemovalReason.CHANGED_DIMENSION, null, to);
        }
        return true;
    }

    public void setSneaking(boolean sneak) {
        this.getHandle().setShiftKeyDown(sneak);
    }

    public boolean isSneaking() {
        return this.getHandle().isShiftKeyDown();
    }

    public boolean isSprinting() {
        return this.getHandle().isSprinting();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().setSprinting(sprinting);
    }

    public void loadData() {
        Optional<ValueInput> optional = this.server.getHandle().playerIo.load(this.nameAndId()).map(nbttagcompound -> TagValueInput.create(ProblemReporter.DISCARDING, (HolderLookup.Provider)this.getHandle().registryAccess(), nbttagcompound));
        optional.ifPresent(this.getHandle()::load);
    }

    public void saveData() {
        this.server.getHandle().playerIo.save(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().containerMenu.sendAllDataToRemote();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().updateSleepingPlayerList();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    public Location getRespawnLocation() {
        Optional<ServerPlayer.RespawnPosAngle> spawnLoc;
        ServerPlayer.RespawnConfig respawnConfig = this.getHandle().getRespawnConfig();
        if (respawnConfig == null) {
            return null;
        }
        ServerLevel world = this.getHandle().server.getLevel(respawnConfig.respawnData().dimension());
        BlockPos bed = respawnConfig.respawnData().pos();
        if (world != null && bed != null && (spawnLoc = ServerPlayer.findRespawnAndUseSpawnBlock(world, respawnConfig, true)).isPresent()) {
            ServerPlayer.RespawnPosAngle vec = spawnLoc.get();
            return CraftLocation.toBukkit(vec.position(), (World)world.getWorld(), vec.yaw(), vec.pitch());
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setRespawnLocation(Location location) {
        this.setRespawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        this.setRespawnLocation(location, override);
    }

    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, override, PlayerSpawnChangeEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(new ServerPlayer.RespawnConfig(LevelData.RespawnData.of(((CraftWorld)location.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(location), location.getYaw(), location.getPitch()), false), override, PlayerSpawnChangeEvent.Cause.PLUGIN);
        }
    }

    public Collection<EnderPearl> getEnderPearls() {
        return this.getHandle().getEnderPearls().stream().map(e -> (EnderPearl)e.getBukkitEntity()).collect(Collectors.toList());
    }

    public Input getCurrentInput() {
        return new CraftInput(this.getHandle().getLastClientInput());
    }

    @Override
    public Location getBedLocation() {
        Optional<BlockPos> bed = this.getHandle().getSleepingPos();
        Preconditions.checkState((boolean)bed.isPresent(), (Object)"Not sleeping");
        return CraftLocation.toBukkit(bed.get(), this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().getRecipeBook().contains(CraftRecipe.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().getRecipeBook().known.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key.location())));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, this.getHandle());
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, material, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, material, this.getHandle());
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, material, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, material, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, material, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, entityType, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, entityType, this.getHandle());
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, entityType, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, entityType, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, entityType, newValue, this.getHandle());
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    public int getExpCooldown() {
        return this.getHandle().takeXpDelay;
    }

    public void setExpCooldown(int ticks) {
        this.getHandle().takeXpDelay = CraftEventFactory.callPlayerXpCooldownEvent(this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return this.ban(reason, expires, source, true);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return this.ban(reason, expires != null ? Date.from(expires) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source, boolean kickPlayer) {
        BanEntry banEntry = ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.ban(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Date expires, String source, boolean kickPlayer) {
        Preconditions.checkArgument((this.getAddress() != null ? 1 : 0) != 0, (Object)"The Address of this Player is null");
        BanEntry banEntry = ((IpBanList)this.server.getBanList(BanList.Type.IP)).addBan((Object)this.getAddress().getAddress(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<InetAddress> banIp(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.banIp(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.banIp(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().getWhiteList().isWhiteListed(this.nameAndId());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().getWhiteList().add(new UserWhiteListEntry(this.nameAndId()));
        } else {
            this.server.getHandle().getWhiteList().remove(this.nameAndId());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().setGameMode(GameType.byId(mode.getValue()));
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().gameMode.getGameModeForPlayer().getId());
    }

    public GameMode getPreviousGameMode() {
        GameType previousGameMode = this.getHandle().gameMode.getPreviousGameModeForPlayer();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.getId());
    }

    public void giveExp(int exp) {
        this.getHandle().giveExperiencePoints(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().giveExperienceLevels(levels);
    }

    public float getExp() {
        return this.getHandle().experienceProgress;
    }

    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().experienceProgress = exp;
        this.getHandle().lastSentExp = -1;
    }

    public int getLevel() {
        return this.getHandle().experienceLevel;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().experienceLevel = level;
        this.getHandle().lastSentExp = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().totalExperience;
    }

    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().totalExperience = exp;
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundSetExperiencePacket packet = new ClientboundSetExperiencePacket(progress, this.getTotalExperience(), level);
        this.getHandle().connection.send(packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hidePlayer(Plugin plugin, Player player) {
        this.hideEntity(plugin, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (String)"Plugin (%s) cannot be disabled", (Object)plugin.getName());
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity hidden cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        ChunkMap tracker = this.getHandle().level().getChunkSource().chunkMap;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId());
        if (entry != null) {
            entry.removePlayer(this.getHandle());
        }
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().connection.send(new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.getUUID())));
            }
        }
        this.server.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((Player)this, entity));
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showPlayer(Plugin plugin, Player player) {
        this.showEntity(plugin, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity show cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        ChunkMap.TrackedEntity entry;
        ChunkMap tracker = this.getHandle().level().getChunkSource().chunkMap;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            this.getHandle().connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(otherPlayer)));
        }
        if ((entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId())) != null && !entry.seenBy.contains(this.getHandle().connection)) {
            entry.updatePlayer(this.getHandle());
        }
        this.server.getPluginManager().callEvent((Event)new PlayerShowEntityEvent((Player)this, entity));
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.invertedVisibilityEntities.remove(entity.getUUID());
    }

    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSeePlayer(UUID uuid) {
        Player entity = this.getServer().getPlayer(uuid);
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    @Override
    public ServerPlayer getHandle() {
        return (ServerPlayer)this.entity;
    }

    public void setHandle(ServerPlayer entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public String getLastKnownName() {
        return this.lastKnownName;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(ValueInput valueinput) {
        this.hasPlayedBefore = true;
        valueinput.child("bukkit").ifPresent(data -> {
            this.firstPlayed = data.getLongOr("firstPlayed", this.firstPlayed);
            this.lastPlayed = data.getLongOr("lastPlayed", this.lastPlayed);
            this.lastKnownName = data.getStringOr("lastKnownName", "");
            ServerPlayer handle = this.getHandle();
            handle.newExp = data.getIntOr("newExp", handle.newExp);
            handle.newTotalExp = data.getIntOr("newTotalExp", handle.newTotalExp);
            handle.newLevel = data.getIntOr("newLevel", handle.newLevel);
            handle.expToDrop = data.getIntOr("expToDrop", handle.expToDrop);
            handle.keepLevel = data.getBooleanOr("keepLevel", handle.keepLevel);
        });
    }

    public void setExtraData(ValueOutput valueoutput) {
        ValueOutput data = valueoutput.child("bukkit");
        ServerPlayer handle = this.getHandle();
        data.putInt("newExp", handle.newExp);
        data.putInt("newTotalExp", handle.newTotalExp);
        data.putInt("newLevel", handle.newLevel);
        data.putInt("expToDrop", handle.expToDrop);
        data.putBoolean("keepLevel", handle.keepLevel);
        data.putLong("firstPlayed", this.getFirstPlayed());
        data.putLong("lastPlayed", System.currentTimeMillis());
        data.putString("lastKnownName", handle.getScoreboardName());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            ResourceLocation id = ResourceLocation.parse(StandardMessenger.validateAndCorrectChannel((String)channel));
            this.sendCustomPayload(id, message);
        }
    }

    private void sendCustomPayload(ResourceLocation id, byte[] message) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(new DiscardedPayload(id, Unpooled.wrappedBuffer((byte[])message)));
        this.getHandle().connection.send(packet);
    }

    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    public void setResourcePack(String url) {
        this.setResourcePack(url, null);
    }

    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, null, force);
    }

    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    public void setResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack ID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), true);
    }

    public void addResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    public void removeResourcePack(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack id cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.of(id)));
    }

    public void removeResourcePacks() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    private void handlePushResourcePack(ClientboundResourcePackPushPacket resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().connection == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().connection.send(resourcePackPushPacket);
    }

    public void addChannel(String channel) {
        Preconditions.checkState((this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().connection == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.sendCustomPayload(ResourceLocation.withDefaultNamespace("register"), stream.toByteArray());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        AbstractContainerMenu container = this.getHandle().containerMenu;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.setData(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().getAbilities().flying;
    }

    public void setFlying(boolean value) {
        if (!this.getAllowFlight()) {
            Preconditions.checkArgument((!value ? 1 : 0) != 0, (Object)"Player is not allowed to fly (check #getAllowFlight())");
        }
        this.getHandle().getAbilities().flying = value;
        this.getHandle().onUpdateAbilities();
    }

    public boolean getAllowFlight() {
        return this.getHandle().getAbilities().mayfly;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().getAbilities().flying = false;
        }
        this.getHandle().getAbilities().mayfly = value;
        this.getHandle().onUpdateAbilities();
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.getAbilities().flyingSpeed = value / 2.0f;
        player.onUpdateAbilities();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.getAbilities().walkingSpeed = value / 2.0f;
        player.onUpdateAbilities();
        this.getHandle().getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(player.getAbilities().walkingSpeed);
    }

    public float getFlySpeed() {
        return this.getHandle().getAbilities().flyingSpeed * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().getAbilities().walkingSpeed * 2.0f;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, amount);
        this.getHandle().resetSentInfo();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().resetSentInfo();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Preconditions.checkArgument((scoreboard != null ? 1 : 0) != 0, (Object)"Scoreboard cannot be null");
        Preconditions.checkState((this.getHandle().connection != null ? 1 : 0) != 0, (Object)"Cannot set scoreboard yet (invalid player connection)");
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setHealthScale(double value) {
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"Health value (%s) must be greater than 0", (Object)value);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMap attributemapserver = this.getHandle().getAttributes();
        Collection<AttributeInstance> set = attributemapserver.getSyncableAttributes();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().connection != null) {
            this.getHandle().connection.send(new ClientboundUpdateAttributesPacket(this.getHandle().getId(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().getEntityData().set(net.minecraft.world.entity.LivingEntity.DATA_HEALTH_ID, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().connection.send(new ClientboundSetHealthPacket((float)health, foodLevel, saturation));
    }

    public void sendHealthUpdate() {
        FoodData foodData = this.getHandle().getFoodData();
        this.sendHealthUpdate(this.getScaledHealth(), foodData.getFoodLevel(), foodData.getSaturationLevel());
    }

    public void injectScaledMaxHealth(Collection<AttributeInstance> collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (AttributeInstance genericInstance : collection) {
            if (genericInstance.getAttribute() != Attributes.MAX_HEALTH) continue;
            collection.remove(genericInstance);
            break;
        }
        AttributeInstance dummy = new AttributeInstance(Attributes.MAX_HEALTH, attribute -> {});
        dummy.setBaseValue(this.scaledHealth ? this.healthScale : this.getMaxHealth());
        collection.add(dummy);
    }

    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().getCamera();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().setCamera(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().connection.send(times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromString(title)[0]);
            this.getHandle().connection.send(packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().connection.send(packetSubtitle);
        }
    }

    public void resetTitle() {
        ClientboundClearTitlesPacket packetReset = new ClientboundClearTitlesPacket(true);
        this.getHandle().connection.send(packetReset);
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        ClientboundLevelParticlesPacket packetplayoutworldparticles = new ClientboundLevelParticlesPacket(CraftParticle.createParticleParam(particle, data), force, false, (float)x, (float)y, (float)z, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().connection.send(packetplayoutworldparticles);
    }

    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        PlayerAdvancements data = this.getHandle().getAdvancements();
        AdvancementProgress progress = data.getOrStartProgress(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().requestedViewDistance() == 0 ? Bukkit.getViewDistance() : this.getHandle().requestedViewDistance();
    }

    public int getPing() {
        return this.getHandle().connection.latency();
    }

    public String getLocale() {
        return this.getHandle().language;
    }

    public void updateCommands() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().server.getCommands().sendCommands(this.getHandle());
    }

    public void openBook(org.bukkit.inventory.ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"ItemStack Material (%s) must be Material.WRITTEN_BOOK", (Object)book.getType());
        org.bukkit.inventory.ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().openItemGui(CraftItemStack.asNMSCopy(book), InteractionHand.MAIN_HAND);
        this.getInventory().setItemInMainHand(hand);
    }

    public void openSign(Sign sign) {
        this.openSign(sign, Side.FRONT);
    }

    public void openSign(@NotNull Sign sign, @NotNull Side side) {
        CraftSign.openSign(sign, this, side);
    }

    public void showDemoScreen() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.DEMO_EVENT, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().allowsListing();
    }

    public void clearDialog() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(ClientboundClearDialogPacket.INSTANCE);
    }

    public void showDialog(NamespacedKey dialog) {
        Preconditions.checkArgument((dialog != null ? 1 : 0) != 0, (Object)"Dialog cannot be null");
        ResourceKey<Dialog> key = ResourceKey.create(Registries.DIALOG, CraftNamespacedKey.toMinecraft(dialog));
        Optional nms = this.getHandle().registryAccess().lookupOrThrow(Registries.DIALOG).get(key);
        this.showDialog((Holder)nms.orElseThrow(() -> new IllegalArgumentException("Dialog does not exist on server: " + String.valueOf(dialog))));
    }

    private void showDialog(Holder<Dialog> dialog) {
        if (this.getHandle().connection == null) {
            return;
        }
        if (dialog == null) {
            return;
        }
        this.getHandle().openDialog(dialog);
    }

    public record CookieFuture(ResourceLocation key, CompletableFuture<byte[]> future) {
    }

    public static interface TransferCookieConnection {
        public boolean isTransferred();

        public ConnectionProtocol getProtocol();

        public void sendPacket(Packet<?> var1);

        public void kickPlayer(Component var1);
    }

    private record ChunkSectionChanges(ShortSet positions, List<BlockState> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<BlockState>());
        }
    }
}

