/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.generator.structure;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructurePiece;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.BoundingBox;

public class CraftGeneratedStructure
implements GeneratedStructure {
    private final StructureStart handle;
    private List<org.bukkit.generator.structure.StructurePiece> pieces;

    public CraftGeneratedStructure(StructureStart handle) {
        this.handle = handle;
    }

    public BoundingBox getBoundingBox() {
        net.minecraft.world.level.levelgen.structure.BoundingBox bb = this.handle.getBoundingBox();
        return new BoundingBox((double)bb.minX(), (double)bb.minY(), (double)bb.minZ(), (double)bb.maxX(), (double)bb.maxY(), (double)bb.maxZ());
    }

    public Structure getStructure() {
        return CraftStructure.minecraftToBukkit(this.handle.getStructure());
    }

    public Collection<org.bukkit.generator.structure.StructurePiece> getPieces() {
        if (this.pieces == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (StructurePiece piece : this.handle.getPieces()) {
                builder.add((Object)new CraftStructurePiece(piece));
            }
            this.pieces = builder.build();
        }
        return this.pieces;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.handle.persistentDataContainer;
    }
}

