/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.level.ItemLike;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;

public interface CraftRecipe
extends org.bukkit.inventory.Recipe {
    public void addToCraftingManager();

    default public Optional<Ingredient> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public Ingredient toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        Ingredient stack;
        if (bukkit == null) {
            stack = Ingredient.of(new ItemLike[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = Ingredient.of(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = Ingredient.ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.isEmpty() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    default public TransmuteResult toNMS(ItemStack stack) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(stack);
        return new TransmuteResult(nms.getItemHolder(), nms.getCount(), nms.getComponentsPatch());
    }

    public static RecipeChoice toBukkit(Optional<Ingredient> list) {
        return list.map(CraftRecipe::toBukkit).orElse(null);
    }

    public static RecipeChoice toBukkit(Ingredient list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks().size());
            for (net.minecraft.world.item.ItemStack i2 : list.itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i2));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.items().map(i -> CraftItemType.minecraftToBukkit((Item)i.value())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static ItemStack toBukkit(TransmuteResult transmute) {
        net.minecraft.world.item.ItemStack nms = new net.minecraft.world.item.ItemStack(transmute.item(), transmute.count(), transmute.components());
        return CraftItemStack.asBukkitCopy(nms);
    }

    public static CraftingBookCategory getCategory(org.bukkit.inventory.recipe.CraftingBookCategory bukkit) {
        return CraftingBookCategory.valueOf(bukkit.name());
    }

    public static org.bukkit.inventory.recipe.CraftingBookCategory getCategory(CraftingBookCategory nms) {
        return org.bukkit.inventory.recipe.CraftingBookCategory.valueOf((String)nms.name());
    }

    public static net.minecraft.world.item.crafting.CookingBookCategory getCategory(CookingBookCategory bukkit) {
        return net.minecraft.world.item.crafting.CookingBookCategory.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(net.minecraft.world.item.crafting.CookingBookCategory nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }

    public static ResourceKey<Recipe<?>> toMinecraft(NamespacedKey key) {
        return ResourceKey.create(Registries.RECIPE, CraftNamespacedKey.toMinecraft(key));
    }
}

