/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, ChatFormatting> formatMap;

    public static ChatFormatting getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(ChatFormatting format) {
        return ChatColor.getByChar((char)format.code);
    }

    public static Optional<Component> fromStringOrOptional(String message) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message));
    }

    public static Optional<Component> fromStringOrOptional(String message, boolean keepNewlines) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message, keepNewlines));
    }

    public static Component fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static Component fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static Component fromStringOrEmpty(String message) {
        return CraftChatMessage.fromStringOrEmpty(message, false);
    }

    public static Component fromStringOrEmpty(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static Component[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static Component[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static Component[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(Component component) {
        return ChatSerializer.toJson(component, MinecraftServer.getDefaultRegistryAccess());
    }

    public static String toJSONOrNull(Component component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static Component fromJSON(String jsonMessage) throws JsonParseException {
        return ChatSerializer.fromJson(jsonMessage, MinecraftServer.getDefaultRegistryAccess());
    }

    public static Component fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex) {
            return null;
        }
    }

    public static Component fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static Component fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    public static Component fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, nullable, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static Component fromJSONOrString(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        Component component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromString(trimmedContent, keepNewlines)[0];
            }
            return component;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromComponent(Component component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (Component c : component) {
            Style modi = c.getStyle();
            TextColor color = modi.getColor();
            if (c.getContents() != PlainTextContents.EMPTY || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.serialize().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.isBold()) {
                out.append(ChatFormatting.BOLD);
                hadFormat = true;
            }
            if (modi.isItalic()) {
                out.append(ChatFormatting.ITALIC);
                hadFormat = true;
            }
            if (modi.isUnderlined()) {
                out.append(ChatFormatting.UNDERLINE);
                hadFormat = true;
            }
            if (modi.isStrikethrough()) {
                out.append(ChatFormatting.STRIKETHROUGH);
                hadFormat = true;
            }
            if (modi.isObfuscated()) {
                out.append(ChatFormatting.OBFUSCATED);
                hadFormat = true;
            }
            c.getContents().visit(x -> {
                out.append(x);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static Component fixComponent(MutableComponent component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static Component fixComponent(MutableComponent component, Matcher matcher) {
        PlainTextContents text;
        String msg;
        if (component.getContents() instanceof PlainTextContents && matcher.reset(msg = (text = (PlainTextContents)component.getContents()).text()).find()) {
            matcher.reset();
            Style modifier = component.getStyle();
            ArrayList<Component> extras = new ArrayList<Component>();
            ArrayList<Component> extrasOld = new ArrayList<Component>(component.getSiblings());
            component = Component.empty();
            int pos = 0;
            while (matcher.find()) {
                Object match = matcher.group();
                if (!((String)match).startsWith("http://") && !((String)match).startsWith("https://")) {
                    match = "http://" + (String)match;
                }
                MutableComponent prev = Component.literal(msg.substring(pos, matcher.start()));
                prev.setStyle(modifier);
                extras.add(prev);
                MutableComponent link = Component.literal(matcher.group());
                try {
                    Style linkModi = modifier.withClickEvent(new ClickEvent.OpenUrl(Util.parseAndValidateUntrustedUri((String)match)));
                    link.setStyle(linkModi);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                extras.add(link);
                pos = matcher.end();
            }
            MutableComponent prev = Component.literal(msg.substring(pos));
            prev.setStyle(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (Component c : extras) {
                component.append(c);
            }
        }
        List<Component> extras = component.getSiblings();
        for (int i = 0; i < extras.size(); ++i) {
            Component comp = extras.get(i);
            if (comp.getStyle() == null || comp.getStyle().getClickEvent() != null) continue;
            extras.set(i, CraftChatMessage.fixComponent(comp.copy(), matcher));
        }
        if (component.getContents() instanceof TranslatableContents) {
            Object[] subs = ((TranslatableContents)component.getContents()).getArgs();
            for (int i = 0; i < subs.length; ++i) {
                Object comp = subs[i];
                if (comp instanceof Component) {
                    Component c = (Component)comp;
                    if (c.getStyle() == null || c.getStyle().getClickEvent() != null) continue;
                    subs[i] = CraftChatMessage.fixComponent(c.copy(), matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i] = CraftChatMessage.fixComponent(Component.literal((String)comp), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ChatFormatting format : ChatFormatting.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final Style RESET = Style.EMPTY.withBold(false).withItalic(false).withUnderlined(false).withStrikethrough(false).withObfuscated(false);
        private final List<Component> list = new ArrayList<Component>();
        private MutableComponent currentChatComponent = Component.empty();
        private Style modifier = Style.EMPTY;
        private final Component[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new Component[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ROOT).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.withColor((TextColor)TextColor.parseColor(this.hex.toString()).result().get());
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.isFormat() || format == ChatFormatting.RESET) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$EnumChatFormat[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.withBold(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.withItalic(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.withStrikethrough(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.withUnderlined(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.withObfuscated(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.withColor(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        try {
                            this.modifier = this.modifier.withClickEvent(new ClickEvent.OpenUrl(Util.parseAndValidateUntrustedUri((String)match)));
                        }
                        catch (URISyntaxException var11_11) {
                            // empty catch block
                        }
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.withClickEvent(null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new Component[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            MutableComponent addition = Component.literal(this.message.substring(this.currentIndex, index)).setStyle(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = Component.empty();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.append(addition);
        }

        private Component[] getOutput() {
            return this.output;
        }
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        private static MutableComponent deserialize(JsonElement jsonelement, HolderLookup.Provider holderlookup_a) {
            return (MutableComponent)ComponentSerialization.CODEC.parse(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)jsonelement).getOrThrow(JsonParseException::new);
        }

        private static JsonElement serialize(Component ichatbasecomponent, HolderLookup.Provider holderlookup_a) {
            return (JsonElement)ComponentSerialization.CODEC.encodeStart(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)ichatbasecomponent).getOrThrow(JsonParseException::new);
        }

        public static String toJson(Component ichatbasecomponent, HolderLookup.Provider holderlookup_a) {
            return GSON.toJson(ChatSerializer.serialize(ichatbasecomponent, holderlookup_a));
        }

        @Nullable
        public static MutableComponent fromJson(String s, HolderLookup.Provider holderlookup_a) {
            JsonElement jsonelement = JsonParser.parseString((String)s);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }
    }
}

