/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.server.MinecraftServer;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Fluid;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.ServerLinks;
import org.bukkit.ServerTickManager;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerTickManager;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.ban.CraftIpBanList;
import org.bukkit.craftbukkit.v1_21_R6.ban.CraftProfileBanList;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R6.boss.CraftKeyedBossbar;
import org.bukkit.craftbukkit.v1_21_R6.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R6.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_21_R6.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityFactory;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R6.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_21_R6.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemCraftResult;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.RecipeIterator;
import org.bukkit.craftbukkit.v1_21_R6.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapColorCache;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.v1_21_R6.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.v1_21_R6.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.v1_21_R6.packs.CraftDataPackManager;
import org.bukkit.craftbukkit.v1_21_R6.packs.CraftResourcePack;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerSkinPatch;
import org.bukkit.craftbukkit.v1_21_R6.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.structure.CraftStructureManager;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftDamageTag;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftFluidTag;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftItemTag;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftIconCache;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R6.util.DatFileFilter;
import org.bukkit.craftbukkit.v1_21_R6.util.Versioning;
import org.bukkit.craftbukkit.v1_21_R6.util.permissions.CraftDefaultPermissions;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemCraftResult;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.packs.ResourcePack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jline.terminal.Terminal;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public final class CraftServer
implements Server {
    private final String serverName = "CraftBukkit";
    private final String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftCommandMap commandMap = new CraftCommandMap(this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final SimplePluginManager pluginManager = new SimplePluginManager((Server)this, (SimpleCommandMap)this.commandMap);
    private final StructureManager structureManager;
    protected final aro console;
    protected final arn playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    private final Map<Class<?>, Registry<?>> registries = new HashMap();
    private YamlConfiguration configuration;
    private YamlConfiguration commandsConfiguration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
    private final Map<UUID, OfflinePlayer> offlinePlayers = new MapMaker().weakValues().makeMap();
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public ApiVersion minimumAPI;
    public CraftScoreboardManager scoreboardManager;
    public CraftDataPackManager dataPackManager;
    private CraftServerTickManager serverTickManager;
    private CraftServerLinks serverLinks;
    private final CraftEntityFactory entityFactory;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandBlockCommands = false;
    public boolean ignoreVanillaPermissions = false;
    private final List<CraftPlayer> playerView;
    public int reloadCount;
    public Set<String> activeCompatibilities = Collections.emptySet();

    public CraftServer(aro console, bbd playerList) {
        this.console = console;
        this.playerList = (arn)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform(playerList.k, (Function)new Function<awy, CraftPlayer>(this){

            public CraftPlayer apply(awy player) {
                return player.getBukkitEntity();
            }
        }));
        this.serverVersion = CraftServer.class.getPackage().getImplementationVersion();
        this.structureManager = new CraftStructureManager(console.be(), console.bg());
        this.dataPackManager = new CraftDataPackManager(this.getServer().aI());
        this.serverTickManager = new CraftServerTickManager(console.aV());
        this.serverLinks = new CraftServerLinks(console);
        this.entityFactory = new CraftEntityFactory(console.bg());
        Bukkit.setServer((Server)this);
        CraftRegistry.setMinecraftRegistry(console.bg());
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        ConfigurationSection legacyAlias = null;
        if (!this.configuration.isString("aliases")) {
            legacyAlias = this.configuration.getConfigurationSection("aliases");
            this.configuration.set("aliases", (Object)"now-in-commands.yml");
        }
        this.saveConfig();
        if (this.getCommandsConfigFile().isFile()) {
            legacyAlias = null;
        }
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.commandsConfiguration.options().copyDefaults(true);
        this.commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
        this.saveCommandsConfig();
        if (legacyAlias != null) {
            ConfigurationSection aliases = this.commandsConfiguration.createSection("aliases");
            for (String key : legacyAlias.getKeys(false)) {
                ArrayList<CallSite> commands = new ArrayList<CallSite>();
                if (legacyAlias.isList(key)) {
                    for (String command : legacyAlias.getStringList(key)) {
                        commands.add((CallSite)((Object)(command + " $1-")));
                    }
                } else {
                    commands.add((CallSite)((Object)(legacyAlias.getString(key) + " $1-")));
                }
                aliases.set(key, commands);
            }
        }
        this.saveCommandsConfig();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        this.pluginManager.useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.overrideSpawnLimits();
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        axe.pluginTimeout = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = ApiVersion.getOrCreateVersion(this.configuration.getString("settings.minimum-api"));
        this.loadIcon();
        this.loadCompatibilities();
        CraftMagicNumbers.INSTANCE.getCommodore().updateReroute(this.activeCompatibilities::contains);
        if (this.configuration.getBoolean("settings.use-map-color-cache")) {
            MapPalette.setMapColorCache((MapPalette.MapColorCache)new CraftMapColorCache(this.logger));
        }
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandBlockCommands || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)this.console.options.valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)this.console.options.valueOf("commands-settings");
    }

    private void overrideSpawnLimits() {
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.spawnCategoryLimit.put((Object)spawnCategory, this.configuration.getInt(CraftSpawnCategory.getConfigNameSpawnLimit(spawnCategory)));
        }
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex2) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + String.valueOf(this.getConfigFile()), ex2);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex2) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + String.valueOf(this.getCommandsConfigFile()), ex2);
        }
    }

    private void loadCompatibilities() {
        ConfigurationSection compatibilities = this.configuration.getConfigurationSection("settings.compatibility");
        if (compatibilities == null) {
            this.activeCompatibilities = Collections.emptySet();
            return;
        }
        this.activeCompatibilities = compatibilities.getKeys(false).stream().filter(arg_0 -> ((ConfigurationSection)compatibilities).getBoolean(arg_0)).collect(Collectors.toSet());
        if (!this.activeCompatibilities.isEmpty()) {
            this.logger.info("Using following compatibilities: `" + Joiner.on((String)"`, `").join(this.activeCompatibilities) + "`, this will affect performance and other plugins behavior.");
            this.logger.info("Only use when necessary and prefer updating plugins if possible.");
        }
        if (this.activeCompatibilities.contains("enum-compatibility-mode")) {
            this.getLogger().warning("Loading plugins in enum compatibility mode. This will affect plugin performance. Use only as a transition period or when absolutely necessary.");
        } else if (System.getProperty("RemoveEnumBanner") == null) {
            this.getLogger().info("*** This version of Spigot contains changes to some enums. If you notice that plugins no longer work after updating, please report this to the developers of those plugins first. ***");
            this.getLogger().info("*** If you cannot update those plugins, you can try setting `settings.compatibility.enum-compatibility-mode` to `true` in `bukkit.yml`. ***");
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = (File)this.console.options.valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex2) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex2.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex2);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands();
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            this.loadCustomPermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands() {
        ek dispatcher = this.console.vanillaCommandDispatcher;
        for (CommandNode cmd2 : dispatcher.a().getRoot().getChildren()) {
            this.commandMap.register("minecraft", (Command)new VanillaCommandWrapper(dispatcher, cmd2));
        }
    }

    public void syncCommands() {
        ek dispatcher = this.console.aA.b().d = new ek();
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof VanillaCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((VanillaCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.a().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(this, entry.getValue()).register(dispatcher.a(), label);
        }
        for (awy player : this.getHandle().k) {
            dispatcher.a(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm, false);
                }
                catch (IllegalArgumentException ex2) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex2);
                }
            }
            this.pluginManager.dirtyPermissibles();
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex3) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex3.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex3);
        }
    }

    public String getName() {
        return "CraftBukkit";
    }

    public String getVersion() {
        return this.serverVersion + " (MC: " + this.console.R() + ")";
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public List<CraftPlayer> getOnlinePlayers() {
        return this.playerView;
    }

    @Deprecated
    public Player getPlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Player found = this.getPlayerExact(name);
        if (found != null) {
            return found;
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        int delta = Integer.MAX_VALUE;
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ROOT).startsWith(lowerName)) continue;
            int curDelta = Math.abs(player.getName().length() - lowerName.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    @Deprecated
    public Player getPlayerExact(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        awy player = this.playerList.a(name);
        return player != null ? player.getBukkitEntity() : null;
    }

    public Player getPlayer(UUID id2) {
        Preconditions.checkArgument((id2 != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        awy player = this.playerList.b(id2);
        if (player != null) {
            return player.getBukkitEntity();
        }
        return null;
    }

    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    @Deprecated
    public List<Player> matchPlayer(String partialName) {
        Preconditions.checkArgument((partialName != null ? 1 : 0) != 0, (Object)"partialName cannot be null");
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ROOT).contains(partialName.toLowerCase(Locale.ROOT))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public int getMaxPlayers() {
        return this.playerList.n();
    }

    public void setMaxPlayers(int maxPlayers) {
        Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers must be >= 0");
        this.console.g(maxPlayers);
    }

    public int getPort() {
        return this.getServer().W();
    }

    public int getViewDistance() {
        return this.console.bB();
    }

    public int getSimulationDistance() {
        return this.console.bC();
    }

    public String getIp() {
        return this.getServer().A();
    }

    public String getWorldType() {
        return this.getProperties().ak.getProperty("level-type");
    }

    public boolean getGenerateStructures() {
        return this.getServer().bf().x().d();
    }

    public int getMaxWorldSize() {
        return this.getProperties().R;
    }

    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    public boolean getAllowNether() {
        return this.configuration.getBoolean("settings.allow-nether");
    }

    public boolean isLoggingIPs() {
        return this.getServer().br();
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    public List<String> getInitialEnabledPacks() {
        return Collections.unmodifiableList(this.getProperties().ab.a());
    }

    public List<String> getInitialDisabledPacks() {
        return Collections.unmodifiableList(this.getProperties().ab.b());
    }

    public DataPackManager getDataPackManager() {
        return this.dataPackManager;
    }

    public ServerTickManager getServerTickManager() {
        return this.serverTickManager;
    }

    public Map<String, String> getCodeOfConducts() {
        return this.getServer().ad();
    }

    public ResourcePack getServerResourcePack() {
        return this.getServer().ae().map(CraftResourcePack::new).orElse(null);
    }

    public String getResourcePack() {
        return this.getServer().ae().map(MinecraftServer.b::b).orElse("");
    }

    public String getResourcePackHash() {
        return this.getServer().ae().map(MinecraftServer.b::c).orElse("").toUpperCase(Locale.ROOT);
    }

    public String getResourcePackPrompt() {
        return this.getServer().ae().map(MinecraftServer.b::e).map(CraftChatMessage::fromComponent).orElse("");
    }

    public boolean isResourcePackRequired() {
        return this.getServer().af();
    }

    public boolean hasWhitelist() {
        return this.getProperties().ae.get();
    }

    private arp getProperties() {
        return this.console.a();
    }

    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    public File getUpdateFolderFile() {
        return new File((File)this.console.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    public long getConnectionThrottle() {
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    public int getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.configuration.getInt(CraftSpawnCategory.getConfigNameTicksPerSpawn(spawnCategory));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public arn getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, amn serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)sender).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.a);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.a);
            return conversable2;
        }
        catch (Exception ex2) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.a + "\"", ex2);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((commandLine != null ? 1 : 0) != 0, (Object)"commandLine cannot be null");
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (sender instanceof Player) {
            sender.sendMessage("Unknown command. Type \"/help\" for help.");
        } else {
            sender.sendMessage("Unknown command. Type \"help\" for help.");
        }
        return false;
    }

    public void reload() {
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration((File)this.getCommandsConfigFile());
        this.console.t = new arq(this.console.options);
        arp config = this.console.t.a();
        this.overrideSpawnLimits();
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        axe.pluginTimeout = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = ApiVersion.getOrCreateVersion(this.configuration.getString("settings.minimum-api"));
        this.printSaveWarning = false;
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.loadIcon();
        this.loadCompatibilities();
        CraftMagicNumbers.INSTANCE.getCommodore().updateReroute(this.activeCompatibilities::contains);
        try {
            this.playerList.g().g();
        }
        catch (IOException ex2) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + ex2.getMessage());
        }
        try {
            this.playerList.f().g();
        }
        catch (IOException ex3) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + ex3.getMessage());
        }
        for (awx world : this.console.Q()) {
            world.J.a(config.m.get());
            for (SpawnCategory spawnCategory : SpawnCategory.values()) {
                if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
                long ticksPerCategorySpawn = this.getTicksPerSpawns(spawnCategory);
                if (ticksPerCategorySpawn < 0L) {
                    world.ticksPerSpawnCategory.put((Object)spawnCategory, CraftSpawnCategory.getDefaultTicksPerSpawn(spawnCategory));
                    continue;
                }
                world.ticksPerSpawnCategory.put((Object)spawnCategory, ticksPerCategorySpawn);
            }
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.reloadData();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException world) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }

    public void reloadData() {
        apu.reload(this.console);
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex2) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex2) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex3) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + String.valueOf(file) + " is not valid YAML: " + ex3.toString());
            return;
        }
        catch (Throwable ex4) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + String.valueOf(file) + " is not valid YAML.", ex4);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + String.valueOf(file) + " is empty, ignoring it");
            return;
        }
        List permsList = Permission.loadPermissions((Map)perms, (String)("Permission node '%s' in " + String.valueOf(file) + " is invalid"), (PermissionDefault)Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex5) {
                this.getLogger().log(Level.SEVERE, "Permission in " + String.valueOf(file) + " was already defined", ex5);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=CraftBukkit,serverVersion=" + this.serverVersion + ",minecraftVersion=" + this.console.R() + "}";
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name((String)name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    public World createWorld(WorldCreator creator) {
        String levelName;
        fil worlddata;
        Dynamic<?> dynamic;
        fih.c worldSession;
        Preconditions.checkState((boolean)this.console.Q().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        Preconditions.checkArgument((creator != null ? 1 : 0) != 0, (Object)"WorldCreator cannot be null");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        if (world != null) {
            return world;
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = this.getBiomeProvider(name);
        }
        ami<eno> actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> eno.b;
            case World.Environment.NETHER -> eno.c;
            case World.Environment.THE_END -> eno.d;
            default -> throw new IllegalArgumentException("Illegal dimension (" + String.valueOf(creator.environment()) + ")");
        };
        try {
            worldSession = fih.b(this.getWorldContainer().toPath()).validateAndCreateAccess(name, actualDimension);
        }
        catch (fnw | IOException ex2) {
            throw new RuntimeException(ex2);
        }
        if (worldSession.m()) {
            fii worldinfo;
            try {
                dynamic = worldSession.h();
                worldinfo = worldSession.a(dynamic);
            }
            catch (IOException | va | vh ioexception) {
                fih.b convertable_b = worldSession.e();
                MinecraftServer.m.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                MinecraftServer.m.info("Attempting to use fallback");
                try {
                    dynamic = worldSession.i();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | va | vh ioexception1) {
                    MinecraftServer.m.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                    MinecraftServer.m.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                    return null;
                }
                worldSession.n();
            }
            if (worldinfo.d()) {
                MinecraftServer.m.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return null;
            }
            if (!worldinfo.r()) {
                MinecraftServer.m.info("This world was created by an incompatible version.");
                return null;
            }
        } else {
            dynamic = null;
        }
        boolean hardcore = creator.hardcore();
        anh.a worldloader_a = this.console.worldLoader;
        jy.b iregistrycustom_dimension = worldloader_a.d();
        jx<eno> iregistry = iregistrycustom_dimension.f(mp.by);
        if (dynamic != null) {
            fie leveldataanddimensions = fih.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
            worlddata = (fil)leveldataanddimensions.a();
            iregistrycustom_dimension = leveldataanddimensions.b().b();
        } else {
            eqn worldoptions = new eqn(creator.seed(), creator.generateStructures(), false);
            arp.a properties = new arp.a(bew.a(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings()), creator.type().name().toLowerCase(Locale.ROOT));
            dru worldsettings = new dru(name, drn.a(this.getDefaultGameMode().getValue()), hardcore, cbn.b, false, new drm(worldloader_a.b().b()), worldloader_a.b());
            eqk worlddimensions = properties.a(worldloader_a.c());
            eqk.b worlddimensions_b = worlddimensions.a(iregistry);
            Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
            worlddata = new fil(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            iregistrycustom_dimension = worlddimensions_b.b();
        }
        iregistry = iregistrycustom_dimension.f(mp.by);
        worlddata.customDimensions = iregistry;
        worlddata.checkName(name);
        worlddata.a(this.console.getServerModName(), this.console.U().a());
        if (this.console.options.has("forceUpgrade")) {
            net.minecraft.server.Main.a(worldSession, worlddata, bgy.a(), this.console.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.console.options.has("recreateRegionFiles"));
        }
        long j2 = dsv.a(creator.seed());
        ImmutableList list = ImmutableList.of((Object)new eqb(), (Object)new eqa(), (Object)new cyt(), (Object)new cqa(), (Object)new cze(worlddata));
        eno worlddimension = iregistry.c(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo(worlddata, worldSession, creator.environment(), worlddimension.a().a());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider((WorldInfo)worldInfo);
        }
        ami<drq> worldKey = name.equals((levelName = this.getServer().a().o) + "_nether") ? drq.i : (name.equals(levelName + "_the_end") ? drq.j : ami.a(mp.bx, amj.b(name.toLowerCase(Locale.ROOT))));
        awx internal = new awx(this.console, this.console.ay, worldSession, worlddata, worldKey, worlddimension, worlddata.z(), j2, (List<drc>)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, this.console.O().R(), creator.environment(), generator, biomeProvider);
        if (!this.worlds.containsKey(name.toLowerCase(Locale.ROOT))) {
            return null;
        }
        this.console.initWorld(internal, worlddata, worlddata, worlddata.x());
        internal.b(true);
        this.console.addLevel(internal);
        this.getServer().prepareLevels(internal);
        internal.M.b();
        this.pluginManager.callEvent((Event)new WorldLoadEvent((World)internal.getWorld()));
        return internal.getWorld();
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        awx handle = ((CraftWorld)world).getHandle();
        if (this.console.a(handle.al()) == null) {
            return false;
        }
        if (handle.al() == drq.h) {
            return false;
        }
        if (handle.C().size() > 0) {
            return false;
        }
        WorldUnloadEvent e2 = new WorldUnloadEvent((World)handle.getWorld());
        this.pluginManager.callEvent((Event)e2);
        if (e2.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.a(null, true, true);
            }
            handle.n().close(save);
            handle.M.close(save);
            handle.convertable.close();
        }
        catch (Exception ex2) {
            this.getLogger().log(Level.SEVERE, null, ex2);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ROOT));
        this.console.removeLevel(handle);
        return true;
    }

    public aro getServer() {
        return this.console;
    }

    public World getWorld(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        return this.worlds.get(name.toLowerCase(Locale.ROOT));
    }

    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            System.out.println("World " + world.getName() + " is a duplicate of another world and has been prevented from loading. Please delete the uid.dat file from " + world.getName() + "'s world directory if you want to be able to load the duplicate world.");
            return;
        }
        this.worlds.put(world.getName().toLowerCase(Locale.ROOT), world);
    }

    public WorldBorder createWorldBorder() {
        return new CraftWorldBorder(new elf());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Terminal getTerminal() {
        return this.console.terminal;
    }

    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    public void savePlayers() {
        this.checkSaveState();
        this.playerList.h();
    }

    public boolean addRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)recipe);
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)recipe);
        } else if (recipe instanceof TransmuteRecipe) {
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    public List<Recipe> getRecipesFor(ItemStack result) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"NamespacedKey recipeKey cannot be null");
        return this.getServer().aN().b(CraftRecipe.toMinecraft(recipeKey)).map(dmn::toBukkitRecipe).orElse(null);
    }

    private ddy createInventoryCrafting() {
        ddg container = new ddg(this, null, -1){

            @Override
            public InventoryView getBukkitView() {
                return null;
            }

            @Override
            public boolean b(czl entityhuman) {
                return false;
            }

            @Override
            public dhp b(czl entityhuman, int i2) {
                return dhp.l;
            }
        };
        dfl inventoryCrafting = new dfl(container, 3, 3);
        return inventoryCrafting;
    }

    public Recipe getCraftingRecipe(ItemStack[] craftingMatrix, World world) {
        return this.getNMSRecipe(craftingMatrix, this.createInventoryCrafting(), (CraftWorld)world).map(dmn::toBukkitRecipe).orElse(null);
    }

    public ItemStack craftItem(ItemStack[] craftingMatrix, World world, Player player) {
        return this.craftItemResult(craftingMatrix, world, player).getResult();
    }

    public ItemCraftResult craftItemResult(ItemStack[] craftingMatrix, World world, Player player) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ddz container = new ddz(-1, craftPlayer.getHandle().gB());
        dfl inventoryCrafting = container.m;
        dez craftResult = container.n;
        Optional<dmn<dlx>> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        dhp itemstack = dhp.l;
        if (recipe.isPresent()) {
            dmn<dlx> recipeCrafting = recipe.get();
            if (craftResult.a(craftPlayer.getHandle(), recipeCrafting)) {
                itemstack = recipeCrafting.b().a(inventoryCrafting.aE_(), craftWorld.getHandle().L_());
            }
        }
        dhp result = CraftEventFactory.callPreCraftEvent(inventoryCrafting, craftResult, itemstack, container.getBukkitView(), recipe);
        return this.createItemCraftResult(recipe, CraftItemStack.asBukkitCopy(result), inventoryCrafting, craftWorld.getHandle());
    }

    public ItemStack craftItem(ItemStack[] craftingMatrix, World world) {
        return this.craftItemResult(craftingMatrix, world).getResult();
    }

    public ItemCraftResult craftItemResult(ItemStack[] craftingMatrix, World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        CraftWorld craftWorld = (CraftWorld)world;
        ddy inventoryCrafting = this.createInventoryCrafting();
        Optional<dmn<dlx>> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        dhp itemStack = dhp.l;
        if (recipe.isPresent()) {
            itemStack = recipe.get().b().a(inventoryCrafting.aE_(), craftWorld.getHandle().L_());
        }
        return this.createItemCraftResult(recipe, CraftItemStack.asBukkitCopy(itemStack), inventoryCrafting, craftWorld.getHandle());
    }

    private CraftItemCraftResult createItemCraftResult(Optional<dmn<dlx>> recipe, ItemStack itemStack, ddy inventoryCrafting, awx worldServer) {
        CraftItemCraftResult craftItemResult = new CraftItemCraftResult(itemStack);
        recipe.map(holder -> ((dlx)holder.b()).a(inventoryCrafting.aE_())).ifPresent(remainingItems -> {
            for (int i2 = 0; i2 < remainingItems.size(); ++i2) {
                dhp itemstack1 = inventoryCrafting.a(i2);
                dhp itemstack2 = (dhp)remainingItems.get(i2);
                if (!itemstack1.f()) {
                    inventoryCrafting.a(i2, 1);
                    itemstack1 = inventoryCrafting.a(i2);
                }
                if (itemstack2.f()) continue;
                if (itemstack1.f()) {
                    inventoryCrafting.a(i2, itemstack2);
                    continue;
                }
                if (dhp.c(itemstack1, itemstack2)) {
                    itemstack2.g(itemstack1.M());
                    inventoryCrafting.a(i2, itemstack2);
                    continue;
                }
                craftItemResult.getOverflowItems().add(CraftItemStack.asBukkitCopy(itemstack2));
            }
        });
        for (int i2 = 0; i2 < inventoryCrafting.getContents().size(); ++i2) {
            craftItemResult.setResultMatrix(i2, CraftItemStack.asBukkitCopy(inventoryCrafting.a(i2)));
        }
        return craftItemResult;
    }

    private Optional<dmn<dlx>> getNMSRecipe(ItemStack[] craftingMatrix, ddy inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i2 = 0; i2 < craftingMatrix.length; ++i2) {
            inventoryCrafting.a(i2, CraftItemStack.asNMSCopy(craftingMatrix[i2]));
        }
        return this.getServer().aN().a(dmt.a, inventoryCrafting.aE_(), world.getHandle());
    }

    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    public void clearRecipes() {
        this.console.aN().clearRecipes();
    }

    public void resetRecipes() {
        this.reloadData();
    }

    public boolean removeRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        return this.getServer().aN().removeRecipe(CraftRecipe.toMinecraft(recipeKey));
    }

    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.commandsConfiguration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                List commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    public int getSpawnRadius() {
        return this.getServer().bG();
    }

    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", (Object)value);
        this.saveConfig();
    }

    public boolean shouldSendChatPreviews() {
        return false;
    }

    public boolean isEnforcingSecureProfiles() {
        return this.getServer().aC();
    }

    public boolean isAcceptingTransfers() {
        return this.getServer().bu();
    }

    public boolean getHideOnlinePlayers() {
        return this.console.as();
    }

    public boolean getOnlineMode() {
        return this.console.ag();
    }

    public boolean getAllowFlight() {
        return this.console.aj();
    }

    public boolean isHardcore() {
        return this.console.w_();
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id2 = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id2);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    public BiomeProvider getBiomeProvider(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        BiomeProvider result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("biome-provider")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id2 = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultBiomeProvider(world, id2);
                    if (result == null) {
                        this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world biome provider");
                    }
                }
                catch (Throwable t2) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t2);
                }
            }
        }
        return result;
    }

    @Deprecated
    public CraftMapView getMap(int id2) {
        fhv worldmap = this.console.a(drq.h).a(new fht(id2));
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    public CraftMapView createMap(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        awx minecraftWorld = ((CraftWorld)world).getHandle();
        ja spawn = minecraftWorld.A().b();
        fht newId = dic.a(minecraftWorld, spawn.u(), spawn.w(), 3, false, false, minecraftWorld.al());
        return minecraftWorld.a((fht)newId).mapView;
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Preconditions.checkArgument((structureType != null ? 1 : 0) != 0, (Object)"StructureType cannot be null");
        Preconditions.checkArgument((structureType.getMapIcon() != null ? 1 : 0) != 0, (String)"Cannot create explorer maps for StructureType %s", (Object)structureType.getName());
        awx worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        ja structurePosition = CraftLocation.toBlockPosition(structureLocation);
        dhp stack = dic.a(worldServer, structurePosition.u(), structurePosition.w(), MapView.Scale.NORMAL.getValue(), true, true);
        dic.a(worldServer, stack);
        dic.b(stack, (drq)worldServer);
        fhv.a(stack, structurePosition, "+", CraftMapCursor.CraftType.bukkitToMinecraftHolder(structureType.getMapIcon()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    public void shutdown() {
        this.console.a(false);
    }

    public int broadcast(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent((Event)broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.getMessage();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Deprecated
    public OfflinePlayer getOfflinePlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Player result = this.getPlayerExact(name);
        if (result == null) {
            bbb profile = null;
            if (this.getOnlineMode()) {
                profile = this.console.av().f().a(name).orElse(null);
            }
            result = profile == null ? this.getOfflinePlayer(bbb.a(name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    public OfflinePlayer getOfflinePlayer(UUID id2) {
        Preconditions.checkArgument((id2 != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        Object result = this.getPlayer(id2);
        if (result == null) {
            result = this.offlinePlayers.get(id2);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new bbb(id2, ""));
                this.offlinePlayers.put(id2, (OfflinePlayer)result);
            }
        } else {
            this.offlinePlayers.remove(id2);
        }
        return result;
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId, String name) {
        return new CraftPlayerProfile(uniqueId, name);
    }

    public PlayerProfile createPlayerProfile(UUID uniqueId) {
        return new CraftPlayerProfile(uniqueId, null);
    }

    public PlayerProfile createPlayerProfile(String name) {
        return new CraftPlayerProfile(null, name);
    }

    public OfflinePlayer getOfflinePlayer(bbb profile) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, profile);
        this.offlinePlayers.put(profile.a(), player);
        return player;
    }

    public Set<String> getIPBans() {
        return this.playerList.g().e().stream().map(bbi::h).collect(Collectors.toSet());
    }

    public void banIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).addBan(address, null, null, null);
    }

    public void unbanIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    public void banIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).addBan(address, null, (Date)null, null);
    }

    public void unbanIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).pardon(address);
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (bbl entry : this.playerList.f().e()) {
            result.add(this.getOfflinePlayer((bbb)entry.h()));
        }
        return result;
    }

    public <T extends BanList<?>> T getBanList(BanList.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"BanList.Type cannot be null");
        return (T)(switch (type) {
            default -> throw new MatchException(null, null);
            case BanList.Type.IP -> (BanList)new CraftIpBanList(this.playerList.g());
            case BanList.Type.PROFILE, BanList.Type.NAME -> (BanList)new CraftProfileBanList(this.playerList.f());
        });
    }

    public void setWhitelist(boolean value) {
        this.console.g(value);
    }

    public boolean isWhitelistEnforced() {
        return this.console.aS();
    }

    public void setWhitelistEnforced(boolean value) {
        this.console.f(value);
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (bbo entry : this.playerList.i().e()) {
            result.add(this.getOfflinePlayer((bbb)entry.h()));
        }
        return result;
    }

    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (bbg entry : this.playerList.k().e()) {
            result.add(this.getOfflinePlayer((bbb)entry.h()));
        }
        return result;
    }

    public void reloadWhitelist() {
        this.playerList.a();
    }

    public GameMode getDefaultGameMode() {
        return GameMode.getByValue((int)this.console.a(drq.h).J.j().a());
    }

    public void setDefaultGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().J.a(drn.a(mode.getValue()));
        }
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    public File getWorldContainer() {
        return this.getServer().g.a(drq.h).getParent().toFile();
    }

    public OfflinePlayer[] getOfflinePlayers() {
        fik storage = this.console.h;
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type);
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)type);
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size);
    }

    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    public Merchant createMerchant(String title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.getDefaultTitle() : title);
    }

    public Merchant createMerchant() {
        return new CraftMerchantCustom("");
    }

    public int getMaxChainedNeighborUpdates() {
        return this.getServer().bp();
    }

    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        return this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
    }

    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.ai) || this.console.hasStopped();
    }

    public String getMotd() {
        return this.console.ak();
    }

    public void setMotd(String motd) {
        this.console.d(motd);
    }

    public ServerLinks getServerLinks() {
        return this.serverLinks;
    }

    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(CommandSender sender, String message, awx world, foh pos, boolean forceCommand) {
        if (!(sender instanceof Player)) {
            return ImmutableList.of();
        }
        Player player = (Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, pos) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)player, message, offers);
        this.getPluginManager().callEvent((Event)tabEvent);
        return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(Player player, String message, awx world, foh pos) {
        List completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete((CommandSender)player, message) : this.getCommandMap().tabComplete((CommandSender)player, message, CraftLocation.toBukkit(pos, (World)world.getWorld()));
        }
        catch (CommandException ex2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex2);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p2 : this.getOnlinePlayers()) {
            if (!player.canSee(p2) || !StringUtil.startsWithIgnoreCase((String)p2.getName(), (String)token)) continue;
            completions.add(p2.getName());
        }
        this.pluginManager.callEvent((Event)event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public CraftEntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public Criteria getScoreboardCriteria(String name) {
        return CraftCriteria.getFromBukkit(name);
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning || this.console.autosavePeriod <= 0) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    public CraftIconCache loadServerIcon(File file) throws Exception {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (String)"File (%s) is not a valid file", (Object)file);
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"BufferedImage image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels wide (%s)", (int)image.getWidth());
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels high (%s)", (int)image.getHeight());
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytebuf);
        return new CraftIconCache(bytebuf.toByteArray());
    }

    public void setIdleTimeout(int threshold) {
        this.console.d(threshold);
    }

    public int getIdleTimeout() {
        return this.console.au();
    }

    public int getPauseWhenEmptyTime() {
        return this.console.by();
    }

    public void setPauseWhenEmptyTime(int seconds) {
        this.console.l(seconds);
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        awx handle = ((CraftWorld)world).getHandle();
        return new OldCraftChunkData(world.getMinHeight(), world.getMaxHeight(), handle.ao());
    }

    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CraftBossBar(title, color, style, flags);
    }

    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        Preconditions.checkArgument((barColor != null ? 1 : 0) != 0, (Object)"BarColor key cannot be null");
        Preconditions.checkArgument((barStyle != null ? 1 : 0) != 0, (Object)"BarStyle key cannot be null");
        anl bossBattleCustom = this.getServer().aR().a(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CraftKeyedBossbar craftKeyedBossbar = new CraftKeyedBossbar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            if (flag == null) continue;
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().aR().b().iterator(), (Function)new Function<anl, KeyedBossBar>(this){

            public KeyedBossBar apply(anl bossBattleCustom) {
                return bossBattleCustom.getBukkitEntity();
            }
        }));
    }

    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        anl bossBattleCustom = this.getServer().aR().a(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : bossBattleCustom.getBukkitEntity();
    }

    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        anm bossBattleCustomData = this.getServer().aR();
        anl bossBattleCustom = bossBattleCustomData.a(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.a(bossBattleCustom);
            return true;
        }
        return false;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        for (awx world : this.getServer().Q()) {
            cdv entity = world.d(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Advancement getAdvancement(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        aj advancement = this.console.aF().a(CraftNamespacedKey.toMinecraft(key));
        return advancement == null ? null : advancement.toBukkit();
    }

    public Iterator<Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.console.aF().b().iterator(), (Function)new Function<aj, Advancement>(this){

            public Advancement apply(aj advancement) {
                return advancement.toBukkit();
            }
        }));
    }

    public BlockData createBlockData(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.createBlockData(material, (String)null);
    }

    public BlockData createBlockData(Material material, Consumer<? super BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept((BlockData)data);
        }
        return data;
    }

    public BlockData createBlockData(String data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data cannot be null");
        return this.createBlockData((Material)null, data);
    }

    public BlockData createBlockData(Material material, String data) {
        Preconditions.checkArgument((material != null || data != null ? 1 : 0) != 0, (Object)"Must provide one of material or data");
        return CraftBlockData.newData(material != null ? material.asBlockType() : null, data);
    }

    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"NamespacedKey tag cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        amj key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                bdj<duv> blockTagKey = bdj.a(mp.i, key);
                if (!mo.e.a(blockTagKey).isPresent()) break;
                return new CraftBlockTag((jx<duv>)mo.e, blockTagKey);
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                bdj<dhl> itemTagKey = bdj.a(mp.O, key);
                if (!mo.h.a(itemTagKey).isPresent()) break;
                return new CraftItemTag((jx<dhl>)mo.h, itemTagKey);
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                bdj<ffz> fluidTagKey = bdj.a(mp.I, key);
                if (!mo.c.a(fluidTagKey).isPresent()) break;
                return new CraftFluidTag((jx<ffz>)mo.c, fluidTagKey);
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                bdj<cee<?>> entityTagKey = bdj.a(mp.E, key);
                if (!mo.g.a(entityTagKey).isPresent()) break;
                return new CraftEntityTag((jx<cee<?>>)mo.g, entityTagKey);
            }
            case "damage_types": {
                Preconditions.checkArgument((clazz == DamageType.class ? 1 : 0) != 0, (String)"Damage type namespace (%s) must have damage type", (Object)clazz.getName());
                bdj<cck> damageTagKey = bdj.a(mp.aU, key);
                jx<cck> damageRegistry = CraftRegistry.getMinecraftRegistry(mp.aU);
                if (!damageRegistry.a(damageTagKey).isPresent()) break;
                return new CraftDamageTag(damageRegistry, damageTagKey);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                jf<duv> blockTags = mo.e;
                return (Iterable)blockTags.l().map(pair -> new CraftBlockTag((jx<duv>)blockTags, pair.h())).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                jf<dhl> itemTags = mo.h;
                return (Iterable)itemTags.l().map(pair -> new CraftItemTag((jx<dhl>)itemTags, pair.h())).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                jf<ffz> fluidTags = mo.c;
                return (Iterable)fluidTags.l().map(pair -> new CraftFluidTag((jx<ffz>)fluidTags, pair.h())).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                jf<cee<?>> entityTags = mo.g;
                return (Iterable)entityTags.l().map(pair -> new CraftEntityTag((jx<cee<?>>)entityTags, pair.h())).collect(ImmutableList.toImmutableList());
            }
            case "damage_types": {
                Preconditions.checkArgument((clazz == DamageType.class ? 1 : 0) != 0, (String)"Damage type namespace (%s) must have damage type", (Object)clazz.getName());
                jx damageTags = CraftRegistry.getMinecraftRegistry(mp.aU);
                return (Iterable)damageTags.l().map(pair -> new CraftDamageTag(damageTags, pair.h())).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    public LootTable getLootTable(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        amt.a registry = this.getServer().bi();
        return registry.a().a(mp.bz).flatMap(lookup -> lookup.a(CraftLootTable.bukkitKeyToMinecraft(key))).map(holder -> new CraftLootTable(key, (fjd)holder.a())).orElse(null);
    }

    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List<? extends cdv> nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender sender cannot be null");
        ex arg2 = ex.b();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg2.parse(reader, true, true).b(VanillaCommandWrapper.getListener(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Spurious trailing data in selector: %s", (Object)selector);
        }
        catch (CommandSyntaxException ex2) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex2);
        }
        return new ArrayList<Entity>(Lists.transform(nms, entity -> entity.getBukkitEntity()));
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    public <T extends Keyed> Registry<T> getRegistry(Class<T> aClass) {
        return this.registries.computeIfAbsent(aClass, key -> CraftRegistry.createRegistry(aClass, this.console.bg()));
    }

    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        ConfigurationSerialization.registerClass(CraftPlayerProfile.class);
        ConfigurationSerialization.registerClass(CraftPlayerSkinPatch.class);
        CraftItemFactory.instance();
    }
}

