/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R6.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R6.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_21_R6.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R6.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R6.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftStructureSearchResult;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final awx world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private static final Random rand = new Random();
    private Map<String, drm.e<?>> gamerules;
    private Map<String, drm.f<?>> gameruleDefinitions;

    public CraftWorld(awx world, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env2) {
        this.world = world;
        this.generator = gen;
        this.biomeProvider = biomeProvider;
        this.environment = env2;
    }

    public Block getBlockAt(int x2, int y2, int z2) {
        return CraftBlock.at(this.world, new ja(x2, y2, z2));
    }

    public Location getSpawnLocation() {
        fid.a respawnData = this.world.A();
        awx spawnWorld = this.world.q().a(respawnData.a());
        return CraftLocation.toBukkit(respawnData.b(), (World)(spawnWorld != null ? spawnWorld.getWorld() : this), respawnData.d(), respawnData.e());
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        World spawnWorld = location.getWorld();
        return this.setSpawnLocation((World)(spawnWorld != null ? spawnWorld : this), location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw(), location.getPitch());
    }

    public boolean setSpawnLocation(int x2, int y2, int z2, float angle) {
        return this.setSpawnLocation(this, x2, y2, z2, angle, 0.0f);
    }

    private boolean setSpawnLocation(World spawnWorld, int x2, int y2, int z2, float yaw, float pitch) {
        try {
            this.world.a(fid.a.a(((CraftWorld)spawnWorld).getHandle().al(), new ja(x2, y2, z2), yaw, pitch));
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x2, int y2, int z2) {
        return this.setSpawnLocation(x2, y2, z2, 0.0f);
    }

    public Chunk getChunkAt(int x2, int z2) {
        elv chunk = (elv)this.world.a(x2, z2, emo.n, true);
        return new CraftChunk(chunk);
    }

    @NotNull
    public Chunk getChunkAt(int x2, int z2, boolean generate) {
        if (generate) {
            return this.getChunkAt(x2, z2);
        }
        return new CraftChunk(this.getHandle(), x2, z2);
    }

    public Chunk getChunkAt(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x2, int z2) {
        return this.world.n().isChunkLoaded(x2, z2);
    }

    public boolean isChunkGenerated(int x2, int z2) {
        try {
            return this.isChunkLoaded(x2, z2) || this.world.n().a.d(new dqv(x2, z2)).get().isPresent();
        }
        catch (InterruptedException | ExecutionException ex2) {
            throw new RuntimeException(ex2);
        }
    }

    public Chunk[] getLoadedChunks() {
        Long2ObjectLinkedOpenHashMap<avy> chunks = this.world.n().a.q;
        return (Chunk[])chunks.values().stream().map(avy::getFullChunkNow).filter(Objects::nonNull).map(CraftChunk::new).toArray(Chunk[]::new);
    }

    public void loadChunk(int x2, int z2) {
        this.loadChunk(x2, z2, true);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x2, int z2) {
        return this.unloadChunk(x2, z2, true);
    }

    public boolean unloadChunk(int x2, int z2, boolean save) {
        return this.unloadChunk0(x2, z2, save);
    }

    public boolean unloadChunkRequest(int x2, int z2) {
        if (this.isChunkLoaded(x2, z2)) {
            this.world.n().c(axe.PLUGIN, new dqv(x2, z2), 1);
        }
        return true;
    }

    private boolean unloadChunk0(int x2, int z2, boolean save) {
        if (!this.isChunkLoaded(x2, z2)) {
            return true;
        }
        elv chunk = this.world.d(x2, z2);
        if (!save) {
            chunk.j();
        }
        this.unloadChunkRequest(x2, z2);
        this.world.n().purgeUnload();
        return !this.isChunkLoaded(x2, z2);
    }

    public boolean regenerateChunk(int x2, int z2) {
        throw new UnsupportedOperationException("Not supported in this Minecraft version! Unless you can fix it, this is not a bug :)");
    }

    public boolean refreshChunk(int x2, int z2) {
        avy playerChunk = (avy)this.world.n().a.q.get(dqv.c(x2, z2));
        if (playerChunk == null) {
            return false;
        }
        playerChunk.a().thenAccept(either -> either.a(chunk -> {
            List<awy> playersInRange = playerChunk.s.a(playerChunk.r(), false);
            if (playersInRange.isEmpty()) {
                return;
            }
            aei refreshPacket = new aei((elv)chunk, this.world.E_(), null, null);
            for (awy player : playersInRange) {
                if (player.g == null) continue;
                player.g.b(refreshPacket);
            }
        }));
        return true;
    }

    public Collection<Player> getPlayersSeeingChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"chunk cannot be null");
        return this.getPlayersSeeingChunk(chunk.getX(), chunk.getZ());
    }

    public Collection<Player> getPlayersSeeingChunk(int x2, int z2) {
        if (!this.isChunkLoaded(x2, z2)) {
            return Collections.emptySet();
        }
        List<awy> players = this.world.n().a.a(new dqv(x2, z2), false);
        if (players.isEmpty()) {
            return Collections.emptySet();
        }
        return players.stream().filter(Objects::nonNull).map(awy::getBukkitEntity).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isChunkInUse(int x2, int z2) {
        return this.isChunkLoaded(x2, z2);
    }

    public boolean loadChunk(int x2, int z2, boolean generate) {
        elk chunk = this.world.n().a(x2, z2, generate ? emo.n : emo.c, true);
        if (chunk instanceof elu) {
            chunk = this.world.n().a(x2, z2, emo.n, true);
        }
        if (chunk instanceof elv) {
            this.world.n().b(axe.PLUGIN, new dqv(x2, z2), 1);
            return true;
        }
        return false;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean addPluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        dsn chunkDistanceManager = this.world.n().i;
        if (chunkDistanceManager.a(dqv.c(x2, z2), axd.of(axe.PLUGIN_TICKET, awb.c, plugin))) {
            this.getChunkAt(x2, z2);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        dsn chunkDistanceManager = this.world.n().i;
        return chunkDistanceManager.b(dqv.c(x2, z2), axd.of(axe.PLUGIN_TICKET, awb.c, plugin));
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        dsn chunkDistanceManager = this.world.n().i;
        chunkDistanceManager.a((ticket, i2) -> ticket.a() == axe.PLUGIN_TICKET && Objects.equals(ticket.key, plugin), null);
    }

    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        dsn chunkDistanceManager = this.world.n().i;
        List<axd> tickets = chunkDistanceManager.a(dqv.c(x2, z2));
        if (tickets == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (axd ticket : tickets) {
            if (ticket.a() != axe.PLUGIN_TICKET) continue;
            ret.add((Object)((Plugin)ticket.key));
        }
        return ret.build();
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        dsn chunkDistanceManager = this.world.n().i;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.f.long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            List tickets = (List)chunkTickets.getValue();
            Chunk chunk = null;
            for (axd ticket : tickets) {
                if (ticket.a() != axe.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(dqv.a(chunkKey), dqv.b(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.key, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox boundingBox) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)boundingBox.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)boundingBox.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)boundingBox.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)boundingBox.getMaxZ()) >> 4;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                chunks.add(this.getChunkAt(x2, z2, false));
            }
        }
        return chunks;
    }

    public boolean isChunkForceLoaded(int x2, int z2) {
        return this.getHandle().B().contains(dqv.c(x2, z2));
    }

    public void setChunkForceLoaded(int x2, int z2, boolean forced) {
        this.getHandle().a(x2, z2, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().B().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(dqv.a(coord), dqv.b(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public awx getHandle() {
        return this.world;
    }

    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    public Item dropItem(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        cvr entity = new cvr(this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.l = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs2 = bfh.a(this.world.z, -0.25, 0.25);
        double ys2 = bfh.a(this.world.z, -0.25, 0.25) - (double)cee.au.m() / 2.0;
        double zs = bfh.a(this.world.z, -0.25, 0.25);
        loc = loc.clone().add(xs2, ys2, zs);
        return this.dropItem(loc, item, function);
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        czv arrow;
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = cee.i.a(this.world, ced.n);
            ((Arrow)arrow.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (czv)cee.bs.a(this.world, ced.n) : (Trident.class.isAssignableFrom(clazz) ? (czv)cee.bE.a(this.world, ced.n) : (czv)cee.i.a(this.world, ced.n));
        }
        arrow.b(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.b(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        cev lightning = cee.aA.a(this.world, ced.n);
        lightning.d(loc.getX(), loc.getY(), loc.getZ());
        lightning.a(isVisual);
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockState blockstate : this.world.capturedBlockStates.values()) {
                ja position = ((CraftBlockState)blockstate).getPosition();
                ejm oldBlock = this.world.a_(position);
                int flag = ((CraftBlockState)blockstate).getFlag();
                delegate.setBlockData(blockstate.getX(), blockstate.getY(), blockstate.getZ(), blockstate.getBlockData());
                ejm newBlock = this.world.a_(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flag, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.J.d();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.al().a());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.ah();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.ah());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.b(this.world.ah() + event.getSkipAmount());
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp2 = (CraftPlayer)p2;
            if (cp2.getHandle().g == null) continue;
            cp2.getHandle().g.b(new agt(cp2.getHandle().A().ag(), cp2.getHandle().getPlayerTime(), cp2.getHandle().A().S().c(drm.m)));
        }
    }

    public long getGameTime() {
        return this.world.A.b();
    }

    public boolean createExplosion(double x2, double y2, double z2, float power) {
        return this.createExplosion(x2, y2, z2, power, false, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire) {
        return this.createExplosion(x2, y2, z2, power, setFire, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x2, y2, z2, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks, Entity source) {
        drq.a explosionType = !breakBlocks ? drq.a.a : (source == null ? drq.a.STANDARD : drq.a.c);
        cdv entity = source == null ? null : ((CraftEntity)source).getHandle();
        return !this.world.explode0((cdv)entity, (cci)drj.a((drq)this.world, (cdv)entity), null, (double)x2, (double)y2, (double)z2, (float)power, (boolean)setFire, (drq.a)explosionType, (mc)me.x, (mc)me.w, drq.a, bce.lw).wasCanceled;
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((spawnReason != null ? 1 : 0) != 0, (Object)"Spawn reason cannot be null");
        return (T)((LivingEntity)this.spawn(location, clazz, function, spawnReason, randomizeData));
    }

    public Block getHighestBlockAt(int x2, int z2) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2), z2);
    }

    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        return this.world.d(x2 >> 4, z2 >> 4).a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public Block getHighestBlockAt(int x2, int z2, HeightMap heightMap) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2, heightMap), z2);
    }

    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public Biome getBiome(int x2, int z2) {
        return this.getBiome(x2, 0, z2);
    }

    public void setBiome(int x2, int z2, Biome bio2) {
        for (int y2 = this.getMinHeight(); y2 < this.getMaxHeight(); ++y2) {
            this.setBiome(x2, y2, z2, bio2);
        }
    }

    @Override
    public void setBiome(int x2, int y2, int z2, jk<dst> bb2) {
        elv chunk;
        ja pos = new ja(x2, 0, z2);
        if (this.world.D(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, bb2);
            chunk.i();
        }
    }

    public double getTemperature(int x2, int z2) {
        return this.getTemperature(x2, 0, z2);
    }

    public double getTemperature(int x2, int y2, int z2) {
        ja pos = new ja(x2, y2, z2);
        return this.world.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2).a().f(pos, this.world.T());
    }

    public double getHumidity(int x2, int z2) {
        return this.getHumidity(x2, 0, z2);
    }

    public double getHumidity(int x2, int y2, int z2) {
        return this.world.getNoiseBiome((int)(x2 >> 2), (int)(y2 >> 2), (int)(z2 >> 2)).a().i.d();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<cdv> getNMSEntities() {
        return this.getHandle().K().a();
    }

    @Override
    public void addEntityToWorld(cdv entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public void addEntityWithPassengers(cdv entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().tryAddFreshEntityWithPassengers(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2) {
        return this.getNearbyEntities(location, x2, y2, z2, null);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x2, (double)y2, (double)z2);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        foc bb2 = new foc(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<cdv> entityList = this.getHandle().a((cdv)null, bb2, (Predicate<? super cdv>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (cdv entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<? super Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.equals(start.getWorld()), (Object)"Location start cannot be in a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir2 = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir2).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.equals(start.getWorld()), (Object)"Location start cannot be in a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir2 = direction.clone().normalize().multiply(maxDistance);
        foh startPos = CraftLocation.toVec3D(start);
        foh endPos = startPos.b(dir2.getX(), dir2.getY(), dir2.getZ());
        fod nmsHitResult = this.getHandle().a(new dqx(startPos, endPos, ignorePassableBlocks ? dqx.a.a : dqx.a.b, CraftFluidCollisionMode.toNMS(fluidCollisionMode), fom.a()));
        return CraftRayTraceResult.fromNMS(this, nmsHitResult);
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.C().size());
        for (czl czl2 : this.world.C()) {
            CraftHumanEntity bukkitEntity = czl2.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)bukkitEntity);
        }
        return list;
    }

    public void save() {
        this.server.checkSaveState();
        boolean oldSave = this.world.e;
        this.world.e = false;
        this.world.a(null, false, false);
        this.world.e = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.e;
    }

    public void setAutoSave(boolean value) {
        this.world.e = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().J.a(cbn.a(difficulty.getValue()));
    }

    public Difficulty getDifficulty() {
        return Difficulty.getByValue((int)this.getHandle().aq().ordinal());
    }

    public int getViewDistance() {
        return this.world.n().a.P;
    }

    public int getSimulationDistance() {
        return this.world.n().a.i().m;
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.A.h();
    }

    public void setStorm(boolean hasStorm) {
        this.world.A.b(hasStorm);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.J.i();
    }

    public void setWeatherDuration(int duration) {
        this.world.J.c(duration);
    }

    public boolean isThundering() {
        return this.world.A.f();
    }

    public void setThundering(boolean thundering) {
        this.world.J.a(thundering);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.J.g();
    }

    public void setThunderDuration(int duration) {
        this.world.J.b(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.J.a(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.J.e();
    }

    public long getSeed() {
        return this.world.H();
    }

    public boolean getPVP() {
        return this.world.S().c(drm.ae);
    }

    public void setPVP(boolean pvp) {
        this.world.S().b(drm.ae).set(pvp, this.world);
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.getData().isAssignableFrom(data.getClass()), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        aej packet = new aej(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().g == null || !location.getWorld().equals((Object)player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().g.b(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        cvq entity = cvq.fall(this.world, ja.a(location.getX(), location.getY(), location.getZ()), CraftBlockType.bukkitToMinecraft(material).m(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        cvq entity = cvq.fall(this.world, ja.a(location.getX(), location.getY(), location.getZ()), ((CraftBlockData)data).getState(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x2, z2, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.n().b(allowMonsters);
    }

    public boolean getAllowAnimals() {
        return true;
    }

    public boolean getAllowMonsters() {
        return this.world.n().k;
    }

    public int getMinHeight() {
        return this.world.M_();
    }

    public int getMaxHeight() {
        return this.world.ar() + 1;
    }

    public int getLogicalHeight() {
        return this.world.H_().p();
    }

    public boolean isNatural() {
        return this.world.H_().j();
    }

    public boolean isBedWorks() {
        return this.world.H_().l();
    }

    public boolean hasSkyLight() {
        return this.world.H_().g();
    }

    public boolean hasCeiling() {
        return this.world.H_().h();
    }

    public boolean isPiglinSafe() {
        return this.world.H_().b();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.H_().m();
    }

    public boolean hasRaids() {
        return this.world.H_().c();
    }

    public boolean isUltraWarm() {
        return this.world.H_().i();
    }

    public int getSeaLevel() {
        return this.world.T();
    }

    public boolean getKeepSpawnInMemory() {
        return false;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public File getWorldFolder() {
        return this.world.convertable.a(fif.l).toFile().getParentFile();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.G() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.J.x().d();
    }

    public boolean isHardcore() {
        return this.world.F_().k();
    }

    public void setHardcore(boolean hardcore) {
        this.world.J.g.c = hardcore;
    }

    @Deprecated
    public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Deprecated
    public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerWaterAmbientSpawns);
    }

    @Deprecated
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Deprecated
    public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.world.ticksPerSpawnCategory.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.world.ticksPerSpawnCategory.getLong((Object)spawnCategory);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimit(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playSound(loc, instrument.getSound(), SoundCategory.RECORDS, 3.0f, note.getPitch());
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(null, x2, y2, z2, CraftSound.bukkitToMinecraft(sound), bcf.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        agx packet = new agx(jk.a(bcd.a(amj.a(sound))), bcf.valueOf(category.name()), x2, y2, z2, volume, pitch, seed);
        this.world.q().am().a(null, x2, y2, z2, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.al(), packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        agw packet = new agw(CraftSound.bukkitToMinecraftHolder(sound), bcf.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        awb.b entityTracker = (awb.b)this.getHandle().n().a.J.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        agw packet = new agw(jk.a(bcd.a(amj.a(sound))), bcf.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        awb.b entityTracker = (awb.b)this.getHandle().n().a.J.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public synchronized Map<String, drm.e<?>> getGameRulesNMS() {
        if (this.gamerules != null) {
            return this.gamerules;
        }
        this.gamerules = CraftWorld.getGameRulesNMS(this.getHandle().S());
        return this.gamerules;
    }

    public static Map<String, drm.e<?>> getGameRulesNMS(drm gameRules) {
        final HashMap gamerules = new HashMap();
        gameRules.a(new drm.c(){

            @Override
            public <T extends drm.g<T>> void a(drm.e<T> gamerules_gamerulekey, drm.f<T> gamerules_gameruledefinition) {
                gamerules.put(gamerules_gamerulekey.a(), gamerules_gamerulekey);
            }
        });
        return gamerules;
    }

    public synchronized Map<String, drm.f<?>> getGameRuleDefinitions() {
        if (this.gameruleDefinitions != null) {
            return this.gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        this.getHandle().S().a(new drm.c(){

            @Override
            public <T extends drm.g<T>> void a(drm.e<T> gamerules_gamerulekey, drm.f<T> gamerules_gameruledefinition) {
                gameruleDefinitions.put(gamerules_gamerulekey.a(), gamerules_gameruledefinition);
            }
        });
        this.gameruleDefinitions = gameruleDefinitions;
        return this.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().S().b(this.getGameRulesNMS().get(rule));
        return value != null ? ((drm.g)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        Object handle = this.getHandle().S().b(this.getGameRulesNMS().get(rule));
        ((drm.g)handle).a(value);
        ((drm.g)handle).onChanged(this.getHandle());
        return true;
    }

    public String[] getGameRules() {
        return this.getGameRulesNMS().keySet().toArray(new String[this.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return this.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (drm.g<?>)this.getHandle().S().b(this.getGameRulesNMS().get(rule.getName())));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (drm.g<?>)this.getGameRuleDefinitions().get(rule.getName()).a());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        Object handle = this.getHandle().S().b(this.getGameRulesNMS().get(rule.getName()));
        ((drm.g)handle).a(newValue.toString());
        ((drm.g)handle).onChanged(this.getHandle());
        return true;
    }

    private <T> T convert(GameRule<T> rule, drm.g<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof drm.a) {
            return rule.getType().cast(((drm.a)value).a());
        }
        if (value instanceof drm.d) {
            return rule.getType().cast(value.c());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + String.valueOf(value) + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.getHandle().sendParticlesSource(null, CraftParticle.createParticleParam(particle, data), force, false, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra);
    }

    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : Registry.STRUCTURE) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        ja originPos = ja.a(origin.getX(), origin.getY(), origin.getZ());
        ArrayList<jk<fan>> holders = new ArrayList<jk<fan>>();
        for (Structure structure : structures) {
            holders.add(jk.a(CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair<ja, jk<fan>> found = this.getHandle().n().g().a(this.getHandle(), jo.a(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((fan)((jk)found.getSecond()).a()), CraftLocation.toBukkit((ja)found.getFirst(), (World)this));
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, Biome ... biomes) {
        return this.locateNearestBiome(origin, radius, 32, 64, biomes);
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, Biome ... biomes) {
        ja originPos = ja.a(origin.getX(), origin.getY(), origin.getZ());
        HashSet<jk<dst>> holders = new HashSet<jk<dst>>();
        for (Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        dtc.f sampler = this.getHandle().n().i().b();
        Pair<ja, jk<dst>> found = this.getHandle().n().g().d().a(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((jk)found.getSecond()), new Location((World)this, (double)((ja)found.getFirst()).u(), (double)((ja)found.getFirst()).v(), (double)((ja)found.getFirst()).w()));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        dbf persistentRaid = this.world.E();
        dbd raid = persistentRaid.a(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid, this.world);
    }

    public List<Raid> getRaids() {
        dbf persistentRaid = this.world.E();
        return persistentRaid.e.values().stream().map(raid -> new CraftRaid((dbd)raid, this.world)).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().I() == null ? null : new CraftDragonBattle(this.getHandle().I());
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2) {
        return this.getStructures(x2, z2, (fan struct) -> true);
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2, Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        jx registry = CraftRegistry.getMinecraftRegistry(mp.bm);
        amj key = registry.b(CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x2, z2, (fan struct) -> registry.b(struct).equals(key));
    }

    private List<GeneratedStructure> getStructures(int x2, int z2, Predicate<fan> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (fav start : this.getHandle().b().a(new dqv(x2, z2), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().O()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public void storeBukkitValues(up c2) {
        if (!this.persistentDataContainer.isEmpty()) {
            c2.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(vp c2) {
        if (c2 instanceof up) {
            this.persistentDataContainer.putAll((up)c2);
        }
    }
}

