/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<eib>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, eib tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        dsk spawnData = ((eib)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<cee<?>> type = spawnData.a().a("id", cee.a);
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((eib)this.getSnapshot()).c().l = caa.a();
            ((eib)this.getSnapshot()).c().m = new dsk();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        bfq rand = this.isPlaced() ? this.getWorldHandle().I_() : bfq.a();
        ((eib)this.getSnapshot()).a(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        dsk spawnData = ((eib)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((eib)this.getSnapshot()).c(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((eib)this.getSnapshot()).c(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(dqq spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.l = caa.a();
        if (snapshot == null) {
            spawner.m = new dsk();
            return;
        }
        up compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.m = new dsk(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((eib)this.getSnapshot()).c(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(dqq spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        up compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        caa.a<dsk> builder = caa.b();
        spawner.l.d().forEach(entry -> builder.a((dsk)entry.a(), entry.b()));
        builder.a(new dsk(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.l = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((eib)this.getSnapshot()).c(), entries);
    }

    public static void setPotentialSpawns(dqq spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        caa.a<dsk> builder = caa.b();
        for (SpawnerEntry spawnerEntry : entries) {
            up compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new dsk(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.l = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((eib)this.getSnapshot()).c());
    }

    public static List<SpawnerEntry> getPotentialSpawns(dqq spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (bzz<dsk> entry : spawner.l.d()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.a().a());
            if (snapshot == null) continue;
            SpawnRule rule = entry.a().e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.b(), rule, CraftCreatureSpawner.getEquipment(entry.a().f())));
        }
        return entries;
    }

    public static dsk.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new dsk.a(new bez<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new bez<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(dsk.a rule) {
        bez<Integer> blockLight = rule.a();
        bez<Integer> skyLight = rule.b();
        return new SpawnRule(blockLight.b().intValue(), blockLight.b().intValue(), skyLight.a().intValue(), skyLight.b().intValue());
    }

    public String getCreatureTypeName() {
        dsk spawnData = ((eib)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<cee<?>> type = spawnData.a().a("id", cee.a);
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((eib)this.getSnapshot()).c().k;
    }

    public void setDelay(int delay) {
        ((eib)this.getSnapshot()).c().k = delay;
    }

    public int getMinSpawnDelay() {
        return ((eib)this.getSnapshot()).c().p;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((eib)this.getSnapshot()).c().p = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((eib)this.getSnapshot()).c().q;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((eib)this.getSnapshot()).c().q = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((eib)this.getSnapshot()).c().t;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((eib)this.getSnapshot()).c().t = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((eib)this.getSnapshot()).c().r;
    }

    public void setSpawnCount(int count) {
        ((eib)this.getSnapshot()).c().r = count;
    }

    public int getRequiredPlayerRange() {
        return ((eib)this.getSnapshot()).c().u;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((eib)this.getSnapshot()).c().u = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((eib)this.getSnapshot()).c().v;
    }

    public void setSpawnRange(int spawnRange) {
        ((eib)this.getSnapshot()).c().v = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<ceh> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new ceh(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<ceh> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.a()), new HashMap<EquipmentSlot, Float>(nms.b().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((cef)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }
}

