/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.BlockType;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockStateEnum;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBarrier;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBrushable;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperBulb;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDriedGhast;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFlowerBed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHangingMoss;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHeavyCore;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLeafLitter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMossyCarpet;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMultiface;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPitcherCrop;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSnifferEgg;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftUntintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftVault;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWaterloggedTransparent;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperBars;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperBulb;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperChain;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperChest;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperGrate;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringCopperTrapDoor;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringLantern;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeatheringLightningRod;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R6.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private ejm state;
    private Map<ekp<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends duv>, Function<ejm, CraftBlockData>> MAP = new HashMap<Class<? extends duv>, Function<ejm, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(ejm state) {
        this.state = state;
    }

    public Material getMaterial() {
        return CraftBlockType.minecraftToBukkit(this.state.b());
    }

    public ejm getState() {
        return this.state;
    }

    protected <N extends Enum<N>, B extends Enum<B>> B get(CraftBlockStateEnum<N, B> nms) {
        return nms.toBukkit((Enum)this.state.c(nms.nms()));
    }

    protected <N extends Enum<N>, B extends Enum<B>> Set<B> getValues(CraftBlockStateEnum<N, B> nms) {
        return nms.getValues();
    }

    protected <N extends Enum<N>, B extends Enum<B>> void set(CraftBlockStateEnum<N, B> nms, B bukkit) {
        this.parsedStates = null;
        this.state = (ejm)this.state.b(nms.nms(), nms.toNMS(bukkit));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.b() == craft.state.b() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (ekp<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (ejm)clone.state.b(parsed, craft.state.c(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.b() != craft.state.b()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals((Object)this);
        }
        return exactMatch;
    }

    protected <T extends Comparable<T>> T get(ekp<T> ibs) {
        return this.state.c(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(ekp<T> ibs, V v2) {
        this.parsedStates = null;
        this.state = (ejm)this.state.b(ibs, v2);
    }

    public String getAsString() {
        return this.toString(this.state.G());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex2) {
            throw new AssertionError("Clone not supported", ex2);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<ekp<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(mo.e.b(this.state.b()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(ejo.a).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public Map<String, String> toStates(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? CraftBlockData.toStates(this.parsedStates) : CraftBlockData.toStates(this.state.G());
    }

    private static Map<String, String> toStates(Map<ekp<?>, Comparable<?>> states) {
        HashMap<String, String> compound = new HashMap<String, String>();
        for (Map.Entry<ekp<?>, Comparable<?>> entry : states.entrySet()) {
            ekp<?> iblockstate = entry.getKey();
            compound.put(iblockstate.f(), iblockstate.b(entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static ekd getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static ekd getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(String name, Class<? extends Enum<B>> bukkit) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static ekm getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static ekd getBoolean(Class<? extends duv> block, String name) {
        return (ekd)CraftBlockData.getState(block, name, false);
    }

    protected static ekd getBoolean(Class<? extends duv> block, String name, boolean optional) {
        return (ekd)CraftBlockData.getState(block, name, optional);
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(Class<? extends duv> block, String name, Class<B> bukkit) {
        return new CraftBlockStateEnum((ekk)CraftBlockData.getState(block, name, false), bukkit);
    }

    protected static ekm getInteger(Class<? extends duv> block, String name) {
        return (ekm)CraftBlockData.getState(block, name, false);
    }

    private static ekp<?> getState(Class<? extends duv> block, String name, boolean optional) {
        ekp<?> state = null;
        for (duv instance : mo.e) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.l().a(name);
                continue;
            }
            ekp<?> newState = instance.l().a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(ekm state) {
        return state.b;
    }

    protected static int getMax(ekm state) {
        return state.c;
    }

    private static void register(Class<? extends duv> nms, Function<ejm, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(BlockType blockType, String data) {
        ejm blockData;
        duv block = blockType == null ? null : (duv)((CraftBlockType)blockType).getHandle();
        Map<ekp<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = String.valueOf(mo.e.b(block)) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                gh.a arg2 = gh.a(CraftRegistry.getMinecraftRegistry(mp.i), reader, false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg2.a();
                parsed = arg2.b();
            }
            catch (CommandSyntaxException ex2) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex2);
            }
        } else {
            blockData = block.m();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(ejm data) {
        return (CraftBlockData)MAP.getOrDefault(data.b().getClass(), (Function<ejm, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.A());
    }

    public int getLightEmission() {
        return this.state.k();
    }

    public boolean isOccluding() {
        return this.state.t();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.state.C();
    }

    public boolean isPreferredTool(ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        dhp nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(ejm iblockdata, dhp nmsItem) {
        return !iblockdata.C() || nmsItem.b(iblockdata);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.state.r().ordinal());
    }

    public boolean isSupported(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.a((drt)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        ja position = CraftLocation.toBlockPosition(location);
        return this.state.a((drt)world.getHandle(), position);
    }

    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.a((dqu)drg.a, ja.c, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    public Color getMapColor() {
        return Color.fromRGB((int)this.state.a(null, null).ak);
    }

    public Material getPlacementMaterial() {
        return CraftItemType.minecraftToBukkit(this.state.b().h());
    }

    public void rotate(StructureRotation rotation) {
        this.state = this.state.a(ebr.valueOf(rotation.name()));
    }

    public void mirror(Mirror mirror) {
        this.state = this.state.a(eaa.valueOf(mirror.name()));
    }

    public void copyTo(BlockData blockData) {
        CraftBlockData other = (CraftBlockData)blockData;
        ejm nms = other.state;
        for (ekp<?> property : this.state.b().l().d()) {
            if (!nms.b(property)) continue;
            nms = this.copyProperty(this.state, nms, property);
        }
        other.state = nms;
    }

    private <T extends Comparable<T>> ejm copyProperty(ejm source, ejm target, ekp<T> property) {
        return (ejm)target.b(property, source.c(property));
    }

    @NotNull
    public BlockState createBlockState() {
        return CraftBlockStates.getBlockState(this.state, null);
    }

    static {
        CraftBlockData.register(dtu.class, (Function<ejm, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(dus.class, (Function<ejm, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(dut.class, (Function<ejm, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(dtv.class, (Function<ejm, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(dtz.class, (Function<ejm, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(dua.class, (Function<ejm, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(een.class, (Function<ejm, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(dub.class, (Function<ejm, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(duc.class, (Function<ejm, CraftBlockData>)((Function)CraftBarrier::new));
        CraftBlockData.register(duo.class, (Function<ejm, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(dup.class, (Function<ejm, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(duq.class, (Function<ejm, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(dur.class, (Function<ejm, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(duu.class, (Function<ejm, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(dva.class, (Function<ejm, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(dvc.class, (Function<ejm, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(dvg.class, (Function<ejm, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(dvh.class, (Function<ejm, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(dvj.class, (Function<ejm, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(dvl.class, (Function<ejm, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(dvp.class, (Function<ejm, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(dvx.class, (Function<ejm, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(dvz.class, (Function<ejm, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(eec.class, (Function<ejm, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(dwb.class, (Function<ejm, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(dwc.class, (Function<ejm, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(eeo.class, (Function<ejm, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(dwd.class, (Function<ejm, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(dwf.class, (Function<ejm, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(dwh.class, (Function<ejm, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(dwj.class, (Function<ejm, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(due.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(dwo.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(dud.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(dwq.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(dug.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(dwp.class, (Function<ejm, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(dwu.class, (Function<ejm, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(dwx.class, (Function<ejm, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(ecu.class, (Function<ejm, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(dxd.class, (Function<ejm, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(dxe.class, (Function<ejm, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(dxk.class, (Function<ejm, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(dxq.class, (Function<ejm, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(dxr.class, (Function<ejm, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(dxp.class, (Function<ejm, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(dxy.class, (Function<ejm, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(dxz.class, (Function<ejm, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(dya.class, (Function<ejm, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(edf.class, (Function<ejm, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(dzt.class, (Function<ejm, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(dyi.class, (Function<ejm, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(dyk.class, (Function<ejm, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(dym.class, (Function<ejm, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(dyn.class, (Function<ejm, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(dyu.class, (Function<ejm, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(dyx.class, (Function<ejm, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(dyz.class, (Function<ejm, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(dyg.class, (Function<ejm, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(dzd.class, (Function<ejm, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(dze.class, (Function<ejm, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(dzf.class, (Function<ejm, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(dzg.class, (Function<ejm, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(dzi.class, (Function<ejm, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(dzj.class, (Function<ejm, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(dzo.class, (Function<ejm, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(dzq.class, (Function<ejm, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(dzv.class, (Function<ejm, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(dwz.class, (Function<ejm, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(ebd.class, (Function<ejm, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(eah.class, (Function<ejm, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(eal.class, (Function<ejm, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(ean.class, (Function<ejm, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(eap.class, (Function<ejm, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(eai.class, (Function<ejm, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(eax.class, (Function<ejm, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(eba.class, (Function<ejm, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(ebb.class, (Function<ejm, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(efn.class, (Function<ejm, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(dvr.class, (Function<ejm, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(dwg.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(ebh.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(ebf.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(ebi.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(ebj.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(ebg.class, (Function<ejm, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(edk.class, (Function<ejm, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(ebl.class, (Function<ejm, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(ebm.class, (Function<ejm, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(ebq.class, (Function<ejm, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(ebt.class, (Function<ejm, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(ebu.class, (Function<ejm, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(ecc.class, (Function<ejm, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(eci.class, (Function<ejm, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(ecm.class, (Function<ejm, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(eat.class, (Function<ejm, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(eau.class, (Function<ejm, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(eer.class, (Function<ejm, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(ecr.class, (Function<ejm, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(ect.class, (Function<ejm, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(dxx.class, (Function<ejm, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(edd.class, (Function<ejm, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(ede.class, (Function<ejm, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(edg.class, (Function<ejm, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(dtw.class, (Function<ejm, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(ecn.class, (Function<ejm, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(edh.class, (Function<ejm, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(edi.class, (Function<ejm, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(edn.class, (Function<ejm, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(edx.class, (Function<ejm, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(dxg.class, (Function<ejm, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(edp.class, (Function<ejm, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(eds.class, (Function<ejm, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(ees.class, (Function<ejm, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(eeb.class, (Function<ejm, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(eee.class, (Function<ejm, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(eef.class, (Function<ejm, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(eeg.class, (Function<ejm, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(eeh.class, (Function<ejm, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(eem.class, (Function<ejm, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(eeq.class, (Function<ejm, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(efl.class, (Function<ejm, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(efq.class, (Function<ejm, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(efr.class, (Function<ejm, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(dvb.class, (Function<ejm, CraftBlockData>)((Function)CraftBrushable::new));
        CraftBlockData.register(dvk.class, (Function<ejm, CraftBlockData>)((Function)CraftCalibratedSculkSensor::new));
        CraftBlockData.register(dvm.class, (Function<ejm, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(dvn.class, (Function<ejm, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(dvu.class, (Function<ejm, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(dvv.class, (Function<ejm, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(dvw.class, (Function<ejm, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(dwa.class, (Function<ejm, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(dwk.class, (Function<ejm, CraftBlockData>)((Function)CraftCopperBulb::new));
        CraftBlockData.register(dwl.class, (Function<ejm, CraftBlockData>)((Function)CraftCopperChest::new));
        CraftBlockData.register(dwm.class, (Function<ejm, CraftBlockData>)((Function)CraftCopperGolemStatue::new));
        CraftBlockData.register(dwr.class, (Function<ejm, CraftBlockData>)((Function)CraftCrafter::new));
        CraftBlockData.register(dwt.class, (Function<ejm, CraftBlockData>)((Function)CraftCreakingHeart::new));
        CraftBlockData.register(dwy.class, (Function<ejm, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(dxi.class, (Function<ejm, CraftBlockData>)((Function)CraftDriedGhast::new));
        CraftBlockData.register(dyc.class, (Function<ejm, CraftBlockData>)((Function)CraftFlowerBed::new));
        CraftBlockData.register(dyl.class, (Function<ejm, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(dys.class, (Function<ejm, CraftBlockData>)((Function)CraftHangingMoss::new));
        CraftBlockData.register(dyt.class, (Function<ejm, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(dyv.class, (Function<ejm, CraftBlockData>)((Function)CraftHeavyCore::new));
        CraftBlockData.register(dzc.class, (Function<ejm, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(dzl.class, (Function<ejm, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(dzm.class, (Function<ejm, CraftBlockData>)((Function)CraftLeafLitter::new));
        CraftBlockData.register(dzr.class, (Function<ejm, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(dzs.class, (Function<ejm, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(dzx.class, (Function<ejm, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(dzy.class, (Function<ejm, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(dzz.class, (Function<ejm, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(eab.class, (Function<ejm, CraftBlockData>)((Function)CraftMossyCarpet::new));
        CraftBlockData.register(ead.class, (Function<ejm, CraftBlockData>)((Function)CraftMultiface::new));
        CraftBlockData.register(eaq.class, (Function<ejm, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(eas.class, (Function<ejm, CraftBlockData>)((Function)CraftPitcherCrop::new));
        CraftBlockData.register(eav.class, (Function<ejm, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(ebx.class, (Function<ejm, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(eby.class, (Function<ejm, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(ebz.class, (Function<ejm, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(ecb.class, (Function<ejm, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(ecg.class, (Function<ejm, CraftBlockData>)((Function)CraftShelf::new));
        CraftBlockData.register(ecp.class, (Function<ejm, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(ecs.class, (Function<ejm, CraftBlockData>)((Function)CraftSnifferEgg::new));
        CraftBlockData.register(edr.class, (Function<ejm, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(edt.class, (Function<ejm, CraftBlockData>)((Function)CraftTest::new));
        CraftBlockData.register(edw.class, (Function<ejm, CraftBlockData>)((Function)CraftTintedParticleLeaves::new));
        CraftBlockData.register(edz.class, (Function<ejm, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(eed.class, (Function<ejm, CraftBlockData>)((Function)CraftTrialSpawner::new));
        CraftBlockData.register(eej.class, (Function<ejm, CraftBlockData>)((Function)CraftUntintedParticleLeaves::new));
        CraftBlockData.register(eek.class, (Function<ejm, CraftBlockData>)((Function)CraftVault::new));
        CraftBlockData.register(eep.class, (Function<ejm, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(eeu.class, (Function<ejm, CraftBlockData>)((Function)CraftWaterloggedTransparent::new));
        CraftBlockData.register(eew.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperBars::new));
        CraftBlockData.register(eey.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperBulb::new));
        CraftBlockData.register(eez.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperChain::new));
        CraftBlockData.register(efa.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperChest::new));
        CraftBlockData.register(efb.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperDoor::new));
        CraftBlockData.register(efd.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperGolemStatue::new));
        CraftBlockData.register(efe.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperGrate::new));
        CraftBlockData.register(eff.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(efg.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(efh.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringCopperTrapDoor::new));
        CraftBlockData.register(efi.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringLantern::new));
        CraftBlockData.register(efj.class, (Function<ejm, CraftBlockData>)((Function)CraftWeatheringLightningRod::new));
        CraftBlockData.register(ejd.class, (Function<ejm, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(eje.class, (Function<ejm, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(ejc.class, (Function<ejm, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

