/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.damage;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftRegistryItem;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
extends CraftRegistryItem<cck>
implements DamageType {
    public CraftDamageType(NamespacedKey key, jk<cck> handle) {
        super(key, handle);
    }

    public String getTranslationKey() {
        return ((cck)this.getHandle()).a();
    }

    public DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(((cck)this.getHandle()).b());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(((cck)this.getHandle()).d());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(((cck)this.getHandle()).e());
    }

    public float getExhaustion() {
        return ((cck)this.getHandle()).c();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public static DeathMessageType deathMessageTypeToBukkit(ccm deathMessageType) {
        return switch (deathMessageType) {
            case ccm.a -> DeathMessageType.DEFAULT;
            case ccm.b -> DeathMessageType.FALL_VARIANTS;
            case ccm.c -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static ccm deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> ccm.a;
            case DeathMessageType.FALL_VARIANTS -> ccm.b;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> ccm.c;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static DamageScaling damageScalingToBukkit(cch damageScaling) {
        return switch (damageScaling) {
            case cch.c -> DamageScaling.ALWAYS;
            case cch.b -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case cch.a -> DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static cch damageScalingToNMS(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.ALWAYS -> cch.c;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> cch.b;
            case DamageScaling.NEVER -> cch.a;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static DamageType minecraftHolderToBukkit(jk<cck> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit(minecraftHolder.a());
    }

    public static jk<cck> bukkitToMinecraftHolder(DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        jx registry = CraftRegistry.getMinecraftRegistry(mp.aU);
        jk<cck> jk2 = registry.e(CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (jk2 instanceof jk.c) {
            jk.c holder = (jk.c)jk2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkitDamageType) + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static cck bukkitToMinecraft(DamageType bukkitDamageType) {
        return (cck)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static DamageType minecraftToBukkit(cck minecraftDamageType) {
        return (DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, mp.aU, Registry.DAMAGE_TYPE);
    }
}

