/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.inventory.meta.BookMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBookSigned
extends CraftMetaItem
implements BookMeta {
    static final CraftMetaItem.ItemMetaKeyType<dlb> BOOK_CONTENT = new CraftMetaItem.ItemMetaKeyType<dlb>(kp.V);
    static final ItemMetaKey BOOK_TITLE = new ItemMetaKey("title");
    static final ItemMetaKey BOOK_AUTHOR = new ItemMetaKey("author");
    static final ItemMetaKey BOOK_PAGES = new ItemMetaKey("pages");
    static final ItemMetaKey RESOLVED = new ItemMetaKey("resolved");
    static final ItemMetaKey GENERATION = new ItemMetaKey("generation");
    static final int MAX_PAGES = Integer.MAX_VALUE;
    static final int MAX_PAGE_LENGTH = 1024;
    static final int MAX_TITLE_LENGTH = 32;
    protected String title;
    protected String author;
    protected List<xx> pages;
    protected boolean resolved;
    protected int generation;

    CraftMetaBookSigned(CraftMetaItem meta) {
        super(meta);
        if (meta instanceof CraftMetaBookSigned) {
            CraftMetaBookSigned bookMeta = (CraftMetaBookSigned)meta;
            this.title = bookMeta.title;
            this.author = bookMeta.author;
            this.resolved = bookMeta.resolved;
            this.generation = bookMeta.generation;
            if (bookMeta.pages != null) {
                this.pages = new ArrayList<xx>(bookMeta.pages.size());
                this.pages.addAll(bookMeta.pages);
            }
        } else if (meta instanceof CraftMetaBook) {
            CraftMetaBook bookMeta = (CraftMetaBook)meta;
            if (bookMeta.pages != null) {
                this.pages = new ArrayList<xx>(bookMeta.pages.size());
                for (String page : bookMeta.pages) {
                    xx component = CraftChatMessage.fromString(page, true, true)[0];
                    this.pages.add(component);
                }
            }
        }
    }

    CraftMetaBookSigned(kn tag) {
        super(tag);
        CraftMetaBookSigned.getOrEmpty(tag, BOOK_CONTENT).ifPresent(written -> {
            this.title = written.d().a();
            this.author = written.e();
            this.resolved = written.g();
            this.generation = written.f();
            List<axo<xx>> pages = written.a();
            this.pages = new ArrayList<xx>(pages.size());
            for (int i2 = 0; i2 < Math.min(pages.size(), Integer.MAX_VALUE); ++i2) {
                xx page = pages.get(i2).a();
                this.pages.add(page);
            }
        });
    }

    CraftMetaBookSigned(Map<String, Object> map) {
        super(map);
        this.setAuthor(SerializableMeta.getString(map, CraftMetaBookSigned.BOOK_AUTHOR.BUKKIT, true));
        this.setTitle(SerializableMeta.getString(map, CraftMetaBookSigned.BOOK_TITLE.BUKKIT, true));
        Iterable pages = SerializableMeta.getObject(Iterable.class, map, CraftMetaBookSigned.BOOK_PAGES.BUKKIT, true);
        if (pages != null) {
            this.pages = new ArrayList<xx>();
            for (Object page : pages) {
                if (!(page instanceof String)) continue;
                this.internalAddPage(CraftChatMessage.fromJSONOrString((String)page, false, true, 1024, false));
            }
        }
        this.resolved = SerializableMeta.getBoolean(map, CraftMetaBookSigned.RESOLVED.BUKKIT);
        this.generation = SerializableMeta.getInteger(map, CraftMetaBookSigned.GENERATION.BUKKIT);
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator itemData) {
        super.applyToItem(itemData);
        if (this.pages != null) {
            ArrayList<axo<xx>> list = new ArrayList<axo<xx>>();
            for (xx page : this.pages) {
                list.add(axo.a(page));
            }
            itemData.put(BOOK_CONTENT, new dlb(axo.a(axp.a(this.title)), this.author, this.generation, list, this.resolved));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBookEmpty();
    }

    boolean isBookEmpty() {
        return this.pages == null && !this.hasAuthor() && !this.hasTitle() && !this.hasGeneration() && !this.resolved;
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.WRITTEN_BOOK;
    }

    public boolean hasAuthor() {
        return this.author != null;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasPages() {
        return this.pages != null && !this.pages.isEmpty();
    }

    public boolean hasGeneration() {
        return this.generation != 0;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 32) {
            return false;
        }
        this.title = title;
        return true;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public BookMeta.Generation getGeneration() {
        return BookMeta.Generation.values()[this.generation];
    }

    public void setGeneration(BookMeta.Generation generation) {
        this.generation = generation == null ? 0 : generation.ordinal();
    }

    public String getPage(int page) {
        Preconditions.checkArgument((boolean)this.isValidPage(page), (String)"Invalid page number (%s)", (int)page);
        return CraftChatMessage.fromComponent(this.pages.get(page - 1));
    }

    public void setPage(int page, String text) {
        Preconditions.checkArgument((boolean)this.isValidPage(page), (String)"Invalid page number (%s/%s)", (int)page, (int)this.getPageCount());
        String newText = this.validatePage(text);
        this.pages.set(page - 1, CraftChatMessage.fromStringOrEmpty(newText, true));
    }

    public void setPages(String ... pages) {
        this.setPages(Arrays.asList(pages));
    }

    public void addPage(String ... pages) {
        for (String page : pages) {
            page = this.validatePage(page);
            this.internalAddPage(CraftChatMessage.fromStringOrEmpty(page, true));
        }
    }

    String validatePage(String page) {
        if (page == null) {
            page = "";
        } else if (page.length() > 1024) {
            page = page.substring(0, 1024);
        }
        return page;
    }

    private void internalAddPage(xx page) {
        if (this.pages == null) {
            this.pages = new ArrayList<xx>();
        } else if (this.pages.size() >= Integer.MAX_VALUE) {
            return;
        }
        this.pages.add(page);
    }

    public int getPageCount() {
        return this.pages == null ? 0 : this.pages.size();
    }

    public List<String> getPages() {
        if (this.pages == null) {
            return ImmutableList.of();
        }
        return (List)this.pages.stream().map(CraftChatMessage::fromComponent).collect(ImmutableList.toImmutableList());
    }

    public void setPages(List<String> pages) {
        if (pages.isEmpty()) {
            this.pages = null;
            return;
        }
        if (this.pages != null) {
            this.pages.clear();
        }
        for (String page : pages) {
            this.addPage(page);
        }
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.getPageCount();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public CraftMetaBookSigned clone() {
        CraftMetaBookSigned meta = (CraftMetaBookSigned)super.clone();
        if (this.pages != null) {
            meta.pages = new ArrayList<xx>(this.pages);
        }
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasTitle()) {
            hash = 61 * hash + this.title.hashCode();
        }
        if (this.hasAuthor()) {
            hash = 61 * hash + 13 * this.author.hashCode();
        }
        if (this.pages != null) {
            hash = 61 * hash + 17 * this.pages.hashCode();
        }
        if (this.resolved) {
            hash = 61 * hash + 17 * Boolean.hashCode(this.resolved);
        }
        if (this.hasGeneration()) {
            hash = 61 * hash + 19 * Integer.hashCode(this.generation);
        }
        return original != hash ? CraftMetaBook.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBookSigned) {
            CraftMetaBookSigned that = (CraftMetaBookSigned)meta;
            return (this.hasTitle() ? that.hasTitle() && this.title.equals(that.title) : !that.hasTitle()) && (this.hasAuthor() ? that.hasAuthor() && this.author.equals(that.author) : !that.hasAuthor()) && Objects.equals(this.pages, that.pages) && Objects.equals(this.resolved, that.resolved) && Objects.equals(this.generation, that.generation);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBookSigned || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasTitle()) {
            builder.put((Object)CraftMetaBookSigned.BOOK_TITLE.BUKKIT, (Object)this.title);
        }
        if (this.hasAuthor()) {
            builder.put((Object)CraftMetaBookSigned.BOOK_AUTHOR.BUKKIT, (Object)this.author);
        }
        if (this.pages != null) {
            builder.put((Object)CraftMetaBookSigned.BOOK_PAGES.BUKKIT, (Object)ImmutableList.copyOf((Collection)Lists.transform(this.pages, CraftChatMessage::toJSON)));
        }
        if (this.resolved) {
            builder.put((Object)CraftMetaBookSigned.RESOLVED.BUKKIT, (Object)this.resolved);
        }
        if (this.generation != 0) {
            builder.put((Object)CraftMetaBookSigned.GENERATION.BUKKIT, (Object)this.generation);
        }
        return builder;
    }
}

