/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaTropicalFishBucket
extends CraftMetaItem
implements TropicalFishBucketMeta {
    static final ItemMetaKey VARIANT = new ItemMetaKey("BucketVariantTag", "fish-variant");
    static final CraftMetaItem.ItemMetaKeyType<dkw<cee<?>>> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(kp.Y, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<djy> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<djy>(kp.Z, "bucket-entity-tag");
    static final Codec<dkw<cee<?>>> ENTITY_TAG_CODEC = dkw.a(cee.a);
    private Integer variant;
    private dkw<cee<?>> entityTag;
    private up bucketEntityTag;

    CraftMetaTropicalFishBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaTropicalFishBucket)) {
            return;
        }
        CraftMetaTropicalFishBucket bucket = (CraftMetaTropicalFishBucket)meta;
        this.variant = bucket.variant;
        this.entityTag = bucket.entityTag;
        this.bucketEntityTag = bucket.bucketEntityTag;
    }

    CraftMetaTropicalFishBucket(kn tag) {
        super(tag);
        CraftMetaTropicalFishBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt;
            this.entityTag.c().e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
        CraftMetaTropicalFishBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.b();
            this.bucketEntityTag.e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
    }

    CraftMetaTropicalFishBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaTropicalFishBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(up tag, Object context) {
        super.deserializeInternal(tag, context);
        ENTITY_TAG_CODEC.decode((DynamicOps)vd.a, (Object)tag).ifSuccess(result -> {
            this.entityTag = (dkw)result.getFirst();
        });
        this.bucketEntityTag = tag.m(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT).orElse(this.bucketEntityTag);
    }

    @Override
    void serializeInternal(Map<String, vp> internalTags) {
        if (this.entityTag != null) {
            internalTags.put(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT, (vp)ENTITY_TAG_CODEC.encodeStart((DynamicOps)vd.a, this.entityTag).getOrThrow());
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.j()) {
            internalTags.put(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT, this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        up bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, this.entityTag);
        }
        up up2 = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.l() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new up();
            }
            bucketEntityTag.a(CraftMetaTropicalFishBucket.VARIANT.NBT, this.variant);
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, djy.a(bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    public DyeColor getPatternColor() {
        return CraftTropicalFish.getPatternColor(this.variant);
    }

    public void setPatternColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(color, this.getPatternColor(), this.getPattern());
    }

    public DyeColor getBodyColor() {
        return CraftTropicalFish.getBodyColor(this.variant);
    }

    public void setBodyColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern());
    }

    public TropicalFish.Pattern getPattern() {
        return CraftTropicalFish.getPattern(this.variant);
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern);
    }

    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaTropicalFishBucket) {
            CraftMetaTropicalFishBucket that = (CraftMetaTropicalFishBucket)meta;
            return (this.hasVariant() ? that.hasVariant() && this.variant.equals(that.variant) : !that.hasVariant()) && (this.entityTag != null ? that.entityTag != null && this.entityTag.equals(that.entityTag) : that.entityTag == null) && (this.bucketEntityTag != null ? that.bucketEntityTag != null && this.bucketEntityTag.equals(that.bucketEntityTag) : that.bucketEntityTag == null);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaTropicalFishBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaTropicalFishBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaTropicalFishBucket clone() {
        CraftMetaTropicalFishBucket clone = (CraftMetaTropicalFishBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = dkw.a(this.entityTag.a(), this.entityTag.c());
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.l();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaTropicalFishBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

