/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    protected final fhv worldMap;

    public CraftMapView(fhv worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(this, worldMap));
    }

    public int getId() {
        return this.worldMap.id.b();
    }

    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    public MapView.Scale getScale() {
        return MapView.Scale.valueOf((byte)this.worldMap.g);
    }

    public void setScale(MapView.Scale scale) {
        this.worldMap.g = scale.getValue();
    }

    public World getWorld() {
        ami<drq> dimension = this.worldMap.f;
        awx world = MinecraftServer.getServer().a(dimension);
        if (world != null) {
            return world.getWorld();
        }
        if (this.worldMap.uniqueId != null) {
            return Bukkit.getServer().getWorld(this.worldMap.uniqueId);
        }
        return null;
    }

    public void setWorld(World world) {
        this.worldMap.f = ((CraftWorld)world).getHandle().al();
        this.worldMap.uniqueId = world.getUID();
    }

    public int getCenterX() {
        return this.worldMap.d;
    }

    public int getCenterZ() {
        return this.worldMap.e;
    }

    public void setCenterX(int x2) {
        this.worldMap.d = x2;
    }

    public void setCenterZ(int z2) {
        this.worldMap.e = z2;
    }

    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                for (int x2 = 0; x2 < 128; ++x2) {
                    for (int y2 = 0; y2 < 128; ++y2) {
                        entry.getValue().setPixel(x2, y2, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            int i2;
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            }
            catch (Throwable ex2) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex2);
            }
            byte[] buf2 = canvas.getBuffer();
            for (i2 = 0; i2 < buf2.length; ++i2) {
                byte color = buf2[i2];
                if (color < 0 && color > -9) continue;
                render.buffer[i2] = color;
            }
            for (i2 = 0; i2 < canvas.getCursors().size(); ++i2) {
                render.cursors.add(canvas.getCursors().getCursor(i2));
            }
        }
        return render;
    }

    public boolean isTrackingPosition() {
        return this.worldMap.n;
    }

    public void setTrackingPosition(boolean trackingPosition) {
        this.worldMap.n = trackingPosition;
    }

    public boolean isUnlimitedTracking() {
        return this.worldMap.o;
    }

    public void setUnlimitedTracking(boolean unlimited) {
        this.worldMap.o = unlimited;
    }

    public boolean isLocked() {
        return this.worldMap.i;
    }

    public void setLocked(boolean locked) {
        this.worldMap.i = locked;
    }
}

