/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftTeam;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements Scoreboard {
    final fpn board;

    CraftScoreboard(fpn board) {
        this.board = board;
    }

    public CraftObjective registerNewObjective(String name, String criteria) {
        return this.registerNewObjective(name, criteria, name);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName) {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName) {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName, RenderType renderType) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"The name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.board.a(name) == null ? 1 : 0) != 0, (String)"An objective of name '%s' already exists", (Object)name);
        fpf objective = this.board.a(name, ((CraftCriteria)criteria).criteria, CraftChatMessage.fromStringOrEmpty(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType), true, null);
        return new CraftObjective(this, objective);
    }

    public Objective getObjective(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        fpf nms = this.board.a(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria name cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (fpf netObjective : this.board.b()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(Criteria criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (fpf netObjective : this.board.b()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getTrackedCriteria().equals((Object)criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.b(), input -> new CraftObjective(this, (fpf)input)));
    }

    public Objective getObjective(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Display slot cannot be null");
        fpf objective = this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) {
        return this.getScores(CraftScoreboard.getScoreHolder(player));
    }

    public ImmutableSet<Score> getScores(String entry) {
        return this.getScores(CraftScoreboard.getScoreHolder(entry));
    }

    private ImmutableSet<Score> getScores(fpm entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (fpf objective : this.board.b()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    public void resetScores(OfflinePlayer player) {
        this.resetScores(CraftScoreboard.getScoreHolder(player));
    }

    public void resetScores(String entry) {
        this.resetScores(CraftScoreboard.getScoreHolder(entry));
    }

    private void resetScores(fpm entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        for (fpf objective : this.board.b()) {
            this.board.e(entry, objective);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        fpi team = this.board.e(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getEntryTeam(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        fpi team = this.board.e(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getTeam(String teamName) {
        Preconditions.checkArgument((teamName != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        fpi team = this.board.b(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.f(), input -> new CraftTeam(this, (fpi)input)));
    }

    public Team registerNewTeam(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Team name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.board.b(name) == null ? 1 : 0) != 0, (String)"Team name '%s' is already in use", (Object)name);
        return new CraftTeam(this, this.board.c(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (fpm playerName : this.board.d()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName.cV()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (fpm entry : this.board.d()) {
            entries.add((Object)entry.cV());
        }
        return entries.build();
    }

    public void clearSlot(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Slot cannot be null");
        this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public fpn getHandle() {
        return this.board;
    }

    static fpm getScoreHolder(String entry) {
        return () -> entry;
    }

    static fpm getScoreHolder(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        if (player instanceof CraftPlayer) {
            CraftPlayer craft = (CraftPlayer)player;
            return craft.getHandle();
        }
        return CraftScoreboard.getScoreHolder(player.getName());
    }
}

