/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)?i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final vq<vp> MOJANGSON_PARSER = vq.a(vd.a);

    public static String serialize(@NotNull vp base) {
        vl snbtVisitor = new vl();
        return snbtVisitor.a(base);
    }

    public static vp deserialize(Object object) {
        if (object instanceof String) {
            String snbtString = (String)object;
            try {
                return vq.a(snbtString);
            }
            catch (CommandSyntaxException e2) {
                throw new RuntimeException("Failed to deserialise nbt", e2);
            }
        }
        return CraftNBTTagConfigSerializer.internalLegacyDeserialization(object);
    }

    private static vp internalLegacyDeserialization(@NotNull Object object) {
        if (object instanceof Map) {
            up compound = new up();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.a((String)entry.getKey(), CraftNBTTagConfigSerializer.internalLegacyDeserialization(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new uv();
            }
            uv tagList = new uv();
            for (Object tag : list) {
                tagList.add(CraftNBTTagConfigSerializer.internalLegacyDeserialization(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            vp nbtBase;
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return MOJANGSON_PARSER.b(new StringReader(string));
                }
                catch (CommandSyntaxException e2) {
                    throw new RuntimeException("Could not deserialize found list ", e2);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return uu.a(Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return uq.a(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            try {
                nbtBase = MOJANGSON_PARSER.b(new StringReader(string));
            }
            catch (CommandSyntaxException e3) {
                throw new RuntimeException("Could not deserialize found value ", e3);
            }
            if (nbtBase instanceof uu) {
                return vn.a(String.valueOf(((uu)nbtBase).h()));
            }
            if (nbtBase instanceof uq) {
                return vn.a(String.valueOf(((uq)nbtBase).k()));
            }
            if (nbtBase instanceof vn) {
                return vn.a(string);
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize NBTBase");
    }
}

