/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DialogCommand;
import net.minecraft.server.commands.FetchProfileCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PermissionCheck;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.VersionCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WaypointCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;

public class CommandDispatcher {
    public static final String a = "/";
    private static final ThreadLocal<ExecutionContext<CommandListenerWrapper>> g = new ThreadLocal();
    private static final Logger h = LogUtils.getLogger();
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 3;
    public static final int f = 4;
    private static final PacketPlayOutCommands.e<CommandListenerWrapper> i = new PacketPlayOutCommands.e<CommandListenerWrapper>(){

        @Override
        @Nullable
        public MinecraftKey a(ArgumentCommandNode<CommandListenerWrapper, ?> argumentcommandnode) {
            SuggestionProvider suggestionprovider = argumentcommandnode.getCustomSuggestions();
            return suggestionprovider != null ? CompletionProviders.b(suggestionprovider) : null;
        }

        @Override
        public boolean a(CommandNode<CommandListenerWrapper> commandnode) {
            return commandnode.getCommand() != null;
        }

        @Override
        public boolean b(CommandNode<CommandListenerWrapper> commandnode) {
            PermissionCheck permissioncheck;
            Predicate<CommandListenerWrapper> predicate = commandnode.getRequirement();
            if (predicate instanceof PermissionCheck && (permissioncheck = (PermissionCheck)predicate).a() > 0) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }
    };
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> j = new com.mojang.brigadier.CommandDispatcher();

    public CommandDispatcher(ServerType commanddispatcher_servertype, CommandBuildContext commandbuildcontext) {
        this();
        CommandAdvancement.a(this.j);
        CommandAttribute.a(this.j, commandbuildcontext);
        CommandExecute.a(this.j, commandbuildcontext);
        CommandBossBar.a(this.j, commandbuildcontext);
        CommandClear.a(this.j, commandbuildcontext);
        CommandClone.a(this.j, commandbuildcontext);
        DamageCommand.a(this.j, commandbuildcontext);
        CommandData.a(this.j);
        CommandDatapack.a(this.j, commandbuildcontext);
        CommandDebug.a(this.j);
        CommandGamemodeDefault.a(this.j);
        DialogCommand.a(this.j, commandbuildcontext);
        CommandDifficulty.a(this.j);
        CommandEffect.a(this.j, commandbuildcontext);
        CommandMe.a(this.j);
        CommandEnchant.a(this.j, commandbuildcontext);
        CommandXp.a(this.j);
        CommandFill.a(this.j, commandbuildcontext);
        FillBiomeCommand.a(this.j, commandbuildcontext);
        CommandForceload.a(this.j);
        CommandFunction.a(this.j);
        CommandGamemode.a(this.j);
        CommandGamerule.a(this.j, commandbuildcontext);
        CommandGive.a(this.j, commandbuildcontext);
        CommandHelp.a(this.j);
        ItemCommands.a(this.j, commandbuildcontext);
        CommandKick.a(this.j);
        CommandKill.a(this.j);
        CommandList.a(this.j);
        CommandLocate.a(this.j, commandbuildcontext);
        CommandLoot.a(this.j, commandbuildcontext);
        CommandTell.a(this.j);
        CommandParticle.a(this.j, commandbuildcontext);
        PlaceCommand.a(this.j);
        CommandPlaySound.a(this.j);
        RandomCommand.a(this.j);
        CommandReload.a(this.j);
        CommandRecipe.a(this.j);
        FetchProfileCommand.a(this.j);
        ReturnCommand.a(this.j);
        RideCommand.a(this.j);
        RotateCommand.a(this.j);
        CommandSay.a(this.j);
        CommandSchedule.a(this.j);
        CommandScoreboard.a(this.j, commandbuildcontext);
        CommandSeed.a(this.j, commanddispatcher_servertype != ServerType.c);
        VersionCommand.a(this.j, commanddispatcher_servertype != ServerType.c);
        CommandSetBlock.a(this.j, commandbuildcontext);
        CommandSpawnpoint.a(this.j);
        CommandSetWorldSpawn.a(this.j);
        CommandSpectate.a(this.j);
        CommandSpreadPlayers.a(this.j);
        CommandStopSound.a(this.j);
        CommandSummon.a(this.j, commandbuildcontext);
        CommandTag.a(this.j);
        CommandTeam.a(this.j, commandbuildcontext);
        CommandTeamMsg.a(this.j);
        CommandTeleport.a(this.j);
        CommandTellRaw.a(this.j, commandbuildcontext);
        GameTestHarnessTestCommand.a(this.j, commandbuildcontext);
        TickCommand.a(this.j);
        CommandTime.a(this.j);
        CommandTitle.a(this.j, commandbuildcontext);
        CommandTrigger.a(this.j);
        WaypointCommand.a(this.j, commandbuildcontext);
        CommandWeather.a(this.j);
        CommandWorldBorder.a(this.j);
        if (JvmProfiler.f.d()) {
            JfrCommand.a(this.j);
        }
        if (SharedConstants.av) {
            ChaseCommand.a(this.j);
        }
        if (SharedConstants.ax || SharedConstants.be) {
            RaidCommand.a(this.j, commandbuildcontext);
            DebugPathCommand.a(this.j);
            DebugMobSpawningCommand.a(this.j);
            WardenSpawnTrackerCommand.a(this.j);
            SpawnArmorTrimsCommand.a(this.j);
            ServerPackCommand.a(this.j);
            if (commanddispatcher_servertype.e) {
                DebugConfigCommand.a(this.j, commandbuildcontext);
            }
        }
        if (commanddispatcher_servertype.e) {
            CommandBanIp.a(this.j);
            CommandBanList.a(this.j);
            CommandBan.a(this.j);
            CommandDeop.a(this.j);
            CommandOp.a(this.j);
            CommandPardon.a(this.j);
            CommandPardonIP.a(this.j);
            PerfCommand.a(this.j);
            CommandSaveAll.a(this.j);
            CommandSaveOff.a(this.j);
            CommandSaveOn.a(this.j);
            CommandIdleTimeout.a(this.j);
            CommandStop.a(this.j);
            TransferCommand.a(this.j);
            CommandWhitelist.a(this.j);
        }
        if (commanddispatcher_servertype.d) {
            CommandPublish.a(this.j);
        }
    }

    public CommandDispatcher() {
        this.j.setConsumer(ExecutionCommandSource.b_());
    }

    public static <S> ParseResults<S> a(ParseResults<S> parseresults, UnaryOperator<S> unaryoperator) {
        CommandContextBuilder commandcontextbuilder = parseresults.getContext();
        CommandContextBuilder commandcontextbuilder1 = commandcontextbuilder.withSource(unaryoperator.apply(commandcontextbuilder.getSource()));
        return new ParseResults(commandcontextbuilder1, parseresults.getReader(), parseresults.getExceptions());
    }

    public void dispatchServerCommand(CommandListenerWrapper sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith(a)) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        String cmd = args[0];
        if (cmd.startsWith("minecraft:")) {
            cmd = cmd.substring("minecraft:".length());
        }
        if (cmd.startsWith("bukkit:")) {
            cmd = cmd.substring("bukkit:".length());
        }
        if (cmd.equalsIgnoreCase("stop") || cmd.equalsIgnoreCase("kick") || cmd.equalsIgnoreCase("op") || cmd.equalsIgnoreCase("deop") || cmd.equalsIgnoreCase("ban") || cmd.equalsIgnoreCase("ban-ip") || cmd.equalsIgnoreCase("pardon") || cmd.equalsIgnoreCase("pardon-ip") || cmd.equalsIgnoreCase("reload")) {
            return;
        }
        if (sender.e().getCraftServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + (String)args[0];
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void a(CommandListenerWrapper commandlistenerwrapper, String s2) {
        this.performPrefixedCommand(commandlistenerwrapper, s2, s2);
    }

    public void performPrefixedCommand(CommandListenerWrapper commandlistenerwrapper, String s2, String label) {
        s2 = CommandDispatcher.a(s2);
        this.performCommand(this.j.parse(s2, commandlistenerwrapper), s2, label);
    }

    public static String a(String s2) {
        return s2.startsWith(a) ? s2.substring(1) : s2;
    }

    public void a(ParseResults<CommandListenerWrapper> parseresults, String s2) {
        this.performCommand(parseresults, s2, s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandListenerWrapper> parseresults, String s2, String label) {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)parseresults.getContext().getSource();
        Profiler.a().a(() -> a + s2);
        ContextChain<CommandListenerWrapper> contextchain = CommandDispatcher.finishParsing(parseresults, s2, commandlistenerwrapper, label);
        try {
            if (contextchain != null) {
                CommandDispatcher.a(commandlistenerwrapper, (ExecutionContext<CommandListenerWrapper> executioncontext) -> ExecutionContext.a(executioncontext, s2, contextchain, commandlistenerwrapper, CommandResultCallback.a));
            }
        }
        catch (Exception exception) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (h.isDebugEnabled()) {
                h.error("Command exception: /{}", (Object)s2, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i2 = 0; i2 < Math.min(astacktraceelement.length, 3); ++i2) {
                    ichatmutablecomponent.f("\n\n").f(astacktraceelement[i2].getMethodName()).f("\n ").f(astacktraceelement[i2].getFileName()).f(":").f(String.valueOf(astacktraceelement[i2].getLineNumber()));
                }
            }
            commandlistenerwrapper.b(IChatBaseComponent.c("command.failed").a(chatmodifier -> chatmodifier.a(new ChatHoverable.e(ichatmutablecomponent))));
            if (SharedConstants.aw || SharedConstants.be) {
                commandlistenerwrapper.b(IChatBaseComponent.b(SystemUtils.c(exception)));
                h.error("'/{}' threw an exception", (Object)s2, (Object)exception);
            }
        }
        finally {
            Profiler.a().c();
        }
    }

    @Nullable
    private static ContextChain<CommandListenerWrapper> finishParsing(ParseResults<CommandListenerWrapper> parseresults, String s2, CommandListenerWrapper commandlistenerwrapper, String label) {
        try {
            CommandDispatcher.a(parseresults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseresults.getContext().build(s2)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            commandlistenerwrapper.b(ChatComponentUtils.a(commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int i2 = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().a(EnumChatFormat.h).a(chatmodifier -> chatmodifier.a(new ChatClickable.SuggestCommand(a + label)));
                if (i2 > 10) {
                    ichatmutablecomponent.b(CommonComponents.w);
                }
                ichatmutablecomponent.f(commandsyntaxexception.getInput().substring(Math.max(0, i2 - 10), i2));
                if (i2 < commandsyntaxexception.getInput().length()) {
                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.b(commandsyntaxexception.getInput().substring(i2)).a(EnumChatFormat.m, EnumChatFormat.t);
                    ichatmutablecomponent.b(ichatbasecomponent);
                }
                ichatmutablecomponent.b(IChatBaseComponent.c("command.context.here").a(EnumChatFormat.m, EnumChatFormat.u));
                commandlistenerwrapper.b(ichatmutablecomponent);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(CommandListenerWrapper commandlistenerwrapper, Consumer<ExecutionContext<CommandListenerWrapper>> consumer) {
        block9: {
            boolean flag;
            MinecraftServer minecraftserver = commandlistenerwrapper.l();
            ExecutionContext<CommandListenerWrapper> executioncontext = g.get();
            boolean bl = flag = executioncontext == null;
            if (flag) {
                int i2 = Math.max(1, minecraftserver.aQ().d(GameRules.z));
                int j2 = minecraftserver.aQ().d(GameRules.A);
                try (ExecutionContext executioncontext1 = new ExecutionContext(i2, j2, Profiler.a());){
                    g.set(executioncontext1);
                    consumer.accept(executioncontext1);
                    executioncontext1.a();
                    break block9;
                }
                finally {
                    g.set(null);
                }
            }
            consumer.accept(executioncontext);
        }
    }

    public void a(EntityPlayer entityplayer) {
        IdentityHashMap map = new IdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode<CommandListenerWrapper> vanilla = entityplayer.cK.vanillaCommandDispatcher.a().getRoot();
        map.put((CommandNode)vanilla, (CommandNode)vanillaRoot);
        CommandDispatcher.a(vanilla, vanillaRoot, entityplayer.C(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put((CommandNode)this.j.getRoot(), (CommandNode)rootcommandnode);
        CommandDispatcher.a(this.j.getRoot(), rootcommandnode, entityplayer.C(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)entityplayer.getBukkitEntity(), new LinkedHashSet(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootcommandnode.removeCommand(orig);
        }
        entityplayer.g.b(new PacketPlayOutCommands(rootcommandnode, i));
    }

    private static <S> void a(CommandNode<S> commandnode, CommandNode<S> commandnode1, S s0, Map<CommandNode<S>, CommandNode<S>> map) {
        for (CommandNode<S> commandnode2 : commandnode.getChildren()) {
            if (!commandnode2.canUse(s0)) continue;
            ArgumentBuilder<S, ?> argumentbuilder = commandnode2.createBuilder();
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(map.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode3 = argumentbuilder.build();
            map.put(commandnode2, commandnode3);
            commandnode1.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            CommandDispatcher.a(commandnode2, commandnode3, s0, map);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> b(String s2) {
        return LiteralArgumentBuilder.literal((String)s2);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> a(String s2, ArgumentType<T> argumenttype) {
        return RequiredArgumentBuilder.argument((String)s2, argumenttype);
    }

    public static Predicate<String> a(b commanddispatcher_b) {
        return s2 -> {
            try {
                commanddispatcher_b.parse(new StringReader(s2));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> a() {
        return this.j;
    }

    public static <S> void a(ParseResults<S> parseresults) throws CommandSyntaxException {
        CommandSyntaxException commandsyntaxexception = CommandDispatcher.b(parseresults);
        if (commandsyntaxexception != null) {
            throw commandsyntaxexception;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException b(ParseResults<S> parseresults) {
        return !parseresults.getReader().canRead() ? null : (parseresults.getExceptions().size() == 1 ? (CommandSyntaxException)((Object)parseresults.getExceptions().values().iterator().next()) : (parseresults.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parseresults.getReader())));
    }

    public static CommandBuildContext a(final HolderLookup.a holderlookup_a) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet a() {
                return FeatureFlags.e.a();
            }

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                return holderlookup_a.b();
            }

            public <T> Optional<HolderLookup.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> resourcekey) {
                return holderlookup_a.a(resourcekey).map(this::a);
            }

            private <T> HolderLookup.b.a<T> a(final HolderLookup.b<T> holderlookup_b) {
                return new HolderLookup.b.a<T>(){

                    @Override
                    public HolderLookup.b<T> a() {
                        return holderlookup_b;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> a(TagKey<T> tagkey) {
                        return Optional.of(this.b(tagkey));
                    }

                    @Override
                    public HolderSet.Named<T> b(TagKey<T> tagkey) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.a().a(tagkey);
                        return optional.orElseGet(() -> HolderSet.a(this.a(), tagkey));
                    }
                };
            }
        };
    }

    public static void b() {
        CommandBuildContext commandbuildcontext = CommandDispatcher.a(VanillaRegistries.a());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = new CommandDispatcher(ServerType.a, commandbuildcontext).a();
        RootCommandNode<CommandListenerWrapper> rootcommandnode = com_mojang_brigadier_commanddispatcher.getRoot();
        com_mojang_brigadier_commanddispatcher.findAmbiguities((AmbiguityConsumer<CommandListenerWrapper>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> h.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{com_mojang_brigadier_commanddispatcher.getPath(commandnode1), com_mojang_brigadier_commanddispatcher.getPath(commandnode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.a(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentTypeInfos.a(argumenttype.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            h.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + String.valueOf(argumenttype)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static <T extends PermissionSource> PermissionCheck<T> a(int i2) {
        return new PermissionSource.a(i2);
    }

    public static enum ServerType {
        a(true, true),
        b(false, true),
        c(true, false);

        final boolean d;
        final boolean e;

        private ServerType(boolean flag, boolean flag1) {
            this.d = flag;
            this.e = flag1;
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

