/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> b = Comparator.comparingInt(var0 -> var0.a(1, 0)).thenComparingInt(var0 -> var0.a(0, 0)).thenComparingInt(var0 -> var0.a(2, 0));
    private static final Comparator<NBTTagList> c = Comparator.comparingDouble(var0 -> var0.a(1, 0.0)).thenComparingDouble(var0 -> var0.a(0, 0.0)).thenComparingDouble(var0 -> var0.a(2, 0.0));
    private static final Codec<ResourceKey<Block>> d = ResourceKey.a(Registries.i);
    public static final String a = "data";
    private static final char e = '{';
    private static final char f = '}';
    private static final String g = ",";
    private static final char h = ':';
    private static final Splitter i = Splitter.on((String)",");
    private static final Splitter j = Splitter.on((char)':').limit(2);
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 2;
    private static final int m = -1;

    private GameProfileSerializer() {
    }

    @VisibleForTesting
    public static boolean a(@Nullable NBTBase var0, @Nullable NBTBase var1, boolean var2) {
        if (var0 == var1) {
            return true;
        }
        if (var0 == null) {
            return true;
        }
        if (var1 == null) {
            return false;
        }
        if (!var0.getClass().equals(var1.getClass())) {
            return false;
        }
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var3 = (NBTTagCompound)var0;
            NBTTagCompound var5 = (NBTTagCompound)var1;
            if (var5.i() < var3.i()) {
                return false;
            }
            for (Map.Entry<String, NBTBase> var7 : var3.g()) {
                NBTBase var8 = var7.getValue();
                if (GameProfileSerializer.a(var8, var5.a(var7.getKey()), var2)) continue;
                return false;
            }
            return true;
        }
        if (var0 instanceof NBTTagList) {
            NBTTagList var4 = (NBTTagList)var0;
            if (var2) {
                NBTTagList var5 = (NBTTagList)var1;
                if (var4.isEmpty()) {
                    return var5.isEmpty();
                }
                if (var5.size() < var4.size()) {
                    return false;
                }
                for (NBTBase var7 : var4) {
                    boolean var8 = false;
                    for (NBTBase var10 : var5) {
                        if (!GameProfileSerializer.a(var7, var10, var2)) continue;
                        var8 = true;
                        break;
                    }
                    if (var8) continue;
                    return false;
                }
                return true;
            }
        }
        return var0.equals(var1);
    }

    public static IBlockData a(HolderGetter<Block> var0, NBTTagCompound var1) {
        Optional var2 = var1.a("Name", d).flatMap(var0::a);
        if (var2.isEmpty()) {
            return Blocks.a.m();
        }
        Block var3 = (Block)((Holder)var2.get()).a();
        IBlockData var4 = var3.m();
        Optional<NBTTagCompound> var5 = var1.m("Properties");
        if (var5.isPresent()) {
            BlockStateList<Block, IBlockData> var6 = var3.l();
            for (String var8 : var5.get().e()) {
                IBlockState<?> var9 = var6.a(var8);
                if (var9 == null) continue;
                var4 = GameProfileSerializer.a(var4, var9, var8, var5.get(), var1);
            }
        }
        return var4;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S var0, IBlockState<T> var1, String var2, NBTTagCompound var3, NBTTagCompound var4) {
        Optional var5 = var3.i(var2).flatMap(var1::b);
        if (var5.isPresent()) {
            return (S)((IBlockDataHolder)var0.b(var1, (Comparable)((Comparable)var5.get())));
        }
        k.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{var2, var3.a(var2), var4});
        return var0;
    }

    public static NBTTagCompound a(IBlockData var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.a("Name", BuiltInRegistries.e.b(var0.b()).toString());
        Map<IBlockState<?>, Comparable<?>> var2 = var0.G();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> var5 : var2.entrySet()) {
                IBlockState<?> var6 = var5.getKey();
                var3.a(var6.f(), GameProfileSerializer.a(var6, var5.getValue()));
            }
            var1.a("Properties", var3);
        }
        return var1;
    }

    public static NBTTagCompound a(Fluid var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.a("Name", BuiltInRegistries.c.b(var0.a()).toString());
        Map<IBlockState<?>, Comparable<?>> var2 = var0.G();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> var5 : var2.entrySet()) {
                IBlockState<?> var6 = var5.getKey();
                var3.a(var6.f(), GameProfileSerializer.a(var6, var5.getValue()));
            }
            var1.a("Properties", var3);
        }
        return var1;
    }

    private static <T extends Comparable<T>> String a(IBlockState<T> var0, Comparable<?> var1) {
        return var0.b(var1);
    }

    public static String a(NBTBase var0) {
        return GameProfileSerializer.a(var0, false);
    }

    public static String a(NBTBase var0, boolean var1) {
        return GameProfileSerializer.a(new StringBuilder(), var0, 0, var1).toString();
    }

    public static StringBuilder a(StringBuilder var0, NBTBase var1, int var2, boolean var3) {
        NBTBase nBTBase = var1;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTag.class, NBTTagEnd.class, NBTTagByteArray.class, NBTTagList.class, NBTTagIntArray.class, NBTTagCompound.class, NBTTagLongArray.class}, (Object)nBTBase2, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PrimitiveTag var6 = (PrimitiveTag)nBTBase2;
                yield var0.append(var6);
            }
            case 1 -> {
                NBTTagEnd var7 = (NBTTagEnd)nBTBase2;
                yield var0;
            }
            case 2 -> {
                NBTTagByteArray var8 = (NBTTagByteArray)nBTBase2;
                byte[] var9 = var8.e();
                int var10 = var9.length;
                GameProfileSerializer.a(var2, var0).append("byte[").append(var10).append("] {\n");
                if (var3) {
                    GameProfileSerializer.a(var2 + 1, var0);
                    for (int var11 = 0; var11 < var9.length; ++var11) {
                        if (var11 != 0) {
                            var0.append(',');
                        }
                        if (var11 % 16 == 0 && var11 / 16 > 0) {
                            var0.append('\n');
                            if (var11 < var9.length) {
                                GameProfileSerializer.a(var2 + 1, var0);
                            }
                        } else if (var11 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%02X", var9[var11] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.a(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.a(var2, var0).append('}');
                yield var0;
            }
            case 3 -> {
                NBTTagList var9 = (NBTTagList)nBTBase2;
                int var10 = var9.size();
                GameProfileSerializer.a(var2, var0).append("list").append("[").append(var10).append("] [");
                if (var10 != 0) {
                    var0.append('\n');
                }
                for (int var11 = 0; var11 < var10; ++var11) {
                    if (var11 != 0) {
                        var0.append(",\n");
                    }
                    GameProfileSerializer.a(var2 + 1, var0);
                    GameProfileSerializer.a(var0, var9.c(var11), var2 + 1, var3);
                }
                if (var10 != 0) {
                    var0.append('\n');
                }
                GameProfileSerializer.a(var2, var0).append(']');
                yield var0;
            }
            case 4 -> {
                NBTTagIntArray var10 = (NBTTagIntArray)nBTBase2;
                int[] var11 = var10.g();
                int var12 = 0;
                for (int var16 : var11) {
                    var12 = Math.max(var12, String.format(Locale.ROOT, "%X", var16).length());
                }
                int var13 = var11.length;
                GameProfileSerializer.a(var2, var0).append("int[").append(var13).append("] {\n");
                if (var3) {
                    GameProfileSerializer.a(var2 + 1, var0);
                    for (int var14 = 0; var14 < var11.length; ++var14) {
                        if (var14 != 0) {
                            var0.append(',');
                        }
                        if (var14 % 16 == 0 && var14 / 16 > 0) {
                            var0.append('\n');
                            if (var14 < var11.length) {
                                GameProfileSerializer.a(var2 + 1, var0);
                            }
                        } else if (var14 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var12 + "X", var11[var14]));
                    }
                } else {
                    GameProfileSerializer.a(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.a(var2, var0).append('}');
                yield var0;
            }
            case 5 -> {
                NBTTagCompound var11 = (NBTTagCompound)nBTBase2;
                ArrayList var12 = Lists.newArrayList(var11.e());
                Collections.sort(var12);
                GameProfileSerializer.a(var2, var0).append('{');
                if (var0.length() - var0.lastIndexOf("\n") > 2 * (var2 + 1)) {
                    var0.append('\n');
                    GameProfileSerializer.a(var2 + 1, var0);
                }
                int var13 = var12.stream().mapToInt(String::length).max().orElse(0);
                String var14 = Strings.repeat((String)" ", (int)var13);
                for (int var15 = 0; var15 < var12.size(); ++var15) {
                    if (var15 != 0) {
                        var0.append(",\n");
                    }
                    String var16 = (String)var12.get(var15);
                    GameProfileSerializer.a(var2 + 1, var0).append('\"').append(var16).append('\"').append(var14, 0, var14.length() - var16.length()).append(": ");
                    GameProfileSerializer.a(var0, var11.a(var16), var2 + 1, var3);
                }
                if (!var12.isEmpty()) {
                    var0.append('\n');
                }
                GameProfileSerializer.a(var2, var0).append('}');
                yield var0;
            }
            case 6 -> {
                NBTTagLongArray var12 = (NBTTagLongArray)nBTBase2;
                long[] var13 = var12.g();
                long var14 = 0L;
                for (long var19 : var13) {
                    var14 = Math.max(var14, (long)String.format(Locale.ROOT, "%X", var19).length());
                }
                long var16 = var13.length;
                GameProfileSerializer.a(var2, var0).append("long[").append(var16).append("] {\n");
                if (var3) {
                    GameProfileSerializer.a(var2 + 1, var0);
                    for (int var18 = 0; var18 < var13.length; ++var18) {
                        if (var18 != 0) {
                            var0.append(',');
                        }
                        if (var18 % 16 == 0 && var18 / 16 > 0) {
                            var0.append('\n');
                            if (var18 < var13.length) {
                                GameProfileSerializer.a(var2 + 1, var0);
                            }
                        } else if (var18 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var14 + "X", var13[var18]));
                    }
                } else {
                    GameProfileSerializer.a(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.a(var2, var0).append('}');
                yield var0;
            }
        };
    }

    private static StringBuilder a(int var0, StringBuilder var1) {
        int var2 = var1.lastIndexOf("\n") + 1;
        int var3 = var1.length() - var2;
        for (int var4 = 0; var4 < 2 * var0 - var3; ++var4) {
            var1.append(' ');
        }
        return var1;
    }

    public static IChatBaseComponent b(NBTBase var0) {
        return new TextComponentTagVisitor("").a(var0);
    }

    public static String a(NBTTagCompound var0) {
        return new SnbtPrinterTagVisitor().a((NBTBase)GameProfileSerializer.b(var0));
    }

    public static NBTTagCompound a(String var0) throws CommandSyntaxException {
        return GameProfileSerializer.c(MojangsonParser.a(var0));
    }

    @VisibleForTesting
    static NBTTagCompound b(NBTTagCompound var02) {
        NBTTagList var5;
        Object var4;
        Optional<NBTTagList> var2 = var02.o("palettes");
        NBTTagList var12 = var2.isPresent() ? var2.get().f(0) : var02.p("palette");
        NBTTagList var3 = var12.j().map(GameProfileSerializer::d).map(NBTTagString::a).collect(Collectors.toCollection(NBTTagList::new));
        var02.a("palette", var3);
        if (var2.isPresent()) {
            var4 = new NBTTagList();
            var2.get().stream().flatMap(var0 -> var0.v_().stream()).forEach(arg_0 -> GameProfileSerializer.a(var3, (NBTTagList)var4, arg_0));
            var02.a("palettes", (NBTBase)var4);
        }
        if (((Optional)(var4 = var02.o("entities"))).isPresent()) {
            var5 = ((NBTTagList)((Optional)var4).get()).j().sorted(Comparator.comparing(var0 -> var0.o("pos"), Comparators.emptiesLast(c))).collect(Collectors.toCollection(NBTTagList::new));
            var02.a("entities", var5);
        }
        var5 = var02.o("blocks").stream().flatMap(NBTTagList::j).sorted(Comparator.comparing(var0 -> var0.o("pos"), Comparators.emptiesLast(b))).peek(var1 -> var1.a("state", var3.m(var1.b("state", 0)).orElseThrow())).collect(Collectors.toCollection(NBTTagList::new));
        var02.a(a, var5);
        var02.r("blocks");
        return var02;
    }

    @VisibleForTesting
    static NBTTagCompound c(NBTTagCompound var02) {
        NBTTagList var1 = var02.p("palette");
        Map var2 = (Map)var1.stream().flatMap(var0 -> var0.r_().stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::b));
        Optional<NBTTagList> var3 = var02.o("palettes");
        if (var3.isPresent()) {
            var02.a("palettes", var3.get().j().map(var12 -> var2.keySet().stream().map(var1 -> var12.i((String)var1).orElseThrow()).map(GameProfileSerializer::b).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            var02.r("palette");
        } else {
            var02.a("palette", var2.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        Optional<NBTTagList> var4 = var02.o(a);
        if (var4.isPresent()) {
            Object2IntOpenHashMap var5 = new Object2IntOpenHashMap();
            var5.defaultReturnValue(-1);
            for (int var6 = 0; var6 < var1.size(); ++var6) {
                var5.put((Object)var1.m(var6).orElseThrow(), var6);
            }
            NBTTagList var6 = var4.get();
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                NBTTagCompound var8 = var6.a(var7).orElseThrow();
                String var9 = var8.i("state").orElseThrow();
                int var10 = var5.getInt((Object)var9);
                if (var10 == -1) {
                    throw new IllegalStateException("Entry " + var9 + " missing from palette");
                }
                var8.a("state", var10);
            }
            var02.a("blocks", var6);
            var02.r(a);
        }
        return var02;
    }

    @VisibleForTesting
    static String d(NBTTagCompound var0) {
        StringBuilder var12 = new StringBuilder(var0.i("Name").orElseThrow());
        var0.m("Properties").ifPresent(var1 -> {
            String var2 = var1.g().stream().sorted(Map.Entry.comparingByKey()).map(var0 -> (String)var0.getKey() + ":" + ((NBTBase)var0.getValue()).r_().orElseThrow()).collect(Collectors.joining(g));
            var12.append('{').append(var2).append('}');
        });
        return var12.toString();
    }

    @VisibleForTesting
    static NBTTagCompound b(String var0) {
        String var3;
        NBTTagCompound var1 = new NBTTagCompound();
        int var22 = var0.indexOf(123);
        if (var22 >= 0) {
            var3 = var0.substring(0, var22);
            NBTTagCompound var4 = new NBTTagCompound();
            if (var22 + 2 <= var0.length()) {
                String var5 = var0.substring(var22 + 1, var0.indexOf(125, var22));
                i.split((CharSequence)var5).forEach(var2 -> {
                    List var3 = j.splitToList((CharSequence)var2);
                    if (var3.size() == 2) {
                        var4.a((String)var3.get(0), (String)var3.get(1));
                    } else {
                        k.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)var0);
                    }
                });
                var1.a("Properties", var4);
            }
        } else {
            var3 = var0;
        }
        var1.a("Name", var3);
        return var1;
    }

    public static NBTTagCompound e(NBTTagCompound var0) {
        int var1 = SharedConstants.b().a().b();
        return GameProfileSerializer.a(var0, var1);
    }

    public static NBTTagCompound a(NBTTagCompound var0, int var1) {
        var0.a("DataVersion", var1);
        return var0;
    }

    public static Dynamic<NBTBase> a(Dynamic<NBTBase> var0) {
        int var1 = SharedConstants.b().a().b();
        return GameProfileSerializer.a(var0, var1);
    }

    public static Dynamic<NBTBase> a(Dynamic<NBTBase> var0, int var1) {
        return var0.set("DataVersion", var0.createInt(var1));
    }

    public static void a(ValueOutput var0) {
        int var1 = SharedConstants.b().a().b();
        GameProfileSerializer.a(var0, var1);
    }

    public static void a(ValueOutput var0, int var1) {
        var0.a("DataVersion", var1);
    }

    public static int b(NBTTagCompound var0, int var1) {
        return var0.b("DataVersion", var1);
    }

    public static int b(Dynamic<?> var0, int var1) {
        return var0.get("DataVersion").asInt(var1);
    }

    private static /* synthetic */ void a(NBTTagList var0, NBTTagList var1, NBTTagList var2) {
        NBTTagCompound var3 = new NBTTagCompound();
        for (int var4 = 0; var4 < var2.size(); ++var4) {
            var3.a(var0.m(var4).orElseThrow(), GameProfileSerializer.d(var2.a(var4).orElseThrow()));
        }
        var1.add(var3);
    }
}

