/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;

public class NBTCompressedStreamTools {
    private static final OpenOption[] a = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static NBTTagCompound a(Path path, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTTagCompound nbttagcompound;
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputstream1 = new FastBufferedInputStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.a(inputstream1, nbtreadlimiter);
        }
        return nbttagcompound;
    }

    private static DataInputStream a(InputStream inputstream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(inputstream)));
    }

    private static DataOutputStream a(OutputStream outputstream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputstream)));
    }

    public static NBTTagCompound a(InputStream inputstream, NBTReadLimiter nbtreadlimiter) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.a(inputstream);){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(datainputstream, nbtreadlimiter);
            return nBTTagCompound;
        }
    }

    public static void a(Path path, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputstream1 = new FastBufferedInputStream(inputstream);){
            NBTCompressedStreamTools.a(inputstream1, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void a(InputStream inputstream, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.a(inputstream);){
            NBTCompressedStreamTools.a((DataInput)datainputstream, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void a(NBTTagCompound nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, a);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);){
            NBTCompressedStreamTools.a(nbttagcompound, outputstream1);
        }
    }

    public static void a(NBTTagCompound nbttagcompound, OutputStream outputstream) throws IOException {
        try (DataOutputStream dataoutputstream = NBTCompressedStreamTools.a(outputstream);){
            NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)dataoutputstream);
        }
    }

    public static void b(NBTTagCompound nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, a);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(outputstream1);){
            NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound a(Path path) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream datainputstream = new DataInputStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.a(datainputstream, NBTReadLimiter.a());
        }
        return nbttagcompound;
    }

    public static NBTTagCompound a(DataInput datainput) throws IOException {
        return NBTCompressedStreamTools.a(datainput, NBTReadLimiter.a());
    }

    public static NBTTagCompound a(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTBase nbtbase = NBTCompressedStreamTools.c(datainput, nbtreadlimiter);
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException {
        NBTCompressedStreamTools.c(nbttagcompound, dataoutput);
    }

    public static void a(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.a(datainput.readByte());
        if (nbttagtype == NBTTagEnd.a) {
            if (streamtagvisitor.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                streamtagvisitor.a();
            }
        } else {
            switch (streamtagvisitor.b(nbttagtype)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(datainput);
                    nbttagtype.b(datainput, nbtreadlimiter);
                    break;
                }
                case a: {
                    NBTTagString.a(datainput);
                    nbttagtype.a(datainput, streamtagvisitor, nbtreadlimiter);
                }
            }
        }
    }

    public static NBTBase b(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        return b0 == 0 ? NBTTagEnd.b : NBTCompressedStreamTools.a(datainput, nbtreadlimiter, b0);
    }

    public static void a(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.b());
        if (nbtbase.b() != 0) {
            nbtbase.a(dataoutput);
        }
    }

    public static void b(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.b());
        if (nbtbase.b() != 0) {
            dataoutput.writeUTF("");
            nbtbase.a(dataoutput);
        }
    }

    public static void c(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        NBTCompressedStreamTools.b(nbtbase, new a(dataoutput));
    }

    @VisibleForTesting
    public static NBTBase c(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        if (b0 == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(datainput);
        return NBTCompressedStreamTools.a(datainput, nbtreadlimiter, b0);
    }

    private static NBTBase a(DataInput datainput, NBTReadLimiter nbtreadlimiter, byte b0) {
        try {
            return NBTTagTypes.a(b0).c(datainput, nbtreadlimiter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.a(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("NBT Tag");
            crashreportsystemdetails.a("Tag type", b0);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class a
    extends DelegateDataOutput {
        public a(DataOutput dataoutput) {
            super(dataoutput);
        }

        @Override
        public void writeUTF(String s2) throws IOException {
            try {
                super.writeUTF(s2);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                SystemUtils.a("Failed to write NBT String", (Throwable)utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

