/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagByteArray
implements NBTList {
    private static final int b = 24;
    public static final NBTTagType<NBTTagByteArray> a = new NBTTagType.b<NBTTagByteArray>(){

        public NBTTagByteArray a(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            return new NBTTagByteArray(1.d(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
            return streamtagvisitor.a(1.d(datainput, nbtreadlimiter));
        }

        private static byte[] d(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            nbtreadlimiter.b(24L);
            int i2 = datainput.readInt();
            nbtreadlimiter.a(1L, i2);
            byte[] abyte = new byte[i2];
            datainput.readFully(abyte);
            return abyte;
        }

        @Override
        public void b(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 1);
        }

        @Override
        public String a() {
            return "BYTE[]";
        }

        @Override
        public String b() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] c;

    public NBTTagByteArray(byte[] abyte) {
        this.c = abyte;
    }

    @Override
    public void a(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.c.length);
        dataoutput.write(this.c);
    }

    @Override
    public int a() {
        return 24 + 1 * this.c.length;
    }

    @Override
    public byte b() {
        return 7;
    }

    public NBTTagType<NBTTagByteArray> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringtagvisitor = new StringTagVisitor();
        stringtagvisitor.a(this);
        return stringtagvisitor.a();
    }

    @Override
    public NBTBase d() {
        byte[] abyte = new byte[this.c.length];
        System.arraycopy(this.c, 0, abyte, 0, this.c.length);
        return new NBTTagByteArray(abyte);
    }

    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagByteArray && Arrays.equals(this.c, ((NBTTagByteArray)object).c);
    }

    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public void a(TagVisitor tagvisitor) {
        tagvisitor.a(this);
    }

    public byte[] e() {
        return this.c;
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagByte a(int i2) {
        return NBTTagByte.a(this.c[i2]);
    }

    @Override
    public boolean a(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            NBTNumber nbtnumber = (NBTNumber)nbtbase;
            this.c[i2] = nbtnumber.j();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            NBTNumber nbtnumber = (NBTNumber)nbtbase;
            this.c = ArrayUtils.add((byte[])this.c, (int)i2, (byte)nbtnumber.j());
            return true;
        }
        return false;
    }

    public NBTTagByte b(int i2) {
        byte b0 = this.c[i2];
        this.c = ArrayUtils.remove((byte[])this.c, (int)i2);
        return NBTTagByte.a(b0);
    }

    @Override
    public void clear() {
        this.c = new byte[0];
    }

    @Override
    public Optional<byte[]> f() {
        return Optional.of(this.c);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.a(this.c);
    }
}

