/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.slf4j.Logger;

public final class NBTTagCompound
implements NBTBase {
    private static final Logger c = LogUtils.getLogger();
    public static final Codec<NBTTagCompound> a = Codec.PASSTHROUGH.comapFlatMap(var0 -> {
        NBTBase var1 = (NBTBase)var0.convert((DynamicOps)DynamicOpsNBT.a).getValue();
        if (var1 instanceof NBTTagCompound) {
            NBTTagCompound var2 = (NBTTagCompound)var1;
            return DataResult.success((Object)(var2 == var0.getValue() ? var2.l() : var2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf(var1));
    }, var0 -> new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)var0.l()));
    private static final int v = 48;
    private static final int w = 32;
    public static final NBTTagType<NBTTagCompound> b = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound a(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.b();
            try {
                NBTTagCompound nBTTagCompound = 1.d(var0, var1);
                return nBTTagCompound;
            }
            finally {
                var1.c();
            }
        }

        private static NBTTagCompound d(DataInput var0, NBTReadLimiter var1) throws IOException {
            byte var3;
            var1.b(48L);
            HashMap var2 = Maps.newHashMap();
            while ((var3 = var0.readByte()) != 0) {
                NBTBase var5;
                String var4 = 1.e(var0, var1);
                if (var2.put(var4, var5 = NBTTagCompound.a(NBTTagTypes.a(var3), var4, var0, var1)) != null) continue;
                var1.b(36L);
            }
            return new NBTTagCompound(var2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            var2.b();
            try {
                StreamTagVisitor.b b2 = 1.c(var0, var1, var2);
                return b2;
            }
            finally {
                var2.c();
            }
        }

        private static StreamTagVisitor.b c(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            byte var3;
            var2.b(48L);
            block13: while ((var3 = var0.readByte()) != 0) {
                NBTTagType<?> var4 = NBTTagTypes.a(var3);
                switch (var1.a(var4)) {
                    case d: {
                        return StreamTagVisitor.b.c;
                    }
                    case c: {
                        NBTTagString.a(var0);
                        var4.b(var0, var2);
                        break block13;
                    }
                    case b: {
                        NBTTagString.a(var0);
                        var4.b(var0, var2);
                        continue block13;
                    }
                    default: {
                        String var5 = 1.e(var0, var2);
                        switch (var1.a(var4, var5)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                var4.b(var0, var2);
                                break block13;
                            }
                            case b: {
                                var4.b(var0, var2);
                                continue block13;
                            }
                        }
                        var2.b(36L);
                        switch (var4.a(var0, var1, var2)) {
                            case c: {
                                return StreamTagVisitor.b.c;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (var3 != 0) {
                while ((var3 = var0.readByte()) != 0) {
                    NBTTagString.a(var0);
                    NBTTagTypes.a(var3).b(var0, var2);
                }
            }
            return var1.b();
        }

        private static String e(DataInput var0, NBTReadLimiter var1) throws IOException {
            String var2 = var0.readUTF();
            var1.b(28L);
            var1.a(2L, var2.length());
            return var2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.b();
            try {
                byte var2;
                while ((var2 = var0.readByte()) != 0) {
                    NBTTagString.a(var0);
                    NBTTagTypes.a(var2).b(var0, var1);
                }
            }
            finally {
                var1.c();
            }
        }

        @Override
        public String a() {
            return "COMPOUND";
        }

        @Override
        public String b() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ NBTBase c(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.a(dataInput, nBTReadLimiter);
        }
    };
    private final Map<String, NBTBase> x;

    NBTTagCompound(Map<String, NBTBase> var0) {
        this.x = var0;
    }

    public NBTTagCompound() {
        this(new HashMap<String, NBTBase>());
    }

    @Override
    public void a(DataOutput var0) throws IOException {
        for (String var2 : this.x.keySet()) {
            NBTBase var3 = this.x.get(var2);
            NBTTagCompound.a(var2, var3, var0);
        }
        var0.writeByte(0);
    }

    @Override
    public int a() {
        int var0 = 48;
        for (Map.Entry<String, NBTBase> var2 : this.x.entrySet()) {
            var0 += 28 + 2 * var2.getKey().length();
            var0 += 36;
            var0 += var2.getValue().a();
        }
        return var0;
    }

    public Set<String> e() {
        return this.x.keySet();
    }

    public Set<Map.Entry<String, NBTBase>> g() {
        return this.x.entrySet();
    }

    public Collection<NBTBase> h() {
        return this.x.values();
    }

    public void a(BiConsumer<String, NBTBase> var0) {
        this.x.forEach(var0);
    }

    @Override
    public byte b() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> c() {
        return b;
    }

    public int i() {
        return this.x.size();
    }

    @Nullable
    public NBTBase a(String var0, NBTBase var1) {
        return this.x.put(var0, var1);
    }

    public void a(String var0, byte var1) {
        this.x.put(var0, NBTTagByte.a(var1));
    }

    public void a(String var0, short var1) {
        this.x.put(var0, NBTTagShort.a(var1));
    }

    public void a(String var0, int var1) {
        this.x.put(var0, NBTTagInt.a(var1));
    }

    public void a(String var0, long var1) {
        this.x.put(var0, NBTTagLong.a(var1));
    }

    public void a(String var0, float var1) {
        this.x.put(var0, NBTTagFloat.a(var1));
    }

    public void a(String var0, double var1) {
        this.x.put(var0, NBTTagDouble.a(var1));
    }

    public void a(String var0, String var1) {
        this.x.put(var0, NBTTagString.a(var1));
    }

    public void a(String var0, byte[] var1) {
        this.x.put(var0, new NBTTagByteArray(var1));
    }

    public void a(String var0, int[] var1) {
        this.x.put(var0, new NBTTagIntArray(var1));
    }

    public void a(String var0, long[] var1) {
        this.x.put(var0, new NBTTagLongArray(var1));
    }

    public void a(String var0, boolean var1) {
        this.x.put(var0, NBTTagByte.a(var1));
    }

    @Nullable
    public NBTBase a(String var0) {
        return this.x.get(var0);
    }

    public boolean b(String var0) {
        return this.x.containsKey(var0);
    }

    private Optional<NBTBase> s(String var0) {
        return Optional.ofNullable(this.x.get(var0));
    }

    public Optional<Byte> c(String var0) {
        return this.s(var0).flatMap(NBTBase::p);
    }

    public byte b(String var0, byte var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.j();
        }
        return var1;
    }

    public Optional<Short> d(String var0) {
        return this.s(var0).flatMap(NBTBase::q);
    }

    public short b(String var0, short var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.i();
        }
        return var1;
    }

    public Optional<Integer> e(String var0) {
        return this.s(var0).flatMap(NBTBase::r);
    }

    public int b(String var0, int var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.h();
        }
        return var1;
    }

    public Optional<Long> f(String var0) {
        return this.s(var0).flatMap(NBTBase::s);
    }

    public long b(String var0, long var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var3 = (NBTNumber)nBTBase;
            return var3.g();
        }
        return var1;
    }

    public Optional<Float> g(String var0) {
        return this.s(var0).flatMap(NBTBase::t);
    }

    public float b(String var0, float var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)nBTBase;
            return var2.l();
        }
        return var1;
    }

    public Optional<Double> h(String var0) {
        return this.s(var0).flatMap(NBTBase::u);
    }

    public double b(String var0, double var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber var3 = (NBTNumber)nBTBase;
            return var3.k();
        }
        return var1;
    }

    public Optional<String> i(String var0) {
        return this.s(var0).flatMap(NBTBase::r_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String b(String var0, String var1) {
        NBTBase nBTBase = this.x.get(var0);
        if (!(nBTBase instanceof NBTTagString)) return var1;
        NBTTagString nBTTagString = (NBTTagString)nBTBase;
        try {
            String string = nBTTagString.k();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Optional<byte[]> j(String var0) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTTagByteArray) {
            NBTTagByteArray var1 = (NBTTagByteArray)nBTBase;
            return Optional.of(var1.e());
        }
        return Optional.empty();
    }

    public Optional<int[]> k(String var0) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray var1 = (NBTTagIntArray)nBTBase;
            return Optional.of(var1.g());
        }
        return Optional.empty();
    }

    public Optional<long[]> l(String var0) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray var1 = (NBTTagLongArray)nBTBase;
            return Optional.of(var1.g());
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> m(String var0) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound var1 = (NBTTagCompound)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagCompound n(String var0) {
        return this.m(var0).orElseGet(NBTTagCompound::new);
    }

    public Optional<NBTTagList> o(String var0) {
        NBTBase nBTBase = this.x.get(var0);
        if (nBTBase instanceof NBTTagList) {
            NBTTagList var1 = (NBTTagList)nBTBase;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public NBTTagList p(String var0) {
        return this.o(var0).orElseGet(NBTTagList::new);
    }

    public Optional<Boolean> q(String var0) {
        return this.s(var0).flatMap(NBTBase::v);
    }

    public boolean b(String var0, boolean var1) {
        return this.b(var0, var1 ? (byte)1 : 0) != 0;
    }

    public void r(String var0) {
        this.x.remove(var0);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.a(this);
        return var0.a();
    }

    public boolean j() {
        return this.x.isEmpty();
    }

    protected NBTTagCompound k() {
        return new NBTTagCompound(new HashMap<String, NBTBase>(this.x));
    }

    public NBTTagCompound l() {
        HashMap<String, NBTBase> var0 = new HashMap<String, NBTBase>();
        this.x.forEach((var1, var2) -> var0.put((String)var1, var2.d()));
        return new NBTTagCompound(var0);
    }

    @Override
    public Optional<NBTTagCompound> u_() {
        return Optional.of(this);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagCompound && Objects.equals(this.x, ((NBTTagCompound)var0).x);
    }

    public int hashCode() {
        return this.x.hashCode();
    }

    private static void a(String var0, NBTBase var1, DataOutput var2) throws IOException {
        var2.writeByte(var1.b());
        if (var1.b() == 0) {
            return;
        }
        var2.writeUTF(var0);
        var1.a(var2);
    }

    static NBTBase a(NBTTagType<?> var0, String var1, DataInput var2, NBTReadLimiter var3) {
        try {
            return var0.c(var2, var3);
        }
        catch (IOException var4) {
            CrashReport var5 = CrashReport.a(var4, "Loading NBT data");
            CrashReportSystemDetails var6 = var5.a("NBT Tag");
            var6.a("Tag name", var1);
            var6.a("Tag type", var0.a());
            throw new ReportedNbtException(var5);
        }
    }

    public NBTTagCompound a(NBTTagCompound var0) {
        for (String var2 : var0.x.keySet()) {
            NBTBase var3 = var0.x.get(var2);
            if (var3 instanceof NBTTagCompound) {
                NBTTagCompound var4 = (NBTTagCompound)var3;
                NBTBase nBTBase = this.x.get(var2);
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound var5 = (NBTTagCompound)nBTBase;
                    var5.a(var4);
                    continue;
                }
            }
            this.a(var2, var3.d());
        }
        return this;
    }

    @Override
    public void a(TagVisitor var0) {
        var0.a(this);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor var0) {
        block14: for (Map.Entry<String, NBTBase> var2 : this.x.entrySet()) {
            NBTBase var3 = var2.getValue();
            NBTTagType<?> var4 = var3.c();
            StreamTagVisitor.a var5 = var0.a(var4);
            switch (var5) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return var0.b();
                }
                case b: {
                    continue block14;
                }
            }
            var5 = var0.a(var4, var2.getKey());
            switch (var5) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return var0.b();
                }
                case b: {
                    continue block14;
                }
            }
            StreamTagVisitor.b var6 = var3.a(var0);
            switch (var6) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    return var0.b();
                }
            }
        }
        return var0.b();
    }

    public <T> void a(String var0, Codec<T> var1, T var2) {
        this.a(var0, var1, DynamicOpsNBT.a, var2);
    }

    public <T> void b(String var0, Codec<T> var1, @Nullable T var2) {
        if (var2 != null) {
            this.a(var0, var1, var2);
        }
    }

    public <T> void a(String var0, Codec<T> var1, DynamicOps<NBTBase> var2, T var3) {
        this.a(var0, (NBTBase)var1.encodeStart(var2, var3).getOrThrow());
    }

    public <T> void b(String var0, Codec<T> var1, DynamicOps<NBTBase> var2, @Nullable T var3) {
        if (var3 != null) {
            this.a(var0, var1, var2, var3);
        }
    }

    public <T> void a(MapCodec<T> var0, T var1) {
        this.a(var0, DynamicOpsNBT.a, var1);
    }

    public <T> void a(MapCodec<T> var0, DynamicOps<NBTBase> var1, T var2) {
        this.a((NBTTagCompound)var0.encoder().encodeStart(var1, var2).getOrThrow());
    }

    public <T> Optional<T> a(String var0, Codec<T> var1) {
        return this.a(var0, var1, DynamicOpsNBT.a);
    }

    public <T> Optional<T> a(String var0, Codec<T> var1, DynamicOps<NBTBase> var22) {
        NBTBase var3 = this.a(var0);
        if (var3 == null) {
            return Optional.empty();
        }
        return var1.parse(var22, (Object)var3).resultOrPartial(var2 -> c.error("Failed to read field ({}={}): {}", new Object[]{var0, var3, var2}));
    }

    public <T> Optional<T> a(MapCodec<T> var0) {
        return this.a(var0, DynamicOpsNBT.a);
    }

    public <T> Optional<T> a(MapCodec<T> var02, DynamicOps<NBTBase> var1) {
        return var02.decode(var1, (MapLike)var1.getMap((Object)this).getOrThrow()).resultOrPartial(var0 -> c.error("Failed to read value ({}): {}", (Object)this, var0));
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.l();
    }
}

