/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.TriState;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomChunkGenerator;
import org.slf4j.Logger;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> f = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> g = CompletableFuture.completedFuture(f);
    private static final byte h = -1;
    private static final byte i = 0;
    private static final byte j = 1;
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 200;
    private static final int m = 20;
    private static final int n = 10000;
    private static final int o = 128;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> p = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> q;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> r;
    private final List<ChunkGenerationTask> s;
    public final WorldServer t;
    private final LightEngineThreaded u;
    private final IAsyncTaskHandler<Runnable> v;
    private final RandomState w;
    private final ChunkGeneratorStructureState x;
    private final Supplier<WorldPersistentData> y;
    private final TicketStorage z;
    private final VillagePlace A;
    public final LongSet B;
    private boolean C;
    private final ChunkTaskDispatcher D;
    private final ChunkTaskDispatcher E;
    private final ChunkStatusUpdateListener F;
    public final a G;
    private final String H;
    private final PlayerMap I;
    public final Int2ObjectMap<EntityTracker> J;
    private final Long2ByteMap K;
    private final Long2LongMap L;
    private final LongSet M;
    private final Queue<Runnable> N;
    private final AtomicInteger O;
    public int P;
    private final WorldGenContext Q;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public PlayerChunkMap(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, IAsyncTaskHandler<Runnable> iasynctaskhandler, ILightAccess ilightaccess, ChunkGenerator chunkgenerator, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier, TicketStorage ticketstorage, int i2, boolean flag) {
        super(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.al(), "chunk"), convertable_conversionsession.a(worldserver.al()).resolve("region"), datafixer, flag);
        this.q = this.p.clone();
        this.r = new Long2ObjectLinkedOpenHashMap();
        this.s = new ArrayList<ChunkGenerationTask>();
        this.B = new LongOpenHashSet();
        this.I = new PlayerMap();
        this.J = new Int2ObjectOpenHashMap();
        this.K = new Long2ByteOpenHashMap();
        this.L = new Long2LongOpenHashMap();
        this.M = new LongLinkedOpenHashSet();
        this.N = Queues.newConcurrentLinkedQueue();
        this.O = new AtomicInteger();
        Path path = convertable_conversionsession.a(worldserver.al());
        this.H = path.getFileName().toString();
        this.t = worldserver;
        IRegistryCustom iregistrycustom = worldserver.L_();
        long j2 = worldserver.H();
        ChunkGenerator randomGenerator = chunkgenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)randomGenerator;
            this.w = RandomState.a(chunkgeneratorabstract.h().a(), iregistrycustom.f(Registries.bg), j2);
        } else {
            this.w = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.f(Registries.bg), j2);
        }
        this.x = chunkgenerator.a(iregistrycustom.f(Registries.bl), this.w, j2);
        this.v = iasynctaskhandler;
        ConsecutiveExecutor consecutiveexecutor = new ConsecutiveExecutor(executor, "worldgen");
        this.F = chunkstatusupdatelistener;
        ConsecutiveExecutor consecutiveexecutor1 = new ConsecutiveExecutor(executor, "light");
        this.D = new ChunkTaskDispatcher(consecutiveexecutor, executor);
        this.E = new ChunkTaskDispatcher(consecutiveexecutor1, executor);
        this.u = new LightEngineThreaded(ilightaccess, this, this.t.H_().g(), consecutiveexecutor1, this.E);
        this.G = new a(ticketstorage, executor, iasynctaskhandler);
        this.y = supplier;
        this.z = ticketstorage;
        this.A = new VillagePlace(new RegionStorageInfo(convertable_conversionsession.f(), worldserver.al(), "poi"), path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver.q(), worldserver);
        this.a(i2);
        this.Q = new WorldGenContext(worldserver, chunkgenerator, structuretemplatemanager, this.u, iasynctaskhandler, this::f);
    }

    private void f(ChunkCoordIntPair chunkcoordintpair) {
        this.M.add(chunkcoordintpair.a());
    }

    protected ChunkGenerator a() {
        return this.Q.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.x;
    }

    protected RandomState c() {
        return this.w;
    }

    public boolean a(EntityPlayer entityplayer, int i2, int j2) {
        return entityplayer.X().a(i2, j2) && !entityplayer.g.g.a(ChunkCoordIntPair.c(i2, j2));
    }

    private boolean b(EntityPlayer entityplayer, int i2, int j2) {
        if (!this.a(entityplayer, i2, j2)) {
            return false;
        }
        for (int k2 = -1; k2 <= 1; ++k2) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                if (k2 == 0 && l2 == 0 || this.a(entityplayer, i2 + k2, j2 + l2)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded d() {
        return this.u;
    }

    @Nullable
    public PlayerChunk a(long i2) {
        return (PlayerChunk)this.p.get(i2);
    }

    @Nullable
    protected PlayerChunk b(long i2) {
        return (PlayerChunk)this.q.get(i2);
    }

    @Nullable
    public ChunkStatus c(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk != null ? playerchunk.u() : null;
    }

    protected IntSupplier d(long i2) {
        return () -> {
            PlayerChunk playerchunk = this.b(i2);
            return playerchunk == null ? ChunkTaskQueue.a - 1 : Math.min(playerchunk.k(), ChunkTaskQueue.a - 1);
        };
    }

    public String a(ChunkCoordIntPair chunkcoordintpair) {
        PlayerChunk playerchunk = this.b(chunkcoordintpair.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.j() + "\n";
        ChunkStatus chunkstatus = playerchunk.u();
        IChunkAccess ichunkaccess = playerchunk.p();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.b() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.n().b() + String.valueOf(ichunkaccess.n()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.s();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s2 + "\u00a7r";
    }

    CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk playerchunk, int i2, IntFunction<ChunkStatus> intfunction) {
        if (i2 == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.a(chunkstatus, this).thenApply(chunkresult -> chunkresult.a(List::of));
        }
        int j2 = MathHelper.i(i2 * 2 + 1);
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> list = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>(j2);
        ChunkCoordIntPair chunkcoordintpair = playerchunk.r();
        for (int k2 = -i2; k2 <= i2; ++k2) {
            for (int l2 = -i2; l2 <= i2; ++l2) {
                int i1 = Math.max(Math.abs(l2), Math.abs(k2));
                long j1 = ChunkCoordIntPair.c(chunkcoordintpair.h + l2, chunkcoordintpair.i + k2);
                PlayerChunk playerchunk1 = this.a(j1);
                if (playerchunk1 == null) {
                    return g;
                }
                ChunkStatus chunkstatus1 = intfunction.apply(i1);
                list.add(playerchunk1.a(chunkstatus1, this));
            }
        }
        return SystemUtils.d(list).thenApply(list1 -> {
            ArrayList<IChunkAccess> list2 = new ArrayList<IChunkAccess>(list1.size());
            for (ChunkResult chunkresult : list1) {
                if (chunkresult == null) {
                    throw this.a(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess ichunkaccess = chunkresult.b(null);
                if (ichunkaccess == null) {
                    return f;
                }
                list2.add(ichunkaccess);
            }
            return ChunkResult.a(list2);
        });
    }

    public ReportedException a(IllegalStateException illegalstateexception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.t().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.r()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.p.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.q.values().forEach(consumer);
        CrashReport crashreport = CrashReport.a(illegalstateexception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", s2);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk playerchunk) {
        return this.a(playerchunk, 2, (int i2) -> ChunkStatus.n).thenApply(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)));
    }

    @Nullable
    PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
        if (!ChunkLevel.f(k2) && !ChunkLevel.f(j2)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.a(j2);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.f(j2)) {
                this.B.add(i2);
            } else {
                this.B.remove(i2);
            }
        }
        if (ChunkLevel.f(j2) && playerchunk == null) {
            playerchunk = (PlayerChunk)this.r.remove(i2);
            if (playerchunk != null) {
                playerchunk.a(j2);
            } else {
                playerchunk = new PlayerChunk(new ChunkCoordIntPair(i2), j2, this.t, this.u, this::a, this);
            }
            this.p.put(i2, (Object)playerchunk);
            this.C = true;
        }
        return playerchunk;
    }

    private void a(ChunkCoordIntPair chunkcoordintpair, IntSupplier intsupplier, int i2, IntConsumer intconsumer) {
        this.D.onLevelChange(chunkcoordintpair, intsupplier, i2, intconsumer);
        this.E.onLevelChange(chunkcoordintpair, intsupplier, i2, intconsumer);
    }

    @Override
    public void close() throws IOException {
        try {
            this.D.close();
            this.E.close();
            this.A.close();
        }
        finally {
            super.close();
        }
    }

    protected void a(boolean flag) {
        if (flag) {
            List<PlayerChunk> list = this.q.values().stream().filter(PlayerChunk::l).peek(PlayerChunk::m).toList();
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    IAsyncTaskHandler<Runnable> iasynctaskhandler = this.v;
                    Objects.requireNonNull(playerchunk);
                    iasynctaskhandler.b(playerchunk::h);
                    return playerchunk.p();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::a).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.A.a();
            this.b(() -> true);
            this.m();
        } else {
            this.L.clear();
            long i2 = SystemUtils.c();
            for (PlayerChunk playerchunk2 : this.q.values()) {
                this.a(playerchunk2, i2);
            }
        }
    }

    protected void a(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("poi");
        this.A.a(booleansupplier);
        gameprofilerfiller.b("chunk_unload");
        if (!this.t.x()) {
            this.b(booleansupplier);
        }
        gameprofilerfiller.c();
    }

    public boolean e() {
        return this.u.O_() || !this.r.isEmpty() || !this.p.isEmpty() || this.A.b() || !this.B.isEmpty() || !this.N.isEmpty() || this.D.a() || this.E.a() || this.G.d();
    }

    private void b(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.B.iterator();
        while (longiterator.hasNext()) {
            long i2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.p.get(i2);
            if (playerchunk != null) {
                this.p.remove(i2);
                this.r.put(i2, (Object)playerchunk);
                this.C = true;
                this.a(i2, playerchunk);
            }
            longiterator.remove();
        }
        for (int j2 = Math.max(0, this.N.size() - 2000); (j2 > 0 || booleansupplier.getAsBoolean()) && (runnable = this.N.poll()) != null; --j2) {
            runnable.run();
        }
        this.c(booleansupplier);
    }

    private void c(BooleanSupplier booleansupplier) {
        long i2 = SystemUtils.c();
        int j2 = 0;
        LongIterator longiterator = this.M.iterator();
        while (j2 < 20 && this.O.get() < 128 && booleansupplier.getAsBoolean() && longiterator.hasNext()) {
            IChunkAccess ichunkaccess;
            long k2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.q.get(k2);
            IChunkAccess iChunkAccess = ichunkaccess = playerchunk != null ? playerchunk.p() : null;
            if (ichunkaccess != null && ichunkaccess.m()) {
                if (!this.a(playerchunk, i2)) continue;
                ++j2;
                longiterator.remove();
                continue;
            }
            longiterator.remove();
        }
    }

    private void a(long i2, PlayerChunk playerchunk) {
        CompletableFuture<?> completablefuture = playerchunk.g();
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture1 = playerchunk.g();
            if (completablefuture1 != completablefuture) {
                this.a(i2, playerchunk);
            } else {
                IChunkAccess ichunkaccess = playerchunk.p();
                if (this.r.remove(i2, (Object)playerchunk) && ichunkaccess != null) {
                    if (ichunkaccess instanceof Chunk) {
                        Chunk chunk = (Chunk)ichunkaccess;
                        chunk.b(false);
                    }
                    this.a(ichunkaccess);
                    if (ichunkaccess instanceof Chunk) {
                        Chunk chunk1 = (Chunk)ichunkaccess;
                        this.t.b(chunk1);
                    }
                    this.u.a(ichunkaccess.f());
                    this.u.b();
                    this.L.remove(ichunkaccess.f().a());
                }
            }
        };
        Queue<Runnable> queue = this.N;
        Objects.requireNonNull(this.N);
        ((CompletableFuture)completablefuture.thenRunAsync(runnable, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                k.error("Failed to save chunk {}", (Object)playerchunk.r(), throwable);
            }
        });
    }

    protected boolean f() {
        if (!this.C) {
            return false;
        }
        this.q = this.p.clone();
        this.C = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> g(ChunkCoordIntPair chunkcoordintpair) {
        CompletionStage completablefuture = this.k(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> {
            SerializableChunkData serializablechunkdata = SerializableChunkData.a((LevelHeightAccessor)this.t, this.t.ao(), nbttagcompound);
            if (serializablechunkdata == null) {
                k.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return serializablechunkdata;
        }), SystemUtils.h().a("parseChunk"));
        CompletableFuture<?> completablefuture1 = this.A.a(chunkcoordintpair);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)completablefuture).thenCombine(completablefuture1, (optional, object) -> optional)).thenApplyAsync(optional -> {
            Profiler.a().f("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk ichunkaccess = ((SerializableChunkData)optional.get()).a(this.t, this.A, this.o(), chunkcoordintpair);
                this.a(chunkcoordintpair, ((IChunkAccess)ichunkaccess).n().d());
                return ichunkaccess;
            }
            return this.h(chunkcoordintpair);
        }, (Executor)this.v)).exceptionallyAsync(throwable -> this.a((Throwable)throwable, chunkcoordintpair), (Executor)this.v);
    }

    private IChunkAccess a(Throwable throwable, ChunkCoordIntPair chunkcoordintpair) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.t.q().a(throwable3, this.o(), chunkcoordintpair);
            return this.h(chunkcoordintpair);
        }
        CrashReport crashreport = CrashReport.a(throwable, "Exception loading chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk being loaded");
        crashreportsystemdetails.a("pos", chunkcoordintpair);
        this.i(chunkcoordintpair);
        throw new ReportedException(crashreport);
    }

    private IChunkAccess h(ChunkCoordIntPair chunkcoordintpair) {
        this.i(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, ChunkConverter.a, this.t, this.t.ao(), null);
    }

    private void i(ChunkCoordIntPair chunkcoordintpair) {
        this.K.put(chunkcoordintpair.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkcoordintpair, ChunkType chunktype) {
        return this.K.put(chunkcoordintpair.a(), (byte)(chunktype == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder e(long i2) {
        PlayerChunk playerchunk = (PlayerChunk)this.p.get(i2);
        playerchunk.n();
        return playerchunk;
    }

    @Override
    public void a(GenerationChunkHolder generationchunkholder) {
        generationchunkholder.o();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder generationchunkholder, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d) {
        ChunkCoordIntPair chunkcoordintpair = generationchunkholder.r();
        if (chunkstep.a() == ChunkStatus.c) {
            return this.g(chunkcoordintpair);
        }
        try {
            GenerationChunkHolder generationchunkholder1 = staticcache2d.a(chunkcoordintpair.h, chunkcoordintpair.i);
            IChunkAccess ichunkaccess = generationchunkholder1.a(chunkstep.a().c());
            if (ichunkaccess == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            return chunkstep.a(this.Q, staticcache2d, ichunkaccess);
        }
        catch (Exception exception) {
            exception.getStackTrace();
            CrashReport crashreport = CrashReport.a(exception, "Exception generating new chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk to be generated");
            crashreportsystemdetails.a("Status being generated", () -> chunkstep.a().f());
            crashreportsystemdetails.a("Location", String.format(Locale.ROOT, "%d,%d", chunkcoordintpair.h, chunkcoordintpair.i));
            crashreportsystemdetails.a("Position hash", ChunkCoordIntPair.c(chunkcoordintpair.h, chunkcoordintpair.i));
            crashreportsystemdetails.a("Generator", this.a());
            this.v.execute(() -> {
                throw new ReportedException(crashreport);
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus chunkstatus, ChunkCoordIntPair chunkcoordintpair) {
        ChunkGenerationTask chunkgenerationtask = ChunkGenerationTask.a((GeneratingChunkMap)this, chunkstatus, chunkcoordintpair);
        this.s.add(chunkgenerationtask);
        return chunkgenerationtask;
    }

    private void a(ChunkGenerationTask chunkgenerationtask) {
        GenerationChunkHolder generationchunkholder = chunkgenerationtask.c();
        ChunkTaskDispatcher chunktaskdispatcher = this.D;
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture = chunkgenerationtask.a();
            if (completablefuture != null) {
                completablefuture.thenRun(() -> this.a(chunkgenerationtask));
            }
        };
        long i2 = generationchunkholder.r().a();
        Objects.requireNonNull(generationchunkholder);
        chunktaskdispatcher.a(runnable, i2, generationchunkholder::k);
    }

    @Override
    public void g() {
        this.s.forEach(this::a);
        this.s.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk playerchunk) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> completablefuture = this.a(playerchunk, 1, (int i2) -> ChunkStatus.n);
        return completablefuture.thenApplyAsync(chunkresult -> chunkresult.a((T list) -> {
            Chunk chunk = (Chunk)list.get(list.size() / 2);
            chunk.a(this.t);
            this.t.c(chunk);
            CompletableFuture<?> completablefuture1 = playerchunk.f();
            if (completablefuture1.isDone()) {
                this.a(playerchunk, chunk);
            } else {
                completablefuture1.thenAcceptAsync(object -> this.a(playerchunk, chunk), (Executor)this.v);
            }
            return chunk;
        }), (Executor)this.v);
    }

    private void a(PlayerChunk playerchunk, Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        for (EntityPlayer entityplayer : this.I.a()) {
            if (!entityplayer.X().a(chunkcoordintpair)) continue;
            PlayerChunkMap.a(entityplayer, chunk);
        }
        this.t.n().a(playerchunk);
        this.t.U().a(chunk);
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk playerchunk) {
        return this.a(playerchunk, 1, ChunkLevel::b).thenApply(chunkresult -> chunkresult.a((T list) -> (Chunk)list.get(list.size() / 2)));
    }

    Stream<PlayerChunk> a(ChunkStatus chunkstatus) {
        int i2 = ChunkLevel.a(chunkstatus);
        return this.q.values().stream().filter(playerchunk -> playerchunk.j() <= i2);
    }

    private boolean a(PlayerChunk playerchunk, long i2) {
        if (playerchunk.l() && playerchunk.h()) {
            IChunkAccess ichunkaccess = playerchunk.p();
            if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
                return false;
            }
            if (!ichunkaccess.m()) {
                return false;
            }
            long j2 = ichunkaccess.f().a();
            long k2 = this.L.getOrDefault(j2, -1L);
            if (i2 < k2) {
                return false;
            }
            boolean flag = this.a(ichunkaccess);
            playerchunk.m();
            if (flag) {
                this.L.put(j2, i2 + 10000L);
            }
            return flag;
        }
        return false;
    }

    public boolean a(IChunkAccess ichunkaccess) {
        this.A.b(ichunkaccess.f());
        if (!ichunkaccess.j()) {
            return false;
        }
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        try {
            ChunkStatus chunkstatus = ichunkaccess.n();
            if (chunkstatus.d() != ChunkType.b) {
                if (this.j(chunkcoordintpair)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.c && ichunkaccess.g().values().stream().noneMatch(StructureStart::b)) {
                    return false;
                }
            }
            Profiler.a().f("chunkSave");
            this.O.incrementAndGet();
            SerializableChunkData serializablechunkdata = SerializableChunkData.a(this.t, ichunkaccess);
            Objects.requireNonNull(serializablechunkdata);
            CompletableFuture<NBTTagCompound> completablefuture = CompletableFuture.supplyAsync(serializablechunkdata::a, SystemUtils.h());
            Objects.requireNonNull(completablefuture);
            this.a(chunkcoordintpair, completablefuture::join).handle((ovoid, throwable) -> {
                if (throwable != null) {
                    this.t.q().b((Throwable)throwable, this.o(), chunkcoordintpair);
                }
                this.O.decrementAndGet();
                return null;
            });
            this.a(chunkcoordintpair, chunkstatus.d());
            return true;
        }
        catch (Exception exception) {
            this.t.q().b(exception, this.o(), chunkcoordintpair);
            return false;
        }
    }

    private boolean j(ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.K.get(chunkcoordintpair.a());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.k(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.i(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            k.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.i(chunkcoordintpair);
            return false;
        }
        ChunkType chunktype = SerializableChunkData.a(nbttagcompound).d();
        return this.a(chunkcoordintpair, chunktype) == 1;
    }

    protected void a(int i2) {
        int j2 = MathHelper.a(i2, 2, 32);
        if (j2 != this.P) {
            this.P = j2;
            this.G.a(this.P);
            for (EntityPlayer entityplayer : this.I.a()) {
                this.e(entityplayer);
            }
        }
    }

    int b(EntityPlayer entityplayer) {
        return MathHelper.a(entityplayer.H(), 2, this.P);
    }

    private void a(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        Chunk chunk = this.f(chunkcoordintpair.a());
        if (chunk != null) {
            PlayerChunkMap.a(entityplayer, chunk);
        }
    }

    private static void a(EntityPlayer entityplayer, Chunk chunk) {
        entityplayer.g.g.a(chunk);
    }

    private static void b(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        entityplayer.g.g.a(entityplayer, chunkcoordintpair);
    }

    @Nullable
    public Chunk f(long i2) {
        PlayerChunk playerchunk = this.b(i2);
        return playerchunk == null ? null : playerchunk.e();
    }

    public int h() {
        return this.q.size();
    }

    public ChunkMapDistance i() {
        return this.G;
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        for (Long2ObjectMap.Entry long2objectmap_entry : this.q.long2ObjectEntrySet()) {
            long i2 = long2objectmap_entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)long2objectmap_entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.p());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.a(chunkcoordintpair.h, chunkcoordintpair.i, playerchunk.j(), optional.isPresent(), optional.map(IChunkAccess::n).orElse(null), optional1.map(Chunk::G).orElse(null), PlayerChunkMap.a(playerchunk.c()), PlayerChunkMap.a(playerchunk.a()), PlayerChunkMap.a(playerchunk.b()), this.z.b(i2, false), this.b(chunkcoordintpair), optional1.map(chunk -> chunk.J().size()).orElse(0), this.z.b(i2, true), this.G.a(i2, true), optional1.map(chunk -> chunk.q().a()).orElse(0), optional1.map(chunk -> chunk.r().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> completablefuture) {
        try {
            ChunkResult chunkresult = completablefuture.getNow(null);
            return chunkresult != null ? (chunkresult.a() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> k(ChunkCoordIntPair chunkcoordintpair) {
        return this.d(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkcoordintpair)), SystemUtils.h().a("upgradeChunk"));
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.t.getTypeKey(), this.y, nbttagcompound, this.a().c(), chunkcoordintpair, this.t);
    }

    void a(List<Chunk> list) {
        LongIterator longiterator = this.G.b();
        while (longiterator.hasNext()) {
            Chunk chunk;
            PlayerChunk playerchunk = (PlayerChunk)this.q.get(longiterator.nextLong());
            if (playerchunk == null || (chunk = playerchunk.d()) == null || !this.l(playerchunk.r())) continue;
            list.add(chunk);
        }
    }

    void a(Consumer<Chunk> consumer) {
        this.G.a(i2 -> {
            Chunk chunk;
            PlayerChunk playerchunk = (PlayerChunk)this.q.get(i2);
            if (playerchunk != null && (chunk = playerchunk.d()) != null) {
                consumer.accept(chunk);
            }
        });
    }

    boolean b(ChunkCoordIntPair chunkcoordintpair) {
        TriState tristate = this.G.e(chunkcoordintpair.a());
        return tristate == TriState.c ? this.l(chunkcoordintpair) : tristate.a(true);
    }

    private boolean l(ChunkCoordIntPair chunkcoordintpair) {
        for (EntityPlayer entityplayer : this.I.a()) {
            if (!this.c(entityplayer, chunkcoordintpair)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair chunkcoordintpair) {
        long i2 = chunkcoordintpair.a();
        if (!this.G.e(i2).a(true)) {
            return List.of();
        }
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.I.a()) {
            if (!this.c(entityplayer, chunkcoordintpair)) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    private boolean c(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        if (entityplayer.at()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer.dD());
        return d0 < 16384.0;
    }

    private static double a(ChunkCoordIntPair chunkcoordintpair, Vec3D vec3d) {
        double d0 = SectionPosition.a(chunkcoordintpair.h, 8);
        double d1 = SectionPosition.a(chunkcoordintpair.i, 8);
        double d2 = d0 - vec3d.g;
        double d3 = d1 - vec3d.i;
        return d2 * d2 + d3 * d3;
    }

    private boolean c(EntityPlayer entityplayer) {
        return entityplayer.at() && !this.t.S().c(GameRules.s);
    }

    void a(EntityPlayer entityplayer, boolean flag) {
        boolean flag1 = this.c(entityplayer);
        boolean flag2 = this.I.d(entityplayer);
        if (flag) {
            this.I.a(entityplayer, flag1);
            this.d(entityplayer);
            if (!flag1) {
                this.G.a(SectionPosition.a(entityplayer), entityplayer);
            }
            entityplayer.a(ChunkTrackingView.a);
            this.e(entityplayer);
        } else {
            SectionPosition sectionposition = entityplayer.W();
            this.I.a(entityplayer);
            if (!flag2) {
                this.G.b(sectionposition, entityplayer);
            }
            this.a(entityplayer, ChunkTrackingView.a);
        }
    }

    private void d(EntityPlayer entityplayer) {
        SectionPosition sectionposition = SectionPosition.a(entityplayer);
        entityplayer.a(sectionposition);
    }

    public void a(EntityPlayer entityplayer) {
        boolean flag2;
        for (EntityTracker playerchunkmap_entitytracker : this.J.values()) {
            if (playerchunkmap_entitytracker.c == entityplayer) {
                playerchunkmap_entitytracker.a(this.t.C());
                continue;
            }
            playerchunkmap_entitytracker.b(entityplayer);
        }
        SectionPosition sectionposition = entityplayer.W();
        SectionPosition sectionposition1 = SectionPosition.a(entityplayer);
        boolean flag = this.I.e(entityplayer);
        boolean flag1 = this.c(entityplayer);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.d(entityplayer);
            if (!flag) {
                this.G.b(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.G.a(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.I.b(entityplayer);
            }
            if (flag && !flag1) {
                this.I.c(entityplayer);
            }
            this.e(entityplayer);
        }
    }

    private void e(EntityPlayer entityplayer) {
        ChunkTrackingView.a chunktrackingview_a;
        ChunkCoordIntPair chunkcoordintpair = entityplayer.dH();
        int i2 = this.b(entityplayer);
        ChunkTrackingView chunktrackingview = entityplayer.X();
        if (chunktrackingview instanceof ChunkTrackingView.a && (chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview).a().equals(chunkcoordintpair) && chunktrackingview_a.b() == i2) {
            return;
        }
        this.a(entityplayer, ChunkTrackingView.a(chunkcoordintpair, i2));
    }

    private void a(EntityPlayer entityplayer, ChunkTrackingView chunktrackingview) {
        if (entityplayer.A() == this.t) {
            ChunkTrackingView chunktrackingview1 = entityplayer.X();
            if (chunktrackingview instanceof ChunkTrackingView.a) {
                ChunkTrackingView.a chunktrackingview_a1;
                ChunkTrackingView.a chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview;
                if (!(chunktrackingview1 instanceof ChunkTrackingView.a) || !(chunktrackingview_a1 = (ChunkTrackingView.a)chunktrackingview1).a().equals(chunktrackingview_a.a())) {
                    entityplayer.g.b(new PacketPlayOutViewCentre(chunktrackingview_a.a().h, chunktrackingview_a.a().i));
                }
            }
            ChunkTrackingView.a(chunktrackingview1, chunktrackingview, chunkcoordintpair -> this.a(entityplayer, (ChunkCoordIntPair)chunkcoordintpair), chunkcoordintpair -> PlayerChunkMap.b(entityplayer, chunkcoordintpair));
            entityplayer.a(chunktrackingview);
        }
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Set<EntityPlayer> set = this.I.a();
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            if ((!flag || !this.b(entityplayer, chunkcoordintpair.h, chunkcoordintpair.i)) && (flag || !this.a(entityplayer, chunkcoordintpair.h, chunkcoordintpair.i))) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    protected void a(Entity entity) {
        EntityTypes<?> entitytypes;
        int i2;
        if (!(entity instanceof EntityComplexPart) && (i2 = (entitytypes = entity.ax()).o() * 16) != 0) {
            int j2 = entitytypes.p();
            if (this.J.containsKey(entity.az())) {
                throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
            }
            EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
            this.J.put(entity.az(), (Object)playerchunkmap_entitytracker);
            playerchunkmap_entitytracker.a(this.t.C());
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                this.a(entityplayer, true);
                for (EntityTracker playerchunkmap_entitytracker1 : this.J.values()) {
                    if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                    playerchunkmap_entitytracker1.b(entityplayer);
                }
            }
        }
    }

    protected void b(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.J.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.J.remove(entity.az())) != null) {
            playerchunkmap_entitytracker1.a();
        }
    }

    protected void j() {
        for (EntityPlayer entityplayer : this.I.a()) {
            this.e(entityplayer);
        }
        ArrayList list = Lists.newArrayList();
        List<EntityPlayer> list1 = this.t.C();
        for (EntityTracker playerchunkmap_entitytracker : this.J.values()) {
            boolean flag;
            SectionPosition sectionposition = playerchunkmap_entitytracker.e;
            SectionPosition sectionposition1 = SectionPosition.a(playerchunkmap_entitytracker.c);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.a(list1);
                Entity entity = playerchunkmap_entitytracker.c;
                if (entity instanceof EntityPlayer) {
                    list.add((EntityPlayer)entity);
                }
                playerchunkmap_entitytracker.e = sectionposition1;
            }
            if (!flag && !this.G.c(sectionposition1.r().a())) continue;
            playerchunkmap_entitytracker.b.a();
        }
        if (!list.isEmpty()) {
            for (EntityTracker playerchunkmap_entitytracker1 : this.J.values()) {
                playerchunkmap_entitytracker1.a(list);
            }
        }
    }

    public void a(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.az());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    public void a(Entity entity, Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.az());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet, predicate);
        }
    }

    protected void b(Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.az());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public boolean c(Entity entity) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.J.get(entity.az());
        return playerchunkmap_entitytracker != null ? !playerchunkmap_entitytracker.f.isEmpty() : false;
    }

    public void a(EntityPlayer entityplayer, Consumer<Entity> consumer) {
        for (EntityTracker playerchunkmap_entitytracker : this.J.values()) {
            if (!playerchunkmap_entitytracker.f.contains(entityplayer.g)) continue;
            consumer.accept(playerchunkmap_entitytracker.c);
        }
    }

    public void b(List<IChunkAccess> list) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : list) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.t.d(chunkcoordintpair.h, chunkcoordintpair.i);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.g.b(ClientboundChunksBiomesPacket.a(list1)));
    }

    protected VillagePlace k() {
        return this.A;
    }

    public String l() {
        return this.H;
    }

    void a(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.F.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = i2 + 1;
        ChunkCoordIntPair.a(chunkcoordintpair, j2).forEach(chunkcoordintpair1 -> {
            PlayerChunk playerchunk = this.b(chunkcoordintpair1.a());
            if (playerchunk != null) {
                playerchunk.a(this.u.a(chunkcoordintpair1.h, chunkcoordintpair1.i));
            }
        });
    }

    public void b(Consumer<Chunk> consumer) {
        for (PlayerChunk playerchunk : this.q.values()) {
            Chunk chunk = playerchunk.e();
            if (chunk == null) continue;
            consumer.accept(chunk);
        }
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class a
    extends ChunkMapDistance {
        protected a(TicketStorage ticketstorage, Executor executor, Executor executor1) {
            super(ticketstorage, executor, executor1);
        }

        @Override
        protected boolean a(long i2) {
            return PlayerChunkMap.this.B.contains(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk b(long i2) {
            return PlayerChunkMap.this.a(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
            return PlayerChunkMap.this.a(i2, j2, playerchunk, k2);
        }
    }

    public class EntityTracker
    implements EntityTrackerEntry.a {
        public final EntityTrackerEntry b;
        final Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = Sets.newIdentityHashSet();

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.t, entity, j2, flag, this, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.az() == this.c.az() : false;
        }

        public int hashCode() {
            return this.c.az();
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.b(packet);
            }
        }

        @Override
        public void b(Packet<? super PacketListenerPlayOut> packet) {
            this.a(packet);
            Entity entity = this.c;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.g.b(packet);
            }
        }

        @Override
        public void a(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                if (!predicate.test(serverplayerconnection.o())) continue;
                serverplayerconnection.b(packet);
            }
        }

        @Override
        public void sendToTrackingPlayersFilteredAndSelf(Packet<? super PacketListenerPlayOut> packet, Predicate<EntityPlayer> predicate) {
            this.a(packet, predicate);
            Entity entity = this.c;
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.g.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.o());
            }
        }

        public void a(EntityPlayer entityplayer) {
            if (this.f.remove(entityplayer.g)) {
                this.b.a(entityplayer);
                if (this.f.isEmpty()) {
                    PlayerChunkMap.this.t.U().b(this.c);
                }
            }
        }

        public void b(EntityPlayer entityplayer) {
            if (entityplayer != this.c) {
                boolean flag;
                Vec3D vec3d = entityplayer.dD().d(this.c.dD());
                int i2 = PlayerChunkMap.this.b(entityplayer);
                double d1 = vec3d.g * vec3d.g + vec3d.i * vec3d.i;
                double d0 = Math.min(this.b(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(entityplayer) && PlayerChunkMap.this.a(entityplayer, this.c.dH().h, this.c.dH().i);
                if (!entityplayer.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(entityplayer.g)) {
                        this.b.b(entityplayer);
                        if (this.f.size() == 1) {
                            PlayerChunkMap.this.t.U().a(this.c);
                        }
                        PlayerChunkMap.this.t.U().a(entityplayer, this.c);
                    }
                } else {
                    this.a(entityplayer);
                }
            }
        }

        private int a(int i2) {
            return PlayerChunkMap.this.t.q().c(i2);
        }

        private int b() {
            int i2 = this.d;
            for (Entity entity : this.c.dm()) {
                int j2 = entity.ax().o() * 16;
                if (j2 <= i2) continue;
                i2 = j2;
            }
            return this.a(i2);
        }

        public void a(List<EntityPlayer> list) {
            for (EntityPlayer entityplayer : list) {
                this.b(entityplayer);
            }
        }
    }
}

