/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomClickActionPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener,
CraftPlayer.TransferCookieConnection {
    private static final Logger f = LogUtils.getLogger();
    public static final int b = 15000;
    private static final int g = 15000;
    private static final IChatBaseComponent h = IChatBaseComponent.c("disconnect.timeout");
    static final IChatBaseComponent c = IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer d;
    protected final NetworkManager e;
    private final boolean i;
    private long j;
    private boolean k;
    private long l;
    private long m;
    private boolean n = false;
    private int o;
    private volatile boolean p = false;
    protected final EntityPlayer player;
    protected final CraftServer cserver;
    public boolean processedDisconnect;
    private static final MinecraftKey CUSTOM_REGISTER = MinecraftKey.b("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = MinecraftKey.b("unregister");

    @Override
    public boolean isTransferred() {
        return this.i;
    }

    @Override
    public EnumProtocol getProtocol() {
        return this.b();
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.b(packet);
    }

    @Override
    public void kickPlayer(IChatBaseComponent reason) {
        this.a(reason);
    }

    public ServerCommonPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        this.d = minecraftserver;
        this.e = networkmanager;
        this.j = SystemUtils.c();
        this.o = commonlistenercookie.b();
        this.i = commonlistenercookie.d();
        this.player = player;
        this.player.transferCookieConnection = this;
        this.cserver = minecraftserver.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : this.player.getBukkitEntity();
    }

    private void l() {
        if (!this.n) {
            this.m = SystemUtils.c();
            this.n = true;
        }
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        if (this.h()) {
            f.info("Stopping singleplayer server as player logged out");
            this.d.a(false);
        }
    }

    @Override
    public void a(Packet packet, Exception exception) throws ReportedException {
        ServerCommonPacketListener.super.a(packet, exception);
        this.d.a(exception, packet.a());
    }

    @Override
    public void a(ServerboundKeepAlivePacket serverboundkeepalivepacket) {
        PlayerConnectionUtils.a(serverboundkeepalivepacket, this, this.player.A());
        if (this.k && serverboundkeepalivepacket.b() == this.l) {
            int i2 = (int)(SystemUtils.c() - this.j);
            this.o = (this.o * 3 + i2) / 4;
            this.k = false;
        } else if (!this.h()) {
            this.a(h);
        }
    }

    @Override
    public void a(ServerboundPongPacket serverboundpongpacket) {
    }

    @Override
    public void a(ServerboundCustomPayloadPacket serverboundcustompayloadpacket) {
        if (!(serverboundcustompayloadpacket.b() instanceof DiscardedPayload)) {
            return;
        }
        PlayerConnectionUtils.a(serverboundcustompayloadpacket, this, this.player.A());
        MinecraftKey identifier = serverboundcustompayloadpacket.b().a().a();
        ByteBuf payload = ((DiscardedPayload)serverboundcustompayloadpacket.b()).data();
        if (identifier.equals(CUSTOM_REGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't register custom payload", (Throwable)ex);
                this.a(IChatBaseComponent.b("Invalid payload REGISTER!"));
            }
        } else if (identifier.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't unregister custom payload", (Throwable)ex);
                this.a(IChatBaseComponent.b("Invalid payload UNREGISTER!"));
            }
        } else {
            try {
                byte[] data = new byte[payload.readableBytes()];
                payload.readBytes(data);
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.player.getBukkitEntity(), identifier.toString(), data);
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.a(IChatBaseComponent.b("Invalid custom payload!"));
            }
        }
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.e.i();
    }

    @Override
    public void a(ServerboundCustomClickActionPacket serverboundcustomclickactionpacket) {
        PlayerConnectionUtils.a(serverboundcustomclickactionpacket, this, this.d.bz());
        this.d.handleCustomClickAction(serverboundcustomclickactionpacket.b(), serverboundcustomclickactionpacket.e(), this.player);
    }

    @Override
    public void a(ServerboundResourcePackPacket serverboundresourcepackpacket) {
        PlayerConnectionUtils.a(serverboundresourcepackpacket, this, this.d.bz());
        if (serverboundresourcepackpacket.e() == ServerboundResourcePackPacket.a.b && this.d.af()) {
            f.info("Disconnecting {} due to resource pack {} rejection", (Object)this.i().name(), (Object)serverboundresourcepackpacket.b());
            this.a(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"));
        }
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), serverboundresourcepackpacket.b(), PlayerResourcePackStatusEvent.Status.values()[serverboundresourcepackpacket.e().ordinal()]));
    }

    @Override
    public void a(ServerboundCookieResponsePacket serverboundcookieresponsepacket) {
        PlayerConnectionUtils.a(serverboundcookieresponsepacket, this, this.d.bz());
        if (this.player.getBukkitEntity().handleCookieResponse(serverboundcookieresponsepacket)) {
            return;
        }
        this.a(c);
    }

    protected void e() {
        Profiler.a().a("keepAlive");
        long i2 = SystemUtils.c();
        if (!this.h() && i2 - this.j >= 25000L) {
            if (this.k) {
                this.a(h);
            } else if (this.a(i2)) {
                this.k = true;
                this.j = i2;
                this.l = i2;
                this.b(new ClientboundKeepAlivePacket(this.l));
            }
        }
        Profiler.a().c();
    }

    private boolean a(long i2) {
        if (this.n) {
            if (i2 - this.m >= 15000L) {
                this.a(h);
            }
            return false;
        }
        return true;
    }

    public void f() {
        this.p = true;
    }

    public void g() {
        this.p = false;
        this.e.a();
    }

    public void b(Packet<?> packet) {
        this.a(packet, (ChannelFutureListener)null);
    }

    public void a(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener) {
        if (packet == null) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.player.compassTarget = CraftLocation.toBukkit(packet6.b().b(), this.getCraftPlayer().getWorld());
        }
        if (packet.d()) {
            this.l();
        }
        boolean flag = !this.p || !this.d.bO();
        try {
            this.e.a(packet, channelfuturelistener, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(new DisconnectionDetails(ichatbasecomponent));
    }

    public void b(final DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.b(disconnectiondetails);
                    return null;
                }
            };
            this.d.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        String leaveMessage = String.valueOf(EnumChatFormat.o) + this.player.cV() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent((Player)this.player.getBukkitEntity(), CraftChatMessage.fromComponent(disconnectiondetails.a()), leaveMessage);
        if (this.cserver.getServer().B()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        this.player.kickLeaveMessage = event.getLeaveMessage();
        this.disconnect0(new DisconnectionDetails(CraftChatMessage.fromString(event.getReason(), true)[0], disconnectiondetails.b(), disconnectiondetails.c()));
    }

    private void disconnect0(DisconnectionDetails disconnectiondetails) {
        this.e.a(new ClientboundDisconnectPacket(disconnectiondetails.a()), PacketSendListener.a(() -> this.e.a(disconnectiondetails)));
        this.a(disconnectiondetails);
        this.e.m();
        MinecraftServer minecraftserver = this.d;
        NetworkManager networkmanager = this.e;
        Objects.requireNonNull(this.e);
        minecraftserver.a(networkmanager::n);
    }

    protected boolean h() {
        return this.d.a(new NameAndId(this.i()));
    }

    protected abstract GameProfile i();

    @VisibleForDebug
    public GameProfile j() {
        return this.i();
    }

    public int k() {
        return this.o;
    }

    protected CommonListenerCookie a(ClientInformation clientinformation) {
        return new CommonListenerCookie(this.i(), this.o, clientinformation, this.i);
    }
}

