/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class JsonList<K, V extends JsonListEntry<K>> {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new GsonBuilder().setPrettyPrinting().create();
    private final File d;
    private final Map<String, V> e = Maps.newHashMap();
    protected final NotificationService a;

    public JsonList(File file, NotificationService notificationservice) {
        this.d = file;
        this.a = notificationservice;
    }

    public File c() {
        return this.d;
    }

    public boolean a(V v0) {
        String s2 = this.b(((JsonListEntry)v0).h());
        JsonListEntry v1 = (JsonListEntry)this.e.get(s2);
        if (v0.equals(v1)) {
            return false;
        }
        this.e.put(s2, v0);
        try {
            this.f();
        }
        catch (IOException ioexception) {
            b.warn("Could not save the list after adding a user.", (Throwable)ioexception);
        }
        return true;
    }

    @Nullable
    public V c(K k0) {
        this.h();
        return (V)((JsonListEntry)this.e.get(this.b(k0)));
    }

    public boolean a(K k0) {
        JsonListEntry v0 = (JsonListEntry)this.e.remove(this.b(k0));
        if (v0 == null) {
            return false;
        }
        try {
            this.f();
        }
        catch (IOException ioexception) {
            b.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
        return true;
    }

    public boolean b(JsonListEntry<K> jsonlistentry) {
        return this.a(Objects.requireNonNull(jsonlistentry.h()));
    }

    public void a() {
        this.e.clear();
        try {
            this.f();
        }
        catch (IOException ioexception) {
            b.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
    }

    public String[] b() {
        return this.e.keySet().toArray(new String[0]);
    }

    public boolean d() {
        return this.e.size() < 1;
    }

    protected String b(K k0) {
        return k0.toString();
    }

    protected boolean d(K k0) {
        this.h();
        return this.e.containsKey(this.b(k0));
    }

    private void h() {
        ArrayList list = Lists.newArrayList();
        for (JsonListEntry v0 : this.e.values()) {
            if (!v0.g()) continue;
            list.add(v0.h());
        }
        for (Object k0 : list) {
            this.e.remove(this.b(k0));
        }
    }

    protected abstract JsonListEntry<K> a(JsonObject var1);

    public Collection<V> e() {
        return this.e.values();
    }

    public void f() throws IOException {
        JsonArray jsonarray = new JsonArray();
        Stream<JsonObject> stream = this.e.values().stream().map(jsonlistentry -> {
            JsonObject jsonobject = new JsonObject();
            Objects.requireNonNull(jsonlistentry);
            return SystemUtils.a(jsonobject, jsonlistentry::a);
        });
        Objects.requireNonNull(jsonarray);
        stream.forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.d, (Charset)StandardCharsets.UTF_8);){
            c.toJson((JsonElement)jsonarray, c.newJsonWriter((Writer)bufferedwriter));
        }
    }

    public void g() throws IOException {
        if (this.d.exists()) {
            try (BufferedReader bufferedreader = Files.newReader((File)this.d, (Charset)StandardCharsets.UTF_8);){
                this.e.clear();
                JsonArray jsonarray = (JsonArray)c.fromJson((Reader)bufferedreader, JsonArray.class);
                if (jsonarray == null) {
                    return;
                }
                for (JsonElement jsonelement : jsonarray) {
                    JsonObject jsonobject = ChatDeserializer.m(jsonelement, "entry");
                    JsonListEntry<K> jsonlistentry = this.a(jsonobject);
                    if (jsonlistentry.h() == null) continue;
                    this.e.put(this.b(jsonlistentry.h()), jsonlistentry);
                }
            }
        }
    }
}

