/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public abstract class EntityLiving
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    public static final String u = "attributes";
    public static final String aN = "sleeping_pos";
    public static final String aO = "equipment";
    public static final String aP = "Brain";
    public static final String aQ = "FallFlying";
    public static final String aR = "HurtTime";
    public static final String aS = "DeathTime";
    public static final String aT = "HurtByTimestamp";
    public static final String aU = "Health";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int aV = 98;
    public static final int aW = 100;
    public static final int aX = 105;
    public static final int aY = 106;
    public static final int aZ = 6;
    public static final int ba = 100;
    private static final int r = 40;
    public static final double bb = 0.003;
    public static final double bc = 0.08;
    public static final int bd = 20;
    protected static final float be = 0.98f;
    private static final int s = 10;
    private static final int t = 2;
    public static final float bf = 0.42f;
    private static final double ca = 128.0;
    protected static final int bg = 1;
    protected static final int bh = 2;
    public static final int bi = 4;
    protected static final DataWatcherObject<Byte> bj = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> cb = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> cc = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cf = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> cg = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int ch = 15;
    protected static final EntitySize bk = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float bl = 0.5f;
    public static final float bm = 0.5f;
    public static final Predicate<EntityLiving> bn = entityliving -> {
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            ItemStack itemstack = entityhuman.a(EnumItemSlot.f);
            return !itemstack.a(TagsItem.cH);
        }
        return true;
    };
    private static final Dynamic<?> ci = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMapBase cj;
    public CombatTracker ck = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> cl = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> cm = SystemUtils.a(EnumItemSlot.class, (K enumitemslot) -> ItemStack.l);
    public boolean bo;
    private boolean cn = false;
    public EnumHand bp;
    public int bq;
    public int br;
    public int bs;
    public int bt;
    public int bu;
    public int bv;
    public float bw;
    public float bx;
    protected int by;
    public final WalkAnimationState bz = new WalkAnimationState();
    public int bA = 20;
    public float bB;
    public float bC;
    public float bD;
    public float bE;
    public final ElytraAnimationState bF = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<EntityHuman> bG;
    protected int bH;
    protected boolean bI;
    protected int bJ;
    public float bK;
    protected boolean bL;
    public float bM;
    public float bN;
    public float bO;
    protected InterpolationHandler bP = new InterpolationHandler(this);
    protected double bQ;
    protected int bR;
    public boolean co = true;
    @Nullable
    public EntityReference<EntityLiving> cp;
    public int cq;
    @Nullable
    private EntityLiving cr;
    private int cs;
    private float ct;
    private int cu;
    private float cv;
    protected ItemStack bS;
    public int bT;
    protected int bU;
    private BlockPosition cw;
    private Optional<BlockPosition> cx;
    @Nullable
    private DamageSource cy;
    private long cz;
    protected int bV;
    protected float bW;
    @Nullable
    protected ItemStack bX;
    private float cA;
    private float cB;
    protected BehaviorController<?> bY;
    protected boolean cC;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cD;
    public final EntityEquipment bZ;
    private Waypoint.a cE;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.cN();
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entitytypes, net.minecraft.world.level.World world) {
        super(entitytypes, world);
        this.bS = ItemStack.l;
        this.cx = Optional.empty();
        this.cD = new EnumMap(EnumItemSlot.class);
        this.cE = new Waypoint.a();
        this.cj = new AttributeMapBase(AttributeDefaults.a(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.cj);
        this.az.a(cb, Float.valueOf((float)this.h(GenericAttributes.t).g()));
        this.bZ = this.ep();
        this.W = true;
        this.aG();
        this.v((float)(Math.random() * 6.2831854820251465));
        this.bD = this.dX();
        this.bY = this.a(ci);
    }

    @Override
    @Nullable
    public EntityLiving eo() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment ep() {
        return new EntityEquipment();
    }

    public BehaviorController<?> eq() {
        return this.bY;
    }

    protected BehaviorController.b<?> er() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.er().a(dynamic);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.a(worldserver, this.ei().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entitytypes) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(bj, (byte)0);
        datawatcher_a.a(cc, List.of());
        datawatcher_a.a(cd, false);
        datawatcher_a.a(ce, 0);
        datawatcher_a.a(cf, 0);
        datawatcher_a.a(cb, Float.valueOf(1.0f));
        datawatcher_a.a(cg, Optional.empty());
    }

    public static AttributeProvider.Builder es() {
        return AttributeProvider.a().a(GenericAttributes.t).a(GenericAttributes.q).a(GenericAttributes.w).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.s).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.o).a(GenericAttributes.y).a(GenericAttributes.l).a(GenericAttributes.p).a(GenericAttributes.x).a(GenericAttributes.h).a(GenericAttributes.j).a(GenericAttributes.G).a(GenericAttributes.v).a(GenericAttributes.d).a(GenericAttributes.i).a(GenericAttributes.H);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        net.minecraft.world.level.World world;
        if (!this.bu()) {
            this.bD();
        }
        if ((world = this.an()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (flag && this.an > 0.0) {
                this.b(worldserver, blockposition);
                double d1 = Math.max(0, MathHelper.a(this.i(this.an)));
                if (d1 > 0.0 && !iblockdata.l()) {
                    double d2 = this.dK();
                    double d3 = this.dM();
                    double d4 = this.dQ();
                    BlockPosition blockposition1 = this.dF();
                    if (blockposition.u() != blockposition1.u() || blockposition.w() != blockposition1.w()) {
                        double d5 = d2 - (double)blockposition.u() - 0.5;
                        double d6 = d4 - (double)blockposition.w() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.u() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.w() + 0.5 + d6 / d7 * 0.5;
                    }
                    double d8 = Math.min((double)0.2f + d1 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d8);
                    if (this instanceof EntityPlayer) {
                        worldserver.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, iblockdata), false, false, d2, d3, d4, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        worldserver.a(new ParticleParamBlock(Particles.b, iblockdata), d2, d3, d4, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.cx = Optional.empty();
        }
    }

    public boolean et() {
        return this.ax().a(TagsEntity.m);
    }

    public float b(float f2) {
        return MathHelper.h(f2, this.cB, this.cA);
    }

    public boolean eu() {
        return this.dI().b() < (double)1.0E-5f && this.bx();
    }

    @Override
    public void aH() {
        EntityLiving entityliving;
        net.minecraft.world.level.World world;
        WorldServer worldserver;
        this.bw = this.bx;
        if (this.ay) {
            this.ge().ifPresent(this::a);
        }
        if ((worldserver = (WorldServer)this.an()) instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            EnchantmentManager.b(worldserver1, this);
        }
        super.aH();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("livingEntityBaseTick");
        if (this.bX() && (world = this.an()) instanceof WorldServer) {
            double d1;
            double d0;
            worldserver = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.bY()) {
                this.a(worldserver, this.ei().g(), 1.0f);
            } else if (flag && !worldserver.u().a(this.de()) && (d0 = worldserver.u().a(this) + worldserver.u().n()) < 0.0 && (d1 = worldserver.u().o()) > 0.0) {
                this.a(worldserver, this.ei().x(), (float)Math.max(1, MathHelper.a(-d0 * d1)));
            }
            if (((Entity)this).a(TagsFluid.a) && !worldserver.a_(BlockPosition.a(this.dK(), this.dO(), this.dQ())).a(Blocks.oa)) {
                boolean flag1;
                boolean bl = flag1 = !this.et() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gC().a);
                if (flag1) {
                    this.j(this.l(this.cF()));
                    if (this.ev()) {
                        this.j(0);
                        worldserver.a((Entity)this, (byte)67);
                        this.a(worldserver, this.ei().i(), 2.0f);
                    }
                } else if (this.cF() < this.cE()) {
                    this.j(this.m(this.cF()));
                }
                if (this.cl() && this.du() != null && this.du().cn()) {
                    this.cb();
                }
            } else if (this.cF() < this.cE()) {
                this.j(this.m(this.cF()));
            }
            BlockPosition blockposition = this.dF();
            if (!com.google.common.base.Objects.equal((Object)this.cw, (Object)blockposition)) {
                this.cw = blockposition;
                this.b(worldserver, blockposition);
            }
        }
        if (this.bt > 0) {
            --this.bt;
        }
        if (this.ax > 0 && !(this instanceof EntityPlayer)) {
            --this.ax;
        }
        if (this.eV() && this.an().h(this)) {
            this.eC();
        }
        if (this.bH > 0) {
            --this.bH;
        } else {
            this.bG = null;
        }
        if (this.cr != null && !this.cr.bX()) {
            this.cr = null;
        }
        if ((entityliving = this.eF()) != null) {
            if (!entityliving.bX()) {
                this.a((EntityLiving)null);
            } else if (this.at - this.cq > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eM();
        this.bE = this.bD;
        this.bC = this.bB;
        this.ab = this.dX();
        this.ac = this.dZ();
        gameprofilerfiller.c();
    }

    protected boolean ev() {
        return this.cF() <= -20;
    }

    @Override
    protected float be() {
        return MathHelper.h((float)this.i(GenericAttributes.v), super.be(), 1.0f);
    }

    public float ew() {
        return 0.0f;
    }

    protected void ex() {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
        if (attributemodifiable != null && attributemodifiable.a(c) != null) {
            attributemodifiable.c(c);
        }
    }

    protected void ey() {
        int i2;
        if (!this.bF().l() && (i2 = this.cH()) > 0) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
            if (attributemodifiable == null) {
                return;
            }
            float f2 = -0.05f * this.cI();
            attributemodifiable.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        EnchantmentManager.a(worldserver, this);
    }

    public boolean g_() {
        return false;
    }

    public float ez() {
        return this.g_() ? 0.5f : 1.0f;
    }

    public final float eA() {
        AttributeMapBase attributemapbase = this.fp();
        return attributemapbase == null ? 1.0f : this.c((float)attributemapbase.c(GenericAttributes.z));
    }

    protected float c(float f2) {
        return f2;
    }

    public boolean eB() {
        return true;
    }

    protected void eC() {
        ++this.bv;
        if (this.bv >= 20 && !this.an().D_() && !this.ec()) {
            this.an().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eD() {
        return !this.g_();
    }

    protected boolean e(WorldServer worldserver) {
        return !this.g_() && worldserver.S().c(GameRules.g);
    }

    protected int l(int i2) {
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        double d0 = attributemodifiable != null ? attributemodifiable.g() : 0.0;
        return d0 > 0.0 && this.as.j() >= 1.0 / (d0 + 1.0) ? i2 : i2 - 1;
    }

    protected int m(int i2) {
        return Math.min(i2 + 4, this.cE());
    }

    public final int a(WorldServer worldserver, @Nullable Entity entity) {
        return EnchantmentManager.a(worldserver, entity, (Entity)this, this.f(worldserver));
    }

    protected int f(WorldServer worldserver) {
        return 0;
    }

    protected boolean eE() {
        return false;
    }

    @Nullable
    public EntityLiving eF() {
        return EntityReference.b(this.cp, this.an());
    }

    @Nullable
    public EntityHuman eG() {
        return EntityReference.c(this.bG, this.an());
    }

    @Override
    public EntityLiving h_() {
        return this.eF();
    }

    public int eH() {
        return this.cq;
    }

    public void a(EntityHuman entityhuman, int i2) {
        this.a(EntityReference.a(entityhuman), i2);
    }

    public void a(UUID uuid, int i2) {
        this.a(EntityReference.a(uuid), i2);
    }

    private void a(EntityReference<EntityHuman> entityreference, int i2) {
        this.bG = entityreference;
        this.bH = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.cp = EntityReference.a(entityliving);
        this.cq = this.at;
    }

    @Nullable
    public EntityLiving eI() {
        return this.cr;
    }

    public int eJ() {
        return this.cs;
    }

    public void C(Entity entity) {
        this.cr = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cs = this.at;
    }

    public int eK() {
        return this.bJ;
    }

    public void n(int i2) {
        this.bJ = i2;
    }

    public boolean eL() {
        return this.cn;
    }

    public void r(boolean flag) {
        this.cn = flag;
    }

    protected boolean b(EnumItemSlot enumitemslot) {
        return true;
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EnumItemSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!(this.an().D_() || this.at() || ItemStack.c(itemstack, itemstack1) || this.ay)) {
            Equippable equippable = itemstack1.a(DataComponents.D);
            if (!this.bm() && equippable != null && enumitemslot == equippable.b() && !silent) {
                this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), this.a(enumitemslot, itemstack1, equippable), this.dw(), 1.0f, 1.0f, this.as.g());
            }
            if (this.b(enumitemslot)) {
                this.c(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        net.minecraft.world.level.World world;
        if ((entity_removalreason == Entity.RemovalReason.a || entity_removalreason == Entity.RemovalReason.b) && (world = this.an()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.bY.a();
    }

    @Override
    public void b(Entity.RemovalReason entity_removalreason) {
        super.b(entity_removalreason);
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.h().c(this);
        }
    }

    protected void a(WorldServer worldserver, Entity.RemovalReason entity_removalreason) {
        for (MobEffect mobeffect : this.eR()) {
            mobeffect.a(worldserver, this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.cl.clear();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a(aU, this.eU());
        valueoutput.a(aR, (short)this.bt);
        valueoutput.a(aT, this.cq);
        valueoutput.a(aS, (short)this.bv);
        valueoutput.a("AbsorptionAmount", this.fM());
        valueoutput.a(u, AttributeModifiable.a.b, this.fp().d());
        if (!this.cl.isEmpty()) {
            valueoutput.a(b, MobEffect.d.listOf(), List.copyOf(this.cl.values()));
        }
        valueoutput.a(aQ, this.fY());
        this.ge().ifPresent(blockposition -> valueoutput.a(aN, BlockPosition.a, blockposition));
        DataResult dataresult = this.bY.a(DynamicOpsNBT.a).map(nbtbase -> new Dynamic((DynamicOps)DynamicOpsNBT.a, nbtbase));
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(dynamic -> valueoutput.a(aP, Codec.PASSTHROUGH, dynamic));
        if (this.bG != null) {
            this.bG.a(valueoutput, "last_hurt_by_player");
            valueoutput.a("last_hurt_by_player_memory_time", this.bH);
        }
        if (this.cp != null) {
            this.cp.a(valueoutput, "last_hurt_by_mob");
            valueoutput.a("ticks_since_last_hurt_by_mob", this.at - this.cq);
        }
        if (!this.bZ.a()) {
            valueoutput.a(aO, EntityEquipment.a, this.bZ);
        }
        if (this.cE.a()) {
            valueoutput.a("locator_bar_icon", Waypoint.a.a, this.cE);
        }
    }

    @Nullable
    public EntityItem a(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.f()) {
            return null;
        }
        if (this.an().D_()) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem entityitem = this.b(itemstack, flag, flag1);
        if (entityitem != null) {
            if (callEvent && this instanceof EntityPlayer) {
                Player player = (Player)this.getBukkitEntity();
                Item drop = (Item)entityitem.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                    if (flag1 && (cur == null || cur.getAmount() == 0)) {
                        player.getInventory().setItemInHand(drop.getItemStack());
                    } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        cur.setAmount(cur.getAmount() + 1);
                        player.getInventory().setItemInHand(cur);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.an().b(entityitem);
        }
        return entityitem;
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.F(valueinput.a("AbsorptionAmount", 0.0f));
        if (this.an() != null && !this.an().D_()) {
            Optional<List<AttributeModifiable.a>> optional = valueinput.a(u, AttributeModifiable.a.b);
            AttributeMapBase attributemapbase = this.fp();
            Objects.requireNonNull(attributemapbase);
            optional.ifPresent(attributemapbase::a);
        }
        List list = valueinput.a(b, MobEffect.d.listOf()).orElse(List.of());
        this.cl.clear();
        for (MobEffect mobeffect : list) {
            this.cl.put(mobeffect.c(), mobeffect);
        }
        float maxHealth = valueinput.a("Bukkit.MaxHealth", -1.0f);
        if (maxHealth > 0.0f) {
            this.h(GenericAttributes.t).a(maxHealth);
        }
        this.x(valueinput.a(aU, this.fj()));
        this.bt = valueinput.a(aR, (short)0);
        this.bv = valueinput.a(aS, (short)0);
        this.cq = valueinput.a(aT, 0);
        valueinput.g("Team").ifPresent(s2 -> {
            boolean flag;
            Scoreboard scoreboard = this.an().W();
            ScoreboardTeam scoreboardteam = scoreboard.b((String)s2);
            boolean bl = flag = scoreboardteam != null && scoreboard.a(this.cU(), scoreboardteam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", s2);
            }
        });
        this.b(7, valueinput.a(aQ, false));
        valueinput.a(aN, BlockPosition.a).ifPresentOrElse(blockposition -> {
            this.g((BlockPosition)blockposition);
            this.az.a(aE, EntityPose.c);
            if (!this.ay) {
                this.a((BlockPosition)blockposition);
            }
        }, this::gf);
        valueinput.a(aP, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.bY = this.a((Dynamic<?>)dynamic);
        });
        this.bG = EntityReference.a(valueinput, "last_hurt_by_player");
        this.bH = valueinput.a("last_hurt_by_player_memory_time", 0);
        this.cp = EntityReference.a(valueinput, "last_hurt_by_mob");
        this.cq = valueinput.a("ticks_since_last_hurt_by_mob", 0) + this.at;
        this.bZ.a(valueinput.a(aO, EntityEquipment.a).orElseGet(EntityEquipment::new));
        this.cE = valueinput.a("locator_bar_icon", Waypoint.a.a).orElseGet(Waypoint.a::new);
    }

    protected void eM() {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Iterator<Holder<MobEffectList>> iterator = this.cl.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder<MobEffectList> holder = iterator.next();
                    MobEffect mobeffect = this.cl.get(holder);
                    if (!mobeffect.a(worldserver, this, () -> this.a(mobeffect, true, (Entity)null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobeffect));
                        continue;
                    }
                    if (mobeffect.d() % 600 != 0) continue;
                    this.a(mobeffect, false, (Entity)null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect e2 : this.effectsToProcess) {
                if (e2.effect != null) {
                    this.addEffect(e2.effect, e2.cause);
                    continue;
                }
                this.removeEffect(e2.type, e2.cause);
            }
            this.effectsToProcess.clear();
            if (this.co) {
                this.M();
                this.p();
                this.co = false;
            }
        } else {
            for (MobEffect mobeffect1 : this.cl.values()) {
                mobeffect1.i();
            }
            List<ParticleParam> list = this.az.a(cc);
            if (!list.isEmpty()) {
                int j2;
                boolean flag = this.az.a(cd);
                int i2 = this.cB() ? 15 : 4;
                int n2 = j2 = flag ? 5 : 1;
                if (this.as.a(i2 * j2) == 0) {
                    this.an().a(SystemUtils.a(list, this.as), this.e(0.5), this.dN(), this.h(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void M() {
        if (this.cl.isEmpty()) {
            this.eP();
            this.l(false);
        } else {
            this.l(this.d(MobEffects.n));
            this.k();
        }
    }

    private void k() {
        List<ParticleParam> list = this.cl.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.az.a(cc, list);
        this.az.a(cd, EntityLiving.d(this.cl.values()));
    }

    private void p() {
        boolean flag = this.cA();
        if (this.i(6) != flag) {
            this.b(6, flag);
        }
    }

    public double D(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.cs()) {
            d0 *= 0.8;
        }
        if (this.cB()) {
            float f2 = this.fs();
            if (f2 < 0.1f) {
                f2 = 0.1f;
            }
            d0 *= 0.7 * (double)f2;
        }
        if (entity != null) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            EntityTypes<?> entitytypes = entity.ax();
            if (entitytypes == EntityTypes.bk && itemstack.a(Items.wt) || entitytypes == EntityTypes.bT && itemstack.a(Items.ww) || entitytypes == EntityTypes.aW && itemstack.a(Items.wz) || entitytypes == EntityTypes.aX && itemstack.a(Items.wz) || entitytypes == EntityTypes.H && itemstack.a(Items.wx)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean c(EntityLiving entityliving) {
        return entityliving instanceof EntityHuman && this.an().aq() == EnumDifficulty.a ? false : entityliving.eN();
    }

    public boolean eN() {
        return !this.cP() && this.eO();
    }

    public boolean eO() {
        return !this.at() && this.bX();
    }

    public static boolean d(Collection<MobEffect> collection) {
        for (MobEffect mobeffect : collection) {
            if (!mobeffect.g() || mobeffect.f()) continue;
            return false;
        }
        return true;
    }

    protected void eP() {
        this.az.a(cc, List.of());
    }

    public boolean eQ() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.an().D_()) {
            return false;
        }
        if (this.cl.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.cl.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eR() {
        return this.cl.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eS() {
        return this.cl;
    }

    public boolean d(Holder<MobEffectList> holder) {
        return this.cl.containsKey(holder);
    }

    @Nullable
    public MobEffect e(Holder<MobEffectList> holder) {
        return this.cl.get(holder);
    }

    public float a(Holder<MobEffectList> holder, float f2) {
        MobEffect mobeffect = this.e(holder);
        return mobeffect != null ? mobeffect.a(this, f2) : 0.0f;
    }

    public final boolean a(MobEffect mobeffect) {
        return this.b(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffect mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.b(mobeffect)) {
            return false;
        }
        MobEffect mobeffect1 = this.cl.get(mobeffect.c());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffect(mobeffect1).b(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.cl.put(mobeffect.c(), mobeffect);
            this.a(mobeffect, entity);
            flag = true;
            mobeffect.b(this);
        } else if (event.isOverride()) {
            mobeffect1.b(mobeffect);
            this.a(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.a(this);
        return flag;
    }

    public boolean b(MobEffect mobeffect) {
        return this.ax().a(TagsEntity.G) ? !mobeffect.a(MobEffects.M) : (this.ax().a(TagsEntity.F) ? !mobeffect.a(MobEffects.L) : (!this.ax().a(TagsEntity.w) ? true : !mobeffect.a(MobEffects.j) && !mobeffect.a(MobEffects.s)));
    }

    public void c(MobEffect mobeffect, @Nullable Entity entity) {
        if (this.b(mobeffect)) {
            MobEffect mobeffect1 = this.cl.put(mobeffect.c(), mobeffect);
            if (mobeffect1 == null) {
                this.a(mobeffect, entity);
            } else {
                mobeffect.d(mobeffect1);
                this.a(mobeffect, true, entity);
            }
        }
    }

    public boolean eT() {
        return this.ax().a(TagsEntity.x);
    }

    @Nullable
    public final MobEffect f(Holder<MobEffectList> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public final MobEffect removeEffectNoUpdate(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffect effect = this.cl.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.cl.remove(holder);
    }

    public boolean g(Holder<MobEffectList> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.c(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        if (!this.an().D_()) {
            this.co = true;
            mobeffect.c().a().a(this.fp(), mobeffect.e());
            this.c(mobeffect);
        }
    }

    public void c(MobEffect mobeffect) {
        for (Entity entity : this.di()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.g.b(new PacketPlayOutEntityEffect(this.az(), mobeffect, false));
        }
    }

    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        if (!this.an().D_()) {
            this.co = true;
            if (flag) {
                MobEffectList mobeffectlist = mobeffect.c().a();
                mobeffectlist.a(this.fp());
                mobeffectlist.a(this.fp(), mobeffect.e());
                this.H();
            }
            this.c(mobeffect);
        }
    }

    protected void c(Collection<MobEffect> collection) {
        if (!this.an().D_()) {
            this.co = true;
            for (MobEffect mobeffect : collection) {
                mobeffect.c().a().a(this.fp());
                for (Entity entity : this.di()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.g.b(new PacketPlayOutRemoveEntityEffect(this.az(), mobeffect.c()));
                }
            }
            this.H();
        }
    }

    private void H() {
        Set<AttributeModifiable> set = this.fp().b();
        for (AttributeModifiable attributemodifiable : set) {
            this.a(attributemodifiable.a());
        }
        set.clear();
    }

    protected void a(Holder<AttributeBase> holder) {
        net.minecraft.world.level.World world;
        if (holder.a(GenericAttributes.t)) {
            float f2 = this.fj();
            if (this.eU() > f2) {
                this.x(f2);
            }
        } else if (holder.a(GenericAttributes.s)) {
            float f1 = this.fk();
            if (this.fM() > f1) {
                this.E(f1);
            }
        } else if (holder.a(GenericAttributes.z)) {
            this.l_();
        } else if (holder.a(GenericAttributes.H) && (world = this.an()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ServerWaypointManager serverwaypointmanager = worldserver.h();
            if (this.cj.c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
    }

    public void d(float f2) {
        this.heal(f2, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f2, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.eU();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f2, regainReason);
            if (this.valid) {
                this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eU() + event.getAmount()));
            }
        }
    }

    public float eU() {
        if (this instanceof EntityPlayer) {
            return (float)((EntityPlayer)this).getBukkitEntity().getHealth();
        }
        return this.az.a(cb).floatValue();
    }

    public void x(float f2) {
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (f2 < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f2 > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f2);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.az.a(cb, Float.valueOf(MathHelper.a(f2, 0.0f, this.fj())));
    }

    public boolean eV() {
        return this.eU() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity1;
        boolean flag2;
        boolean flag;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.ec() || this.bI || this.eU() <= 0.0f) {
            return false;
        }
        if (damagesource.a(DamageTypeTags.i) && this.d(MobEffects.l)) {
            return false;
        }
        if (this.gg()) {
            this.gh();
        }
        this.bJ = 0;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f1 = f2;
        ItemStack itemstack = this.fQ();
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f2);
        f2 = 0.0f;
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f2 += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        float f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
        boolean bl = flag = f22 > 0.0f;
        if (Float.isNaN(f2 -= f22) || Float.isInfinite(f2)) {
            f2 = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.ax > (float)this.bA / 2.0f && !damagesource.a(DamageTypeTags.e)) {
            if (f2 <= this.bK) {
                return false;
            }
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage() - this.bK, event)) {
                return false;
            }
            this.bK = f2;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.bK = f2;
            this.ax = this.bA;
            this.bt = this.bu = 10;
        }
        this.f(damagesource);
        this.g(damagesource);
        if (flag1) {
            BlocksAttacks blocksattacks = itemstack.a(DataComponents.I);
            if (flag && blocksattacks != null) {
                blocksattacks.a(worldserver, this);
            } else {
                worldserver.a((Entity)this, damagesource);
            }
            if (!damagesource.a(DamageTypeTags.r) && !flag) {
                this.bP();
            }
            if (!damagesource.a(DamageTypeTags.z)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity = damagesource.c();
                if (entity instanceof IProjectile) {
                    IProjectile iprojectile = (IProjectile)entity;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.a_(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.i() != null) {
                    d0 = damagesource.i().a() - this.dK();
                    d1 = damagesource.i().c() - this.dQ();
                }
                this.knockback(0.4f, d0, d1, entity, entity == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d0, d1);
                }
            }
        }
        if (this.eV()) {
            if (!this.j(damagesource)) {
                if (flag1) {
                    this.b(this.f_());
                    this.i(damagesource);
                }
                this.a(damagesource);
            }
        } else if (flag1) {
            this.h(damagesource);
            this.i(damagesource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.cy = damagesource;
            this.cz = this.an().ag();
            for (MobEffect mobeffect : new LinkedList<MobEffect>(this.eR())) {
                mobeffect.a(worldserver, this, damagesource, f2);
            }
        }
        if (this instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this;
            CriterionTriggers.i.a(entityplayer, damagesource, f1, f2, flag);
            if (f22 > 0.0f && f22 < 3.4028235E37f) {
                entityplayer.a(StatisticList.L, Math.round(f22 * 10.0f));
            }
        }
        if ((entity1 = damagesource.d()) instanceof EntityPlayer) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity1;
            CriterionTriggers.h.a(entityplayer1, this, damagesource, f1, f2, flag);
        }
        return flag2;
    }

    public float b(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.actuallyDoItemBlocking(worldserver, damagesource, this.calculateItemBlocking(damagesource, f2));
    }

    private float calculateItemBlocking(DamageSource damagesource, float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemstack = this.fW();
        if (itemstack == null) {
            return 0.0f;
        }
        BlocksAttacks blocksattacks = itemstack.a(DataComponents.I);
        if (blocksattacks != null) {
            Optional<TagKey<DamageType>> optional = blocksattacks.f();
            Objects.requireNonNull(damagesource);
            if (!optional.map(damagesource::a).orElse(false).booleanValue()) {
                double d0;
                EntityArrow entityarrow;
                Entity entity = damagesource.c();
                if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).s() > 0) {
                    return 0.0f;
                }
                Vec3D vec3d = damagesource.i();
                if (vec3d != null) {
                    Vec3D vec3d1 = this.c(0.0f, this.cN());
                    Vec3D vec3d2 = vec3d.d(this.dD());
                    vec3d2 = new Vec3D(vec3d2.g, 0.0, vec3d2.i).d();
                    d0 = Math.acos(vec3d2.b(vec3d1));
                } else {
                    d0 = 3.1415927410125732;
                }
                float f1 = blocksattacks.a(damagesource, f2, d0);
                return f1;
            }
        }
        return 0.0f;
    }

    private float actuallyDoItemBlocking(WorldServer worldserver, DamageSource damagesource, float f1) {
        BlocksAttacks blocksattacks;
        ItemStack itemstack = this.fW();
        if (itemstack != null && (blocksattacks = itemstack.a(DataComponents.I)) != null) {
            Entity entity1;
            blocksattacks.a(this.an(), itemstack, this, this.fP(), f1);
            if (f1 > 0.0f && !damagesource.a(DamageTypeTags.j) && (entity1 = damagesource.c()) instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity1;
                this.a(worldserver, entityliving);
            }
            return f1;
        }
        return 0.0f;
    }

    private void i(DamageSource damagesource) {
        if (damagesource.a(DamageTypes.P)) {
            SoundCategory soundcategory = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.an().a((Entity)null, this.dD().g, this.dD().h, this.dD().i, SoundEffects.BQ, soundcategory);
        }
    }

    protected void f(DamageSource damagesource) {
        Entity entity = damagesource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (!(damagesource.a(DamageTypeTags.q) || damagesource.a(DamageTypes.I) && this.ax().a(TagsEntity.E))) {
                this.a(entityliving);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damagesource) {
        EntityWolf entitywolf;
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            this.a(entityhuman, 100);
        } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).m()) {
            if (entitywolf.d() != null) {
                this.a(entitywolf.d().c(), 100);
            } else {
                this.bG = null;
                this.bH = 0;
            }
        }
        return EntityReference.c(this.bG, this.an());
    }

    protected void a(WorldServer worldserver, EntityLiving entityliving) {
        entityliving.d(this);
    }

    protected void d(EntityLiving entityliving) {
        entityliving.knockback(0.5, entityliving.dK() - this.dK(), entityliving.dQ() - this.dQ(), null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damagesource) {
        if (damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        EnumHand hand = null;
        ItemStack itemstack1 = ItemStack.l;
        for (EnumHand enumhand : EnumHand.values()) {
            itemstack1 = this.b(enumhand);
            deathprotection = itemstack1.a(DataComponents.H);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.an().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.f()) {
                itemstack1.h(1);
            }
            if (itemstack != null && this instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)this;
                entityplayer.b(StatisticList.c.b(itemstack.h()));
                CriterionTriggers.C.a(entityplayer, itemstack);
                this.c(GameEvent.C);
            }
            this.x(1.0f);
            deathprotection.a(itemstack, this);
            this.an().a((Entity)this, (byte)35);
        }
        return deathprotection != null;
    }

    @Nullable
    public DamageSource eW() {
        if (this.an().ag() - this.cz > 40L) {
            this.cy = null;
        }
        return this.cy;
    }

    protected void h(DamageSource damagesource) {
        this.b(this.e(damagesource));
    }

    public void b(@Nullable SoundEffect soundeffect) {
        if (soundeffect != null) {
            this.a(soundeffect, this.ft(), this.fu());
        }
    }

    private void g(ItemStack itemstack) {
        if (!itemstack.f()) {
            Holder<SoundEffect> holder = itemstack.a(DataComponents.au);
            if (holder != null && !this.bm()) {
                this.an().a(this.dK(), this.dM(), this.dQ(), holder.a(), this.dw(), 0.8f, 0.8f + this.an().z.i() * 0.4f, false);
            }
            this.b(itemstack, 5);
        }
    }

    public void a(DamageSource damagesource) {
        if (!this.ec() && !this.bI) {
            Entity entity = damagesource.d();
            EntityLiving entityliving = this.fi();
            if (entityliving != null) {
                entityliving.a((Entity)this, damagesource);
            }
            if (this.gg()) {
                this.gh();
            }
            if (!this.an().D_() && this.k_()) {
                a.info("Named entity {} died: {}", (Object)this, (Object)this.fh().a().getString());
            }
            this.bI = true;
            this.fh().c();
            net.minecraft.world.level.World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (entity == null || entity.a(worldserver, this, damagesource)) {
                    this.c(GameEvent.p);
                    this.b(worldserver, damagesource);
                    this.e(entityliving);
                }
                this.an().a((Entity)this, (byte)3);
            }
            this.c(EntityPose.h);
        }
    }

    protected void e(@Nullable EntityLiving entityliving) {
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            boolean flag = false;
            if (entityliving instanceof EntityWither) {
                if (worldserver.S().c(GameRules.d)) {
                    BlockPosition blockposition = this.dF();
                    IBlockData iblockdata = Blocks.cn.m();
                    if (this.an().a_(blockposition).l() && iblockdata.a((IWorldReader)this.an(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.an(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    EntityItem entityitem = new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.an().b(entityitem);
                }
            }
        }
    }

    protected void b(WorldServer worldserver, DamageSource damagesource) {
        boolean flag = this.bH > 0;
        this.g(worldserver);
        if (this.e(worldserver)) {
            this.b(worldserver, damagesource, flag);
            this.a(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.b(worldserver, damagesource.d());
    }

    protected void g(WorldServer worldserver) {
    }

    public int getExpReward(WorldServer worldserver, @Nullable Entity entity) {
        if (!this.eZ() && (this.eE() || this.bH > 0 && this.eD() && worldserver.S().c(GameRules.g))) {
            return this.a(worldserver, entity);
        }
        return 0;
    }

    protected void b(WorldServer worldserver, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.a(worldserver, this.dD(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
    }

    public long eX() {
        return 0L;
    }

    protected float b(Entity entity, DamageSource damagesource) {
        float f2 = (float)this.i(GenericAttributes.d);
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return EnchantmentManager.d(worldserver, this.el(), entity, damagesource, f2);
        }
        return f2;
    }

    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        Optional<ResourceKey<LootTable>> optional = this.em();
        if (!optional.isEmpty()) {
            this.a(worldserver, damagesource, flag, optional.get());
        }
    }

    public void a(WorldServer worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey) {
        this.a(worldserver, damagesource, flag, resourcekey, (ItemStack itemstack) -> this.a(worldserver, (ItemStack)itemstack));
    }

    public void a(WorldServer worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey, Consumer<ItemStack> consumer) {
        LootTable loottable = worldserver.q().bi().a(resourcekey);
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.a, this).a(LootContextParameters.h, this.dD()).a(LootContextParameters.e, damagesource).b(LootContextParameters.f, damagesource.d()).b(LootContextParameters.g, damagesource.c());
        EntityHuman entityhuman = this.eG();
        if (flag && entityhuman != null) {
            lootparams_a = lootparams_a.a(LootContextParameters.d, entityhuman).a(entityhuman.ew());
        }
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
        loottable.a(lootparams, this.eX(), consumer);
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, @Nullable Entity entity, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.c, this).b(LootContextParameters.b, entity).a(LootContextParameters.k, itemstack).a(LootContextParameterSets.t), biconsumer);
    }

    public boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, BiConsumer<WorldServer, ItemStack> biconsumer) {
        return this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.h, this.dD()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), biconsumer);
    }

    protected void a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, ItemStack itemstack, BiConsumer<WorldServer, ItemStack> biconsumer) {
        this.a(worldserver, resourcekey, (LootParams.a lootparams_a) -> lootparams_a.a(LootContextParameters.h, this.dD()).a(LootContextParameters.a, this).a(LootContextParameters.k, itemstack).a(LootContextParameterSets.s), biconsumer);
    }

    protected boolean a(WorldServer worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.a, LootParams> function, BiConsumer<WorldServer, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.q().bi().a(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams = function.apply(new LootParams.a(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void o(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.i(GenericAttributes.q);
        Vec3D vec3d = this.dI();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3d1 = new Vec3D(d1, 0.0, d2).d().c(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.g / 2.0 - vec3d1.g, this.aS() ? Math.min(0.4, vec3d.h / 2.0 + d0) : vec3d.h, vec3d.i / 2.0 - vec3d1.i);
        if (event.isCancelled()) {
            return;
        }
        this.aF = true;
        this.m(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void a(double d0, double d1) {
    }

    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.ly;
    }

    @Nullable
    protected SoundEffect f_() {
        return SoundEffects.lt;
    }

    private SoundEffect q(int i2) {
        return i2 > 4 ? this.fc().b() : this.fc().a();
    }

    public void eY() {
        this.cC = true;
    }

    public boolean eZ() {
        return this.cC;
    }

    public float fa() {
        return 0.0f;
    }

    protected AxisAlignedBB fb() {
        AxisAlignedBB axisalignedbb = this.de();
        Entity entity = this.du();
        if (entity != null) {
            Vec3D vec3d = entity.n(this);
            return axisalignedbb.b(Math.max(vec3d.h, axisalignedbb.b));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot enumitemslot) {
        return (Map)this.cD.computeIfAbsent(enumitemslot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public a fc() {
        return new a(SoundEffects.lz, SoundEffects.lr);
    }

    public SoundEffect getHurtSound0(DamageSource damagesource) {
        return this.e(damagesource);
    }

    public SoundEffect getDeathSound0() {
        return this.f_();
    }

    public SoundEffect getFallDamageSound0(int fallHeight) {
        return this.q(fallHeight);
    }

    public Optional<BlockPosition> fd() {
        return this.cx;
    }

    public boolean fe() {
        if (this.at()) {
            return false;
        }
        BlockPosition blockposition = this.dF();
        IBlockData iblockdata = this.dG();
        if (iblockdata.a(TagsBlock.bd)) {
            this.cx = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.b() instanceof BlockTrapdoor && this.c(blockposition, iblockdata)) {
            this.cx = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData iblockdata1 = this.an().a_(blockposition.e());
        return iblockdata1.a(Blocks.dm) && iblockdata1.c(BlockLadder.b) == iblockdata.c(BlockTrapdoor.f);
    }

    @Override
    public boolean bX() {
        return !this.ec() && this.eU() > 0.0f;
    }

    public boolean a(EntityLiving entityliving, double d0, boolean flag, boolean flag1, double ... adouble) {
        Vec3D vec3d = entityliving.h(1.0f).d();
        for (double d1 : adouble) {
            Vec3D vec3d1 = new Vec3D(this.dK() - entityliving.dK(), d1 - entityliving.dO(), this.dQ() - entityliving.dQ());
            double d2 = vec3d1.g();
            vec3d1 = vec3d1.d();
            double d3 = vec3d.b(vec3d1);
            double d4 = flag ? d2 : 1.0;
            if (!(d3 > 1.0 - d0 / d4) || !entityliving.a(this, flag1 ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cR() {
        return this.y(0.0f);
    }

    protected final int y(float f2) {
        return MathHelper.d(f2 + 3.0f);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        boolean flag = super.a(d0, f2, damagesource);
        int i2 = this.a(d0, f2);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.an(), damagesource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.ff();
            return true;
        }
        return flag;
    }

    protected int a(double d0, float f2) {
        if (this.ax().a(TagsEntity.o)) {
            return 0;
        }
        double d1 = this.i(d0);
        return MathHelper.a(d1 * (double)f2 * this.i(GenericAttributes.l));
    }

    private double i(double d0) {
        return d0 + 1.0E-6 - this.i(GenericAttributes.y);
    }

    protected void ff() {
        if (!this.bm()) {
            int i2 = MathHelper.a(this.dK());
            int j2 = MathHelper.a(this.dM() - (double)0.2f);
            int k2 = MathHelper.a(this.dQ());
            IBlockData iblockdata = this.an().a_(new BlockPosition(i2, j2, k2));
            if (!iblockdata.l()) {
                SoundEffectType soundeffecttype = iblockdata.A();
                this.a(soundeffecttype.g(), soundeffecttype.a() * 0.5f, soundeffecttype.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float f2) {
        this.bt = this.bu = 10;
    }

    public int fg() {
        return MathHelper.a(this.i(GenericAttributes.a));
    }

    protected void c(DamageSource damagesource, float f2) {
    }

    protected void d(DamageSource damagesource, float f2) {
    }

    protected void a(DamageSource damagesource, float f2, EnumItemSlot ... aenumitemslot) {
        if (f2 > 0.0f) {
            int i2 = (int)Math.max(1.0f, f2 / 4.0f);
            for (EnumItemSlot enumitemslot : aenumitemslot) {
                ItemStack itemstack = this.a(enumitemslot);
                Equippable equippable = itemstack.a(DataComponents.D);
                if (equippable == null || !equippable.i() || !itemstack.m() || !itemstack.a(damagesource)) continue;
                itemstack.a(i2, this, enumitemslot);
            }
        }
    }

    protected float e(DamageSource damagesource, float f2) {
        if (!damagesource.a(DamageTypeTags.b)) {
            f2 = CombatMath.a(this, f2, damagesource, this.fg(), (float)this.i(GenericAttributes.b));
        }
        return f2;
    }

    protected float f(DamageSource damagesource, float f2) {
        float f4;
        if (damagesource.a(DamageTypeTags.f)) {
            return f2;
        }
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.a(DamageTypeTags.h)) {
            return f2;
        }
        net.minecraft.world.level.World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            f4 = EnchantmentManager.b(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f2 = CombatMath.a(f2, f4);
        }
        return f2;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f2) {
        float originalDamage = f2;
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.o) && EntityLiving.this.ax().a(TagsEntity.l)) {
                    return -(f2 - f2 * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f2)).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (damagesource.a(DamageTypeTags.a) && !EntityLiving.this.a(EnumItemSlot.f).f()) {
                    return -(f2 - f2 * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f2 += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -((double)EntityLiving.this.calculateItemBlocking(damagesource, f2.floatValue()));
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f2 += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.e(damagesource, f2.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f2 += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                if (!damagesource.a(DamageTypeTags.f) && EntityLiving.this.d(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                    int i2 = (EntityLiving.this.e(MobEffects.k).e() + 1) * 5;
                    int j2 = 25 - i2;
                    float f1 = f2.floatValue() * (float)j2;
                    return -(f2 - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f2 += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -(f2 - (double)EntityLiving.this.f(damagesource, f2.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f2 += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f2) {
                return -Math.max(f2 - Math.max(f2 - (double)EntityLiving.this.fM(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f2 += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.a(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.d() instanceof EntityHuman) {
                ((EntityHuman)damagesource.d()).gV();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.N, Math.round(f3 * 10.0f));
                } else if (damagesource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damagesource.d()).a(StatisticList.J, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                this.d(damagesource, f2);
            }
            if (!damagesource.a(DamageTypeTags.b)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.c(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.actuallyDoItemBlocking(worldserver, damagesource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fM() - absorptionModifier, 0.0f));
            float f22 = absorptionModifier;
            if (f22 > 0.0f && f22 < 3.4028235E37f && this instanceof EntityHuman) {
                ((EntityHuman)this).a(StatisticList.M, Math.round(f22 * 10.0f));
            }
            if (f22 > 0.0f && f22 < 3.4028235E37f && (entity = damagesource.d()) instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(StatisticList.I, Math.round(f22 * 10.0f));
            }
            if (f2 > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damagesource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f2 < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.K, Math.round(f2 * 10.0f));
                    }
                }
                this.fh().a(damagesource, f2);
                this.x(this.eU() - f2);
                if (!human) {
                    this.E(this.fM() - f2);
                }
                this.c(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damagesource, f2, originalDamage, true);
                    f22 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f22 > 0.0f && f22 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.L, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damagesource.d(), this, damagesource, f2, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker fh() {
        return this.ck;
    }

    @Nullable
    public EntityLiving fi() {
        return this.bG != null ? (EntityLiving)this.bG.a(this.an(), EntityHuman.class) : (this.cp != null ? this.cp.a(this.an(), EntityLiving.class) : null);
    }

    public final float fj() {
        return (float)this.i(GenericAttributes.t);
    }

    public final float fk() {
        return (float)this.i(GenericAttributes.s);
    }

    public final int fl() {
        return this.az.a(ce);
    }

    public final void o(int i2) {
        this.setArrowCount(i2, false);
    }

    public final void setArrowCount(int i2, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.fl(), i2, flag);
        if (event.isCancelled()) {
            return;
        }
        this.az.a(ce, event.getNewAmount());
    }

    public final int fm() {
        return this.az.a(cf);
    }

    public final void p(int i2) {
        this.az.a(cf, i2);
    }

    private int I() {
        return MobEffectUtil.a(this) ? 6 - (1 + MobEffectUtil.b(this)) : (this.d(MobEffects.d) ? 6 + (1 + this.e(MobEffects.d).e()) * 2 : 6);
    }

    public void a(EnumHand enumhand) {
        this.a(enumhand, false);
    }

    public void a(EnumHand enumhand, boolean flag) {
        if (!this.bo || this.bq >= this.I() / 2 || this.bq < 0) {
            this.bq = -1;
            this.bo = true;
            this.bp = enumhand;
            if (this.an() instanceof WorldServer) {
                PacketPlayOutAnimation packetplayoutanimation = new PacketPlayOutAnimation(this, enumhand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkproviderserver = ((WorldServer)this.an()).n();
                if (flag) {
                    chunkproviderserver.a(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.b(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damagesource) {
        this.bz.a(1.5f);
        this.ax = 20;
        this.bt = this.bu = 10;
        SoundEffect soundeffect = this.e(damagesource);
        if (soundeffect != null) {
            this.a(soundeffect, this.ft(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
        this.cy = damagesource;
        this.cz = this.an().ag();
    }

    @Override
    public void b(byte b0) {
        switch (b0) {
            case 3: {
                SoundEffect soundeffect = this.f_();
                if (soundeffect != null) {
                    this.a(soundeffect, this.ft(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.ei().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int j2 = 0; j2 < 128; ++j2) {
                    double d0 = (double)j2 / 127.0;
                    float f2 = (this.as.i() - 0.5f) * 0.2f;
                    float f1 = (this.as.i() - 0.5f) * 0.2f;
                    float f22 = (this.as.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d0, this.Y, this.dK()) + (this.as.j() - 0.5) * (double)this.dA() * 2.0;
                    double d2 = MathHelper.d(d0, this.Z, this.dM()) + this.as.j() * (double)this.dB();
                    double d3 = MathHelper.d(d0, this.aa, this.dQ()) + (this.as.j() - 0.5) * (double)this.dA() * 2.0;
                    this.an().a(Particles.ag, d1, d2, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.K();
                break;
            }
            case 60: {
                this.fn();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.J();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(b0);
            }
        }
    }

    public void fn() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d2 = this.as.k() * 0.02;
            double d3 = 10.0;
            this.an().a(Particles.af, this.e(1.0) - d0 * 10.0, this.dN() - d1 * 10.0, this.h(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void J() {
        Vec3D vec3d = this.dI();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d0 = this.as.a(0.0, 1.0);
            double d1 = this.as.a(0.0, 1.0);
            double d2 = this.as.a(0.0, 1.0);
            this.an().a(Particles.d, this.dK() + d0, this.dM() + d1, this.dQ() + d2, vec3d.g, vec3d.h, vec3d.i);
        }
    }

    private void K() {
        ItemStack itemstack = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemstack);
    }

    @Override
    protected void aR() {
        this.a(this.ei().o(), 4.0f);
    }

    protected void fo() {
        int i2 = this.I();
        if (this.bo) {
            ++this.bq;
            if (this.bq >= i2) {
                this.bq = 0;
                this.bo = false;
            }
        } else {
            this.bq = 0;
        }
        this.bx = (float)this.bq / (float)i2;
    }

    @Nullable
    public AttributeModifiable h(Holder<AttributeBase> holder) {
        return this.fp().a(holder);
    }

    public double i(Holder<AttributeBase> holder) {
        return this.fp().c(holder);
    }

    public double j(Holder<AttributeBase> holder) {
        return this.fp().d(holder);
    }

    public AttributeMapBase fp() {
        return this.cj;
    }

    public ItemStack fq() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fr() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack b(EnumMainHand enummainhand) {
        return this.as() == enummainhand ? this.fq() : this.fr();
    }

    @Override
    @Nonnull
    public ItemStack el() {
        return this.fq();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemstack) -> itemstack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fq()) || predicate.test(this.fr());
    }

    public ItemStack b(EnumHand enumhand) {
        if (enumhand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (enumhand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void a(EnumHand enumhand, ItemStack itemstack) {
        if (enumhand == EnumHand.a) {
            this.a(EnumItemSlot.a, itemstack);
        } else {
            if (enumhand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.a(EnumItemSlot.b, itemstack);
        }
    }

    public boolean d(EnumItemSlot enumitemslot) {
        return !this.a(enumitemslot).f();
    }

    public boolean e(EnumItemSlot enumitemslot) {
        return true;
    }

    public ItemStack a(EnumItemSlot enumitemslot) {
        return this.bZ.a(enumitemslot);
    }

    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    public void setItemSlot(EnumItemSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.onEquipItem(enumitemslot, this.bZ.a(enumitemslot, itemstack), itemstack, silent);
    }

    public float fs() {
        int i2 = 0;
        int j2 = 0;
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemstack = this.a(enumitemslot);
            if (!itemstack.f()) {
                ++j2;
            }
            ++i2;
        }
        return i2 > 0 ? (float)j2 / (float)i2 : 0.0f;
    }

    @Override
    public void i(boolean flag) {
        super.i(flag);
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
        attributemodifiable.c(e.a());
        if (flag) {
            attributemodifiable.b(e);
        }
    }

    protected float ft() {
        return 1.0f;
    }

    public float fu() {
        return this.g_() ? (this.as.i() - this.as.i()) * 0.2f + 1.5f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    protected boolean fv() {
        return this.eV();
    }

    @Override
    public void h(Entity entity) {
        if (!this.gg()) {
            super.h(entity);
        }
    }

    private void G(Entity entity) {
        Vec3D vec3d;
        if (this.ec()) {
            vec3d = this.dD();
        } else if (!entity.ec() && !this.an().a_(entity.dF()).a(TagsBlock.aX)) {
            vec3d = entity.b(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.dM(), entity.dM());
            vec3d = new Vec3D(this.dK(), d0, this.dQ());
            boolean bl = flag = this.dA() <= 4.0f && this.dB() <= 4.0f;
            if (flag) {
                double d1 = (double)this.dB() / 2.0;
                Vec3D vec3d1 = vec3d.b(0.0, d1, 0.0);
                VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, this.dA(), this.dB(), this.dA()));
                vec3d = this.an().a((Entity)this, voxelshape, vec3d1, (double)this.dA(), (double)this.dB(), (double)this.dA()).map(vec3d2 -> vec3d2.b(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.l(vec3d.g, vec3d.h, vec3d.i);
    }

    @Override
    public boolean cZ() {
        return this.cY();
    }

    protected float fw() {
        return this.z(1.0f);
    }

    protected float z(float f2) {
        return (float)this.i(GenericAttributes.p) * f2 * this.bd() + this.fx();
    }

    public float fx() {
        return this.d(MobEffects.h) ? 0.1f * ((float)this.e(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void u() {
        float f2 = this.fw();
        if (f2 > 1.0E-5f) {
            Vec3D vec3d = this.dI();
            this.m(vec3d.g, Math.max((double)f2, vec3d.h), vec3d.i);
            if (this.cv()) {
                float f1 = this.dX() * ((float)Math.PI / 180);
                this.l(new Vec3D((double)(-MathHelper.a(f1)) * 0.2, 0.0, (double)MathHelper.b(f1) * 0.2));
            }
            this.aF = true;
        }
    }

    protected void fy() {
        this.k(this.dI().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> tagkey) {
        this.k(this.dI().b(0.0, 0.04f, 0.0));
    }

    protected float fz() {
        return 0.8f;
    }

    public boolean a(Fluid fluid) {
        return false;
    }

    @Override
    protected double bo() {
        return this.i(GenericAttributes.o);
    }

    protected double fA() {
        boolean flag = this.dI().h <= 0.0;
        return flag && this.d(MobEffects.B) ? Math.min(this.bp(), 0.01) : this.bp();
    }

    public void m(Vec3D vec3d) {
        Fluid fluid = this.an().b_(this.dF());
        if ((this.bu() || this.bJ()) && this.eB() && !this.a(fluid)) {
            this.o(vec3d);
        } else if (this.fY()) {
            this.p(vec3d);
        } else {
            this.a(vec3d);
        }
    }

    protected void a(Vec3D vec3d, float f2) {
        this.a(vec3d, 0.02f, 0.02f, f2);
    }

    protected void a(Vec3D vec3d, float f2, float f1, float f22) {
        if (this.bu()) {
            this.a(f2, vec3d);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c((double)0.8f));
        } else if (this.bJ()) {
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.5));
        } else {
            this.a(f22, vec3d);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c((double)0.91f));
        }
    }

    private void a(Vec3D vec3d) {
        BlockPosition blockposition = this.bb();
        float f2 = this.aS() ? this.an().a_(blockposition).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3d1 = this.b(vec3d, f2);
        double d0 = vec3d1.h;
        MobEffect mobeffect = this.e(MobEffects.y);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.e() + 1) - vec3d1.h) * 0.2) : (this.an().D_() && !this.an().D(blockposition) ? (this.dM() > (double)this.an().M_() ? -0.1 : 0.0) : (d0 -= this.fA()));
        if (this.eL()) {
            this.m(vec3d1.g, d0, vec3d1.i);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.m(vec3d1.g * (double)f1, d0 * (double)f22, vec3d1.i * (double)f1);
        }
    }

    private void o(Vec3D vec3d) {
        boolean flag = this.dI().h <= 0.0;
        double d0 = this.dM();
        double d1 = this.fA();
        if (this.bu()) {
            float f2 = this.cv() ? 0.9f : this.fz();
            float f1 = 0.02f;
            float f22 = (float)this.i(GenericAttributes.G);
            if (!this.aS()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fD() - f1) * f22;
            }
            if (this.d(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, vec3d);
            this.a(EnumMoveType.a, this.dI());
            Vec3D vec3d1 = this.dI();
            if (this.ad && this.fe()) {
                vec3d1 = new Vec3D(vec3d1.g, 0.2, vec3d1.i);
            }
            vec3d1 = vec3d1.d(f2, 0.8f, f2);
            this.k(this.a(d1, flag, vec3d1));
        } else {
            this.a(0.02f, vec3d);
            this.a(EnumMoveType.a, this.dI());
            if (this.b(TagsFluid.b) <= this.dz()) {
                this.k(this.dI().d(0.5, 0.8f, 0.5));
                Vec3D vec3d2 = this.a(d1, flag, this.dI());
                this.k(vec3d2);
            } else {
                this.k(this.dI().c(0.5));
            }
            if (d1 != 0.0) {
                this.k(this.dI().b(0.0, -d1 / 4.0, 0.0));
            }
        }
        Vec3D vec3d3 = this.dI();
        if (this.ad && this.f(vec3d3.g, vec3d3.h + (double)0.6f - this.dM() + d0, vec3d3.i)) {
            this.m(vec3d3.g, 0.3f, vec3d3.i);
        }
    }

    private void p(Vec3D vec3d) {
        if (this.fe()) {
            this.a(vec3d);
            this.fB();
        } else {
            Vec3D vec3d1 = this.dI();
            double d0 = vec3d1.i();
            this.k(this.q(vec3d1));
            this.a(EnumMoveType.a, this.dI());
            if (!this.an().D_()) {
                double d1 = this.dI().i();
                this.c(d0, d1);
            }
        }
    }

    public void fB() {
        if (CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            return;
        }
        this.b(7, true);
        this.b(7, false);
    }

    private Vec3D q(Vec3D vec3d) {
        Vec3D vec3d1 = this.cf();
        float f2 = this.dZ() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.g * vec3d1.g + vec3d1.i * vec3d1.i);
        double d1 = vec3d.i();
        double d2 = this.fA();
        double d3 = MathHelper.l(Math.cos(f2));
        vec3d = vec3d.b(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (vec3d.h < 0.0 && d0 > 0.0) {
            double d4 = vec3d.h * -0.1 * d3;
            vec3d = vec3d.b(vec3d1.g * d4 / d0, d4, vec3d1.i * d4 / d0);
        }
        if (f2 < 0.0f && d0 > 0.0) {
            double d5 = d1 * (double)(-MathHelper.a(f2)) * 0.04;
            vec3d = vec3d.b(-vec3d1.g * d5 / d0, d5 * 3.2, -vec3d1.i * d5 / d0);
        }
        if (d0 > 0.0) {
            vec3d = vec3d.b((vec3d1.g / d0 * d1 - vec3d.g) * 0.1, 0.0, (vec3d1.i / d0 * d1 - vec3d.i) * 0.1);
        }
        return vec3d.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double d0, double d1) {
        double d2;
        float f2;
        if (this.ad && (f2 = (float)((d2 = d0 - d1) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.ei().n(), f2);
        }
    }

    private void c(EntityHuman entityhuman, Vec3D vec3d) {
        Vec3D vec3d1 = this.b(entityhuman, vec3d);
        this.a(entityhuman, vec3d1);
        if (this.ds()) {
            this.B(this.f(entityhuman));
            this.m(vec3d1);
        } else {
            this.k(Vec3D.c);
        }
    }

    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
    }

    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return vec3d;
    }

    protected float f(EntityHuman entityhuman) {
        return this.fD();
    }

    public void s(boolean flag) {
        float f2 = (float)MathHelper.g(this.dK() - this.Y, flag ? this.dM() - this.Z : 0.0, this.dQ() - this.aa);
        if (!this.cl() && this.bX()) {
            this.A(f2);
        } else {
            this.bz.a();
        }
    }

    protected void A(float f2) {
        float f1 = Math.min(f2 * 4.0f, 1.0f);
        this.bz.a(f1, 0.4f, this.g_() ? 3.0f : 1.0f);
    }

    private Vec3D b(Vec3D vec3d, float f2) {
        this.a(this.G(f2), vec3d);
        this.k(this.r(this.dI()));
        this.a(EnumMoveType.a, this.dI());
        Vec3D vec3d1 = this.dI();
        if ((this.ad || this.bL) && (this.fe() || this.aK && PowderSnowBlock.a(this))) {
            vec3d1 = new Vec3D(vec3d1.g, 0.2, vec3d1.i);
        }
        return vec3d1;
    }

    public Vec3D a(double d0, boolean flag, Vec3D vec3d) {
        if (d0 != 0.0 && !this.cv()) {
            double d1 = flag && Math.abs(vec3d.h - 0.005) >= 0.003 && Math.abs(vec3d.h - d0 / 16.0) < 0.003 ? -0.003 : vec3d.h - d0 / 16.0;
            return new Vec3D(vec3d.g, d1, vec3d.i);
        }
        return vec3d;
    }

    private Vec3D r(Vec3D vec3d) {
        if (this.fe()) {
            this.l();
            float f2 = 0.15f;
            double d0 = MathHelper.a(vec3d.g, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(vec3d.i, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.h, (double)-0.15f);
            if (d2 < 0.0 && !this.dG().a(Blocks.oP) && this.fX() && this instanceof EntityHuman) {
                d2 = 0.0;
            }
            vec3d = new Vec3D(d0, d2, d1);
        }
        return vec3d;
    }

    private float G(float f2) {
        return this.aS() ? this.fD() * (0.21600002f / (f2 * f2 * f2)) : this.fC();
    }

    protected float fC() {
        return this.dg() instanceof EntityHuman ? this.fD() * 0.1f : 0.02f;
    }

    public float fD() {
        return this.ct;
    }

    public void B(float f2) {
        this.ct = f2;
    }

    public boolean c(WorldServer worldserver, Entity entity) {
        this.C(entity);
        return false;
    }

    @Override
    public void g() {
        super.g();
        this.P();
        this.Q();
        if (!this.an().D_()) {
            int j2;
            int i2 = this.fl();
            if (i2 > 0) {
                if (this.br <= 0) {
                    this.br = 20 * (30 - i2);
                }
                --this.br;
                if (this.br <= 0) {
                    this.o(i2 - 1);
                }
            }
            if ((j2 = this.fm()) > 0) {
                if (this.bs <= 0) {
                    this.bs = 20 * (30 - j2);
                }
                --this.bs;
                if (this.bs <= 0) {
                    this.p(j2 - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.at % 20 == 0) {
                this.fh().c();
            }
            if (!(!this.gg() || this.au() && this.R())) {
                this.gh();
            }
        }
        if (!this.ec()) {
            this.e_();
        }
        double d0 = this.dK() - this.Y;
        double d1 = this.dQ() - this.aa;
        float f2 = (float)(d0 * d0 + d1 * d1);
        float f1 = this.bB;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d0) * 57.295776f - 90.0f;
            float f3 = MathHelper.e(MathHelper.h(this.dX()) - f22);
            f1 = 95.0f < f3 && f3 < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.bx > 0.0f) {
            f1 = this.dX();
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("headTurn");
        this.C(f1);
        gameprofilerfiller.c();
        gameprofilerfiller.a("rangeChecks");
        while (this.dX() - this.ab < -180.0f) {
            this.ab -= 360.0f;
        }
        while (this.dX() - this.ab >= 180.0f) {
            this.ab += 360.0f;
        }
        while (this.bB - this.bC < -180.0f) {
            this.bC -= 360.0f;
        }
        while (this.bB - this.bC >= 180.0f) {
            this.bC += 360.0f;
        }
        while (this.dZ() - this.ac < -180.0f) {
            this.ac -= 360.0f;
        }
        while (this.dZ() - this.ac >= 180.0f) {
            this.ac += 360.0f;
        }
        while (this.bD - this.bE < -180.0f) {
            this.bE -= 360.0f;
        }
        while (this.bD - this.bE >= 180.0f) {
            this.bE += 360.0f;
        }
        gameprofilerfiller.c();
        this.bU = this.fY() ? ++this.bU : 0;
        if (this.gg()) {
            this.w(0.0f);
        }
        this.H();
        this.bF.a();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EnumItemSlot, ItemStack> map = this.N();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> N() {
        Map map = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemstack1;
            ItemStack itemstack = this.cm.get(enumItemSlot);
            if (!this.a(itemstack, itemstack1 = this.a(enumItemSlot))) continue;
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
            }
            map.put(enumItemSlot, itemstack1);
            AttributeMapBase attributemapbase = this.fp();
            if (itemstack.f()) continue;
            this.a(itemstack, enumItemSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot enumitemslot1 = (EnumItemSlot)entry.getKey();
                ItemStack itemstack2 = (ItemStack)entry.getValue();
                if (itemstack2.f() || itemstack2.q()) continue;
                itemstack2.a(enumitemslot1, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    AttributeModifiable attributemodifiable = this.cj.a((Holder<AttributeBase>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.c(attributemodifier.a());
                        attributemodifiable.b((AttributeModifier)attributemodifier);
                    }
                });
                net.minecraft.world.level.World world = this.an();
                if (!(world instanceof WorldServer)) continue;
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, itemstack2, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.a(itemstack1, itemstack);
    }

    private void a(Map<EnumItemSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EnumItemSlot.a);
        ItemStack itemstack1 = map.get(EnumItemSlot.b);
        if (itemstack != null && itemstack1 != null && ItemStack.a(itemstack, this.cm.get(EnumItemSlot.b)) && ItemStack.a(itemstack1, this.cm.get(EnumItemSlot.a))) {
            ((WorldServer)this.an()).n().b(this, new PacketPlayOutEntityStatus(this, 55));
            map.remove(EnumItemSlot.a);
            map.remove(EnumItemSlot.b);
            this.cm.put(EnumItemSlot.a, itemstack.v());
            this.cm.put(EnumItemSlot.b, itemstack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.v();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            this.cm.put((EnumItemSlot)enumitemslot, itemstack1);
        });
        ((WorldServer)this.an()).n().b(this, new PacketPlayOutEntityEquipment(this.az(), list));
    }

    protected void C(float f2) {
        float f1 = MathHelper.h(f2 - this.bB);
        this.bB += f1 * 0.3f;
        float f22 = MathHelper.h(this.dX() - this.bB);
        float f3 = this.fE();
        if (Math.abs(f22) > f3) {
            this.bB += f22 - (float)MathHelper.k((double)f22) * f3;
        }
    }

    protected float fE() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void e_() {
        if (this.cu > 0) {
            --this.cu;
        }
        if (this.cd()) {
            this.n_().e();
        } else if (!this.ds()) {
            this.k(this.dI().c(0.98));
        }
        if (this.bR > 0) {
            this.a(this.bR, this.bQ);
            --this.bR;
        }
        this.bZ.a((Entity)this);
        vec3d = this.dI();
        d0 = vec3d.g;
        d1 = vec3d.h;
        d2 = vec3d.i;
        if (this.ax().equals(EntityTypes.bX)) {
            if (vec3d.j() < 9.0E-6) {
                d0 = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(vec3d.g) < 0.003) {
                d0 = 0.0;
            }
            if (Math.abs(vec3d.i) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(vec3d.h) < 0.003) {
            d1 = 0.0;
        }
        this.m(d0, d1, d2);
        gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("ai");
        this.fF();
        if (this.fv()) {
            this.bL = false;
            this.bM = 0.0f;
            this.bO = 0.0f;
        } else if (this.dt() && !this.an().D_()) {
            gameprofilerfiller.a("newAi");
            this.fK();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("jump");
        if (this.bL && this.eB()) {
            d3 = this.bJ() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bu() != false && d3 > 0.0;
            d4 = this.dz();
            if (!flag || this.aS() && d3 <= d4) {
                if (!this.bJ() || this.aS() && d3 <= d4) {
                    if ((this.aS() || flag && d3 <= d4) && this.cu == 0) {
                        this.u();
                        this.cu = 10;
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.cu = 0;
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("travel");
        if (this.fY()) {
            this.fI();
        }
        axisalignedbb = this.de();
        vec3d1 = new Vec3D(this.bM, this.bN, this.bO);
        if (this.d(MobEffects.B) || this.d(MobEffects.y)) {
            this.l();
        }
        if (!((entityliving = this.dg()) instanceof EntityHuman)) ** GOTO lbl-1000
        entityhuman = (EntityHuman)entityliving;
        if (this.bX()) {
            this.c(entityhuman, vec3d1);
        } else if (this.ds() && this.dt()) {
            this.m(vec3d1);
        }
        if (!this.an().D_() || this.dq()) {
            this.aT();
        }
        if (this.an().D_()) {
            this.s(this instanceof EntityBird);
        }
        gameprofilerfiller.c();
        world = this.an();
        if (world instanceof WorldServer) {
            worldserver = (WorldServer)world;
            gameprofilerfiller.a("freezing");
            if (!this.aJ || !this.dV()) {
                this.k(Math.max(0, this.cH() - 2));
            }
            this.ex();
            this.ey();
            if (this.at % 40 == 0 && this.cJ() && this.dV()) {
                this.a(worldserver, this.ei().v(), 1.0f);
            }
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("push");
        if (this.bV > 0) {
            --this.bV;
            this.a(axisalignedbb, this.de());
        }
        this.q();
        gameprofilerfiller.c();
        world = this.an();
        if (world instanceof WorldServer) {
            worldserver1 = (WorldServer)world;
            if (this.fG() && this.bw()) {
                this.a(worldserver1, this.ei().i(), 1.0f);
            }
        }
    }

    protected void fF() {
        this.bM *= 0.98f;
        this.bO *= 0.98f;
    }

    public boolean fG() {
        return false;
    }

    public boolean fH() {
        return this.bL;
    }

    protected void fI() {
        this.cL();
        if (!this.an().D_()) {
            if (!this.fJ()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bU + 1;
            if (i2 % 10 == 0) {
                int j2 = i2 / 10;
                if (j2 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(enumitemslot -> EntityLiving.b(this.a((EnumItemSlot)enumitemslot), enumitemslot)).toList();
                    EnumItemSlot enumitemslot2 = SystemUtils.a(list, this.as);
                    this.a(enumitemslot2).a(1, this, enumitemslot2);
                }
                this.c(GameEvent.n);
            }
        }
    }

    protected boolean fJ() {
        if (!(this.aS() || this.cl() || this.d(MobEffects.y))) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(enumitemslot), enumitemslot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fK() {
    }

    protected void q() {
        List<Entity> list = this.an().i(this, this.de());
        if (!list.isEmpty()) {
            WorldServer worldserver;
            int i2;
            net.minecraft.world.level.World world = this.an();
            if (world instanceof WorldServer && (i2 = (worldserver = (WorldServer)world).S().d(GameRules.w)) > 0 && list.size() > i2 - 1 && this.as.a(4) == 0) {
                int j2 = 0;
                for (Entity entity : list) {
                    if (entity.cl()) continue;
                    ++j2;
                }
                if (j2 > i2 - 1) {
                    this.a(worldserver, this.ei().h(), 6.0f);
                }
            }
            for (Entity entity1 : list) {
                this.E(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB axisalignedbb, AxisAlignedBB axisalignedbb1) {
        AxisAlignedBB axisalignedbb2 = axisalignedbb.b(axisalignedbb1);
        List<Entity> list = this.an().a_(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityLiving)) continue;
                this.f((EntityLiving)entity);
                this.bV = 0;
                this.k(this.dI().c(-0.2));
                break;
            }
        } else if (this.ad) {
            this.bV = 0;
        }
        if (!this.an().D_() && this.bV <= 0) {
            this.c(4, false);
            this.bW = 0.0f;
            this.bX = null;
        }
    }

    protected void E(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving entityliving) {
    }

    public boolean fL() {
        return (this.az.a(bj) & 4) != 0;
    }

    @Override
    public void cb() {
        Entity entity = this.du();
        super.cb();
        if (entity != null && entity != this.du() && !this.an().D_()) {
            this.G(entity);
        }
    }

    @Override
    public void t() {
        super.t();
        this.l();
    }

    @Override
    public InterpolationHandler n_() {
        return this.bP;
    }

    @Override
    public void a(float f2, int i2) {
        this.bQ = f2;
        this.bR = i2;
    }

    public void t(boolean flag) {
        this.bL = flag;
    }

    public void a(EntityItem entityitem) {
        Entity entity = entityitem.ai_();
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)entity, entityitem.e(), this);
        }
    }

    public void a(Entity entity, int i2) {
        if (!entity.ec() && !this.an().D_() && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.an()).n().b(entity, new PacketPlayOutCollect(entity.az(), this.az(), i2));
        }
    }

    public boolean F(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dO());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption raytrace_blockcollisionoption, RayTrace.FluidCollisionOption raytrace_fluidcollisionoption, double d0) {
        if (entity.an() != this.an()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.dK(), this.dO(), this.dQ());
        Vec3D vec3d1 = new Vec3D(entity.dK(), d0, entity.dQ());
        return vec3d1.f(vec3d) > 128.0 ? false : this.an().a(new RayTrace(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float f2) {
        return f2 == 1.0f ? this.bD : MathHelper.i(f2, this.bE, this.bD);
    }

    public float D(float f2) {
        float f1 = this.bx - this.bw;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.bw + f1 * f2;
    }

    @Override
    public boolean bT() {
        return !this.ec() && this.collides;
    }

    @Override
    public boolean bU() {
        return this.bX() && !this.at() && !this.fe() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bU() && this.collides != this.collidableExemptions.contains(entity.cT());
    }

    @Override
    public float cN() {
        return this.bD;
    }

    @Override
    public void r(float f2) {
        this.bD = f2;
    }

    @Override
    public void s(float f2) {
        this.bB = f2;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.n(super.a(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3D n(Vec3D vec3d) {
        return new Vec3D(vec3d.g, vec3d.h, 0.0);
    }

    public float fM() {
        return this.cv;
    }

    public final void E(float f2) {
        this.F(MathHelper.a(f2, 0.0f, this.fk()));
    }

    protected void F(float f2) {
        this.cv = f2;
    }

    public void i_() {
    }

    public void Q_() {
    }

    protected void fN() {
        this.co = true;
    }

    public abstract EnumMainHand as();

    public boolean fO() {
        return (this.az.a(bj) & 1) > 0;
    }

    public EnumHand fP() {
        return (this.az.a(bj) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    private void P() {
        if (this.fO()) {
            if (ItemStack.b(this.b(this.fP()), this.bS)) {
                this.bS = this.b(this.fP());
                this.a(this.bS);
            } else {
                this.fU();
            }
        }
    }

    @Nullable
    private EntityItem b(ItemStack itemstack, boolean flag, boolean flag1) {
        if (itemstack.f()) {
            return null;
        }
        double d0 = this.dO() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.an(), this.dK(), d0, this.dQ(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.as.i() * 0.5f;
            float f1 = this.as.i() * ((float)Math.PI * 2);
            entityitem.m(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f2 = 0.3f;
            float f3 = MathHelper.a(this.dZ() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dZ() * ((float)Math.PI / 180));
            float f5 = MathHelper.a(this.dX() * ((float)Math.PI / 180));
            float f6 = MathHelper.b(this.dX() * ((float)Math.PI / 180));
            float f7 = this.as.i() * ((float)Math.PI * 2);
            float f8 = 0.02f * this.as.i();
            entityitem.m((double)(-f5 * f4 * 0.3f) + Math.cos(f7) * (double)f8, -f3 * 0.3f + 0.1f + (this.as.i() - this.as.i()) * 0.1f, (double)(f6 * f4 * 0.3f) + Math.sin(f7) * (double)f8);
        }
        return entityitem;
    }

    protected void a(ItemStack itemstack) {
        itemstack.b(this.an(), this, this.fR());
        if (--this.bT == 0 && !this.an().D_() && !itemstack.x()) {
            this.R_();
        }
    }

    private void Q() {
        this.cB = this.cA;
        this.cA = this.cx() ? Math.min(1.0f, this.cA + 0.09f) : Math.max(0.0f, this.cA - 0.09f);
    }

    public void c(int i2, boolean flag) {
        int j2 = this.az.a(bj).byteValue();
        j2 = flag ? (j2 |= i2) : (j2 &= ~i2);
        this.az.a(bj, (byte)j2);
    }

    public void c(EnumHand enumhand) {
        ItemStack itemstack = this.b(enumhand);
        if (!itemstack.f() && !this.fO()) {
            this.bS = itemstack;
            this.bT = itemstack.a(this);
            if (!this.an().D_()) {
                this.c(1, true);
                this.c(2, enumhand == EnumHand.b);
                this.c(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (cg.equals(datawatcherobject)) {
            if (this.an().D_()) {
                this.ge().ifPresent(this::a);
            }
        } else if (bj.equals(datawatcherobject) && this.an().D_()) {
            if (this.fO() && this.bS.f()) {
                this.bS = this.b(this.fP());
                if (!this.bS.f()) {
                    this.bT = this.bS.a(this);
                }
            } else if (!this.fO() && !this.bS.f()) {
                this.bS = ItemStack.l;
                this.bT = 0;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.bE = this.bD;
        this.bC = this.bB = this.bD;
    }

    @Override
    public float t(float f2) {
        return MathHelper.h(f2, this.bC, this.bB);
    }

    public void b(ItemStack itemstack, int i2) {
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = new Vec3D(((double)this.as.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.a(-this.dZ() * ((float)Math.PI / 180));
            vec3d = vec3d.b(-this.dX() * ((float)Math.PI / 180));
            double d0 = (double)(-this.as.i()) * 0.6 - 0.3;
            Vec3D vec3d1 = new Vec3D(((double)this.as.i() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.a(-this.dZ() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(-this.dX() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.b(this.dK(), this.dO(), this.dQ());
            this.an().a(new ParticleParamItem(Particles.V, itemstack), vec3d1.g, vec3d1.h, vec3d1.i, vec3d.g, vec3d.h + 0.05, vec3d.i);
        }
    }

    protected void R_() {
        if (!this.an().D_() || this.fO()) {
            EnumHand enumhand = this.fP();
            if (!this.bS.equals(this.b(enumhand))) {
                this.fT();
            } else if (!this.bS.f() && this.fO()) {
                ItemStack itemstack;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bS);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bS.a(DataComponents.w);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.bS);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.bS.a(this.an(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.an(), this);
                } else {
                    itemstack = this.bS.a(this.an(), this);
                }
                if (itemstack != this.bS) {
                    this.a(enumhand, itemstack);
                }
                this.fU();
            }
        }
    }

    public void b(ItemStack itemstack) {
    }

    public ItemStack fQ() {
        return this.bS;
    }

    public int fR() {
        return this.bT;
    }

    public int fS() {
        return this.fO() ? this.bS.a(this) - this.fR() : 0;
    }

    public void fT() {
        ItemStack itemstack = this.b(this.fP());
        if (!this.bS.f() && ItemStack.b(itemstack, this.bS)) {
            this.bS = itemstack;
            this.bS.a(this.an(), this, this.fR());
            if (this.bS.x()) {
                this.P();
            }
        }
        this.fU();
    }

    public void fU() {
        if (!this.an().D_()) {
            boolean flag = this.fO();
            this.c(1, false);
            if (flag) {
                this.c(GameEvent.C);
            }
        }
        this.bS = ItemStack.l;
        this.bT = 0;
    }

    public boolean fV() {
        return this.fW() != null;
    }

    @Nullable
    public ItemStack fW() {
        int i2;
        if (!this.fO()) {
            return null;
        }
        BlocksAttacks blocksattacks = this.bS.a(DataComponents.I);
        if (blocksattacks != null && (i2 = this.bS.h().a(this.bS, this) - this.bT) >= blocksattacks.a()) {
            return this.bS;
        }
        return null;
    }

    public boolean fX() {
        return this.cp();
    }

    public boolean fY() {
        return this.i(7);
    }

    @Override
    public boolean cx() {
        return super.cx() || !this.fY() && this.d(EntityPose.b);
    }

    public int fZ() {
        return this.bU;
    }

    public boolean b(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.dK();
        double d4 = this.dM();
        double d5 = this.dQ();
        double d6 = d1;
        boolean flag1 = false;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        net.minecraft.world.level.World world = this.an();
        if (world.D(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.v() > world.M_()) {
                BlockPosition blockposition1 = blockposition.e();
                IBlockData iblockdata = world.a_(blockposition1);
                if (iblockdata.d()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.a_(d0, d6, d2);
                if (world.g(this) && !world.d(this.de())) {
                    flag1 = true;
                }
                this.a_(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.an().getWorld(), d3, d4, d5), new Location((World)this.an().getWorld(), d0, d6, d2));
                        this.an().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).g.teleport(d0, d6, d2, this.dX(), this.dZ(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.a((Entity)this, (byte)46);
        }
        if (!(this instanceof EntityCreature)) return Optional.of(true);
        EntityCreature entitycreature = (EntityCreature)this;
        entitycreature.S().n();
        return Optional.of(true);
    }

    public boolean ga() {
        return !this.eV();
    }

    public boolean gb() {
        return true;
    }

    public void a(BlockPosition blockposition, boolean flag) {
    }

    public boolean gc() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.c ? bk : this.b(entitypose).a(this.eA());
    }

    protected EntitySize b(EntityPose entitypose) {
        return this.ax().n().a(this.ez());
    }

    public ImmutableList<EntityPose> gd() {
        return ImmutableList.of((Object)EntityPose.a);
    }

    public AxisAlignedBB f(EntityPose entitypose) {
        EntitySize entitysize = this.a(entitypose);
        return new AxisAlignedBB(-entitysize.a() / 2.0f, 0.0, -entitysize.a() / 2.0f, entitysize.a() / 2.0f, entitysize.b(), entitysize.a() / 2.0f);
    }

    protected boolean g(EntityPose entitypose) {
        AxisAlignedBB axisalignedbb = this.a(entitypose).a(this.dD());
        return this.an().b(this, axisalignedbb);
    }

    @Override
    public boolean o(boolean flag) {
        return super.o(flag) && !this.gg();
    }

    public Optional<BlockPosition> ge() {
        return this.az.a(cg);
    }

    public void g(BlockPosition blockposition) {
        this.az.a(cg, Optional.of(blockposition));
    }

    public void gf() {
        this.az.a(cg, Optional.empty());
    }

    public boolean gg() {
        return this.ge().isPresent();
    }

    public void b(BlockPosition blockposition) {
        IBlockData iblockdata;
        if (this.cl()) {
            this.cb();
        }
        if ((iblockdata = this.an().a_(blockposition)).b() instanceof BlockBed) {
            this.an().a(blockposition, (IBlockData)iblockdata.b(BlockBed.c, true), 3);
        }
        this.c(EntityPose.c);
        this.a(blockposition);
        this.g(blockposition);
        this.k(Vec3D.c);
        this.aF = true;
    }

    private void a(BlockPosition blockposition) {
        this.a_((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.6875, (double)blockposition.w() + 0.5);
    }

    private boolean R() {
        return this.ge().map(blockposition -> this.an().a_((BlockPosition)blockposition).b() instanceof BlockBed).orElse(false);
    }

    public void gh() {
        Optional<BlockPosition> optional = this.ge();
        net.minecraft.world.level.World world = this.an();
        Objects.requireNonNull(world);
        optional.filter(world::D).ifPresent(blockposition -> {
            IBlockData iblockdata = this.an().a_((BlockPosition)blockposition);
            if (iblockdata.b() instanceof BlockBed) {
                EnumDirection enumdirection = (EnumDirection)iblockdata.c(BlockBed.f);
                this.an().a((BlockPosition)blockposition, (IBlockData)iblockdata.b(BlockBed.c, false), 3);
                Vec3D vec3d = BlockBed.a(this.ax(), (ICollisionAccess)this.an(), blockposition, enumdirection, this.dX()).orElseGet(() -> {
                    BlockPosition blockposition1 = blockposition.d();
                    return new Vec3D((double)blockposition1.u() + 0.5, (double)blockposition1.v() + 0.1, (double)blockposition1.w() + 0.5);
                });
                Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
                float f2 = (float)MathHelper.e(MathHelper.d(vec3d1.i, vec3d1.g) * 57.2957763671875 - 90.0);
                this.a_(vec3d.g, vec3d.h, vec3d.i);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3d = this.dD();
        this.c(EntityPose.a);
        this.a_(vec3d.g, vec3d.h, vec3d.i);
        this.gf();
    }

    @Nullable
    public EnumDirection gi() {
        BlockPosition blockposition = this.ge().orElse(null);
        return blockposition != null ? BlockBed.a(this.an(), blockposition) : null;
    }

    @Override
    public boolean bY() {
        return !this.gg() && super.bY();
    }

    public ItemStack d(ItemStack itemstack) {
        return ItemStack.l;
    }

    private static byte g(EnumItemSlot enumitemslot) {
        return switch (enumitemslot) {
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
            default -> throw new MatchException(null, null);
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot enumitemslot) {
        this.an().a((Entity)this, EntityLiving.g(enumitemslot));
        this.a(this.a(enumitemslot), enumitemslot, this.cj);
    }

    private void a(ItemStack itemstack, EnumItemSlot enumitemslot, AttributeMapBase attributemapbase) {
        itemstack.a(enumitemslot, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
            AttributeModifiable attributemodifiable = attributemapbase.a((Holder<AttributeBase>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.e((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentManager.a(itemstack, this, enumitemslot);
    }

    public final boolean e(ItemStack itemstack) {
        if (this.bX() && !this.at()) {
            Equippable equippable = itemstack.a(DataComponents.D);
            if (equippable != null && equippable.g()) {
                EnumItemSlot enumitemslot = equippable.b();
                return this.e(enumitemslot) && equippable.a(this.ax()) ? this.a(enumitemslot).f() && this.f(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot enumitemslot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack itemstack) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack itemstack, EnumItemSlot enumitemslot) {
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable == null ? enumitemslot == EnumItemSlot.a && this.e(EnumItemSlot.a) : enumitemslot == equippable.b() && this.e(equippable.b()) && equippable.a(this.ax());
    }

    private static SlotAccess a(EntityLiving entityliving, EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.f && enumitemslot != EnumItemSlot.a && enumitemslot != EnumItemSlot.b ? SlotAccess.a(entityliving, enumitemslot, (ItemStack itemstack) -> itemstack.f() || entityliving.f((ItemStack)itemstack) == enumitemslot) : SlotAccess.a(entityliving, enumitemslot);
    }

    @Nullable
    private static EnumItemSlot r(int i2) {
        return i2 == 100 + EnumItemSlot.f.b() ? EnumItemSlot.f : (i2 == 100 + EnumItemSlot.e.b() ? EnumItemSlot.e : (i2 == 100 + EnumItemSlot.d.b() ? EnumItemSlot.d : (i2 == 100 + EnumItemSlot.c.b() ? EnumItemSlot.c : (i2 == 98 ? EnumItemSlot.a : (i2 == 99 ? EnumItemSlot.b : (i2 == 105 ? EnumItemSlot.g : (i2 == 106 ? EnumItemSlot.h : null)))))));
    }

    @Override
    public SlotAccess a_(int i2) {
        EnumItemSlot enumitemslot = EntityLiving.r(i2);
        return enumitemslot != null ? EntityLiving.a(this, enumitemslot) : super.a_(i2);
    }

    @Override
    public boolean dV() {
        if (this.at()) {
            return false;
        }
        for (EnumItemSlot enumitemslot : EquipmentSlotGroup.i) {
            if (!this.a(enumitemslot).a(TagsItem.bH)) continue;
            return false;
        }
        return super.dV();
    }

    @Override
    public boolean cA() {
        return !this.an().D_() && this.d(MobEffects.x) || super.cA();
    }

    @Override
    public float dY() {
        return this.bB;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        float f2 = packetplayoutspawnentity.l();
        float f1 = packetplayoutspawnentity.k();
        this.e(d0, d1, d2);
        this.bB = packetplayoutspawnentity.m();
        this.bD = packetplayoutspawnentity.m();
        this.bC = this.bB;
        this.bE = this.bD;
        this.e(packetplayoutspawnentity.b());
        this.a_(packetplayoutspawnentity.e());
        this.a(d0, d1, d2, f2, f1);
        this.k(packetplayoutspawnentity.j());
    }

    public float gj() {
        Weapon weapon = this.el().a(DataComponents.B);
        return weapon != null ? weapon.b() : 0.0f;
    }

    @Override
    public float eb() {
        float f2 = (float)this.i(GenericAttributes.C);
        return this.dg() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D n(Entity entity) {
        return this.dD().e(this.a(entity, this.a(this.aE()), this.eA() * this.ez()));
    }

    protected void a(int i2, double d0) {
        this.bD = (float)MathHelper.e(1.0 / (double)i2, (double)this.bD, d0);
    }

    @Override
    public void g(int i2) {
        super.g(MathHelper.c((double)i2 * this.i(GenericAttributes.h)));
    }

    public boolean gk() {
        return false;
    }

    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.d(damagesource) || EnchantmentManager.a(worldserver, this, damagesource);
    }

    public static boolean b(ItemStack itemstack, EnumItemSlot enumitemslot) {
        if (!itemstack.c(DataComponents.F)) {
            return false;
        }
        Equippable equippable = itemstack.a(DataComponents.D);
        return equippable != null && enumitemslot == equippable.b() && !itemstack.r();
    }

    @VisibleForTesting
    public int gl() {
        return this.bH;
    }

    @Override
    public boolean gm() {
        return this.i(GenericAttributes.H) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.c> f(EntityPlayer entityplayer) {
        if (!this.ay && entityplayer != this) {
            if (WaypointTransmitter.a(this, entityplayer)) {
                return Optional.empty();
            }
            Waypoint.a waypoint_a = this.cE.a(this);
            return WaypointTransmitter.b(this, entityplayer) ? Optional.of(new WaypointTransmitter.d(this, waypoint_a, entityplayer)) : (!WaypointTransmitter.a(this.dH(), entityplayer) ? Optional.of(new WaypointTransmitter.f(this, waypoint_a, entityplayer)) : Optional.of(new WaypointTransmitter.e(this, waypoint_a, entityplayer)));
        }
        return Optional.empty();
    }

    @Override
    public Waypoint.a gn() {
        return this.cE;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

