/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cw = 6000;
    private static final int ct = 0;
    public int cu = 0;
    @Nullable
    public EntityReference<EntityPlayer> cv;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gN() {
        return EntityInsentient.I().a(GenericAttributes.F, 10.0);
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.aa_() != 0) {
            this.cu = 0;
        }
        super.a(worldserver);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.aa_() != 0) {
            this.cu = 0;
        }
        if (this.cu > 0) {
            --this.cu;
            if (this.cu % 10 == 0) {
                double d0 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d2 = this.as.k() * 0.02;
                this.an().a(Particles.T, this.e(1.0), this.dN() + 0.5, this.h(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gT();
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.i) ? 10.0f : iworldreader.y(blockposition);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("InLove", this.cu);
        EntityReference.a(this.cv, valueoutput, "LoveCause");
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cu = valueinput.a("InLove", 0);
        this.cv = EntityReference.a(valueinput, "LoveCause");
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = EntitySpawnReason.b(entityspawnreason) || EntityAnimal.a(generatoraccess, blockposition);
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.ck) && flag;
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int W() {
        return 120;
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    protected int f(WorldServer worldserver) {
        return 1 + this.as.a(3);
    }

    public abstract boolean i(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.i(itemstack)) {
            int i2 = this.aa_();
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                if (i2 == 0 && this.gP()) {
                    this.a(entityhuman, enumhand, itemstack);
                    this.h(entityplayer);
                    this.gO();
                    return EnumInteractionResult.b;
                }
            }
            if (this.g_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                this.gO();
                return EnumInteractionResult.a;
            }
            if (this.an().D_()) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void gO() {
    }

    public boolean gP() {
        return this.cu <= 0;
    }

    public void h(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.cu = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            this.cv = EntityReference.a(entityplayer);
        }
        this.breedItem = entityhuman.gB().h();
        this.an().a((Entity)this, (byte)18);
    }

    public void r(int i2) {
        this.cu = i2;
    }

    public int gQ() {
        return this.cu;
    }

    @Nullable
    public EntityPlayer gR() {
        return EntityReference.a(this.cv, this.an(), EntityPlayer.class);
    }

    public boolean gS() {
        return this.cu > 0;
    }

    public void gT() {
        this.cu = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.gS() && entityanimal.gS());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dK(), this.dM(), this.dQ(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gR()).or(() -> Optional.ofNullable(entityanimal.gR())).orElse(null);
            int experience = this.ek().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.ek().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.gR()).or(() -> Optional.ofNullable(entityanimal.gR())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.Q);
            CriterionTriggers.p.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.c_(6000);
        entityanimal.c_(6000);
        this.gT();
        entityanimal.gT();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.S().c(GameRules.g) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dK(), this.dM(), this.dQ(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d2 = this.as.k() * 0.02;
                this.an().a(Particles.T, this.e(1.0), this.dN() + 0.5, this.h(1.0), d0, d1, d2);
            }
        } else {
            super.b(b0);
        }
    }
}

