/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> ct = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<PigVariant>> cu = DataWatcher.a(EntityPig.class, DataWatcherRegistry.C);
    public final SaddleStorage cv;

    public EntityPig(EntityTypes<? extends EntityPig> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cv = new SaddleStorage(this.az, ct);
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(1, new PathfinderGoalPanic(this, 1.25));
        this.cq.a(3, new PathfinderGoalBreed(this, 1.0));
        this.cq.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(Items.pn), false));
        this.cq.a(4, new PathfinderGoalTempt(this, 1.2, itemstack -> itemstack.a(TagsItem.aY), false));
        this.cq.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.cq.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.am() && (entity = this.dj()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.pn)) {
            return entityhuman;
        }
        return super.dg();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (ct.equals(datawatcherobject) && this.an().D_()) {
            this.cv.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ct, 0);
        datawatcher_a.a(cu, VariantUtils.a(this.ej(), PigVariants.d));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        VariantUtils.a(valueoutput, this.n());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        VariantUtils.a(valueinput, Registries.bi).ifPresent(this::b);
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.vt;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.vv;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.vu;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.vx, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.i(entityhuman.b(enumhand));
        if (!flag && this.am() && !this.cm() && !entityhuman.gp()) {
            if (!this.an().D_()) {
                entityhuman.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return this.a(itemstack, EnumItemSlot.h) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.e;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean e(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.h ? super.e(enumitemslot) : this.bX() && !this.g_();
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.h || super.f(enumitemslot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EnumItemSlot.h ? SoundEffects.vw : super.a(enumitemslot, itemstack, equippable);
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        EnumDirection enumdirection = this.dc();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(entityliving);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dF();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : entityliving.gd()) {
            AxisAlignedBB axisalignedbb = entityliving.f(entitypose);
            for (int[] aint1 : aint) {
                blockposition_mutableblockposition.d(blockposition.u() + aint1[0], blockposition.v(), blockposition.w() + aint1[1]);
                double d0 = this.an().j(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0)) continue;
                Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                if (!DismountUtil.a(this.an(), entityliving, axisalignedbb.c(vec3d))) continue;
                entityliving.c(entitypose);
                return vec3d;
            }
        }
        return super.b(entityliving);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.aq() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = this.convertTo(EntityTypes.bW, ConversionParams.a(this, false, true), entitypigzombie1 -> {
                if (this.fq().f()) {
                    entitypigzombie1.a(EnumItemSlot.a, new ItemStack(Items.qC));
                }
                entitypigzombie1.gq();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, entitylightning, entitypigzombie).isCancelled()) {
                return;
            }
            worldserver.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (entitypigzombie == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        super.a(entityhuman, vec3d);
        this.a(entityhuman.dX(), entityhuman.dZ() * 0.5f);
        this.bB = this.bD = this.dX();
        this.ab = this.bD;
        this.cv.b();
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman entityhuman) {
        return (float)(this.i(GenericAttributes.w) * 0.225 * (double)this.cv.c());
    }

    @Override
    public boolean a() {
        return this.cv.a(this.ek());
    }

    @Nullable
    public EntityPig b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityPig entitypig = EntityTypes.aV.a(worldserver, EntitySpawnReason.e);
        if (entitypig != null && entityageable instanceof EntityPig) {
            EntityPig entitypig1 = (EntityPig)entityageable;
            entitypig.b(this.as.h() ? this.n() : entitypig1.n());
        }
        return entitypig;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.aY);
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    public void b(Holder<PigVariant> holder) {
        this.az.a(cu, holder);
    }

    public Holder<PigVariant> n() {
        return this.az.a(cu);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aH ? EntityPig.c(datacomponenttype, this.n()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aH);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aH) {
            this.b(EntityPig.c(DataComponents.aH, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        VariantUtils.a(SpawnContext.a(worldaccess, this.dF()), Registries.bi).ifPresent(this::b);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }
}

