/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class EntityItemFrame
extends EntityHanging {
    public static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> d = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int b = 8;
    private static final float e = 0.0625f;
    private static final float f = 0.75f;
    private static final float g = 0.75f;
    private static final byte h = 0;
    private static final float i = 1.0f;
    private static final boolean j = false;
    private static final boolean k = false;
    public float l = 1.0f;
    public boolean m = false;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world);
        this.l(false);
    }

    public EntityItemFrame(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        this(EntityTypes.aw, world, blockposition, enumdirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world, blockposition);
        this.b(enumdirection);
        this.l(false);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(c, ItemStack.l);
        datawatcher_a.a(d, 0);
    }

    @Override
    public void b(EnumDirection enumdirection) {
        Objects.requireNonNull(enumdirection);
        super.a(enumdirection);
        if (enumdirection.o().d()) {
            this.w(0.0f);
            this.v(enumdirection.e() * 90);
        } else {
            this.w(-90 * enumdirection.f().a());
            this.v(0.0f);
        }
        this.ac = this.dZ();
        this.ab = this.dX();
        this.e();
    }

    @Override
    protected final void e() {
        super.e();
        this.e(this.dK(), this.dM(), this.dQ());
    }

    @Override
    protected AxisAlignedBB a(BlockPosition blockposition, EnumDirection enumdirection) {
        return EntityItemFrame.calculateBoundingBoxStatic(blockposition, enumdirection, this.w());
    }

    public static AxisAlignedBB calculateBoundingBoxStatic(BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        float f2 = 0.46875f;
        Vec3D vec3d = Vec3D.b(blockposition).a(enumdirection, -0.46875);
        float f1 = flag ? 1.0f : 0.75f;
        float f22 = flag ? 1.0f : 0.75f;
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        double d0 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? 0.0625 : (double)f1;
        double d1 = enumdirection_enumaxis == EnumDirection.EnumAxis.b ? 0.0625 : (double)f22;
        double d2 = enumdirection_enumaxis == EnumDirection.EnumAxis.c ? 0.0625 : (double)f1;
        return AxisAlignedBB.a(vec3d, d0, d1, d2);
    }

    @Override
    public boolean f() {
        if (this.m) {
            return true;
        }
        if (!this.an().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.an().a_(this.a.a(this.db().g()));
        return iblockdata.e() || this.db().o().d() && BlockDiodeAbstract.p(iblockdata) ? this.a(true) : false;
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (!this.m) {
            super.a(enummovetype, vec3d);
        }
    }

    @Override
    public void i(double d0, double d1, double d2) {
        if (!this.m) {
            super.i(d0, d1, d2);
        }
    }

    @Override
    public void c(WorldServer worldserver) {
        this.d(this.v());
        super.c(worldserver);
    }

    private boolean a(DamageSource damagesource) {
        return !damagesource.a(DamageTypeTags.l) && !this.v().f();
    }

    private static boolean e(DamageSource damagesource) {
        return damagesource.a(DamageTypeTags.d) || damagesource.h();
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return this.m && !EntityItemFrame.e(damagesource) ? false : !this.d(damagesource);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!this.m) {
            if (this.d(damagesource)) {
                return false;
            }
            if (this.a(damagesource)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false) || this.ec()) {
                    return true;
                }
                this.a(worldserver, damagesource.d(), false);
                this.a(GameEvent.c, damagesource.d());
                this.a(this.k(), 1.0f, 1.0f);
                return true;
            }
            return super.a(worldserver, damagesource, f2);
        }
        return EntityItemFrame.e(damagesource) && super.a(worldserver, damagesource, f2);
    }

    public SoundEffect k() {
        return SoundEffects.ph;
    }

    @Override
    public boolean a(double d0) {
        double d1 = 16.0;
        return d0 < (d1 *= 64.0 * EntityItemFrame.cX()) * d1;
    }

    @Override
    public void a(WorldServer worldserver, @Nullable Entity entity) {
        this.a(this.m(), 1.0f, 1.0f);
        this.a(worldserver, entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect m() {
        return SoundEffects.pf;
    }

    @Override
    public void u() {
        this.a(this.n(), 1.0f, 1.0f);
    }

    public SoundEffect n() {
        return SoundEffects.pg;
    }

    private void a(WorldServer worldserver, @Nullable Entity entity, boolean flag) {
        if (!this.m) {
            ItemStack itemstack = this.v();
            this.b(ItemStack.l);
            if (!worldserver.S().c(GameRules.j)) {
                if (entity == null) {
                    this.d(itemstack);
                }
            } else {
                EntityHuman entityhuman;
                if (entity instanceof EntityHuman && (entityhuman = (EntityHuman)entity).gk()) {
                    this.d(itemstack);
                    return;
                }
                if (flag) {
                    this.a(worldserver, this.r());
                }
                if (!itemstack.f()) {
                    itemstack = itemstack.v();
                    this.d(itemstack);
                    if (this.as.i() < this.l) {
                        this.a(worldserver, itemstack);
                    }
                }
            }
        }
    }

    private void d(ItemStack itemstack) {
        WorldMap worldmap;
        MapId mapid = this.a(itemstack);
        if (mapid != null && (worldmap = ItemWorldMap.a(mapid, this.an())) != null) {
            worldmap.a(this.a, this.az());
        }
        itemstack.a((Entity)null);
    }

    public ItemStack v() {
        return this.aC().a(c);
    }

    @Nullable
    public MapId a(ItemStack itemstack) {
        return itemstack.a(DataComponents.M);
    }

    public boolean w() {
        return this.v().c(DataComponents.M);
    }

    public void b(ItemStack itemstack) {
        this.a(itemstack, true);
    }

    public void a(ItemStack itemstack, boolean flag) {
        this.setItem(itemstack, flag, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.f()) {
            itemstack = itemstack.c(1);
        }
        this.e(itemstack);
        this.aC().a(c, itemstack);
        if (!itemstack.f() && playSound) {
            this.a(this.p(), 1.0f, 1.0f);
        }
        if (flag && this.a != null) {
            this.an().b(this.a, Blocks.a);
        }
    }

    public SoundEffect p() {
        return SoundEffects.pe;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::v, this::b) : super.a_(i2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (datawatcherobject.equals(c)) {
            this.e(this.v());
        }
    }

    private void e(ItemStack itemstack) {
        if (!itemstack.f() && itemstack.I() != this) {
            itemstack.a(this);
        }
        this.e();
    }

    public int x() {
        return this.aC().a(d);
    }

    public void b(int i2) {
        this.a(i2, true);
    }

    private void a(int i2, boolean flag) {
        this.aC().a(d, i2 % 8);
        if (flag && this.a != null) {
            this.an().b(this.a, Blocks.a);
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        ItemStack itemstack = this.v();
        if (!itemstack.f()) {
            valueoutput.a("Item", ItemStack.b, itemstack);
        }
        valueoutput.a("ItemRotation", (byte)this.x());
        valueoutput.a("ItemDropChance", this.l);
        valueoutput.a("Facing", EnumDirection.k, this.db());
        valueoutput.a("Invisible", this.cB());
        valueoutput.a("Fixed", this.m);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        ItemStack itemstack = valueinput.a("Item", ItemStack.b).orElse(ItemStack.l);
        ItemStack itemstack1 = this.v();
        if (!itemstack1.f() && !ItemStack.a(itemstack, itemstack1)) {
            this.d(itemstack1);
        }
        this.a(itemstack, false);
        this.a(valueinput.a("ItemRotation", (byte)0), false);
        this.l = valueinput.a("ItemDropChance", 1.0f);
        this.b(valueinput.a("Facing", EnumDirection.k).orElse(EnumDirection.a));
        this.l(valueinput.a("Invisible", false));
        this.m = valueinput.a("Fixed", false);
    }

    @Override
    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag1;
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = !this.v().f();
        boolean bl = flag1 = !itemstack.f();
        if (this.m) {
            return EnumInteractionResult.e;
        }
        if (!entityhuman.an().D_()) {
            if (!flag) {
                if (flag1 && !this.ec()) {
                    WorldMap worldmap = ItemWorldMap.b(itemstack, this.an());
                    if (worldmap != null && worldmap.a(256)) {
                        return EnumInteractionResult.d;
                    }
                    this.b(itemstack);
                    this.a(GameEvent.c, (Entity)entityhuman);
                    itemstack.a(1, (EntityLiving)entityhuman);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.e;
            }
            this.a(this.q(), 1.0f, 1.0f);
            this.b(this.x() + 1);
            this.a(GameEvent.c, (Entity)entityhuman);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(!flag && !flag1 ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    public SoundEffect q() {
        return SoundEffects.pi;
    }

    public int y() {
        return this.v().f() ? 0 : this.x() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, this.db().d(), this.i());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.b(EnumDirection.a(packetplayoutspawnentity.n()));
    }

    @Override
    public ItemStack dU() {
        ItemStack itemstack = this.v();
        return itemstack.f() ? this.r() : itemstack.v();
    }

    protected ItemStack r() {
        return new ItemStack(Items.wk);
    }

    @Override
    public float dY() {
        EnumDirection enumdirection = this.db();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.x() * 45 + i2);
    }
}

