/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey ct = MinecraftKey.b("suffocating");
    private static final AttributeModifier cu = new AttributeModifier(ct, -0.34f, AttributeModifier.Operation.b);
    private static final float cv = 0.35f;
    private static final float cx = 0.55f;
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cA;
    @Nullable
    private PathfinderGoalTempt cB;

    public EntityStrider(EntityTypes<? extends EntityStrider> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cA = new SaddleStorage(this.az, cy);
        this.W = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (generatoraccess.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return generatoraccess.a_(blockposition_mutableblockposition).l();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cy.equals(datawatcherobject) && this.an().D_()) {
            this.cA.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cy, 0);
        datawatcher_a.a(cz, false);
    }

    @Override
    public boolean e(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.h ? super.e(enumitemslot) : this.bX() && !this.g_();
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.h || super.f(enumitemslot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EnumItemSlot.h ? SoundEffects.Ax : super.a(enumitemslot, itemstack, equippable);
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalPanic(this, 1.65));
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cB = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.a(TagsItem.bb), false);
        this.cq.a(3, this.cB);
        this.cq.a(4, new a(this, 1.0));
        this.cq.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.cq.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cq.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean flag) {
        this.az.a(cz, flag);
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.w);
        if (attributemodifiable != null) {
            if (flag) {
                attributemodifiable.a(cu);
            } else {
                attributemodifiable.c(ct);
            }
        }
    }

    public boolean m() {
        return this.az.a(cz);
    }

    @Override
    public boolean a(Fluid fluid) {
        return fluid.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        if (!this.an().D_()) {
            return super.a(entity, entitysize, f2);
        }
        float f1 = Math.min(0.25f, this.bz.b());
        float f22 = this.bz.c();
        float f3 = 0.12f * MathHelper.b(f22 * 1.5f) * 2.0f * f1;
        return super.a(entity, entitysize, f2).b(0.0, f3 * f2, 0.0);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.am() && (entity = this.dj()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.po)) {
            return entityhuman;
        }
        return super.dg();
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dA(), (double)entityliving.dA(), entityliving.dX()), EntityStrider.a(this.dA(), (double)entityliving.dA(), entityliving.dX() - 22.5f), EntityStrider.a(this.dA(), (double)entityliving.dA(), entityliving.dX() + 22.5f), EntityStrider.a(this.dA(), (double)entityliving.dA(), entityliving.dX() - 45.0f), EntityStrider.a(this.dA(), (double)entityliving.dA(), entityliving.dX() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.de().e;
        double d1 = this.de().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3d : avec3d) {
            blockposition_mutableblockposition.b(this.dK() + vec3d.g, d0, this.dQ() + vec3d.i);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.j());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.an().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.an().j(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : entityliving.gd()) {
                AxisAlignedBB axisalignedbb = entityliving.f(entitypose);
                if (!DismountUtil.a(this.an(), entityliving, axisalignedbb.c(vec3d1))) continue;
                entityliving.c(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dK(), this.de().e, this.dQ());
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        this.a(entityhuman.dX(), entityhuman.dZ() * 0.5f);
        this.bB = this.bD = this.dX();
        this.ab = this.bD;
        this.cA.b();
        super.a(entityhuman, vec3d);
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman entityhuman) {
        return (float)(this.i(GenericAttributes.w) * (double)(this.m() ? 0.35f : 0.55f) * (double)this.cA.c());
    }

    @Override
    protected float bf() {
        return this.al + 0.6f;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.bJ() ? SoundEffects.Av : SoundEffects.Au, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cA.a(this.ek());
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.bJ()) {
            this.l();
        } else {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void g() {
        if (this.s() && this.as.a(140) == 0) {
            this.b(SoundEffects.Aq);
        } else if (this.gF() && this.as.a(60) == 0) {
            this.b(SoundEffects.Ar);
        }
        if (!this.gx()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.an().a_(this.dF());
            IBlockData iblockdata1 = this.bF();
            boolean flag = iblockdata.a(TagsBlock.bg) || iblockdata1.a(TagsBlock.bg) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.du();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).m();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.m() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.g();
        this.gI();
    }

    private boolean s() {
        return this.cB != null && this.cB.k();
    }

    @Override
    protected boolean J() {
        return true;
    }

    private void gI() {
        if (this.bJ()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.dF(), true) && !this.an().b_(this.dF().d()).a(TagsFluid.b)) {
                this.e(true);
            } else {
                this.k(this.dI().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.175f);
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return !this.gF() && !this.s() ? SoundEffects.Ap : null;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.At;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.As;
    }

    @Override
    protected boolean s(Entity entity) {
        return !this.cm() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fG() {
        return true;
    }

    @Override
    public boolean ck() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition).y().a(TagsFluid.b) ? 10.0f : (this.bJ() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.by.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ba);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.i(entityhuman.b(enumhand));
        if (!flag && this.am() && !this.cm() && !entityhuman.gp()) {
            if (!this.an().D_()) {
                entityhuman.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return this.a(itemstack, EnumItemSlot.h) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.e;
        }
        if (flag && !this.bm()) {
            this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.Aw, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (this.g_()) {
            return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        }
        RandomSource randomsource = worldaccess.I_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bW.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityinsentient != null) {
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityinsentient, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.po));
                this.a(EnumItemSlot.h, new ItemStack(Items.oR));
                this.g(EnumItemSlot.h);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.by.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityageable != null) {
                entityageable.c_(-24000);
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityageable, (GroupDataEntity)null);
            }
        } else {
            groupdataentity = new EntityAgeable.a(0.5f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntityInsentient entityinsentient, @Nullable GroupDataEntity groupdataentity) {
        entityinsentient.b(this.dK(), this.dM(), this.dQ(), this.dX(), 0.0f);
        entityinsentient.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, groupdataentity);
        entityinsentient.a((Entity)this, true, false);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.g = entitystrider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bJ() && this.a(this.g.an(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bJ() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return iworldreader.a_(blockposition).a(Blocks.K) && iworldreader.a_(blockposition.d()).a(PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entitystrider, World world) {
            super(entitystrider, world);
        }

        @Override
        protected Pathfinder a(int i2) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, i2);
        }

        @Override
        protected boolean a(PathType pathtype) {
            return pathtype != PathType.i && pathtype != PathType.o && pathtype != PathType.n ? super.a(pathtype) : true;
        }

        @Override
        public boolean a(BlockPosition blockposition) {
            return this.b.a_(blockposition).a(Blocks.K) || super.a(blockposition);
        }
    }
}

