/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.u);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int d = 0;
    private static final int f = 0;
    private static final boolean g = false;
    public int h = 0;
    public int i = 0;
    @Nullable
    public EntityLiving j;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireworks(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.ac, world);
        this.h = 0;
        this.a_(d0, d1, d2);
        this.az.a(a, itemstack.v());
        int i2 = 1;
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.m(this.as.a(0.0, 0.002297), 0.05, this.as.a(0.0, 0.002297));
        this.i = 10 * i2 + this.as.a(6) + this.as.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.c(entity);
    }

    public EntityFireworks(World world, ItemStack itemstack, EntityLiving entityliving) {
        this(world, entityliving, entityliving.dK(), entityliving.dM(), entityliving.dQ(), itemstack);
        this.az.a(b, OptionalInt.of(entityliving.az()));
        this.j = entityliving;
    }

    public EntityFireworks(World world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.az.a(c, flag);
    }

    public EntityFireworks(World world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.c(entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(a, EntityFireworks.n());
        datawatcher_a.a(b, OptionalInt.empty());
        datawatcher_a.a(c, false);
    }

    @Override
    public boolean a(double d0) {
        return d0 < 4096.0 && !this.k();
    }

    @Override
    public boolean j(double d0, double d1, double d2) {
        return super.j(d0, d1, d2) && !this.k();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition movingobjectposition;
        super.g();
        if (this.k()) {
            if (this.j == null) {
                this.az.a(b).ifPresent(i2 -> {
                    Entity entity = this.an().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.j = (EntityLiving)entity;
                    }
                });
            }
            if (this.j != null) {
                Vec3D vec3d;
                if (this.j.fY()) {
                    Vec3D vec3d1 = this.j.cf();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.j.dI();
                    this.j.k(vec3d2.b(vec3d1.g * 0.1 + (vec3d1.g * 1.5 - vec3d2.g) * 0.5, vec3d1.h * 0.1 + (vec3d1.h * 1.5 - vec3d2.h) * 0.5, vec3d1.i * 0.1 + (vec3d1.i * 1.5 - vec3d2.i) * 0.5));
                    vec3d = this.j.a(Items.wC);
                } else {
                    vec3d = Vec3D.c;
                }
                this.a_(this.j.dK() + vec3d.g, this.j.dM() + vec3d.h, this.j.dQ() + vec3d.i);
                this.k(this.j.dI());
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.ad ? 1.0 : 1.15;
                this.k(this.dI().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d3 = this.dI();
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, vec3d3);
            this.aT();
            this.k(vec3d3);
        }
        if (!this.ar && this.bX() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.aF = true;
        }
        this.A();
        if (this.h == 0 && !this.bm()) {
            this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.kh, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.h;
        if (this.an().D_() && this.h % 2 < 2) {
            this.an().a(Particles.E, this.dK(), this.dM(), this.dQ(), this.as.k() * 0.05, -this.dI().h * 0.5, this.as.k() * 0.05);
        }
        if (this.h > this.i && (world = this.an()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    private void b(WorldServer worldserver) {
        worldserver.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.ai_());
        this.e(worldserver);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = new BlockPosition(movingobjectpositionblock.b());
        this.an().a_(blockposition).a(this.an(), blockposition, (Entity)this, InsideBlockEffectApplier.a);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.i() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
                this.b(worldserver);
            }
        }
        super.a(movingobjectpositionblock);
    }

    private boolean i() {
        return !this.m().isEmpty();
    }

    private void e(WorldServer worldserver) {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.m();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.j != null) {
                this.j.a(worldserver, this.ei().a(this, this.ai_()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dD();
            for (EntityLiving entityliving : this.an().a(EntityLiving.class, this.de().g(5.0))) {
                if (entityliving == this.j || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dK(), entityliving.f(0.5 * (double)i2), entityliving.dQ());
                    MovingObjectPositionBlock movingobjectposition = this.an().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)movingobjectposition).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(worldserver, this.ei().a(this, this.ai_()), f1);
            }
        }
    }

    private boolean k() {
        return this.az.a(b).isPresent();
    }

    public boolean f() {
        return this.az.a(c);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 17 && this.an().D_()) {
            Vec3D vec3d = this.dI();
            this.an().a(this.dK(), this.dM(), this.dQ(), vec3d.g, vec3d.h, vec3d.i, this.m());
        }
        super.b(b0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Life", this.h);
        valueoutput.a("LifeTime", this.i);
        valueoutput.a("FireworksItem", ItemStack.b, this.e());
        valueoutput.a("ShotAtAngle", this.az.a(c));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.h = valueinput.a("Life", 0);
        this.i = valueinput.a("LifeTime", 0);
        this.az.a(a, valueinput.a("FireworksItem", ItemStack.b).orElse(EntityFireworks.n()));
        this.az.a(c, valueinput.a("ShotAtAngle", false));
    }

    private List<FireworkExplosion> m() {
        ItemStack itemstack = this.az.a(a);
        Fireworks fireworks = itemstack.a(DataComponents.aj);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.az.a(a);
    }

    @Override
    public boolean cO() {
        return false;
    }

    private static ItemStack n() {
        return new ItemStack(Items.wC);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dD().g - this.dD().g;
        double d1 = entityliving.dD().i - this.dD().i;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

