/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double a = 0.15;
    @Nullable
    private EntityReference<Entity> b;
    @Nullable
    private EnumDirection c;
    private int d;
    private double f;
    private double g;
    private double h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
        this.ar = true;
    }

    public EntityShulkerBullet(World world, EntityLiving entityliving, Entity entity, EnumDirection.EnumAxis enumdirection_enumaxis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.bi, world);
        this.c(entityliving);
        Vec3D vec3d = entityliving.de().f();
        this.b(vec3d.g, vec3d.h, vec3d.i, this.dX(), this.dZ());
        this.b = EntityReference.a(entity);
        this.c = EnumDirection.b;
        this.a(enumdirection_enumaxis, entity);
        this.projectileSource = (LivingEntity)entityliving.getBukkitEntity();
    }

    public Entity getTarget() {
        return EntityReference.a(this.b, this.an(), Entity.class);
    }

    public void setTarget(Entity e2) {
        this.b = e2 != null ? EntityReference.a(e2) : null;
        this.c = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a, e2);
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        if (this.b != null) {
            valueoutput.a("Target", UUIDUtil.a, this.b.c());
        }
        valueoutput.b("Dir", EnumDirection.k, this.c);
        valueoutput.a("Steps", this.d);
        valueoutput.a("TXD", this.f);
        valueoutput.a("TYD", this.g);
        valueoutput.a("TZD", this.h);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.d = valueinput.a("Steps", 0);
        this.f = valueinput.a("TXD", 0.0);
        this.g = valueinput.a("TYD", 0.0);
        this.h = valueinput.a("TZD", 0.0);
        this.c = valueinput.a("Dir", EnumDirection.k).orElse(null);
        this.b = EntityReference.a(valueinput, "Target");
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
    }

    @Nullable
    private EnumDirection e() {
        return this.c;
    }

    private void a(@Nullable EnumDirection enumdirection) {
        this.c = enumdirection;
    }

    private void a(@Nullable EnumDirection.EnumAxis enumdirection_enumaxis, @Nullable Entity entity) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (entity == null) {
            blockposition = this.dF().e();
        } else {
            d0 = (double)entity.dB() * 0.5;
            blockposition = BlockPosition.a(entity.dK(), entity.dM() + d0, entity.dQ());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.dD(), 2.0)) {
            BlockPosition blockposition1 = this.dF();
            ArrayList list = Lists.newArrayList();
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.an().w(blockposition1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.an().w(blockposition1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.an().w(blockposition1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.an().w(blockposition1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (enumdirection_enumaxis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.an().w(blockposition1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.an().w(blockposition1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.b(this.as);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.an().w(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.b(this.as);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.as.a(list.size()));
            }
            d1 = this.dK() + (double)enumdirection.j();
            d2 = this.dM() + (double)enumdirection.k();
            d3 = this.dQ() + (double)enumdirection.l();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dK();
        double d5 = d2 - this.dM();
        double d6 = d3 - this.dQ();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.f = 0.0;
            this.g = 0.0;
            this.h = 0.0;
        } else {
            this.f = d4 / d7 * 0.15;
            this.g = d5 / d7 * 0.15;
            this.h = d6 / d7 * 0.15;
        }
        this.aF = true;
        this.d = 10 + this.as.a(5) * 10;
    }

    @Override
    public void dR() {
        if (this.an().aq() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bo() {
        return 0.04;
    }

    @Override
    public void g() {
        super.g();
        Entity entity = !this.an().D_() ? EntityReference.a(this.b, this.an()) : null;
        MovingObjectPosition movingobjectposition = null;
        if (!this.an().D_()) {
            if (entity == null) {
                this.b = null;
            }
            if (entity == null || !entity.bX() || entity instanceof EntityHuman && entity.at()) {
                this.bq();
            } else {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                this.h = MathHelper.a(this.h * 1.025, -1.0, 1.0);
                Vec3D vec3d = this.dI();
                this.k(vec3d.b((this.f - vec3d.g) * 0.2, (this.g - vec3d.h) * 0.2, (this.h - vec3d.i) * 0.2));
            }
            movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        }
        Vec3D vec3d1 = this.dI();
        this.b(this.dD().e(vec3d1));
        this.aT();
        if (this.aG != null && this.aG.e()) {
            this.ci();
        }
        if (movingobjectposition != null && this.bX() && movingobjectposition.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.an().D_()) {
            this.an().a(Particles.u, this.dK() - vec3d1.g, this.dM() - vec3d1.h + 0.15, this.dQ() - vec3d1.i, 0.0, 0.0, 0.0);
        } else if (entity != null) {
            if (this.d > 0) {
                --this.d;
                if (this.d == 0) {
                    this.a(this.c == null ? null : this.c.o(), entity);
                }
            }
            if (this.c != null) {
                BlockPosition blockposition = this.dF();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.c.o();
                if (this.an().a(blockposition.a(this.c), this)) {
                    this.a(enumdirection_enumaxis, entity);
                } else {
                    BlockPosition blockposition1 = entity.dF();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis, entity);
                    }
                }
            }
        }
    }

    @Override
    protected boolean aW() {
        return !this.ec();
    }

    @Override
    protected boolean b(Entity entity) {
        return super.b(entity) && !entity.ar;
    }

    @Override
    public boolean ck() {
        return false;
    }

    @Override
    public boolean a(double d0) {
        return d0 < 16384.0;
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        Entity entity = movingobjectpositionentity.a();
        Entity entity1 = this.ai_();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        DamageSource damagesource = this.ei().a((Entity)this, entityliving);
        boolean flag = entity.b(damagesource, 4.0f);
        if (flag) {
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                entityliving1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        ((WorldServer)this.an()).a(Particles.x, this.dK(), this.dM(), this.dQ(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.yT, 1.0f, 1.0f);
    }

    private void f() {
        this.destroy(null);
    }

    private void destroy(EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.an().a(GameEvent.o, this.dD(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition movingobjectposition) {
        super.a(movingobjectposition);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bT() {
        return true;
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false)) {
            return false;
        }
        this.a(SoundEffects.yU, 1.0f, 1.0f);
        worldserver.a(Particles.g, this.dK(), this.dM(), this.dQ(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.k(packetplayoutspawnentity.j());
    }
}

